/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.satellite;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.ISatelliteIdItem;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemSatellite;
import zmaster587.libVulpes.util.UniversalBattery;
import zmaster587.libVulpes.util.ZUtils;

public abstract class SatelliteBase {
    protected SatelliteProperties satelliteProperties;
    private Optional<ResourceLocation> dimId = Optional.empty();
    protected ItemStack satellite;
    private boolean isDead;
    protected UniversalBattery battery;

    public SatelliteBase() {
        this.satelliteProperties = new SatelliteProperties();
        this.satelliteProperties.setSatelliteType(SatelliteRegistry.getKey(this.getClass()));
        this.isDead = false;
        this.satellite = ItemStack.field_190927_a;
        this.battery = new UniversalBattery(this.satelliteProperties.getPowerStorage());
    }

    public boolean acceptsItemInConstruction(ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return SatelliteProperties.Property.MAIN.isOfType(flag) || SatelliteProperties.Property.POWER_GEN.isOfType(flag) || SatelliteProperties.Property.BATTERY.isOfType(flag);
    }

    public abstract String getInfo(World var1);

    public abstract String getName();

    public abstract boolean performAction(PlayerEntity var1, World var2, BlockPos var3);

    public abstract double failureChance();

    public int getPowerPerTick() {
        return this.satelliteProperties.getPowerGeneration();
    }

    public ItemStack getContollerItemStack(ItemStack satIdChip, SatelliteProperties properties) {
        ISatelliteIdItem idChipItem = (ISatelliteIdItem)satIdChip.func_77973_b();
        idChipItem.setSatellite(satIdChip, properties);
        return satIdChip;
    }

    public boolean isAcceptableControllerItemStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == AdvancedRocketryItems.itemSatelliteIdChip;
    }

    public boolean canTick() {
        return true;
    }

    public void tickEntity() {
        this.battery.acceptEnergy(this.getPowerPerTick() - 1, false);
    }

    public long getId() {
        return this.satelliteProperties.getId();
    }

    public void remove() {
        this.isDead = true;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDimensionId(World world) {
        ResourceLocation newId = ZUtils.getDimensionIdentifier((World)world);
        if (this.dimId.isPresent()) {
            // empty if block
        }
        this.dimId = Optional.of(newId);
    }

    public void setDimensionId(ResourceLocation world) {
        ResourceLocation newId = world;
        if (this.dimId.isPresent()) {
            // empty if block
        }
        this.dimId = Optional.of(newId);
    }

    public void setProperties(ItemStack stack) {
        this.satelliteProperties = ((ItemSatellite)stack.func_77973_b()).getSatellite(stack);
        this.battery.setMaxEnergyStored(this.satelliteProperties.getPowerStorage());
        this.satellite = stack;
    }

    public ItemStack getItemStackFromSatellite() {
        return this.satellite;
    }

    public Optional<ResourceLocation> getDimensionId() {
        return this.dimId;
    }

    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74778_a("dataType", SatelliteRegistry.getKey(this.getClass()));
        CompoundNBT properties = new CompoundNBT();
        this.satelliteProperties.writeToNBT(properties);
        nbt.func_218657_a("properties", (INBT)properties);
        this.dimId.ifPresent(value -> nbt.func_74778_a("dimId", value.toString()));
        this.battery.write(nbt);
        CompoundNBT itemNBT = new CompoundNBT();
        if (!this.satellite.func_190926_b()) {
            this.satellite.func_77955_b(itemNBT);
        }
        nbt.func_218657_a("item", (INBT)itemNBT);
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.satelliteProperties.readFromNBT(nbt.func_74775_l("properties"));
        this.dimId = nbt.func_74764_b("dimId") ? Optional.of(new ResourceLocation(nbt.func_74779_i("dimId"))) : Optional.empty();
        this.satellite = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item"));
        this.battery.readFromNBT(nbt);
        if (this.satelliteProperties.getPowerStorage() == 0) {
            this.satelliteProperties.setPowerStorage(720);
            this.battery = new UniversalBattery(720);
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte packetId) {
    }

    public void readDataToNetwork(byte packetId, ByteBuf in) {
    }

    public void useNetworkData(PlayerEntity player, Dist client, byte packetId, CompoundNBT nbt) {
    }

    public int numberChangesToSend() {
        return 0;
    }

    public void onChangeRecieved(int slot, int value) {
    }

    public boolean isUpdateRequired(int localId) {
        return false;
    }

    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
    }
}

