/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.armor;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.armor.IProtectiveArmor;
import zmaster587.advancedRocketry.api.capability.CapabilitySpaceArmor;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.client.render.armor.RenderJetPack;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.api.IJetPack;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.IconResource;

public class ItemSpaceArmor
extends ArmorItem
implements ICapabilityProvider,
IProtectiveArmor,
IModularArmor,
IDyeableArmorItem {
    private static final String componentNBTName = "componentName";
    private int numModules;

    public ItemSpaceArmor(Item.Properties props, ArmorMaterial material, EquipmentSlotType component, int numModules) {
        super((IArmorMaterial)material, component, props);
        this.numModules = numModules;
    }

    public boolean canBeExternallyModified(ItemStack armor, int slot) {
        return true;
    }

    public void func_77624_a(ItemStack stack, World p_77624_2_, List list, ITooltipFlag p_77624_4_) {
        super.func_77624_a(stack, p_77624_2_, list, p_77624_4_);
        list.add(new TranslationTextComponent("msg.modules"));
        for (ItemStack componentStack : this.getComponents(stack)) {
            list.add(componentStack.func_200301_q());
        }
    }

    public boolean func_77645_m() {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (armorSlot == EquipmentSlotType.CHEST) {
            for (ItemStack stack : this.getComponents(itemStack)) {
                if (!(stack.func_77973_b() instanceof IJetPack)) continue;
                return (A)((Object)new RenderJetPack(_default));
            }
        }
        return (A)super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT nbttagcompound1;
        CompoundNBT nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return 0xFFFFFF;
    }

    private EmbeddedInventory loadEmbeddedInventory(ItemStack stack) {
        if (stack.func_77942_o()) {
            EmbeddedInventory inv = new EmbeddedInventory(this.numModules);
            inv.readFromNBT(stack.func_77978_p());
            return inv;
        }
        return new EmbeddedInventory(this.numModules);
    }

    protected void saveEmbeddedInventory(ItemStack stack, EmbeddedInventory inv) {
        if (stack.func_77942_o()) {
            inv.write(stack.func_77978_p());
        } else {
            CompoundNBT nbt = new CompoundNBT();
            inv.write(nbt);
            stack.func_77982_d(nbt);
        }
    }

    public void onArmorTick(ItemStack armor, World world, PlayerEntity player) {
        super.onArmorTick(armor, world, player);
        if (armor.func_77942_o()) {
            EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                IArmorComponent component = (IArmorComponent)stack.func_77973_b();
                component.onTick(world, player, armor, (IInventory)inv, stack);
            }
            this.saveEmbeddedInventory(armor, inv);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (type != null) {
            if (stack.func_77973_b() == AdvancedRocketryItems.itemSpaceSuit_Leggings) {
                return "advancedrocketry:textures/armor/spacesuit_layer1_overlay.png";
            }
            return "advancedrocketry:textures/armor/spacesuit_layer2_overlay.png";
        }
        if (stack.func_77973_b() == AdvancedRocketryItems.itemSpaceSuit_Leggings) {
            return "advancedrocketry:textures/armor/spacesuit_layer1.png";
        }
        return "advancedrocketry:textures/armor/spacesuit_layer2.png";
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public void addArmorComponent(World world, ItemStack armor, ItemStack component, int slot) {
        EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
        if (((IArmorComponent)component.func_77973_b()).onComponentAdded(world, armor)) {
            inv.func_70299_a(slot, component);
            this.saveEmbeddedInventory(armor, inv);
        }
    }

    public ItemStack removeComponent(World world, ItemStack armor, int index) {
        if (!armor.func_77942_o()) {
            return ItemStack.field_190927_a;
        }
        CompoundNBT nbt = armor.func_77978_p();
        ListNBT componentList = nbt.func_150295_c(componentNBTName, 10);
        EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
        ItemStack stack = inv.func_70301_a(index);
        inv.func_70299_a(index, ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            IArmorComponent component = (IArmorComponent)stack.func_77973_b();
            component.onComponentRemoved(world, armor);
            this.saveEmbeddedInventory(armor, inv);
        }
        return stack;
    }

    public List<ItemStack> getComponents(ItemStack armor) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        if (armor.func_77942_o()) {
            EmbeddedInventory inv = this.loadEmbeddedInventory(armor);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i).func_190926_b()) continue;
                list.add(inv.func_70301_a(i));
            }
        }
        return list;
    }

    @Override
    public boolean protectsFromSubstance(IAtmosphere atmosphere, ItemStack stack, boolean commitProtection) {
        return atmosphere == AtmosphereType.SUPERHIGHPRESSURE || atmosphere == AtmosphereType.HIGHPRESSURE || atmosphere == AtmosphereType.VACUUM || atmosphere == AtmosphereType.VERYHOT || atmosphere == AtmosphereType.SUPERHEATED || atmosphere == AtmosphereType.LOWOXYGEN || atmosphere == AtmosphereType.SUPERHIGHPRESSURENOO2 || atmosphere == AtmosphereType.HIGHPRESSURENOO2 || atmosphere == AtmosphereType.VERYHOTNOO2 || atmosphere == AtmosphereType.SUPERHEATEDNOO2 || atmosphere == AtmosphereType.NOO2;
    }

    public int getNumSlots(ItemStack stack) {
        return this.loadEmbeddedInventory(stack).func_70302_i_();
    }

    public ItemStack getComponentInSlot(ItemStack stack, int slot) {
        return this.loadEmbeddedInventory(stack).func_70301_a(slot);
    }

    public IInventory loadModuleInventory(ItemStack stack) {
        return this.loadEmbeddedInventory(stack);
    }

    public void saveModuleInventory(ItemStack stack, IInventory inv) {
        this.saveEmbeddedInventory(stack, (EmbeddedInventory)inv);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilitySpaceArmor.PROTECTIVEARMOR) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    public boolean isItemValidForSlot(ItemStack stack, int slot) {
        return true;
    }

    public IconResource getResourceForSlot(int slot) {
        return null;
    }
}

