/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.armor;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.armor.IFillableArmor;
import zmaster587.advancedRocketry.armor.ItemSpaceArmor;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.IconResource;

public class ItemSpaceChest
extends ItemSpaceArmor
implements IFillableArmor {
    public ItemSpaceChest(Item.Properties props, ArmorMaterial material, EquipmentSlotType component, int numModules) {
        super(props, material, component, numModules);
    }

    @Override
    public boolean isItemValidForSlot(ItemStack stack, int slot) {
        if (slot >= 2) {
            return true;
        }
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (stack.func_190926_b() || !cap.isPresent()) {
            return false;
        }
        FluidStack fstack = ((IFluidHandlerItem)cap.orElse(null)).getFluidInTank(0);
        return fstack == null || fstack.isEmpty() || FluidUtils.areFluidsSameType((Fluid)fstack.getFluid(), (Fluid)((Fluid)AdvancedRocketryFluids.oxygenFlowing.get()));
    }

    @Override
    public boolean canBeExternallyModified(ItemStack armor, int slot) {
        return slot >= 2;
    }

    @Override
    public IconResource getResourceForSlot(int slot) {
        if (slot < 2) {
            return TextureResources.slotO2;
        }
        return null;
    }

    @Override
    public int getAirRemaining(ItemStack stack) {
        List<ItemStack> list = this.getComponents(stack);
        int airRemaining = 0;
        for (ItemStack component : list) {
            if (!FluidUtils.containsFluid((ItemStack)component, (Fluid)((Fluid)AdvancedRocketryFluids.oxygenStill.get()))) continue;
            airRemaining += FluidUtils.getFluidForItem((ItemStack)component).getAmount();
        }
        return airRemaining;
    }

    @Override
    public void setAirRemaining(ItemStack stack, int amt) {
    }

    @Override
    public int decrementAir(ItemStack stack, int amt) {
        if (stack.func_77942_o()) {
            EmbeddedInventory inv = new EmbeddedInventory(this.getNumSlots(stack));
            inv.readFromNBT(stack.func_77978_p());
            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i).func_190926_b()) continue;
                list.add(inv.func_70301_a(i));
            }
            int amtDrained = amt;
            for (ItemStack component : list) {
                LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                if (!cap.isPresent()) continue;
                IFluidHandlerItem fluidItem = (IFluidHandlerItem)cap.orElse(null);
                FluidStack fluidStack = FluidUtils.getFluidForItem((ItemStack)component);
                FluidStack fluidDrained = null;
                if (fluidStack != null && FluidUtils.areFluidsSameType((Fluid)fluidStack.getFluid(), (Fluid)((Fluid)AdvancedRocketryFluids.oxygenStill.get()))) {
                    fluidDrained = fluidItem.drain(amtDrained, IFluidHandler.FluidAction.EXECUTE);
                }
                if (fluidDrained != null) {
                    amtDrained -= fluidDrained.getAmount();
                }
                if (amtDrained != 0) continue;
                break;
            }
            this.saveEmbeddedInventory(stack, inv);
            return amt - amtDrained;
        }
        return 0;
    }

    @Override
    public int increment(ItemStack stack, int amt) {
        if (stack.func_77942_o()) {
            EmbeddedInventory inv = new EmbeddedInventory(this.getNumSlots(stack));
            inv.readFromNBT(stack.func_77978_p());
            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                FluidStack fstack;
                if (inv.func_70301_a(i).func_190926_b()) continue;
                LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                if (i < 2) {
                    int count = i;
                    cap.ifPresent(value -> list.add(inv.func_70301_a(count)));
                    continue;
                }
                if (!FluidUtils.containsFluid((ItemStack)inv.func_70301_a(i)) || (fstack = FluidUtils.getFluidForItem((ItemStack)inv.func_70301_a(i))) == null || !FluidUtils.areFluidsSameType((Fluid)fstack.getFluid(), (Fluid)((Fluid)AdvancedRocketryFluids.oxygenStill.get()))) continue;
                list.add(inv.func_70301_a(i));
            }
            int amtDrained = amt;
            for (ItemStack component : list) {
                IFluidHandlerItem fHandler = (IFluidHandlerItem)component.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
                FluidStack fluidStack = fHandler.getFluidInTank(0);
                if (fluidStack == null || FluidUtils.areFluidsSameType((Fluid)fluidStack.getFluid(), (Fluid)((Fluid)AdvancedRocketryFluids.oxygenStill.get()))) {
                    amtDrained -= fHandler.fill(new FluidStack((Fluid)AdvancedRocketryFluids.oxygenStill.get(), amtDrained), IFluidHandler.FluidAction.EXECUTE);
                }
                if (amtDrained != 0) continue;
                break;
            }
            this.saveEmbeddedInventory(stack, inv);
            return amt - amtDrained;
        }
        return 0;
    }

    @Override
    public int getMaxAir(ItemStack stack) {
        if (stack.func_77942_o()) {
            EmbeddedInventory inv = new EmbeddedInventory(this.getNumSlots(stack));
            inv.readFromNBT(stack.func_77978_p());
            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                FluidStack fstack;
                if (inv.func_70301_a(i).func_190926_b()) continue;
                LazyOptional cap = inv.func_70301_a(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                if (i < 2) {
                    int count = i;
                    cap.ifPresent(value -> list.add(inv.func_70301_a(count)));
                    continue;
                }
                if (!cap.isPresent() || (fstack = FluidUtils.getFluidForItem((ItemStack)inv.func_70301_a(i))) == null || !FluidUtils.areFluidsSameType((Fluid)fstack.getFluid(), (Fluid)((Fluid)AdvancedRocketryFluids.oxygenStill.get()))) continue;
                list.add(inv.func_70301_a(i));
            }
            int maxAir = 0;
            for (ItemStack component : list) {
                LazyOptional cap = component.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                IFluidHandlerItem fHandler = (IFluidHandlerItem)cap.orElse(null);
                FluidStack fluidStack = fHandler.getFluidInTank(0);
                if (fluidStack != null && !fluidStack.isEmpty() && !FluidUtils.areFluidsSameType((Fluid)fluidStack.getFluid(), (Fluid)((Fluid)AdvancedRocketryFluids.oxygenStill.get()))) continue;
                maxAir += fHandler.getTankCapacity(0);
            }
            return maxAir;
        }
        return 0;
    }

    @Override
    public boolean protectsFromSubstance(IAtmosphere atmosphere, ItemStack stack, boolean commitProtection) {
        if (!super.protectsFromSubstance(atmosphere, stack, commitProtection)) {
            return false;
        }
        if (atmosphere.allowsCombustion()) {
            return true;
        }
        boolean commitAndDecrement = commitProtection && ((IFillableArmor)AdvancedRocketryItems.itemSpaceSuit_Chest).decrementAir(stack, 1) > 0;
        boolean noncommitAndHasAir = !commitProtection && ((IFillableArmor)AdvancedRocketryItems.itemSpaceSuit_Chest).getAirRemaining(stack) > 0;
        return noncommitAndHasAir || commitAndDecrement;
    }
}

