/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.atmosphere;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.event.AtmosphereEvent;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketAtmSync;
import zmaster587.advancedRocketry.util.AtmosphereBlob;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public class AtmosphereHandler {
    public static final DamageSource vacuumDamage = new DamageSource("vacuum").func_76348_h().func_151518_m();
    public static final DamageSource lowOxygenDamage = new DamageSource("lowoxygen").func_76348_h().func_151518_m();
    public static final DamageSource heatDamage = new DamageSource("heat").func_76348_h().func_151518_m();
    public static final DamageSource oxygenToxicityDamage = new DamageSource("oxygentoxicity").func_76348_h().func_151518_m();
    public static long lastSuffocationTime = Integer.MIN_VALUE;
    private static final int MAX_BLOB_RADIUS = ((Integer)ARConfiguration.getCurrentConfig().atmosphereHandleBitMask.get() & 1) == 1 ? 256 : (Integer)ARConfiguration.getCurrentConfig().oxygenVentSize.get();
    private static HashMap<ResourceLocation, AtmosphereHandler> dimensionOxygen = new HashMap();
    private static HashMap<PlayerEntity, IAtmosphere> prevAtmosphere = new HashMap();
    private HashMap<IBlobHandler, AreaBlob> blobs;
    ResourceLocation dimId;
    public static IAtmosphere currentAtm;
    public static int currentPressure;

    public static void registerWorld(World world) {
        ResourceLocation dimId = ZUtils.getDimensionIdentifier((World)world);
        DimensionProperties dimProp = DimensionManager.getInstance().getDimensionProperties(dimId);
        if (((Boolean)ARConfiguration.getCurrentConfig().enableOxygen.get()).booleanValue() && dimProp.hasSurface() && (((Boolean)ARConfiguration.getCurrentConfig().overrideGCAir.get()).booleanValue() || dimId != ARConfiguration.getCurrentConfig().MoonId || dimProp.isNativeDimension)) {
            dimensionOxygen.put(dimId, new AtmosphereHandler(dimId));
            MinecraftForge.EVENT_BUS.register((Object)dimensionOxygen.get(dimId));
        }
    }

    public static void unregisterWorld(World dimId) {
        AtmosphereHandler handler = dimensionOxygen.remove(dimId);
        if (((Boolean)ARConfiguration.getCurrentConfig().enableOxygen.get()).booleanValue() && handler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)handler);
            FMLJavaModLoadingContext.get().getModEventBus().unregister((Object)handler);
        }
    }

    private AtmosphereHandler(ResourceLocation dimId) {
        this.dimId = dimId;
        this.blobs = new HashMap();
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && ZUtils.getDimensionIdentifier((World)entity.field_70170_p) == this.dimId) {
            IAtmosphere atmosType = this.getAtmosphereType(entity);
            if (entity instanceof PlayerEntity && atmosType != prevAtmosphere.get(entity)) {
                PacketHandler.sendToPlayer((BasePacket)new PacketAtmSync(atmosType.getUnlocalizedName(), this.getAtmospherePressure(entity)), (PlayerEntity)((PlayerEntity)entity));
                prevAtmosphere.put((PlayerEntity)entity, atmosType);
            }
            if (atmosType.canTick() && !event.getEntityLiving().func_180799_ab() && !event.getEntityLiving().func_70090_H()) {
                AtmosphereEvent.AtmosphereTickEvent event2 = new AtmosphereEvent.AtmosphereTickEvent(entity, atmosType);
                MinecraftForge.EVENT_BUS.post((Event)event2);
                if (!event2.isCanceled() && !atmosType.isImmune(event.getEntity().getClass())) {
                    atmosType.onTick(event.getEntityLiving());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        prevAtmosphere.remove(event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        prevAtmosphere.remove(event.getPlayer());
    }

    private void onBlockRemove(HashedBlockPosition pos) {
        List<AreaBlob> blobs = this.getBlobWithinRadius(pos, MAX_BLOB_RADIUS);
        block0: for (AreaBlob blob : blobs) {
            for (Direction dir : Direction.values()) {
                if (!blob.contains(pos.getPositionAtOffset(dir))) continue;
                blob.addBlock(pos, blobs);
                continue block0;
            }
        }
    }

    public static boolean hasAtmosphereHandler(ResourceLocation dimId) {
        return dimensionOxygen.containsKey(dimId);
    }

    public static boolean hasAtmosphereHandler(World dimId) {
        return dimensionOxygen.containsKey(ZUtils.getDimensionIdentifier((World)dimId));
    }

    public static void onBlockChange(World world, BlockPos bpos) {
        if (((Boolean)ARConfiguration.getCurrentConfig().enableOxygen.get()).booleanValue() && !world.field_72995_K && world.func_175667_e(new BlockPos((Vector3i)bpos))) {
            IFluidBlock fluidblock;
            HashedBlockPosition pos = new HashedBlockPosition(bpos);
            AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(ZUtils.getDimensionIdentifier((World)world));
            if (handler == null) {
                return;
            }
            if (handler.getAtmosphereType(bpos) == AtmosphereType.SUPERHEATED) {
                if (!world.func_180495_p(bpos).func_185904_a().func_76217_h()) {
                    if (world.func_180495_p(bpos).func_185904_a() == Material.field_151569_G) {
                        world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                    } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151572_C) {
                        world.func_175656_a(bpos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            } else if (!handler.getAtmosphereType(bpos).allowsCombustion()) {
                if (world.func_180495_p(bpos).func_185904_a() == Material.field_151584_j) {
                    world.func_175656_a(bpos, Blocks.field_150350_a.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151581_o) {
                    world.func_175656_a(bpos, Blocks.field_150350_a.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151570_A) {
                    world.func_175656_a(bpos, Blocks.field_150350_a.func_176223_P());
                } else if (world.func_180495_p(bpos).func_185904_a() == Material.field_151585_k && world.func_180495_p(bpos).func_177230_c() != Blocks.field_196555_aI) {
                    world.func_175656_a(bpos, Blocks.field_196555_aI.func_176223_P());
                }
            }
            if (handler.getAtmosphereType(bpos) == AtmosphereType.VACUUM && world.func_180495_p(bpos).func_185904_a() == Material.field_151586_h && !(world.func_180495_p(bpos).func_177230_c() instanceof FlowingFluidBlock) && (fluidblock = (IFluidBlock)world.func_180495_p(bpos).func_177230_c()).getFluid().getAttributes().isGaseous()) {
                world.func_175656_a(bpos, Blocks.field_150350_a.func_176223_P());
            }
            if ((handler.getAtmosphereType(bpos) == AtmosphereType.SUPERHEATED || handler.getAtmosphereType(bpos) == AtmosphereType.SUPERHEATEDNOO2 || handler.getAtmosphereType(bpos) == AtmosphereType.VERYHOT || handler.getAtmosphereType(bpos) == AtmosphereType.VERYHOTNOO2) && world.func_180495_p(bpos).func_185904_a() == Material.field_151586_h) {
                world.func_175656_a(bpos, Blocks.field_150350_a.func_176223_P());
            }
            List<AreaBlob> nearbyBlobs = handler.getBlobWithinRadius(pos, MAX_BLOB_RADIUS);
            for (AreaBlob blob : nearbyBlobs) {
                if (!((double)blob.getBlobMaxRadius() > pos.getDistance(blob.getRootPosition()))) continue;
                if (world.func_175623_d(bpos)) {
                    handler.onBlockRemove(pos);
                    continue;
                }
                if (blob.contains(pos) && !blob.isPositionAllowed(world, pos, nearbyBlobs)) {
                    blob.removeBlock(pos);
                    continue;
                }
                if (!blob.contains(blob.getRootPosition())) {
                    blob.addBlock(blob.getRootPosition(), nearbyBlobs);
                    continue;
                }
                if (blob.contains(pos) || !blob.isPositionAllowed(world, pos, nearbyBlobs)) continue;
                blob.addBlock(pos, nearbyBlobs);
            }
        }
    }

    protected List<AreaBlob> getBlobWithinRadius(HashedBlockPosition pos, int radius) {
        LinkedList<AreaBlob> list = new LinkedList<AreaBlob>();
        for (AreaBlob blob : this.blobs.values()) {
            if (!(blob.getRootPosition().getDistance(pos) - (double)radius <= 0.0)) continue;
            list.add(blob);
        }
        return list;
    }

    public static AtmosphereHandler getOxygenHandler(ResourceLocation dimNumber) {
        return dimensionOxygen.get(dimNumber);
    }

    public static AtmosphereHandler getOxygenHandler(World world) {
        return AtmosphereHandler.getOxygenHandler(ZUtils.getDimensionIdentifier((World)world));
    }

    public void registerBlob(IBlobHandler handler, BlockPos pos) {
        AreaBlob blob = this.blobs.get(handler);
        if (blob == null) {
            blob = new AtmosphereBlob(handler);
            this.blobs.put(handler, blob);
            blob.setData(AtmosphereType.PRESSURIZEDAIR);
        }
    }

    public void registerBlob(IBlobHandler handler, BlockPos pos, AreaBlob blob2) {
        AreaBlob blob = this.blobs.get(handler);
        if (blob == null) {
            blob = blob2;
            this.blobs.put(handler, blob);
            blob.setData(AtmosphereType.PRESSURIZEDAIR);
        }
    }

    public void unregisterBlob(IBlobHandler handler) {
        this.blobs.remove(handler);
    }

    public void clearBlob(IBlobHandler handler) {
        if (this.blobs.containsKey(handler)) {
            this.blobs.get(handler).clearBlob();
        }
    }

    public void addBlock(IBlobHandler handler, int x, int y, int z) {
        this.addBlock(handler, new HashedBlockPosition(x, y, z));
    }

    public boolean addBlock(IBlobHandler handler, HashedBlockPosition pos) {
        AreaBlob blob = this.blobs.get(handler);
        blob.addBlock(pos, this.getBlobWithinRadius(pos, MAX_BLOB_RADIUS));
        return !blob.getLocations().isEmpty();
    }

    public IAtmosphere getAtmosphereType(BlockPos pos2) {
        if (((Boolean)ARConfiguration.getCurrentConfig().enableOxygen.get()).booleanValue()) {
            HashedBlockPosition pos = new HashedBlockPosition(pos2);
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos)) continue;
                return (IAtmosphere)blob.getData();
            }
            return this.getDefaultAtmosphereType();
        }
        return AtmosphereType.AIR;
    }

    public IAtmosphere getDefaultAtmosphereType() {
        return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere();
    }

    public IAtmosphere getAtmosphereType(Entity entity) {
        if (((Boolean)ARConfiguration.getCurrentConfig().enableOxygen.get()).booleanValue()) {
            HashedBlockPosition pos = new HashedBlockPosition((int)Math.floor(entity.func_226277_ct_()), (int)Math.ceil(entity.func_226278_cu_()), (int)Math.floor(entity.func_226281_cx_()));
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos)) continue;
                return (IAtmosphere)blob.getData();
            }
            return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere();
        }
        return AtmosphereType.AIR;
    }

    public int getAtmospherePressure(Entity entity) {
        if (((Boolean)ARConfiguration.getCurrentConfig().enableOxygen.get()).booleanValue()) {
            HashedBlockPosition pos = new HashedBlockPosition((int)Math.floor(entity.func_226277_ct_()), (int)Math.ceil(entity.func_226278_cu_()), (int)Math.floor(entity.func_226281_cx_()));
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos) || !(blob instanceof AtmosphereBlob)) continue;
                return ((AtmosphereBlob)blob).getPressure();
            }
        }
        return -1;
    }

    public boolean canEntityBreathe(LivingEntity entity) {
        if (((Boolean)ARConfiguration.getCurrentConfig().enableOxygen.get()).booleanValue()) {
            HashedBlockPosition pos = new HashedBlockPosition((int)Math.floor(entity.func_226277_ct_()), (int)Math.ceil(entity.func_226278_cu_()), (int)Math.floor(entity.func_226281_cx_()));
            for (AreaBlob blob : this.blobs.values()) {
                if (!blob.contains(pos) || !((IAtmosphere)blob.getData()).isImmune(entity)) continue;
                return true;
            }
            return DimensionManager.getInstance().getDimensionProperties(this.dimId).getAtmosphere().isImmune(entity);
        }
        return true;
    }

    public int getBlobSize(IBlobHandler handler) {
        return this.blobs.get(handler).getBlobSize();
    }

    public void setAtmosphereType(IBlobHandler handler, IAtmosphere data) {
        this.blobs.get(handler).setData(data);
    }

    public IAtmosphere getAtmosphereType(IBlobHandler handler) {
        return (IAtmosphere)this.blobs.get(handler).getData();
    }
}

