/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.backwardCompat;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.advancedRocketry.backwardCompat.TextureCoordinate;
import zmaster587.advancedRocketry.backwardCompat.Vertex;

public class Face {
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(MatrixStack matrix, int lighting, int lightingOverlay, IVertexBuilder tessellator, float r, float g, float b, float a) {
        this.addFaceForRender(matrix, lighting, lightingOverlay, tessellator, 5.0E-4f, r, g, b, a);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(MatrixStack matrix, IVertexBuilder tessellator) {
        this.addFaceForRender(matrix, tessellator, 5.0E-4f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(MatrixStack matrix, IVertexBuilder tessellator, float r, float g, float b, float a) {
        this.addFaceForRender(matrix, tessellator, 5.0E-4f, r, g, b, a);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(MatrixStack matrix, IVertexBuilder tessellator, float textureOffset, float r, float g, float b, float a) {
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u;
                averageV += this.textureCoordinates[i].v;
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = matrix.func_227866_c_().func_227872_b_();
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector4f vector4f;
            Vector3f vector3f;
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                if (this.textureCoordinates[i].u > averageU) {
                    offsetU = -offsetU;
                }
                if (this.textureCoordinates[i].v > averageV) {
                    offsetV = -offsetV;
                }
                vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
                vector3f.func_229188_a_(matrix3f);
                vector4f = new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f);
                vector4f.func_229372_a_(matrix4f);
                tessellator.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_225583_a_(this.textureCoordinates[i].u + offsetU, this.textureCoordinates[i].v + offsetV).func_225584_a_(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c()).func_181675_d();
                continue;
            }
            vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
            vector3f.func_229188_a_(matrix3f);
            vector4f = new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f);
            vector4f.func_229372_a_(matrix4f);
            tessellator.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225587_b_(-1, -1).func_225584_a_(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c()).func_181675_d();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(MatrixStack matrix, int lighting, int lightingOverlay, IVertexBuilder tessellator, float textureOffset) {
        this.addFaceForRender(matrix, lighting, lightingOverlay, tessellator, textureOffset, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(MatrixStack matrix, int lighting, int lightingOverlay, IVertexBuilder tessellator, float textureOffset, float r, float g, float b, float a) {
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u;
                averageV += this.textureCoordinates[i].v;
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = matrix.func_227866_c_().func_227872_b_();
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector4f vector4f;
            Vector3f vector3f;
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                if (this.textureCoordinates[i].u > averageU) {
                    offsetU = -offsetU;
                }
                if (this.textureCoordinates[i].v > averageV) {
                    offsetV = -offsetV;
                }
                vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
                vector3f.func_229188_a_(matrix3f);
                vector4f = new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f);
                vector4f.func_229372_a_(matrix4f);
                tessellator.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), r, g, b, a, this.textureCoordinates[i].u + offsetU, this.textureCoordinates[i].v + offsetV, lightingOverlay, lighting, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
                continue;
            }
            vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
            vector3f.func_229188_a_(matrix3f);
            vector4f = new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f);
            vector4f.func_229372_a_(matrix4f);
            tessellator.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), r, g, b, a, 0.0f, 0.0f, lightingOverlay, lighting, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
        }
    }

    public Vertex calculateFaceNormal() {
        Vector3d v1 = new Vector3d((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        Vector3d v2 = new Vector3d((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        Vector3d normalVector = null;
        normalVector = v1.func_72431_c(v2).func_72432_b();
        return new Vertex((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
    }
}

