/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.item.ItemBlockFluidTank;
import zmaster587.advancedRocketry.tile.TileFluidTank;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.util.FluidUtils;

public class BlockPressurizedFluidTank
extends Block {
    private static VoxelShape bb = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);

    public BlockPressurizedFluidTank(AbstractBlock.Properties material) {
        super(material);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tile = world.func_175625_s(pos);
        if (FluidUtils.containsFluid((ItemStack)player.func_184586_b(hand))) {
            IFluidHandler fluidHndl = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
            if (fluidHndl != null) {
                FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)fluidHndl);
            }
        } else if (!world.field_72995_K && tile != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tile), buf -> {
                buf.writeInt(((IModularInventory)tile).getModularInvType().ordinal());
                buf.func_179255_a(pos);
            });
        }
        return ActionResultType.SUCCESS;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileFluidTank((int)(64000.0 * (Double)ARConfiguration.getCurrentConfig().blockTankCapacity.get()));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new LinkedList<ItemStack>();
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        TileEntity tile = te;
        if (tile != null && tile instanceof TileFluidTank) {
            LazyOptional cap = ((TileFluidTank)tile).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN);
            IFluidHandler fluid = (IFluidHandler)cap.orElse(null);
            ItemStack itemstack = new ItemStack((IItemProvider)AdvancedRocketryBlocks.blockPressureTank);
            ((ItemBlockFluidTank)itemstack.func_77973_b()).fill(itemstack, fluid.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
            int j1 = world.field_73012_v.nextInt(21) + 10;
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            itemstack.func_190920_e(1);
            ItemEntity entityitem = new ItemEntity(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), itemstack.func_77946_l());
            float f3 = 0.05f;
            entityitem.func_213293_j((double)((float)world.field_73012_v.nextGaussian() * f3), (double)((float)world.field_73012_v.nextGaussian() * f3 + 0.2f), (double)((float)world.field_73012_v.nextGaussian() * f3));
            if (itemstack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
            }
            world.func_217376_c((Entity)entityitem);
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (side.func_96559_d() != 0 && adjacentBlockState.func_177230_c() == this) {
            return false;
        }
        return super.func_200122_a(state, adjacentBlockState, side);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return bb;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFluidTank) {
            ((TileFluidTank)tile).onAdjacentBlockUpdated(Direction.func_176737_a((float)(neighbor.func_177958_n() - pos.func_177958_n()), (float)(neighbor.func_177956_o() - pos.func_177956_o()), (float)(neighbor.func_177952_p() - pos.func_177952_p())));
        }
    }
}

