/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.tile.atmosphere.TileSeal;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class BlockSeal
extends Block {
    private HashMap<HashedBlockPosition, BlobHandler> blobList = new HashMap();

    public BlockSeal(AbstractBlock.Properties materialIn) {
        super(materialIn);
    }

    public void clearMap() {
        this.blobList.clear();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileSeal();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn);
        if (atmhandler == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlobHandler handler = this.blobList.remove(new HashedBlockPosition(pos.func_177972_a(dir)));
            if (handler != null) {
                atmhandler.unregisterBlob(handler);
            }
            this.fireCheckAllDirections(worldIn, pos.func_177972_a(dir), dir);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void removeSeal(World worldIn, BlockPos pos) {
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn);
        if (atmhandler == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlobHandler handler = this.blobList.remove(new HashedBlockPosition(pos.func_177972_a(dir)));
            if (handler == null) continue;
            atmhandler.unregisterBlob(handler);
        }
    }

    public void clearBlob(World worldIn, BlockPos pos, BlockState state) {
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn);
        if (atmhandler == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlobHandler handler = this.blobList.remove(new HashedBlockPosition(pos.func_177972_a(dir)));
            if (handler == null) continue;
            atmhandler.unregisterBlob(handler);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        this.checkCompleteness(worldIn, pos);
        for (Direction dir : Direction.values()) {
            this.fireCheckAllDirections(worldIn, pos.func_177972_a(dir), dir);
        }
    }

    public void fireCheckAllDirections(World worldIn, BlockPos startBlock, Direction directionFrom) {
        for (Direction dir : Direction.values()) {
            if (directionFrom.func_176734_d() == dir) continue;
            this.fireCheck(worldIn, startBlock.func_177972_a(dir));
        }
    }

    private void fireCheck(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == this) {
            BlockSeal blockSeal = (BlockSeal)block;
            blockSeal.checkCompleteness(worldIn, pos);
        }
    }

    private boolean checkCompleteness(World worldIn, BlockPos pos) {
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn);
        if (atmhandler == null) {
            return false;
        }
        if (worldIn.func_180495_p(pos.func_177984_a().func_177976_e()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a().func_177974_f()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a().func_177984_a()).func_177230_c() == this || worldIn.func_180495_p(pos.func_177984_a().func_177978_c()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a().func_177968_d()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a().func_177984_a()).func_177230_c() == this && !this.blobList.containsKey(new HashedBlockPosition(pos.func_177984_a()))) {
            pos = pos.func_177984_a();
            HashedBlockPosition hashPos = new HashedBlockPosition(pos);
            BlobHandler handler = new BlobHandler(worldIn, pos);
            this.blobList.put(hashPos, handler);
            AreaBlob blob = new AreaBlob(handler);
            blob.addBlock(hashPos, new LinkedList<AreaBlob>());
            atmhandler.registerBlob(handler, pos, blob);
            return true;
        }
        if (worldIn.func_180495_p(pos.func_177974_f().func_177978_c()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177974_f().func_177968_d()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177974_f().func_177974_f()).func_177230_c() == this && !this.blobList.containsKey(new HashedBlockPosition(pos.func_177974_f()))) {
            pos = pos.func_177974_f();
            HashedBlockPosition hashPos = new HashedBlockPosition(pos);
            BlobHandler handler = new BlobHandler(worldIn, pos);
            this.blobList.put(hashPos, handler);
            AreaBlob blob = new AreaBlob(handler);
            blob.addBlock(hashPos, new LinkedList<AreaBlob>());
            atmhandler.registerBlob(handler, pos, blob);
            return true;
        }
        return false;
    }

    private static class BlobHandler
    implements IBlobHandler {
        World world;
        BlockPos pos;

        public BlobHandler(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        @Override
        public boolean canFormBlob() {
            return true;
        }

        @Override
        public World getWorldObj() {
            return this.world;
        }

        @Override
        public boolean canBlobsOverlap(HashedBlockPosition blockPosition, AreaBlob blob) {
            return false;
        }

        @Override
        public int getMaxBlobRadius() {
            return 0;
        }

        @Override
        public HashedBlockPosition getRootPosition() {
            return new HashedBlockPosition(this.pos);
        }

        @Override
        public int getTraceDistance() {
            return -1;
        }
    }
}

