/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.RecipesMachine;

public class BlockSmallPlatePress
extends PistonBlock {
    public BlockSmallPlatePress(AbstractBlock.Properties properties) {
        super(false, properties);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.field_72995_K && world.func_175625_s(pos) == null) {
            this.checkForMove(world, pos, state);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)Direction.DOWN)).func_206870_a((Property)field_176320_b, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.field_72995_K) {
            this.checkForMove(world, pos, state);
        }
    }

    private boolean shouldBeExtended(World worldIn, BlockPos pos, Direction facing) {
        for (Direction enumfacing : Direction.values()) {
            if (enumfacing == facing || !worldIn.func_175709_b(pos.func_177972_a(enumfacing), enumfacing)) continue;
            return true;
        }
        if (worldIn.func_175709_b(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.func_177984_a();
        for (Direction enumfacing1 : Direction.values()) {
            if (enumfacing1 == Direction.DOWN || !worldIn.func_175709_b(blockpos.func_177972_a(enumfacing1), enumfacing1)) continue;
            return true;
        }
        return false;
    }

    private void checkForMove(World worldIn, BlockPos pos, BlockState state) {
        ItemStack stack;
        Direction enumfacing = Direction.DOWN;
        boolean flag = this.shouldBeExtended(worldIn, pos, enumfacing);
        if (flag && (stack = this.getRecipe(worldIn, pos, state)) != null && !((Boolean)state.func_177229_b((Property)field_176320_b)).booleanValue()) {
            worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, stack));
            }
            if (new PistonBlockStructureHelper(worldIn, pos, Direction.DOWN, true).func_177253_a()) {
                worldIn.func_175641_c(pos, (Block)this, 0, enumfacing.func_176745_a());
            }
        } else if (!flag && ((Boolean)state.func_177229_b((Property)field_176320_b)).booleanValue()) {
            worldIn.func_175641_c(pos, (Block)this, 1, enumfacing.func_176745_a());
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!world.field_72995_K) {
            this.checkForMove(world, pos, state);
        }
    }

    private ItemStack getRecipe(World world, BlockPos pos, BlockState state) {
        if (world.func_175623_d(pos.func_177982_a(0, -1, 0))) {
            return null;
        }
        BlockState state2 = world.func_180495_p(pos.func_177982_a(0, -1, 0));
        Block block = state2.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            return null;
        }
        ItemStack stackInWorld = block.func_185473_a((IBlockReader)world, pos.func_177982_a(0, -1, 0), state2);
        List recipes = RecipesMachine.getInstance().getRecipes(((Object)((Object)this)).getClass());
        ItemStack stack = null;
        block0: for (IRecipe recipe : recipes) {
            for (ItemStack stack2 : (List)recipe.getPossibleIngredients().get(0)) {
                if (!stack2.func_77969_a(stackInWorld)) continue;
                stack = (ItemStack)recipe.getOutput().get(0);
                continue block0;
            }
        }
        if (world.func_180495_p(pos.func_177982_a(0, -2, 0)).func_177230_c() == Blocks.field_150343_Z) {
            return stack;
        }
        return null;
    }

    private boolean doMove(World worldIn, BlockPos pos, Direction directionIn, boolean extending) {
        PistonBlockStructureHelper pistonblockstructurehelper;
        BlockPos blockpos = pos.func_177972_a(directionIn);
        if (!extending && worldIn.func_180495_p(blockpos).func_203425_a(Blocks.field_150332_K)) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(pistonblockstructurehelper = new PistonBlockStructureHelper(worldIn, pos, directionIn, extending)).func_177253_a()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List list = pistonblockstructurehelper.func_177254_c();
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos1 = (BlockPos)list.get(i);
            BlockState blockstate = worldIn.func_180495_p(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
        }
        List list2 = pistonblockstructurehelper.func_177252_d();
        BlockState[] ablockstate = new BlockState[list.size() + list2.size()];
        Direction direction = extending ? directionIn : directionIn.func_176734_d();
        int j = 0;
        for (int k = list2.size() - 1; k >= 0; --k) {
            BlockPos blockpos2 = (BlockPos)list2.get(k);
            BlockState blockState = worldIn.func_180495_p(blockpos2);
            TileEntity tileentity = blockState.hasTileEntity() ? worldIn.func_175625_s(blockpos2) : null;
            BlockSmallPlatePress.func_220059_a((BlockState)blockState, (IWorld)worldIn, (BlockPos)blockpos2, (TileEntity)tileentity);
            worldIn.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 18);
            ablockstate[j++] = blockState;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = (BlockPos)list.get(l);
            BlockState blockState = worldIn.func_180495_p(blockpos3);
            blockpos3 = blockpos3.func_177972_a(direction);
            map.remove(blockpos3);
            worldIn.func_180501_a(blockpos3, (BlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)directionIn), 68);
            worldIn.func_175690_a(blockpos3, MovingPistonBlock.func_196343_a((BlockState)((BlockState)list1.get(l)), (Direction)directionIn, (boolean)extending, (boolean)false));
            ablockstate[j++] = blockState;
        }
        if (extending) {
            PistonType pistontype = PistonType.DEFAULT;
            BlockState blockstate4 = (BlockState)((BlockState)Blocks.field_150332_K.func_176223_P().func_206870_a((Property)PistonHeadBlock.field_176387_N, (Comparable)directionIn)).func_206870_a((Property)PistonHeadBlock.field_176325_b, (Comparable)pistontype);
            BlockState blockState = (BlockState)((BlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a((Property)MovingPistonBlock.field_196344_a, (Comparable)directionIn)).func_206870_a((Property)MovingPistonBlock.field_196345_b, (Comparable)PistonType.DEFAULT);
            map.remove(blockpos);
            worldIn.func_180501_a(blockpos, blockState, 68);
            worldIn.func_175690_a(blockpos, MovingPistonBlock.func_196343_a((BlockState)blockstate4, (Direction)directionIn, (boolean)true, (boolean)true));
        }
        BlockState blockstate3 = Blocks.field_150350_a.func_176223_P();
        for (BlockPos blockPos : map.keySet()) {
            worldIn.func_180501_a(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)entry.getValue();
            blockstate2.func_196948_b((IWorld)worldIn, blockpos5, 2);
            blockstate3.func_235734_a_((IWorld)worldIn, blockpos5, 2);
            blockstate3.func_196948_b((IWorld)worldIn, blockpos5, 2);
        }
        j = 0;
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = ablockstate[j++];
            BlockPos blockpos6 = (BlockPos)list2.get(i1);
            blockState.func_196948_b((IWorld)worldIn, blockpos6, 2);
            worldIn.func_195593_d(blockpos6, blockState.func_177230_c());
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            worldIn.func_195593_d((BlockPos)list.get(j1), ablockstate[j++].func_177230_c());
        }
        if (extending) {
            worldIn.func_195593_d(blockpos, Blocks.field_150332_K);
        }
        return true;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        Direction direction = (Direction)state.func_177229_b((Property)field_176387_N);
        if (!worldIn.field_72995_K) {
            boolean flag = this.shouldBeExtended(worldIn, pos, direction);
            if (flag && (id == 1 || id == 2)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176320_b, (Comparable)Boolean.valueOf(true)), 2);
                return false;
            }
            if (!flag && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (ForgeEventFactory.onPistonMovePre((World)worldIn, (BlockPos)pos, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.doMove(worldIn, pos, direction, true)) {
                return false;
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176320_b, (Comparable)Boolean.valueOf(true)), 67);
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1 || id == 2) {
            if (ForgeEventFactory.onPistonMovePre((World)worldIn, (BlockPos)pos, (Direction)direction, (boolean)false)) {
                return false;
            }
            TileEntity tileentity1 = worldIn.func_175625_s(pos.func_177972_a(direction));
            if (tileentity1 instanceof PistonTileEntity) {
                ((PistonTileEntity)tileentity1).func_145866_f();
            }
            BlockState blockstate = (BlockState)((BlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a((Property)MovingPistonBlock.field_196344_a, (Comparable)direction)).func_206870_a((Property)MovingPistonBlock.field_196345_b, (Comparable)PistonType.DEFAULT);
            worldIn.func_180501_a(pos, blockstate, 20);
            worldIn.func_175690_a(pos, MovingPistonBlock.func_196343_a((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)Direction.func_82600_a((int)(param & 7)))), (Direction)direction, (boolean)false, (boolean)true));
            worldIn.func_230547_a_(pos, blockstate.func_177230_c());
            blockstate.func_235734_a_((IWorld)worldIn, pos, 2);
            worldIn.func_217377_a(pos.func_177972_a(direction), false);
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        ForgeEventFactory.onPistonMovePost((World)worldIn, (BlockPos)pos, (Direction)direction, (id == 0 ? 1 : 0) != 0);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        Style style = Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GRAY).func_240712_a_(TextFormatting.ITALIC);
        tooltip.add((ITextComponent)new TranslationTextComponent("machine.tooltip.smallplatepress").func_240703_c_(style));
    }
}

