/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.cable;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import zmaster587.advancedRocketry.cable.CableNetwork;
import zmaster587.advancedRocketry.tile.cables.TilePipe;

public class HandlerCableNetwork {
    protected Hashtable<Integer, CableNetwork> networks = new Hashtable();

    public int getNewNetworkID() {
        CableNetwork net = CableNetwork.initNetwork();
        this.networks.put(net.networkID, net);
        return net.networkID;
    }

    public int mergeNetworks(int a, int b) {
        assert (this.networks.get(Math.max(a, b)) == null || this.networks.get(Math.min(a, b)) == null);
        this.networks.get(Math.min(a, b)).merge(this.networks.get(Math.max(a, b)));
        this.networks.get((Object)Integer.valueOf((int)Math.min((int)a, (int)b))).numCables += this.networks.get((Object)Integer.valueOf((int)Math.max((int)a, (int)b))).numCables;
        this.networks.remove(Math.max(a, b));
        return Math.min(a, b);
    }

    public void tickAllNetworks() {
        Iterator<Map.Entry<Integer, CableNetwork>> iter = this.networks.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next().getValue().tick();
        }
    }

    public boolean doesNetworkExist(int id) {
        return this.networks.containsKey(id);
    }

    public void addSource(TilePipe tilePipe, TileEntity tile, Direction dir) {
        this.networks.get(tilePipe.getNetworkID()).addSource(tile, dir.func_176734_d());
    }

    public void addSink(TilePipe tilePipe, TileEntity tile, Direction dir) {
        this.networks.get(tilePipe.getNetworkID()).addSink(tile, dir.func_176734_d());
    }

    public void removeNetworkByID(int id) {
        this.networks.remove(id);
    }

    public void removeFromAllTypes(TilePipe pipe, TileEntity tile) {
        if (pipe.isInitialized()) {
            this.networks.get(pipe.getNetworkID()).removeFromAll(tile);
        }
    }

    public String toString(int networkID) {
        if (this.networks.get(networkID) != null) {
            return this.networks.get(networkID).toString();
        }
        return "";
    }

    public CableNetwork getNetwork(int id) {
        return this.networks.get(id);
    }
}

