/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.cable;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.cable.CableNetwork;
import zmaster587.libVulpes.util.FluidUtils;

public class LiquidNetwork
extends CableNetwork {
    private final int MAX_TRANSFER = 100;

    public static LiquidNetwork initNetwork() {
        Random random = new Random(System.currentTimeMillis());
        int id = random.nextInt();
        while (usedIds.contains(id)) {
            id = random.nextInt();
        }
        LiquidNetwork net = new LiquidNetwork();
        usedIds.add(id);
        net.networkID = id;
        return net;
    }

    @Override
    public void tick() {
        int amount = 100;
        if (this.sinks.isEmpty() || this.sources.isEmpty()) {
            return;
        }
        Iterator sinkItr = this.sinks.iterator();
        while (sinkItr.hasNext()) {
            Map.Entry obj = (Map.Entry)sinkItr.next();
            IFluidHandler fluidHandleSink = (IFluidHandler)((TileEntity)obj.getKey()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (Direction)obj.getValue());
            Direction dir = (Direction)obj.getValue();
            Iterator sourceItr = this.sources.iterator();
            Fluid fluid = null;
            if (fluidHandleSink == null) {
                sinkItr.remove();
                AdvancedRocketry.logger.info("Tile at " + ((TileEntity)obj.getKey()).func_174877_v().toString() + " is added as a sink but has no fluid capabilities on the side connected");
                continue;
            }
            for (int i = 0; i < fluidHandleSink.getTanks(); ++i) {
                if (fluidHandleSink.getFluidInTank(i) == null) continue;
                fluid = fluidHandleSink.getFluidInTank(i).getFluid();
                break;
            }
            if (fluid == null) {
                block2: while (sourceItr.hasNext()) {
                    Map.Entry objSource = (Map.Entry)sourceItr.next();
                    IFluidHandler fluidHandleSource = (IFluidHandler)((TileEntity)objSource.getKey()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (Direction)obj.getValue());
                    if (fluidHandleSource == null) {
                        sourceItr.remove();
                        AdvancedRocketry.logger.info("Tile at " + ((TileEntity)obj.getKey()).func_174877_v().toString() + " is added as a source but has no fluid capabilities on the side connected");
                        continue;
                    }
                    for (int i = 0; i < fluidHandleSource.getTanks(); ++i) {
                        if (fluidHandleSource.getFluidInTank(i) == null) continue;
                        fluid = fluidHandleSource.getFluidInTank(i).getFluid();
                        continue block2;
                    }
                }
            }
            if (fluid == null) break;
            if (fluidHandleSink.fill(new FluidStack(fluid, 1), IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
            sourceItr = this.sources.iterator();
            int maxFill = Math.min(fluidHandleSink.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.SIMULATE), amount);
            int actualFill = 0;
            while (sourceItr.hasNext()) {
                Map.Entry objSource = (Map.Entry)sourceItr.next();
                IFluidHandler fluidHandleSource = (IFluidHandler)((TileEntity)objSource.getKey()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (Direction)obj.getValue());
                FluidStack fluid2 = fluidHandleSource.drain(maxFill, IFluidHandler.FluidAction.SIMULATE);
                if (fluid2 != null) {
                    int buffer;
                    if (fluid2 == null || !FluidUtils.areFluidsSameType((Fluid)fluid, (Fluid)fluid2.getFluid())) {
                        buffer = 0;
                    } else {
                        fluidHandleSource.drain(maxFill, IFluidHandler.FluidAction.EXECUTE);
                        buffer = fluid2.getAmount();
                    }
                    maxFill -= buffer;
                    actualFill += buffer;
                }
                if (maxFill != 0) continue;
                break;
            }
            fluidHandleSink.fill(new FluidStack(fluid, actualFill), IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

