/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IDayTimeReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.client.render.planet.ISkyRenderer;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.client.render.planet.RenderSpaceSky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;

public class ClientHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static boolean callCustomSkyRenderer(MatrixStack matrix, float partialTicks) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (!DimensionManager.getInstance().isDimensionCreated((World)world)) {
            return true;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties((World)world, new BlockPos(Minecraft.func_71410_x().field_71439_g.func_213303_ch()));
        ISkyRenderer renderer = properties.getSkyRenderer();
        if (renderer == null) {
            if (properties.isStation()) {
                properties.setSkyRenderer(new RenderSpaceSky());
            } else {
                properties.setSkyRenderer(new RenderPlanetarySky());
            }
            renderer = properties.getSkyRenderer();
        }
        renderer.render(matrix, partialTicks);
        return false;
    }

    public static float callTimeOfDay(float ogTime, IDayTimeReader reader) {
        if (!(reader instanceof World)) {
            return ogTime;
        }
        if (!DimensionManager.getInstance().isDimensionCreated((World)reader)) {
            return ogTime;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties((World)reader);
        if (properties.isStation() || properties.getId().equals((Object)ARConfiguration.GetSpaceDimId())) {
            return AdvancedRocketry.proxy.calculateCelestialAngleSpaceStation();
        }
        double d0 = MathHelper.func_181162_h((double)((double)reader.func_241851_ab() / (double)properties.rotationalPeriod - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }
}

