/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryEntities;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.AdvancedRocketryParticleTypes;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.client.KeyBindings;
import zmaster587.advancedRocketry.client.render.RenderComponents;
import zmaster587.advancedRocketry.client.render.RenderLaser;
import zmaster587.advancedRocketry.client.render.RenderTank;
import zmaster587.advancedRocketry.client.render.RendererPhantomBlock;
import zmaster587.advancedRocketry.client.render.RendererRocket;
import zmaster587.advancedRocketry.client.render.RendererRocketAssemblingMachine;
import zmaster587.advancedRocketry.client.render.entity.RenderButtonUIEntity;
import zmaster587.advancedRocketry.client.render.entity.RenderElevatorCapsule;
import zmaster587.advancedRocketry.client.render.entity.RenderHoverCraft;
import zmaster587.advancedRocketry.client.render.entity.RenderPlanetUIEntity;
import zmaster587.advancedRocketry.client.render.entity.RenderSeat;
import zmaster587.advancedRocketry.client.render.entity.RenderStarUIEntity;
import zmaster587.advancedRocketry.client.render.entity.RendererItem;
import zmaster587.advancedRocketry.client.render.multiblocks.RenderAreaGravityController;
import zmaster587.advancedRocketry.client.render.multiblocks.RenderAstrobodyDataProcessor;
import zmaster587.advancedRocketry.client.render.multiblocks.RenderBeacon;
import zmaster587.advancedRocketry.client.render.multiblocks.RenderBiomeScanner;
import zmaster587.advancedRocketry.client.render.multiblocks.RenderBlackHoleGenerator;
import zmaster587.advancedRocketry.client.render.multiblocks.RenderCentrifuge;
import zmaster587.advancedRocketry.client.render.multiblocks.RenderOrbitalLaserDrill;
import zmaster587.advancedRocketry.client.render.multiblocks.RenderTerraformerAtm;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererChemicalReactor;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererCrystallizer;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererCuttingMachine;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererElectrolyser;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererLathe;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererMicrowaveReciever;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererObservatory;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererPrecisionAssembler;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererPrecisionLaserEtcher;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererRailgun;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererRollingMachine;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererSolarArray;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererSpaceElevator;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererWarpCore;
import zmaster587.advancedRocketry.common.CommonProxy;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.FxSkyLaser;
import zmaster587.advancedRocketry.entity.fx.FxLaser;
import zmaster587.advancedRocketry.entity.fx.FxLaserHeat;
import zmaster587.advancedRocketry.entity.fx.FxLaserSpark;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.api.LibVulpesTileEntityTypes;
import zmaster587.libVulpes.entity.fx.FxErrorBlock;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;

public class ClientProxy
extends CommonProxy {
    private static DimensionManager dimensionManagerClient = new DimensionManager();

    @Override
    public void initDeferredRegistries() {
        AdvancedRocketryParticleTypes.init();
    }

    @Override
    public void registerRenderers() {
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_ROCKET_BUILDER, dispatcher -> new RendererRocketAssemblingMachine((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_STATION_BUILDER, dispatcher -> new RendererRocketAssemblingMachine((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_PREC_ASS, dispatcher -> new RendererPrecisionAssembler((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_CUTTING_MACHINE, dispatcher -> new RendererCuttingMachine((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_CRYSTALLIZER, dispatcher -> new RendererCrystallizer((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_OBSERVATORY, dispatcher -> new RendererObservatory((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_ASTROBODY_DATA, dispatcher -> new RenderAstrobodyDataProcessor((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_LATHE, dispatcher -> new RendererLathe((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_ROLLING, dispatcher -> new RendererRollingMachine((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_ELECTROLYSER, dispatcher -> new RendererElectrolyser((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_WARP_CORE, dispatcher -> new RendererWarpCore((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_CHEMICAL_REACTOR, dispatcher -> new RendererChemicalReactor((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer((TileEntityType)LibVulpesTileEntityTypes.TILE_SCHEMATIC, dispatcher -> new RendererPhantomBlock((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_MICROWAVE_RECIEVER, dispatcher -> new RendererMicrowaveReciever((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_SPACE_LASER, dispatcher -> new RenderOrbitalLaserDrill((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_BIOME_SCANNER, dispatcher -> new RenderBiomeScanner((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_BLACK_HOLE_GENERATOR, dispatcher -> new RenderBlackHoleGenerator((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_TERRAFORMER, dispatcher -> new RenderTerraformerAtm((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_FLUID_TANK, dispatcher -> new RenderTank((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_RAILGUN, dispatcher -> new RendererRailgun((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_GRAVITY_CONTROLLER, dispatcher -> new RenderAreaGravityController((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_SPACE_ELEVATOR, dispatcher -> new RendererSpaceElevator((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_BEACON, dispatcher -> new RenderBeacon((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_CENTRIFUGE, dispatcher -> new RenderCentrifuge((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_PREC_LASER_ETCHER, dispatcher -> new RendererPrecisionLaserEtcher((TileEntityRendererDispatcher)dispatcher));
        ClientRegistry.bindTileEntityRenderer(AdvancedRocketryTileEntityType.TILE_SOLAR_ARRAY, dispatcher -> new RendererSolarArray((TileEntityRendererDispatcher)dispatcher));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_ROCKET, (IRenderFactory)new RendererRocket(null));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_LASER_NODE, (IRenderFactory)new RenderLaser(2.0, new float[]{1.0f, 0.25f, 0.25f, 0.2f}, new float[]{0.9f, 0.2f, 0.3f, 0.5f}));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_ITEM_ABDUCTED, (IRenderFactory)new RendererItem(Minecraft.func_71410_x().func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_UIPLANET, (IRenderFactory)new RenderPlanetUIEntity(null));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_UIBUTTON, (IRenderFactory)new RenderButtonUIEntity(null));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_UISTAR, (IRenderFactory)new RenderStarUIEntity(null));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_ELEVATOR_CAPSULE, (IRenderFactory)new RenderElevatorCapsule(null));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_HOVER_CRAFT, (IRenderFactory)new RenderHoverCraft(null));
        RenderingRegistry.registerEntityRenderingHandler(AdvancedRocketryEntities.ENTITY_DUMMY, (IRenderFactory)new RenderSeat(null));
    }

    @Override
    public void init() {
        Minecraft.func_71410_x().getItemColors().func_199877_a(new IItemColor(){

            public int getColor(ItemStack stack, int tintIndex) {
                return tintIndex > 0 ? -1 : ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack);
            }
        }, new IItemProvider[]{AdvancedRocketryItems.itemSpaceSuit_Boots, AdvancedRocketryItems.itemSpaceSuit_Chest, AdvancedRocketryItems.itemSpaceSuit_Helmet, AdvancedRocketryItems.itemSpaceSuit_Leggings});
        AdvancedRocketry.materialRegistry.init();
        RenderTypeLookup.setRenderLayer((Block)AdvancedRocketryBlocks.blockStructureTower, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)AdvancedRocketryBlocks.blockUnlitTorch, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)AdvancedRocketryBlocks.blockUnlitTorchWall, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)AdvancedRocketryBlocks.blockThermiteTorch, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)AdvancedRocketryBlocks.blockThermiteTorchWall, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)AdvancedRocketryBlocks.blockLens, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)AdvancedRocketryBlocks.blockForceField, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)AdvancedRocketryBlocks.blockPressureTank, (RenderType)RenderType.func_228643_e_());
        for (Block block : AdvancedRocketryBlocks.crystalBlocks) {
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228645_f_());
        }
    }

    @Override
    public void preInitBlocks() {
    }

    @Override
    public void preInitItems() {
    }

    @Override
    public void preinit() {
        this.registerRenderers();
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new RocketEventHandler());
        MinecraftForge.EVENT_BUS.register(ModuleContainerPan.class);
        MinecraftForge.EVENT_BUS.register((Object)new RenderComponents());
    }

    @Override
    public void fireFogBurst(ISpaceObject station) {
        try {
            PlanetEventHandler.runBurst(Minecraft.func_71410_x().field_71441_e.func_82737_E() + 20L, 20L);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void registerKeyBindings() {
        KeyBindings.init();
        MinecraftForge.EVENT_BUS.register((Object)new KeyBindings());
    }

    @Override
    public IProfiler getProfiler() {
        return Minecraft.func_71410_x().func_213239_aq();
    }

    @Override
    public void changeClientPlayerWorld(World world) {
        Minecraft.func_71410_x().field_71439_g.field_70170_p = world;
    }

    @Override
    public void spawnParticle(String particle, World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        if (particle == "rocketFlame") {
            world.func_195594_a((IParticleData)AdvancedRocketryParticleTypes.rocketFx.get(), x, y, z, motionX, motionY, motionZ);
        } else if (particle == "smallRocketFlame") {
            world.func_195594_a((IParticleData)AdvancedRocketryParticleTypes.rocketFx.get(), x, y, z, motionX, motionY, motionZ);
        } else if (particle == "rocketSmoke") {
            world.func_195594_a((IParticleData)AdvancedRocketryParticleTypes.trailFx.get(), x, y, z, motionX, motionY, motionZ);
        } else if (particle == "rocketSmokeInverse") {
            world.func_195594_a((IParticleData)AdvancedRocketryParticleTypes.inverseTrailFx.get(), x, y, z, motionX, motionY, motionZ);
        } else if (particle == "arc") {
            world.func_195594_a((IParticleData)AdvancedRocketryParticleTypes.fxElectricArc.get(), x, y, z, motionX, 0.0, 0.0);
        } else if (particle == "smallLazer") {
            FxSkyLaser fx = new FxSkyLaser(world, x, y, z);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        } else if (particle == "errorBox") {
            FxErrorBlock fx = new FxErrorBlock((ClientWorld)world, x, y, z);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        } else if (particle.equals("gravityEffect")) {
            world.func_195594_a((IParticleData)AdvancedRocketryParticleTypes.fxGravityEffect.get(), x, y, z, motionX, motionY, motionZ);
        } else if (particle.equals("oxygencloudFx")) {
            world.func_195594_a((IParticleData)AdvancedRocketryParticleTypes.oxygenCloudFx.get(), x, y, z, motionX, motionY, motionZ);
        } else if (particle.equals("oxygentraceFx")) {
            world.func_195594_a((IParticleData)AdvancedRocketryParticleTypes.oxygenlTraceFx.get(), x, y, z, motionX, motionY, motionZ);
        }
    }

    @Override
    public void spawnLaser(Entity entity, Vector3d toPos) {
        FxLaser fx = new FxLaser(entity.field_70170_p, toPos.field_72450_a, toPos.field_72448_b, toPos.field_72449_c, entity);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        FxLaserHeat fx2 = new FxLaserHeat(entity.field_70170_p, toPos.field_72450_a, toPos.field_72448_b, toPos.field_72449_c, 0.02f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx2);
        for (int i = 0; i < 4; ++i) {
            FxLaserSpark fx3 = new FxLaserSpark(entity.field_70170_p, toPos.field_72450_a, toPos.field_72448_b, toPos.field_72449_c, 0.125 - (double)(entity.field_70170_p.field_73012_v.nextFloat() / 4.0f), 0.125 - (double)(entity.field_70170_p.field_73012_v.nextFloat() / 4.0f), 0.125 - (double)(entity.field_70170_p.field_73012_v.nextFloat() / 4.0f), 0.5);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx3);
        }
    }

    @Override
    public float calculateCelestialAngleSpaceStation() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        try {
            return (float)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos(player.func_213303_ch())).getRotation(Direction.EAST);
        }
        catch (NullPointerException e) {
            return 0.0f;
        }
    }

    @Override
    public long getWorldTimeUniversal() {
        try {
            return Minecraft.func_71410_x().field_71441_e.func_82737_E();
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    @Override
    public void loadUILayout(ARConfiguration config) {
    }

    @Override
    public void saveUILayout(ARConfiguration configuration) {
    }

    @Override
    public void displayMessage(String msg, int time) {
        RocketEventHandler.setOverlay(Minecraft.func_71410_x().field_71441_e.func_82737_E() + (long)time, msg);
    }

    @Override
    public String getNameFromBiome(Biome biome) {
        return AdvancedRocketryBiomes.getBiomeResource(biome).toString();
    }

    @Override
    public DimensionManager getDimensionManager() {
        return dimensionManagerClient;
    }
}

