/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ClientDynamicTexture {
    private BufferedImage image;
    private static final byte BYTES_PER_PIXEL = 4;
    int textureId;

    public ClientDynamicTexture() {
        this(512, 512);
    }

    public ClientDynamicTexture(int x, int y) {
        this.image = new BufferedImage(x, y, 2);
        this.textureId = -1;
        this.init();
    }

    public int getHeight() {
        return 512;
    }

    public int getWidth() {
        return 512;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setPixel(int x, int y, int color) {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.image.getHeight() * this.image.getWidth() * 4));
        GL11.glBindTexture((int)3553, (int)this.getTextureId());
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        buffer.putInt(x + y * this.image.getHeight(), color);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
    }

    public IntBuffer getByteBuffer() {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.image.getHeight() * this.image.getWidth() * 4));
        int[] pixels = new int[this.image.getWidth() * this.image.getHeight()];
        this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), pixels, 0, this.image.getWidth());
        IntBuffer ret = buffer.asIntBuffer();
        ret.put(pixels);
        return ret;
    }

    public void setByteBuffer(IntBuffer buffer) {
        GL11.glBindTexture((int)3553, (int)this.getTextureId());
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)0, (int)6408, (int)5121, (IntBuffer)buffer);
    }

    private void init() {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.image.getHeight() * this.image.getWidth() * 4));
        for (int i = 0; i < this.image.getHeight() * this.image.getWidth(); ++i) {
            buffer.putInt(0);
        }
        buffer.flip();
        GL11.glBindTexture((int)3553, (int)this.getTextureId());
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
    }

    public int getTextureId() {
        if (this.textureId != -1) {
            return this.textureId;
        }
        this.textureId = GL11.glGenTextures();
        return this.textureId;
    }
}

