/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.advancedRocketry.tile.TileFluidTank;
import zmaster587.libVulpes.render.RenderHelper;

public class RenderTank
extends TileEntityRenderer<TileFluidTank> {
    public RenderTank(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileFluidTank tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        TileFluidTank fluidTile = tile;
        FluidStack fluid = fluidTile.getFluidInTank(0);
        ResourceLocation fluidIcon = new ResourceLocation("advancedrocketry:textures/blocks/fluid/oxygen_flow.png");
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        if (fluid != null && fluid.getFluid() != null) {
            matrix.func_227860_a_();
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 0.0f;
            float maxV = 1.0f;
            Optional mat = ForgeHooksClient.getFluidMaterials((Fluid)fluid.getFluid()).findFirst();
            if (mat.isPresent()) {
                TextureAtlasSprite sprite = ((RenderMaterial)mat.get()).func_229314_c_();
                fluidIcon = ((RenderMaterial)mat.get()).func_229310_a_();
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
            int color = fluid.getFluid().getAttributes().getColor();
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
            BlockState block = tile.func_195044_w();
            Tessellator tess = Tessellator.func_178181_a();
            float amt = (float)fluid.getAmount() / (float)fluidTile.getTankCapacity(0);
            AxisAlignedBB bb = block.func_196954_c((IBlockReader)tile.func_145831_w(), tile.func_174877_v()).func_197752_a();
            IVertexBuilder tileBuffer = buffer.getBuffer(RenderHelper.getTranslucentTexturedManualRenderType((ResourceLocation)fluidIcon));
            RenderHelper.renderCubeWithUV((MatrixStack)matrix, (IVertexBuilder)tileBuffer, (double)(bb.field_72340_a + 0.01), (double)(bb.field_72338_b + 0.01), (double)(bb.field_72339_c + 0.01), (double)(bb.field_72336_d - 0.01), (double)(bb.field_72337_e * (double)amt - 0.01), (double)(bb.field_72334_f - 0.01), (float)minU, (float)maxU, (float)minV, (float)maxV, (float)r, (float)g, (float)b, (float)a);
            matrix.func_227865_b_();
        }
    }
}

