/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import zmaster587.advancedRocketry.backwardCompat.ModelFormatException;
import zmaster587.advancedRocketry.backwardCompat.WavefrontObject;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererWarpCore;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityUIPlanet;
import zmaster587.libVulpes.render.RenderHelper;

public class RenderPlanetUIEntity
extends EntityRenderer<EntityUIPlanet>
implements IRenderFactory<EntityUIPlanet> {
    private static WavefrontObject sphere;
    public static ResourceLocation planetUIBG;
    public static ResourceLocation planetUIFG;

    public RenderPlanetUIEntity(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public EntityRenderer<? super EntityUIPlanet> createRenderFor(EntityRendererManager manager) {
        return new RenderPlanetUIEntity(manager);
    }

    public ResourceLocation getEntityTexture(EntityUIPlanet entity) {
        return DimensionProperties.PlanetIcons.EARTHLIKE.getResource();
    }

    public void render(EntityUIPlanet entity, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer bufferIn, int packedLightIn) {
        DimensionProperties properties = entity.getProperties();
        if (properties == null) {
            return;
        }
        float sizeScale = Math.max(properties.gravitationalMultiplier * properties.gravitationalMultiplier * entity.getScale(), 0.5f);
        int j = packedLightIn;
        int k = OverlayTexture.field_229196_a_;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, (double)(sizeScale * 0.03f), 0.0);
        matrix.func_227862_a_(0.1f * sizeScale, 0.1f * sizeScale, 0.1f * sizeScale);
        IVertexBuilder translucentBuffer = bufferIn.getBuffer(RenderHelper.getTranslucentEntityModelRenderType((ResourceLocation)properties.getPlanetIconLEO()));
        matrix.func_227860_a_();
        matrix.func_227863_a_(new Quaternion(0.0f, (float)(entity.field_70170_p.func_82737_E() & 0xFFL), 0.0f, true));
        sphere.tessellateAll(matrix, j, k, translucentBuffer);
        IVertexBuilder atmBuffer = bufferIn.getBuffer(RenderHelper.getLightningTranslucencyNoTexEntityModelRenderType());
        if (properties.hasAtmosphere()) {
            matrix.func_227860_a_();
            matrix.func_227862_a_(1.1f, 1.1f, 1.1f);
            for (int i = 0; i < 5; ++i) {
                matrix.func_227862_a_(1.01f, 1.01f, 1.01f);
                sphere.renderOnly(matrix, 0, 0, atmBuffer, properties.skyColor[0], properties.skyColor[1], properties.skyColor[2], 0.5f, "Sphere");
            }
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        IVertexBuilder buf = bufferIn.getBuffer(RenderHelper.getTranslucentManualRenderType());
        float myTime = (float)(entity.field_70170_p.func_82737_E() & 0xFL) / 16.0f;
        for (int i = 0; i < 4; ++i) {
            myTime = (float)((long)(i * 4) + entity.field_70170_p.func_82737_E() & 0xFL) / 16.0f;
            RenderHelper.renderTopFace((MatrixStack)matrix, (IVertexBuilder)buf, (double)((double)myTime - 0.5), (double)-0.5, (double)-0.5, (double)0.5, (double)0.5, (float)0.0f, (float)1.0f, (float)1.0f, (float)(0.2f * (1.0f - myTime)));
            RenderHelper.renderBottomFace((MatrixStack)matrix, (IVertexBuilder)buf, (double)((double)myTime - 0.5), (double)-0.5, (double)-0.5, (double)0.5, (double)0.5, (float)0.0f, (float)1.0f, (float)1.0f, (float)(0.2f * (1.0f - myTime)));
        }
        matrix.func_227865_b_();
        if (entity.isSelected()) {
            double speedRotate = 0.025;
            float r = 0.4f;
            float g = 0.4f;
            float b = 1.0f;
            float a = 0.6f;
            matrix.func_227861_a_(0.0, -1.25, 0.0);
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, (float)(speedRotate * (double)System.currentTimeMillis() % 360.0), 0.0f, true));
            RendererWarpCore.model.renderOnly(matrix, j, k, translucentBuffer, r, g, b, a, "Rotate1");
            matrix.func_227865_b_();
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, (float)(180.0 + speedRotate * (double)System.currentTimeMillis() % 360.0), 0.0f, true));
            RendererWarpCore.model.renderOnly(matrix, j, k, translucentBuffer, r, g, b, a, "Rotate1");
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
        RayTraceResult hitObj = Minecraft.func_71410_x().field_71476_x;
        if (hitObj != null && hitObj.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)hitObj).func_216348_a() == entity) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, (double)(sizeScale * 0.1f), 0.0);
            sizeScale = 0.005f * sizeScale;
            matrix.func_227862_a_(sizeScale, sizeScale, sizeScale);
            matrix.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, 180.0f, true));
            IVertexBuilder HUDBufferFG = bufferIn.getBuffer(RenderHelper.getTranslucentTexturedManualRenderType((ResourceLocation)planetUIFG));
            this.renderMassIndicator(matrix, HUDBufferFG, Math.min(properties.gravitationalMultiplier / 2.0f, 1.0f));
            IVertexBuilder HUDBufferBG = bufferIn.getBuffer(RenderHelper.getTranslucentTexturedManualRenderType((ResourceLocation)planetUIBG));
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)HUDBufferBG, (double)1.0, (double)-40.0, (double)-25.0, (double)40.0, (double)55.0, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            HUDBufferFG = bufferIn.getBuffer(RenderHelper.getTranslucentTexturedManualRenderType((ResourceLocation)planetUIFG));
            this.renderATMIndicator(matrix, HUDBufferFG, Math.min((float)properties.getAtmosphereDensity() / 200.0f, 1.0f));
            this.renderTemperatureIndicator(matrix, HUDBufferFG, Math.min((float)properties.getAverageTemp() / 400.0f, 1.0f));
            RenderHelper.renderTag((MatrixStack)matrix, (IRenderTypeBuffer)bufferIn, (double)Minecraft.func_71410_x().field_71439_g.func_70092_e(hitObj.func_216347_e().field_72449_c, hitObj.func_216347_e().field_72448_b, hitObj.func_216347_e().field_72450_a), (String)properties.getName(), (int)packedLightIn, (float)5.0f);
            RenderHelper.renderTag((MatrixStack)matrix, (IRenderTypeBuffer)bufferIn, (double)Minecraft.func_71410_x().field_71439_g.func_70092_e(hitObj.func_216347_e().field_72449_c, hitObj.func_216347_e().field_72448_b, hitObj.func_216347_e().field_72450_a), (String)("NumMoons: " + properties.getChildPlanets().size()), (int)packedLightIn, (float)5.0f);
            matrix.func_227865_b_();
        }
    }

    protected void renderMassIndicator(MatrixStack matrix, IVertexBuilder buffer, float percent) {
        float maxUV = (1.0f - percent) * 0.5f;
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-20.0, (double)(-5.0f + 41.0f * (1.0f - percent)), (double)20.0, (double)36.0, (float)0.5f, (float)0.0f, (float)0.5f, (float)maxUV, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderATMIndicator(MatrixStack matrix, IVertexBuilder buffer, float percent) {
        float maxUV = (1.0f - percent) * 0.406f + 0.578f;
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)6.0, (double)(20.0f + (1.0f - percent) * 33.0f), (double)39.0, (double)53.0, (float)0.5624f, (float)0.984f, (float)0.984f, (float)maxUV, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderTemperatureIndicator(MatrixStack matrix, IVertexBuilder buffer, float percent) {
        float maxUV = (1.0f - percent) * 0.406f + 0.578f;
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-38.0, (double)(21.4f + (1.0f - percent) * 33.0f), (double)-4.0, (double)53.0, (float)0.016f, (float)0.4376f, (float)0.984f, (float)maxUV, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        planetUIBG = new ResourceLocation("advancedrocketry", "textures/gui/planetuioverlay.png");
        planetUIFG = new ResourceLocation("advancedrocketry", "textures/gui/planetuioverlayfg.png");
        try {
            sphere = new WavefrontObject(new ResourceLocation("advancedrocketry:models/atmosphere.obj"));
        }
        catch (ModelFormatException e) {
            throw new RuntimeException(e);
        }
    }
}

