/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityUIStar;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.render.RenderHelper;

public class RenderStarUIEntity
extends EntityRenderer<EntityUIStar>
implements IRenderFactory<EntityUIStar> {
    public RenderStarUIEntity(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public EntityRenderer<? super EntityUIStar> createRenderFor(EntityRendererManager manager) {
        return new RenderStarUIEntity(manager);
    }

    public ResourceLocation getEntityTexture(EntityUIStar entity) {
        return DimensionProperties.PlanetIcons.EARTHLIKE.getResource();
    }

    public void render(EntityUIStar entity, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer bufferIn, int packedLightIn) {
        StellarBody body = entity.getStarProperties();
        if (body == null) {
            return;
        }
        float sizeScale = entity.getScale();
        matrix.func_227862_a_(sizeScale, sizeScale, sizeScale);
        matrix.func_227860_a_();
        matrix.func_227862_a_(0.1f, 0.1f, 0.1f);
        matrix.func_227861_a_(0.0, 2.5, 0.0);
        matrix.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
        IVertexBuilder translucentBuffer = bufferIn.getBuffer(RenderHelper.getTranslucentTexturedManualRenderType((ResourceLocation)TextureResources.locationSunNew));
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)translucentBuffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)body.getColor()[0], (float)body.getColor()[1], (float)body.getColor()[2], (float)1.0f);
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        matrix.func_227862_a_(0.1f, 0.1f, 0.1f);
        IVertexBuilder buf = bufferIn.getBuffer(RenderHelper.getTranslucentManualRenderType());
        float myTime = (float)(entity.field_70170_p.func_82737_E() & 0xFL) / 16.0f;
        for (int i = 0; i < 4; ++i) {
            myTime = (float)((long)(i * 4) + entity.field_70170_p.func_82737_E() & 0xFL) / 16.0f;
            RenderHelper.renderTopFace((MatrixStack)matrix, (IVertexBuilder)buf, (double)myTime, (double)-0.5, (double)-0.5, (double)0.5, (double)0.5, (float)0.0f, (float)1.0f, (float)1.0f, (float)(0.2f * (1.0f - myTime)));
            RenderHelper.renderBottomFace((MatrixStack)matrix, (IVertexBuilder)buf, (double)((double)myTime - 0.5), (double)-0.5, (double)-0.5, (double)0.5, (double)0.5, (float)0.0f, (float)1.0f, (float)1.0f, (float)(0.2f * (1.0f - myTime)));
        }
        matrix.func_227865_b_();
    }

    protected void renderMassIndicator(MatrixStack matrix, BufferBuilder buffer, float percent) {
        float maxUV = (1.0f - percent) * 0.5f;
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-20.0, (double)(-5.0f + 41.0f * (1.0f - percent)), (double)20.0, (double)36.0, (float)0.5f, (float)0.0f, (float)0.5f, (float)maxUV, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderATMIndicator(MatrixStack matrix, BufferBuilder buffer, float percent) {
        float maxUV = (1.0f - percent) * 0.406f + 0.578f;
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)6.0, (double)(20.0f + (1.0f - percent) * 33.0f), (double)39.0, (double)53.0, (float)0.5624f, (float)0.984f, (float)0.984f, (float)maxUV, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderTemperatureIndicator(MatrixStack matrix, BufferBuilder buffer, float percent) {
        float maxUV = (1.0f - percent) * 0.406f + 0.578f;
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-38.0, (double)(21.4f + (1.0f - percent) * 33.0f), (double)-4.0, (double)53.0, (float)0.016f, (float)0.4376f, (float)0.984f, (float)maxUV, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

