/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.multiblocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockDisplayReader;
import zmaster587.advancedRocketry.backwardCompat.ModelFormatException;
import zmaster587.advancedRocketry.backwardCompat.WavefrontObject;
import zmaster587.advancedRocketry.tile.multiblock.TileAreaGravityController;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.render.RenderHelper;

public class RenderAreaGravityController
extends TileEntityRenderer<TileAreaGravityController> {
    WavefrontObject model;
    ResourceLocation texture = new ResourceLocation("advancedrocketry:textures/models/areagravitycontroller.png");

    public RenderAreaGravityController(TileEntityRendererDispatcher tile) {
        super(tile);
        try {
            this.model = new WavefrontObject(new ResourceLocation("advancedrocketry:models/areagravitycontroller.obj"));
        }
        catch (ModelFormatException e) {
            e.printStackTrace();
        }
    }

    public void render(TileAreaGravityController tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        int i;
        if (!tile.canRender()) {
            return;
        }
        combinedLightIn = tile.func_145831_w() != null ? WorldRenderer.func_228421_a_((IBlockDisplayReader)tile.func_145831_w(), (BlockPos)tile.func_174877_v().func_177982_a(0, 1, 0)) : 0xF000F0;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, -0.5, 0.5);
        Direction front = RotatableBlock.getFront((BlockState)tile.func_145831_w().func_180495_p(tile.func_174877_v()));
        matrix.func_227863_a_(new Quaternion(0.0f, (float)(front.func_82601_c() == 1 ? 180 : 0) + (float)front.func_82599_e() * 90.0f, 0.0f, true));
        IVertexBuilder entitySolidBuilder = buffer.getBuffer(RenderHelper.getSolidEntityModelRenderType((ResourceLocation)this.texture));
        this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Hull");
        int maxSize = 5;
        matrix.func_227860_a_();
        entitySolidBuilder = buffer.getBuffer(RenderHelper.getSolidEntityModelRenderType((ResourceLocation)this.texture));
        matrix.func_227863_a_(new Quaternion(0.0f, (float)tile.getArmRotation(), 0.0f, true));
        for (i = 0; i < maxSize; ++i) {
            matrix.func_227863_a_(new Quaternion(0.0f, 360.0f / (float)maxSize, 0.0f, true));
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Arm");
        }
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        matrix.func_227862_a_(1.11f, 1.0f, 1.11f);
        IVertexBuilder entityTransBuilder = buffer.getBuffer(RenderHelper.getLightningTranslucencyNoTexEntityModelRenderType());
        for (i = 0; i < 4; ++i) {
            matrix.func_227862_a_(0.93f, 1.0f, 0.93f);
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entityTransBuilder, 0.0f, 1.0f, 1.0f, Math.max(((float)tile.getGravityMultiplier() - 0.1f) * 0.2f, 0.0f), "Blur");
        }
        matrix.func_227865_b_();
        matrix.func_227865_b_();
    }
}

