/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.multiblocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import zmaster587.advancedRocketry.backwardCompat.ModelFormatException;
import zmaster587.advancedRocketry.backwardCompat.WavefrontObject;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileLathe;
import zmaster587.libVulpes.api.material.MaterialRegistry;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.render.RenderHelper;

public class RendererLathe
extends TileEntityRenderer<TileLathe> {
    WavefrontObject model;
    ResourceLocation texture = new ResourceLocation("advancedrocketry", "textures/models/lathe.png");

    public RendererLathe(TileEntityRendererDispatcher tile) {
        super(tile);
        try {
            this.model = new WavefrontObject(new ResourceLocation("advancedrocketry", "models/lathe.obj"));
        }
        catch (ModelFormatException e) {
            e.printStackTrace();
        }
    }

    public void render(TileLathe tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.canRender()) {
            return;
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.0, 0.5);
        Direction front = RotatableBlock.getFront((BlockState)tile.func_145831_w().func_180495_p(tile.func_174877_v()));
        matrix.func_227863_a_(new Quaternion(0.0f, (float)(front.func_82601_c() == 1 ? 0 : 180) + (float)front.func_82599_e() * 90.0f, 0.0f, true));
        matrix.func_227861_a_(-0.5, -1.0, -2.5);
        IVertexBuilder entitySolidBuilder = buffer.getBuffer(RenderHelper.getTranslucentEntityModelRenderType((ResourceLocation)this.texture));
        if (tile.isRunning()) {
            ItemStack outputStack;
            float progress = (float)tile.getProgress(0) / (float)tile.getTotalProgress(0);
            this.model.tessellatePart(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Hull");
            matrix.func_227860_a_();
            if (progress < 0.95f) {
                matrix.func_227861_a_(0.0, 0.0, (double)(-progress / 0.85f));
            } else {
                matrix.func_227861_a_(0.0, 0.0, (double)(-(1.0f - progress) / 0.05f));
            }
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Tool");
            matrix.func_227865_b_();
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.375, 0.9375, 0.0);
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, progress * 1500.0f, true));
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Shaft");
            matrix.func_227865_b_();
            int color = tile.getOutputs() != null && (outputStack = (ItemStack)tile.getOutputs().get(0)) != null ? MaterialRegistry.getColorFromItemMaterial((ItemStack)outputStack) : 0;
            float r = (float)(0xFF & color >> 16) / 255.0f;
            float g = (float)(0xFF & color >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.375, 1.1875, 0.0);
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, progress * 1500.0f, true));
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, r, g, b, 1.0f, "Rod");
            matrix.func_227865_b_();
        } else {
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Hull");
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Tool");
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.375, 0.9375, 0.0);
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Sool");
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }
}

