/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.multiblocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.tile.multiblock.energy.TileMicrowaveReciever;
import zmaster587.libVulpes.render.RenderHelper;

public class RendererMicrowaveReciever
extends TileEntityRenderer<TileMicrowaveReciever> {
    ResourceLocation texture = new ResourceLocation("advancedrocketry", "textures/blocks/solar.png");
    ResourceLocation panelSide = new ResourceLocation("advancedrocketry", "textures/blocks/panelside.png");

    public RendererMicrowaveReciever(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileMicrowaveReciever tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        double distance;
        if (!tile.canRender()) {
            return;
        }
        matrix.func_227860_a_();
        IVertexBuilder entitySolidManual = buffer.getBuffer(RenderHelper.getSolidTexturedManualRenderType((ResourceLocation)this.texture));
        if (((Boolean)ARConfiguration.getCurrentConfig().advancedVFX.get()).booleanValue() && tile.getPowerMadeLastTick() > 0 && (distance = tile.func_174877_v().func_177951_i((Vector3i)new BlockPos(Minecraft.func_71410_x().field_71439_g.func_213303_ch()))) < 256.0) {
            int g;
            int i;
            double u = 256.0 / distance;
            double resolution = (int)u;
            double[][] yLoc = new double[(int)resolution][(int)resolution];
            for (i = 0; i < (int)resolution; ++i) {
                for (g = 0; g < (int)resolution; ++g) {
                    double amplitideMax = 0.002 / resolution;
                    amplitideMax *= resolution / 2.0 - Math.abs((double)g - resolution / 2.0);
                    yLoc[i][g] = (amplitideMax *= resolution / 2.0 - Math.abs((double)i - resolution / 2.0)) * (double)MathHelper.func_76126_a((float)((float)((long)(i * 16 + g) + tile.func_145831_w().func_82737_E() & 0xFFFFL) * 0.5f));
                }
            }
            matrix.func_227860_a_();
            matrix.func_227861_a_(-2.0, 0.0, -2.0);
            for (i = 0; i < (int)resolution; ++i) {
                for (g = 0; g < (int)resolution; ++g) {
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)entitySolidManual, (double)(1.01 + yLoc[i][g]), (double)((double)(5 * i) / resolution), (double)((double)(5 * g) / resolution), (double)((double)(5 * (i + 1)) / resolution), (double)((double)(5 * (g + 1)) / resolution), (float)((float)((double)(5 * i) / resolution)), (float)((float)((double)(5 * (i + 1)) / resolution)), (float)((float)((double)(5 * g) / resolution)), (float)((float)((double)(5 * (g + 1)) / resolution)), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            matrix.func_227865_b_();
        }
        RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)entitySolidManual, (double)1.01, (double)-2.0, (double)-2.0, (double)3.0, (double)3.0, (float)0.0f, (float)5.0f, (float)0.0f, (float)5.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IVertexBuilder entitySolidSideManual = buffer.getBuffer(RenderHelper.getSolidTexturedManualRenderType((ResourceLocation)this.panelSide));
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManual, (double)-1.99, (double)-2.0, (double)0.0, (double)3.0, (double)1.0, (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderSouthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManual, (double)2.99, (double)-2.0, (double)0.0, (double)3.0, (double)1.0, (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderEastFaceWithUV((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManual, (double)2.99, (double)0.0, (double)-2.0, (double)1.0, (double)3.0, (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderWestFaceWithUV((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManual, (double)-1.99, (double)0.0, (double)-2.0, (double)1.0, (double)3.0, (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IVertexBuilder entitySolidSideManualColor = buffer.getBuffer(RenderHelper.getSolidManualRenderType());
        RenderHelper.renderBottomFace((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManualColor, (double)0.001, (double)-2.0, (double)-2.0, (double)3.0, (double)3.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderCube((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManualColor, (double)-2.0, (double)0.99, (double)-2.0, (double)-1.9, (double)1.1, (double)3.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderCube((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManualColor, (double)-2.0, (double)0.99, (double)-2.0, (double)3.0, (double)1.1, (double)-1.9, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderCube((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManualColor, (double)-1.9, (double)0.99, (double)2.9, (double)3.0, (double)1.1, (double)3.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderCube((MatrixStack)matrix, (IVertexBuilder)entitySolidSideManualColor, (double)2.9, (double)0.99, (double)-1.9, (double)3.0, (double)1.1, (double)3.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 0.5f;
        if (tile.getPowerMadeLastTick() > 0) {
            matrix.func_227860_a_();
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            IVertexBuilder laserBeam = buffer.getBuffer(RenderHelper.getLaserBeamType());
            for (float radius = 0.25f; radius < 2.0f; radius += 0.25f) {
                double i;
                for (i = 0.0; i < Math.PI * 2; i += Math.PI) {
                    laserBeam.func_225582_a_((double)(-x), (double)(-y + 200.0f), (double)(-z)).func_227885_a_(r, g, b, a).func_181675_d();
                    laserBeam.func_225582_a_((double)(-x), (double)(-y + 200.0f), (double)(-z)).func_227885_a_(r, g, b, a).func_181675_d();
                    laserBeam.func_225582_a_(-((double)radius * Math.cos(i)) + 0.5, 0.0, -((double)radius * Math.sin(i)) + 0.5).func_227885_a_(r, g, b, a).func_181675_d();
                    laserBeam.func_225582_a_((double)radius * Math.sin(i) + 0.5, 0.0, (double)radius * Math.cos(i) + 0.5).func_227885_a_(r, g, b, a).func_181675_d();
                }
                for (i = 0.0; i < Math.PI * 2; i += Math.PI) {
                    laserBeam.func_225582_a_((double)(-x), (double)(-y + 200.0f), (double)(-z)).func_227885_a_(r, g, b, a).func_181675_d();
                    laserBeam.func_225582_a_((double)(-x), (double)(-y + 200.0f), (double)(-z)).func_227885_a_(r, g, b, a).func_181675_d();
                    laserBeam.func_225582_a_((double)radius * Math.sin(i) + 0.5, 0.0, -((double)radius * Math.cos(i)) + 0.5).func_227885_a_(r, g, b, a).func_181675_d();
                    laserBeam.func_225582_a_(-((double)radius * Math.cos(i)) + 0.5, 0.0, (double)radius * Math.sin(i) + 0.5).func_227885_a_(r, g, b, a).func_181675_d();
                }
            }
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }
}

