/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.multiblocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockDisplayReader;
import zmaster587.advancedRocketry.backwardCompat.ModelFormatException;
import zmaster587.advancedRocketry.backwardCompat.WavefrontObject;
import zmaster587.advancedRocketry.client.render.RenderLaser;
import zmaster587.advancedRocketry.tile.multiblock.TileSpaceElevator;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.render.RenderHelper;

public class RendererSpaceElevator
extends TileEntityRenderer<TileSpaceElevator> {
    WavefrontObject model;
    public ResourceLocation baseTexture = new ResourceLocation("advancedrocketry", "textures/models/spaceelevator.png");
    RenderLaser laser = new RenderLaser(1.0, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, new float[]{1.0f, 1.0f, 0.0f, 0.11f});

    public RendererSpaceElevator(TileEntityRendererDispatcher tile) {
        super(tile);
        try {
            this.model = new WavefrontObject(new ResourceLocation("advancedrocketry", "models/spaceelevator.obj"));
        }
        catch (ModelFormatException e) {
            e.printStackTrace();
        }
    }

    public void render(TileSpaceElevator tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        float rotationAmount;
        if (!tile.canRender()) {
            return;
        }
        combinedLightIn = tile.func_145831_w() != null ? WorldRenderer.func_228421_a_((IBlockDisplayReader)tile.func_145831_w(), (BlockPos)tile.func_174877_v().func_177982_a(0, 1, 0)) : 0xF000F0;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.0, 0.5);
        Direction front = RotatableBlock.getFront((BlockState)tile.func_145831_w().func_180495_p(tile.func_174877_v()));
        float f = rotationAmount = tile.isAnchorOnSpaceStation() ? 180.0f : 0.0f;
        if (front.func_176740_k() == Direction.Axis.X) {
            matrix.func_227863_a_(new Quaternion(rotationAmount, 0.0f, 0.0f, true));
        } else {
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, rotationAmount, true));
        }
        matrix.func_227863_a_(new Quaternion(0.0f, (float)(front.func_82601_c() == 1 ? 180 : 0) + (float)front.func_82599_e() * 90.0f, 0.0f, true));
        float yOffset = tile.isAnchorOnSpaceStation() ? -1.0f : 0.0f;
        matrix.func_227861_a_(4.5, (double)yOffset, 0.5);
        IVertexBuilder entitySolidBuilder = buffer.getBuffer(RenderHelper.getSolidEntityModelRenderType((ResourceLocation)this.baseTexture));
        this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Anchor");
        if (tile.isTetherConnected()) {
            this.model.renderOnly(matrix, combinedLightIn, combinedOverlayIn, entitySolidBuilder, "Tether");
        }
        matrix.func_227865_b_();
        IVertexBuilder translucentBuilder = buffer.getBuffer(RenderHelper.getTranslucentManualRenderType());
        matrix.func_227860_a_();
        matrix.func_227861_a_(tile.getLandingLocationX() - (double)tile.func_174877_v().func_177958_n(), 0.0, tile.getLandingLocationZ() - (double)tile.func_174877_v().func_177952_p());
        if (tile.isTetherConnected() && !tile.isAnchorOnSpaceStation()) {
            double renderX = tile.getLandingLocationX() - (double)tile.func_174877_v().func_177958_n() - (front.func_176740_k() == Direction.Axis.X ? 0.5 : 2.5);
            double renderZ = tile.getLandingLocationZ() - (double)tile.func_174877_v().func_177952_p() - (front.func_176740_k() == Direction.Axis.X ? -1.5 : 0.5);
            matrix.func_227860_a_();
            matrix.func_227861_a_(renderX + 0.5, 4.0, renderZ + 0.5);
            this.laser.doRender(buffer, matrix);
            double position = (float)(System.currentTimeMillis() % 16000L) / 200.0f;
            for (int i = 1; i < 11; ++i) {
                float radius = 0.25f;
                while ((double)radius < 1.25) {
                    RenderHelper.renderCube((MatrixStack)matrix, (IVertexBuilder)translucentBuilder, (double)(-radius), (double)((double)(-radius) - position + (double)(i * 80) + 4.0), (double)(-radius), (double)radius, (double)((double)radius - position + (double)(i * 80) + 4.0), (double)radius, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.11f);
                    radius += 0.25f;
                }
            }
        }
        matrix.func_227865_b_();
    }
}

