/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.planet;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.client.render.planet.ISkyRenderer;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.Vector3F;

public class RenderPlanetarySky
implements ISkyRenderer {
    private final VertexFormat skyVertexFormat = DefaultVertexFormats.field_181705_e;
    private VertexBuffer starGLCallList;
    private VertexBuffer glSkyList;
    private VertexBuffer glSkyList2;
    private VertexBuffer glSkyList3;
    ResourceLocation currentlyBoundTex = null;
    float celestialAngle;
    Vector3F<Float> axis;
    public static final ResourceLocation asteroid1 = new ResourceLocation("advancedrocketry:textures/planets/asteroid_a.png");
    public static final ResourceLocation asteroid2 = new ResourceLocation("advancedrocketry:textures/planets/asteroid_b.png");
    public static final ResourceLocation asteroid3 = new ResourceLocation("advancedrocketry:textures/planets/asteroid_c.png");
    Minecraft mc = Minecraft.func_71410_x();

    public RenderPlanetarySky() {
        this.axis = new Vector3F((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        this.generateStars();
        this.generateSky();
        this.generateSky2();
        this.generateAsteroids();
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.glSkyList2 != null) {
            this.glSkyList2.close();
        }
        this.glSkyList2 = new VertexBuffer(this.skyVertexFormat);
        this.renderSky(bufferbuilder, -16.0f, true);
        bufferbuilder.func_178977_d();
        this.glSkyList2.func_227875_a_(bufferbuilder);
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.glSkyList != null) {
            this.glSkyList.close();
        }
        this.glSkyList = new VertexBuffer(this.skyVertexFormat);
        this.renderSky(bufferbuilder, 16.0f, false);
        bufferbuilder.func_178977_d();
        this.glSkyList.func_227875_a_(bufferbuilder);
    }

    private void renderSky(BufferBuilder bufferBuilderIn, float posY, boolean reverseX) {
        int i = 64;
        int j = 6;
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                bufferBuilderIn.func_225582_a_((double)f, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f1, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f1, (double)posY, (double)(l + 64)).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f, (double)posY, (double)(l + 64)).func_181675_d();
            }
        }
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.starGLCallList != null) {
            this.starGLCallList.close();
        }
        this.starGLCallList = new VertexBuffer(this.skyVertexFormat);
        this.renderStars(bufferbuilder);
        bufferbuilder.func_178977_d();
        this.starGLCallList.func_227875_a_(bufferbuilder);
    }

    private void renderStars(BufferBuilder bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.func_225582_a_(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }

    private void generateAsteroids() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.glSkyList3 != null) {
            this.glSkyList3.close();
        }
        this.glSkyList3 = new VertexBuffer(DefaultVertexFormats.field_181707_g);
        this.renderAsteroids(bufferbuilder);
        this.glSkyList3.func_227875_a_(bufferbuilder);
    }

    private void renderAsteroids(BufferBuilder buffer) {
        Random random = new Random(10843L);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < 200; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 1.0f - 0.5f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double size = 0.15f + random.nextFloat();
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 0.5 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            float r = random.nextFloat() * 0.05f + 0.95f;
            float g = random.nextFloat() * 0.1f + 0.9f;
            float b = random.nextFloat() * 0.1f + 0.9f;
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * size;
                double d19 = (double)((j + 1 & 2) - 1) * size;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                buffer.func_225582_a_(d5 + d24, d6 + d22, d7 + d25).func_225583_a_((float)(d18 / (size * 2.0) + 0.5), (float)(d19 / (size * 2.0) + 0.5)).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            }
        }
        buffer.func_178977_d();
    }

    @Override
    public void render(MatrixStack matrix, float partialTicks) {
        float f10;
        float f8;
        float f7;
        float f6;
        Vector3d sunColor;
        boolean isMoon;
        int solarOrbitalDistance;
        LinkedList<DimensionProperties> children;
        float atmosphere;
        DimensionProperties properties;
        Minecraft mc = Minecraft.func_71410_x();
        DimensionManager dimensionMgr = DimensionManager.getInstance();
        ClientWorld world = mc.field_71441_e;
        int planetOrbitalDistance = 0;
        double myPhi = 0.0;
        double myTheta = 0.0;
        double myPrevOrbitalTheta = 0.0;
        double myRotationalPhi = 0.0;
        boolean hasAtmosphere = false;
        float[] parentAtmColor = new float[]{1.0f, 1.0f, 1.0f};
        float[] parentRingColor = new float[]{1.0f, 1.0f, 1.0f};
        float[] ringColor = new float[]{1.0f, 1.0f, 1.0f};
        float sunSize = 1.0f;
        float starSeperation = 0.0f;
        boolean isWarp = false;
        boolean isGasGiant = false;
        boolean hasRings = false;
        boolean parentPlanetHasDecorator = true;
        boolean parentHasRings = false;
        DimensionProperties parentProperties = null;
        Direction travelDirection = null;
        ResourceLocation parentPlanetIcon = null;
        StellarBody primaryStar = DimensionManager.getSol();
        this.celestialAngle = mc.field_71441_e.func_72929_e(partialTicks);
        BlockPos playerPos = new BlockPos(mc.field_71439_g.func_213303_ch());
        if (dimensionMgr.isDimensionCreated((World)mc.field_71441_e)) {
            properties = DimensionManager.getInstance().getDimensionProperties((World)mc.field_71441_e, new BlockPos(mc.field_71439_g.func_213303_ch()));
            atmosphere = properties.getAtmosphereDensityAtHeight(mc.func_175606_aa().func_226278_cu_());
            Direction dir = this.getRotationAxis(properties, playerPos);
            this.axis.x = Float.valueOf(dir.func_82601_c());
            this.axis.y = Float.valueOf(dir.func_96559_d());
            this.axis.z = Float.valueOf(dir.func_82599_e());
            myPhi = properties.orbitalPhi;
            myTheta = properties.orbitTheta;
            myRotationalPhi = properties.rotationalPhi;
            myPrevOrbitalTheta = properties.prevOrbitalTheta;
            hasRings = properties.hasRings();
            ringColor = properties.ringColor;
            children = new LinkedList();
            for (ResourceLocation i : properties.getChildPlanets()) {
                children.add(DimensionManager.getInstance().getDimensionProperties(i));
            }
            solarOrbitalDistance = properties.getSolarOrbitalDistance();
            isMoon = properties.isMoon();
            if (isMoon) {
                parentProperties = properties.getParentProperties();
                isGasGiant = parentProperties.isGasGiant();
                hasAtmosphere = parentProperties.hasAtmosphere();
                planetOrbitalDistance = properties.getParentOrbitalDistance();
                parentAtmColor = parentProperties.skyColor;
                parentPlanetIcon = this.getTextureForPlanet(parentProperties);
                parentHasRings = parentProperties.hasRings;
                parentRingColor = parentProperties.ringColor;
            }
            float[] sunColorFloat = properties.getSunColor();
            sunColor = new Vector3d((double)sunColorFloat[0], (double)sunColorFloat[1], (double)sunColorFloat[2]);
            primaryStar = properties.getStar();
            if (primaryStar != null) {
                sunSize = properties.getStar().getSize();
                starSeperation = properties.getStar().getStarSeparation();
            } else {
                primaryStar = DimensionManager.getSol();
            }
            if (properties.isStation() && (isWarp = SpaceObjectManager.WARPDIMID.equals((Object)properties.getParentPlanet()))) {
                SpaceStationObject station = (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(playerPos);
                travelDirection = station.getForwardDirection();
            }
        } else {
            children = new LinkedList<DimensionProperties>();
            isMoon = false;
            hasAtmosphere = DimensionManager.overworldProperties.hasAtmosphere();
            atmosphere = DimensionManager.overworldProperties.getAtmosphereDensityAtHeight(mc.func_175606_aa().func_226278_cu_());
            solarOrbitalDistance = DimensionManager.overworldProperties.orbitalDist;
            sunColor = new Vector3d(1.0, 1.0, 1.0);
            primaryStar = DimensionManager.overworldProperties.getStar();
            properties = DimensionManager.overworldProperties;
        }
        RenderSystem.disableTexture();
        Vector3d vec3 = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f1 = (float)vec3.field_72450_a;
        float f2 = (float)vec3.field_72448_b;
        float f3 = (float)vec3.field_72449_c;
        RenderSystem.color3f((float)(f1 *= atmosphere), (float)(f2 *= atmosphere), (float)(f3 *= atmosphere));
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f1, (float)f2, (float)f3);
        this.glSkyList.func_177359_a();
        DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
        this.glSkyList.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        DefaultVertexFormats.field_181705_e.func_227895_d_();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        float[] afloat = world.func_239132_a_().func_230492_a_(world.func_242415_f(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, MathHelper.func_76126_a((float)mc.field_71441_e.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f, true));
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, 90.0f - (float)myRotationalPhi, true));
            f6 = afloat[0];
            f7 = afloat[1];
            f8 = afloat[2];
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)100.0, (double)0.0).func_227885_a_(f6, f7, f8, afloat[3] * atmosphere).func_181675_d();
            int b0 = 16;
            for (int j = 0; j <= b0; ++j) {
                float f11 = (float)j * (float)Math.PI * 2.0f / (float)b0;
                float f12 = MathHelper.func_76126_a((float)f11);
                float f13 = MathHelper.func_76134_b((float)f11);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3])).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        matrix.func_227860_a_();
        f6 = atmosphere > 0.0f ? 1.0f - mc.field_71441_e.func_72867_j(partialTicks) * (atmosphere / 100.0f) : 1.0f;
        f7 = 0.0f;
        f8 = 0.0f;
        float f9 = 0.0f;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
        matrix.func_227861_a_((double)f7, (double)f8, (double)f9);
        matrix.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
        float multiplier = (2.0f - atmosphere) / 2.0f;
        if (mc.field_71441_e.func_175727_C(new BlockPos(mc.field_71439_g.func_213303_ch().func_72441_c(0.0, 199.0, 0.0)))) {
            multiplier *= 1.0f - mc.field_71441_e.func_72867_j(partialTicks);
        }
        matrix.func_227863_a_(new Quaternion(0.0f, (float)myRotationalPhi, 0.0f, true));
        if (hasRings) {
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            f10 = 100.0f;
            double ringDist = 0.0;
            mc.func_110434_K().func_110577_a(DimensionProperties.planetRings);
            matrix.func_227863_a_(new Quaternion(70.0f, 0.0f, 0.0f, true));
            matrix.func_227861_a_(0.0, -10.0, 0.0);
            RenderSystem.color4f((float)ringColor[0], (float)ringColor[1], (float)ringColor[2], (float)multiplier);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)ringDist, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)ringDist, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)ringDist, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)ringDist, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227865_b_();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            matrix.func_227863_a_(new Quaternion(70.0f, 0.0f, 0.0f, true));
            matrix.func_227863_a_(new Quaternion(0.0f, isWarp ? 0.0f : this.celestialAngle * 360.0f, 0.0f, true));
            matrix.func_227861_a_(0.0, -10.0, 0.0);
            mc.func_110434_K().func_110577_a(DimensionProperties.planetRingShadow);
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)multiplier);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)ringDist, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)ringDist, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)ringDist, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)ringDist, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227865_b_();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        if (!isWarp) {
            this.rotateAroundAxis(matrix);
        }
        RenderSystem.disableTexture();
        float f18 = mc.field_71441_e.func_228330_j_(partialTicks) * f6 * atmosphere + (1.0f - atmosphere);
        if (mc.field_71441_e.func_175727_C(playerPos)) {
            f18 *= 1.0f - mc.field_71441_e.func_72867_j(partialTicks);
        }
        if (f18 > 0.0f) {
            RenderSystem.color4f((float)f18, (float)f18, (float)f18, (float)f18);
            matrix.func_227860_a_();
            if (isWarp) {
                for (int i = -3; i < 5; ++i) {
                    matrix.func_227860_a_();
                    double magnitude = (float)(i * -100) + (float)((System.currentTimeMillis() + 50L) % 2000L) / 20.0f;
                    matrix.func_227861_a_((double)(-travelDirection.func_82599_e()) * magnitude, 0.0, (double)travelDirection.func_82601_c() * magnitude);
                    this.starGLCallList.func_177359_a();
                    DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
                    this.starGLCallList.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
                    VertexBuffer.func_177361_b();
                    DefaultVertexFormats.field_181705_e.func_227895_d_();
                    matrix.func_227865_b_();
                }
            } else {
                this.starGLCallList.func_177359_a();
                DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
                this.starGLCallList.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
                VertexBuffer.func_177361_b();
                DefaultVertexFormats.field_181705_e.func_227895_d_();
                if ((double)atmosphere < 0.5) {
                    RenderSystem.color4f((float)f18, (float)f18, (float)f18, (float)(f18 / 2.0f));
                    matrix.func_227860_a_();
                    matrix.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
                    this.starGLCallList.func_177359_a();
                    DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
                    VertexBuffer.func_177361_b();
                    DefaultVertexFormats.field_181705_e.func_227895_d_();
                    matrix.func_227865_b_();
                }
                if ((double)atmosphere < 0.25) {
                    RenderSystem.color4f((float)f18, (float)f18, (float)f18, (float)(f18 / 4.0f));
                    matrix.func_227860_a_();
                    matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                    this.starGLCallList.func_177359_a();
                    DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
                    VertexBuffer.func_177361_b();
                    DefaultVertexFormats.field_181705_e.func_227895_d_();
                    matrix.func_227865_b_();
                }
                RenderSystem.color4f((float)f18, (float)f18, (float)f18, (float)f18);
            }
            matrix.func_227865_b_();
        }
        RenderSystem.enableTexture();
        if (!isWarp) {
            this.drawStarAndSubStars(buffer, matrix, primaryStar, properties, solarOrbitalDistance, sunSize, sunColor, multiplier);
        }
        f10 = 20.0f;
        if (isMoon) {
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, (float)myPhi, true));
            matrix.func_227863_a_(new Quaternion((float)(((double)partialTicks * myTheta + (double)(1.0f - partialTicks) * myPrevOrbitalTheta) * 180.0 / Math.PI), 0.0f, 0.0f, true));
            float phiAngle = (float)(myPhi * Math.PI / 180.0);
            double x = MathHelper.func_76126_a((float)phiAngle) * MathHelper.func_76134_b((float)((float)myTheta));
            double y = -MathHelper.func_76126_a((float)((float)myTheta));
            double rotation = -1.5707963267948966 + Math.atan2(x, y) - (myTheta - Math.PI) * (double)MathHelper.func_76126_a((float)phiAngle);
            if (parentHasRings) {
                matrix.func_227860_a_();
                matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                f10 = 100.0f;
                double ringDist = 0.0;
                mc.func_110434_K().func_110577_a(DimensionProperties.planetRings);
                matrix.func_227863_a_(new Quaternion(70.0f, 0.0f, 0.0f, true));
                matrix.func_227861_a_(0.0, -10.0, 50.0);
                RenderSystem.color4f((float)parentRingColor[0], (float)parentRingColor[1], (float)parentRingColor[2], (float)multiplier);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)ringDist, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)ringDist, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)ringDist, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)ringDist, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
                RenderSystem.blendFunc((int)770, (int)771);
                matrix.func_227860_a_();
                matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(70.0f, 0.0f, 0.0f, true));
                matrix.func_227861_a_(0.0, -10.0, 50.0);
                mc.func_110434_K().func_110577_a(DimensionProperties.planetRingShadow);
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)ringDist, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)ringDist, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)ringDist, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)ringDist, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
                RenderSystem.blendFunc((int)770, (int)1);
            }
            assert (parentProperties != null);
            this.renderPlanet(buffer, matrix, parentProperties, planetOrbitalDistance, multiplier, rotation, false, false, (float)Math.pow(parentProperties.getGravitationalMultiplier(), 0.4));
            matrix.func_227865_b_();
        }
        for (DimensionProperties moons : children) {
            matrix.func_227860_a_();
            double rot = ((double)partialTicks * moons.orbitTheta + (double)(1.0f - partialTicks) * moons.prevOrbitalTheta) * 180.0 / Math.PI;
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, (float)moons.orbitalPhi, true));
            matrix.func_227863_a_(new Quaternion(0.0f, (float)rot, 0.0f, true));
            float phiAngle = (float)(moons.orbitalPhi * Math.PI / 180.0);
            double x = -MathHelper.func_76126_a((float)phiAngle) * MathHelper.func_76134_b((float)((float)moons.orbitTheta));
            double y = MathHelper.func_76126_a((float)((float)moons.orbitTheta));
            double rotation = -1.5707963267948966 + Math.atan2(x, y) - (moons.orbitTheta - Math.PI) * (double)MathHelper.func_76126_a((float)phiAngle);
            this.renderPlanet(buffer, matrix, moons, moons.getParentOrbitalDistance(), multiplier, rotation, moons.hasAtmosphere(), moons.hasRings, (float)Math.pow(moons.gravitationalMultiplier, 0.4));
            matrix.func_227865_b_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrix.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = this.mc.field_71439_g.func_226280_cw_() - world.func_72912_H().func_239159_f_();
        if (d0 < 0.0 && !properties.isAsteroid() && !properties.isStation()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 12.0, 0.0);
            this.glSkyList2.func_177359_a();
            this.skyVertexFormat.func_227892_a_(0L);
            this.glSkyList2.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.skyVertexFormat.func_227895_d_();
            matrix.func_227865_b_();
        }
        RenderSystem.enableTexture();
        RenderSystem.enableTexture();
        if (properties.isAsteroid()) {
            mc.func_110434_K().func_110577_a(asteroid1);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.glSkyList3.func_177359_a();
            DefaultVertexFormats.field_181707_g.func_227892_a_(0L);
            this.glSkyList3.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_181707_g.func_227895_d_();
            matrix.func_227860_a_();
            GL11.glRotatef((float)90.0f, (float)0.2f, (float)0.8f, (float)0.0f);
            mc.func_110434_K().func_110577_a(asteroid2);
            this.glSkyList3.func_177359_a();
            DefaultVertexFormats.field_181707_g.func_227892_a_(0L);
            this.glSkyList3.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_181707_g.func_227895_d_();
            GL11.glRotatef((float)90.0f, (float)0.2f, (float)0.8f, (float)0.0f);
            mc.func_110434_K().func_110577_a(asteroid3);
            this.glSkyList3.func_177359_a();
            DefaultVertexFormats.field_181707_g.func_227892_a_(0L);
            this.glSkyList3.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_181707_g.func_227895_d_();
            matrix.func_227865_b_();
        }
        RenderSystem.depthMask((boolean)true);
        RocketEventHandler.onPostWorldRender(matrix, partialTicks);
        RenderSystem.blendFunc((int)770, (int)771);
    }

    protected ResourceLocation getTextureForPlanet(DimensionProperties properties) {
        return properties.getPlanetIcon();
    }

    protected ResourceLocation getTextureForPlanetLEO(DimensionProperties properties) {
        return properties.getPlanetIcon();
    }

    protected Direction getRotationAxis(DimensionProperties properties, BlockPos pos) {
        return Direction.EAST;
    }

    protected void renderPlanet(BufferBuilder buffer, MatrixStack matrix, DimensionProperties properties, float planetOrbitalDistance, float alphaMultiplier, double shadowAngle, boolean hasAtmosphere, boolean hasRing, float gravitationalMultiplier) {
        this.renderPlanet2(buffer, matrix, properties, 20.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance) * gravitationalMultiplier, alphaMultiplier, shadowAngle, hasRing);
    }

    protected void renderPlanet2(BufferBuilder buffer, MatrixStack matrix, DimensionProperties properties, float size, float alphaMultiplier, double shadowAngle, boolean hasRing) {
        ResourceLocation icon = this.getTextureForPlanet(properties);
        boolean hasAtmosphere = properties.hasAtmosphere();
        boolean gasGiant = properties.isGasGiant();
        boolean hasDecorators = properties.hasDecorators();
        float[] skyColor = properties.skyColor;
        float[] ringColor = properties.skyColor;
        RenderPlanetarySky.renderPlanetPubHelper(buffer, matrix, icon, 0, 0, -20.0, size * 0.2f, alphaMultiplier, shadowAngle, hasAtmosphere, skyColor, ringColor, gasGiant, hasRing, hasDecorators);
    }

    protected void rotateAroundAxis(MatrixStack matrix) {
        Vector3F<Float> axis = this.getRotateAxis();
        float x = this.getSkyRotationAmount() * ((Float)axis.x).floatValue();
        float y = this.getSkyRotationAmount() * ((Float)axis.y).floatValue();
        float z = this.getSkyRotationAmount() * ((Float)axis.z).floatValue();
        matrix.func_227863_a_(new Quaternion(x, y, z, false));
    }

    protected float getSkyRotationAmount() {
        return this.celestialAngle;
    }

    protected Vector3F<Float> getRotateAxis() {
        return this.axis;
    }

    public static void renderPlanetPubHelper(BufferBuilder buffer, MatrixStack matrix, ResourceLocation icon, int locationX, int locationY, double zLevel, float size, float alphaMultiplier, double shadowAngle, boolean hasAtmosphere, float[] skyColor, float[] ringColor, boolean gasGiant, boolean hasRing, boolean hasDecorators) {
        float f15;
        RenderSystem.enableBlend();
        float f10 = size;
        float f14 = 1.0f;
        float f16 = f15 = 0.0f;
        float f17 = f14;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)locationX, zLevel, (double)locationY);
        if (hasDecorators) {
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, (float)(90.0 - shadowAngle * 180.0 / Math.PI), 0.0f, true));
            if (hasRing) {
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.color4f((float)ringColor[0], (float)ringColor[1], (float)ringColor[2], (float)(alphaMultiplier * 0.2f));
                float ringSize = f10 * 1.4f;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.planetRings);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-ringSize), (double)(zLevel - (double)0.01f), (double)ringSize).func_225583_a_(f16, f17).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)ringSize, (double)(zLevel - (double)0.01f), (double)ringSize).func_225583_a_(f14, f17).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)ringSize, (double)(zLevel - (double)0.01f), (double)(-ringSize)).func_225583_a_(f14, f15).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-ringSize), (double)(zLevel - (double)0.01f), (double)(-ringSize)).func_225583_a_(f16, f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)alphaMultiplier);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.planetRingShadow);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-ringSize), (double)(zLevel - (double)0.01f), (double)ringSize).func_225583_a_(f16, f17).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)ringSize, (double)(zLevel - (double)0.01f), (double)ringSize).func_225583_a_(f14, f17).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)ringSize, (double)(zLevel - (double)0.01f), (double)(-ringSize)).func_225583_a_(f14, f15).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-ringSize), (double)(zLevel - (double)0.01f), (double)(-ringSize)).func_225583_a_(f16, f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
            RenderSystem.blendFunc((int)770, (int)1);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.atmGlow);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)(zLevel + (double)0.01f), (double)f10).func_225583_a_(f16, f17).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)(zLevel + (double)0.01f), (double)f10).func_225583_a_(f14, f17).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)(zLevel + (double)0.01f), (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)(zLevel + (double)0.01f), (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227865_b_();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        RenderSystem.blendFunc((int)770, (int)771);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
        RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)zLevel, (double)f10).func_225583_a_(f16, f17).func_181675_d();
        RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)zLevel, (double)f10).func_225583_a_(f14, f17).func_181675_d();
        RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)zLevel, (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
        RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)zLevel, (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        if (hasDecorators) {
            if (hasAtmosphere) {
                RenderSystem.blendFunc((int)770, (int)1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.getAtmosphereResource());
                RenderSystem.color4f((float)skyColor[0], (float)skyColor[1], (float)skyColor[2], (float)alphaMultiplier);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)zLevel, (double)f10).func_225583_a_(f16, f17).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)zLevel, (double)f10).func_225583_a_(f14, f17).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)zLevel, (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)zLevel, (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
            matrix.func_227863_a_(new Quaternion(0.0f, (float)(90.0 - shadowAngle * 180.0 / Math.PI), 0.0f, true));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.getShadowResource());
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)(zLevel - (double)0.01f), (double)f10).func_225583_a_(f16, f17).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)(zLevel - (double)0.01f), (double)f10).func_225583_a_(f14, f17).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)(zLevel - (double)0.01f), (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)(zLevel - (double)0.01f), (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        matrix.func_227865_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawStarAndSubStars(BufferBuilder buffer, MatrixStack matrix, StellarBody sun, DimensionProperties properties, int solarOrbitalDistance, float sunSize, Vector3d sunColor, float multiplier) {
        this.drawStar(buffer, matrix, sun, properties, solarOrbitalDistance, sunSize, sunColor, multiplier);
        List<StellarBody> subStars = sun.getSubStars();
        if (subStars != null && !subStars.isEmpty()) {
            matrix.func_227860_a_();
            float phaseInc = 360 / subStars.size();
            for (StellarBody subStar : subStars) {
                matrix.func_227863_a_(new Quaternion(0.0f, phaseInc, 0.0f, true));
                matrix.func_227860_a_();
                matrix.func_227863_a_(new Quaternion(subStar.getStarSeparation() * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance), 0.0f, 0.0f, true));
                float[] color = subStar.getColor();
                this.drawStar(buffer, matrix, subStar, properties, solarOrbitalDistance, subStar.getSize(), new Vector3d((double)color[0], (double)color[1], (double)color[2]), multiplier);
                matrix.func_227865_b_();
            }
            matrix.func_227865_b_();
        }
    }

    protected void drawStar(BufferBuilder buffer, MatrixStack matrix, StellarBody sun, DimensionProperties properties, int solarOrbitalDistance, float sunSize, Vector3d sunColor, float multiplier) {
        if (sun != null && sun.isBlackHole()) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableAlphaTest();
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            this.mc.func_110434_K().func_110577_a(TextureResources.locationBlackHole);
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 100.0, 0.0);
            float phase = (float)(-(System.currentTimeMillis() % 3600L)) / 3600.0f;
            float scale = 1.0f + (float)Math.sin((double)phase * 3.14) * 0.1f;
            matrix.func_227863_a_(new Quaternion(0.0f, phase *= 360.0f, 0.0f, true));
            matrix.func_227862_a_(scale, scale, scale);
            RenderSystem.color4f((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float f10 = sunSize * 2.5f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227865_b_();
            this.mc.func_110434_K().func_110577_a(TextureResources.locationAccretionDisk);
            RenderSystem.depthMask((boolean)false);
            for (int i = 0; i < 3; ++i) {
                float speedMult = (float)i * 1.01f + 1.0f;
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, 100.0, 0.0);
                matrix.func_227863_a_(new Quaternion(-80.0f, 80.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(speedMult * 36000.0f))) / (100.0f * speedMult), 0.0f, true));
                RenderSystem.color4f((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 20.0f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)99.99f, 0.0);
                matrix.func_227863_a_(new Quaternion(-80.0f, 80.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 50.0f))) / (50.0f * speedMult), 0.0f, true));
                RenderSystem.color4f((float)0.8f, (float)0.7f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 15.0f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)99.98f, 0.0);
                matrix.func_227863_a_(new Quaternion(-80.0f, 80.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 25.0f))) / (25.0f * speedMult), 0.0f, true));
                RenderSystem.color4f((float)0.2f, (float)0.4f, (float)1.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 7.5f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
            }
            RenderSystem.depthMask((boolean)true);
            GL11.glClear((int)256);
            RenderSystem.depthMask((boolean)false);
        } else {
            this.mc.func_110434_K().func_110577_a(TextureResources.locationSunPng);
            RenderSystem.color4f((float)((float)sunColor.field_72450_a), (float)((float)sunColor.field_72448_b), (float)((float)sunColor.field_72449_c), (float)Math.min(multiplier * 2.0f, 1.0f));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float f10 = sunSize * 15.0f * AstronomicalBodyHelper.getBodySizeMultiplier(solarOrbitalDistance);
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)100.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)100.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)100.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)100.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }
}

