/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.planet;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.Vector3F;

public class RenderSpaceSky
extends RenderPlanetarySky {
    Minecraft mc = Minecraft.func_71410_x();

    @Override
    protected void drawStar(BufferBuilder buffer, MatrixStack matrix, StellarBody sun, DimensionProperties properties, int solarOrbitalDistance, float sunSize, Vector3d sunColor, float multiplier) {
        DimensionProperties parentProperties = properties.getParentProperties();
        if (parentProperties != null && sun != parentProperties.getStarData()) {
            super.drawStar(buffer, matrix, sun, properties, solarOrbitalDistance, sunSize, sunColor, multiplier);
        }
    }

    @Override
    public void renderPlanet2(BufferBuilder buffer, MatrixStack matrix, DimensionProperties properties, float size, float alphaMultiplier, double shadowAngle, boolean hasRing) {
        float f15;
        BlockPos playerPos = new BlockPos(this.mc.field_71439_g.func_213303_ch());
        ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(playerPos);
        if (object == null) {
            return;
        }
        float planetOrbitalDistance = object.getOrbitalDistance();
        if (properties.isStar()) {
            size = 10.0f;
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableAlphaTest();
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            this.mc.func_110434_K().func_110577_a(TextureResources.locationBlackHole);
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, 180.0f, true));
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 100.0, 0.0);
            float phase = (float)(-(System.currentTimeMillis() % 3600L)) / 3600.0f;
            float scale = 1.0f + (float)Math.sin((double)phase * 3.14) * 0.1f;
            matrix.func_227863_a_(new Quaternion(0.0f, phase *= 360.0f, 0.0f, true));
            matrix.func_227862_a_(scale, scale, scale);
            RenderSystem.color4f((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float f10 = size * 2.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
            RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227865_b_();
            GL11.glDepthMask((boolean)false);
            for (int i = 0; i < 3; ++i) {
                float speedMult = (float)i * 1.01f + 1.0f;
                this.mc.func_110434_K().func_110577_a(TextureResources.locationAccretionDisk);
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)(100 + i * 50), 0.0);
                matrix.func_227863_a_(new Quaternion(60.0f, 0.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(129600.0f * speedMult))) / (360.0f * speedMult), 0.0f, true));
                RenderSystem.color4f((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = size * 40.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)(99.9f + (float)(i * 50)), 0.0);
                matrix.func_227863_a_(new Quaternion(60.0f, 0.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(72000.0f * speedMult))) / (200.0f * speedMult), 0.0f, true));
                RenderSystem.color4f((float)0.8f, (float)0.7f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = size * 30.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)(99.8f + (float)(i * 50)), 0.0);
                matrix.func_227863_a_(new Quaternion(60.0f, 0.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(36000.0f * speedMult))) / (100.0f * speedMult), 0.0f, true));
                RenderSystem.color4f((float)0.2f, (float)0.4f, (float)1.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = size * 15.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
            }
            matrix.func_227865_b_();
            return;
        }
        float[] atmColor = properties.skyColor;
        matrix.func_227860_a_();
        GL11.glPushAttrib((int)1048575);
        RenderSystem.disableFog();
        RenderSystem.blendFunc((int)1, (int)0);
        this.mc.func_110434_K().func_110577_a(this.getTextureForPlanet(properties));
        GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        float f10 = 100.0f * AstronomicalBodyHelper.getBodySizeMultiplier(planetOrbitalDistance);
        float Xoffset = (float)((double)System.currentTimeMillis() / 1000000.0 % 1.0);
        float f14 = 1.0f + Xoffset;
        float f16 = f15 = 0.0f + Xoffset;
        float f17 = f14;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)-10.0, (double)f10).func_225583_a_(f16, f17).func_181675_d();
        RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)-10.0, (double)f10).func_225583_a_(f14, f17).func_181675_d();
        RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)f10, (double)-10.0, (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
        RenderHelper.vertexPos((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-f10), (double)-10.0, (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopAttrib();
        if (properties.hasDecorators()) {
            if (properties.isGasGiant()) {
                int i;
                RenderSystem.blendFunc((int)770, (int)1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                this.mc.func_110434_K().func_110577_a(DimensionProperties.getAtmosphereLEOResource());
                double dist = -5.0 - (double)(4.0f * planetOrbitalDistance) / 200.0;
                double scalingMult = 1.0 - 0.9 * (double)planetOrbitalDistance / 200.0;
                float r = 0.5f;
                float g = 0.5f;
                float b = 1.0f;
                float a = 0.08f;
                int maxAmt = 6;
                float lng = (float)((double)System.currentTimeMillis() / 100000.0 % 1.0);
                for (i = 0; i < maxAmt; ++i) {
                    r = 0.05f * ((float)maxAmt - (float)i / 6.0f);
                    g = 0.4f * ((float)i / 6.0f);
                    b = 1.0f;
                    a = 0.4f;
                    RenderSystem.color4f((float)(0.05f * ((float)maxAmt - (float)i / 6.0f)), (float)(0.4f * ((float)i / 6.0f)), (float)1.0f, (float)0.4f);
                    Xoffset = lng * ((float)i - (float)maxAmt / 4.0f);
                    float Yoffset = -lng * (float)i;
                    f14 = (float)i + Yoffset;
                    f15 = 0.0f + Yoffset;
                    f16 = 0.0f + Xoffset;
                    f17 = (float)i + Xoffset;
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-10.0 + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (float)f14, (float)f15, (float)f16, (float)f17, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-10.0 + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (float)f14, (float)f15, (float)f16, (float)f17, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-10.0 + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (float)f14, (float)f15, (float)f16, (float)f17, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-10.0 + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (float)f14, (float)f15, (float)f16, (float)f17, (float)r, (float)g, (float)b, (float)a);
                }
                Tessellator.func_178181_a().func_78381_a();
                RenderSystem.disableTexture();
                RenderSystem.blendFunc((int)770, (int)771);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                r = 0.5f;
                g = 0.5f;
                b = 1.0f;
                a = 0.08f;
                for (i = 0; i < 5; ++i) {
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (float)f14, (float)f15, (float)f16, (float)f17, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (float)f14, (float)f15, (float)f16, (float)f17, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (float)f14, (float)f15, (float)f16, (float)f17, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (float)f14, (float)f15, (float)f16, (float)f17, (float)r, (float)g, (float)b, (float)a);
                }
                Tessellator.func_178181_a().func_78381_a();
                RenderSystem.enableTexture();
            } else if (properties.hasAtmosphere()) {
                RenderSystem.blendFunc((int)770, (int)1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                this.mc.func_110434_K().func_110577_a(DimensionProperties.getAtmosphereLEOResource());
                float a = 0.5f;
                Xoffset = (float)((double)System.currentTimeMillis() / 100000.0 % 1.0);
                f14 = 1.0f + Xoffset;
                f16 = f15 = 0.0f + Xoffset;
                f17 = f14;
                RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)-10.0, (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (float)f14, (float)f15, (float)f16, (float)f17, (float)1.0f, (float)1.0f, (float)1.0f, (float)a);
                RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)-10.0, (double)0.0, (double)0.0, (double)f10, (double)f10, (float)f14, (float)f15, (float)f16, (float)f17, (float)1.0f, (float)1.0f, (float)1.0f, (float)a);
                RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)-10.0, (double)(-f10), (double)0.0, (double)0.0, (double)f10, (float)f14, (float)f15, (float)f16, (float)f17, (float)1.0f, (float)1.0f, (float)1.0f, (float)a);
                RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)-10.0, (double)0.0, (double)(-f10), (double)f10, (double)0.0, (float)f14, (float)f15, (float)f16, (float)f17, (float)1.0f, (float)1.0f, (float)1.0f, (float)a);
                Tessellator.func_178181_a().func_78381_a();
                RenderSystem.disableTexture();
                RenderSystem.blendFunc((int)770, (int)771);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                a = 0.08f;
                double dist = -5.0 - (double)(4.0f * planetOrbitalDistance) / 200.0;
                double scalingMult = 1.0 - 0.9 * (double)planetOrbitalDistance / 200.0;
                for (int i = 0; i < 5; ++i) {
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (float)f14, (float)f15, (float)f16, (float)f17, (float)atmColor[0], (float)atmColor[1], (float)atmColor[2], (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (float)f14, (float)f15, (float)f16, (float)f17, (float)atmColor[0], (float)atmColor[1], (float)atmColor[2], (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (float)f14, (float)f15, (float)f16, (float)f17, (float)atmColor[0], (float)atmColor[1], (float)atmColor[2], (float)a);
                    RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (float)f14, (float)f15, (float)f16, (float)f17, (float)atmColor[0], (float)atmColor[1], (float)atmColor[2], (float)a);
                }
                Tessellator.func_178181_a().func_78381_a();
                RenderSystem.enableTexture();
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableFog();
        matrix.func_227865_b_();
    }

    @Override
    protected Direction getRotationAxis(DimensionProperties properties, BlockPos pos) {
        try {
            return SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos).getForwardDirection().func_176746_e();
        }
        catch (Exception e) {
            return Direction.EAST;
        }
    }

    @Override
    protected void rotateAroundAxis(MatrixStack matrix) {
        Vector3F<Float> axis = this.getRotateAxis();
        ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos(this.mc.field_71439_g.func_213303_ch()));
        if (obj != null) {
            matrix.func_227863_a_(new Quaternion(0.0f, (float)(obj.getRotation(Direction.UP) * 360.0), 0.0f, true));
            matrix.func_227863_a_(new Quaternion((float)(obj.getRotation(Direction.EAST) * 360.0), 0.0f, 0.0f, true));
        }
    }

    @Override
    protected ResourceLocation getTextureForPlanet(DimensionProperties properties) {
        return properties.getPlanetIconLEO();
    }
}

