/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.planet;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.backwardCompat.ModelFormatException;
import zmaster587.advancedRocketry.backwardCompat.WavefrontObject;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.SpacePosition;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.Vector3F;

public class RenderSpaceTravelSky
extends RenderPlanetarySky {
    private VertexBuffer starGLCallList;
    private VertexBuffer glSkyList;
    private VertexBuffer glSkyList2;
    ResourceLocation currentlyBoundTex = null;
    float celestialAngle;
    Vector3F<Float> axis;
    private static WavefrontObject sphere;
    public static ResourceLocation planetUIBG;
    public static ResourceLocation planetUIFG;
    private static final double SIZE_SCALE = 0.01;
    Minecraft mc = Minecraft.func_71410_x();

    public RenderSpaceTravelSky() {
        int k;
        int j;
        this.axis = new Vector3F((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        this.starGLCallList = new VertexBuffer(DefaultVertexFormats.field_181705_e);
        this.renderStars(buffer);
        this.starGLCallList.func_227875_a_(buffer);
        buffer = Tessellator.func_178181_a().func_178180_c();
        this.glSkyList = new VertexBuffer(DefaultVertexFormats.field_181705_e);
        int b2 = 64;
        int i = 256 / b2 + 2;
        float f = 16.0f;
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                buffer.func_225582_a_((double)(j + 0), (double)f, (double)(k + 0)).func_181675_d();
                buffer.func_225582_a_((double)(j + b2), (double)f, (double)(k + 0)).func_181675_d();
                buffer.func_225582_a_((double)(j + b2), (double)f, (double)(k + b2)).func_181675_d();
                buffer.func_225582_a_((double)(j + 0), (double)f, (double)(k + b2)).func_181675_d();
            }
        }
        buffer.func_178977_d();
        this.glSkyList.func_227875_a_(buffer);
        buffer = Tessellator.func_178181_a().func_178180_c();
        this.glSkyList2 = new VertexBuffer(DefaultVertexFormats.field_181705_e);
        f = -16.0f;
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                buffer.func_225582_a_((double)(j + 0), (double)f, (double)(k + 0)).func_181675_d();
                buffer.func_225582_a_((double)(j + b2), (double)f, (double)(k + 0)).func_181675_d();
                buffer.func_225582_a_((double)(j + b2), (double)f, (double)(k + b2)).func_181675_d();
                buffer.func_225582_a_((double)(j + 0), (double)f, (double)(k + b2)).func_181675_d();
            }
        }
        buffer.func_178977_d();
        this.glSkyList2.func_227875_a_(buffer);
    }

    public void renderPlanet(IDimensionProperties properties, MatrixStack matrix, SpacePosition position, SpacePosition playerPosition, float sizeOverride) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)((float)position.x), (double)((float)position.y), (double)((float)position.z));
        matrix.func_227862_a_(sizeOverride, sizeOverride, sizeOverride);
        RenderSystem.disableLighting();
        RenderSystem.depthMask((boolean)true);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(properties.getPlanetIconLEO());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.alphaFunc((int)516, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.func_227860_a_();
        sphere.renderAll(matrix);
        matrix.func_227865_b_();
        RenderSystem.blendFunc((int)1, (int)770);
        matrix.func_227860_a_();
        matrix.func_227862_a_(1.1f, 1.1f, 1.1f);
        matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, 90.0f, true));
        matrix.func_227863_a_(new Quaternion((float)(-(properties.getOrbitTheta() * 180.0 / Math.PI)), 0.0f, 0.0f, true));
        RenderSystem.blendFunc((int)770, (int)771);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.shadow3);
        RenderSystem.color4f((float)0.1f, (float)0.1f, (float)0.1f, (float)0.75f);
        sphere.renderAll(matrix);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        if (properties.hasRings()) {
            matrix.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, -90.0f, true));
            float[] ringColor = properties.getRingColor();
            RenderSystem.color4f((float)ringColor[0], (float)ringColor[1], (float)ringColor[2], (float)0.5f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.planetRings);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            RenderHelper.renderBottomFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.planetRingShadow);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.renderBottomFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
        }
        matrix.func_227865_b_();
        if (properties.hasAtmosphere()) {
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, 90.0f, true));
            matrix.func_227863_a_(new Quaternion((float)(-(properties.getOrbitTheta() * 180.0 / Math.PI)), 0.0f, 0.0f, true));
            matrix.func_227862_a_(1.1f, 1.1f, 1.1f);
            RenderSystem.disableTexture();
            RenderSystem.blendFunc((int)770, (int)771);
            float[] skyColor = properties.getSkyColor();
            RenderSystem.color4f((float)skyColor[0], (float)skyColor[1], (float)skyColor[2], (float)0.04f);
            for (int i = 0; i < 10; ++i) {
                matrix.func_227862_a_(1.01f, 1.01f, 1.01f);
                sphere.renderAll(matrix);
            }
            RenderSystem.enableTexture();
            matrix.func_227865_b_();
        }
        RenderSystem.depthMask((boolean)true);
        matrix.func_227865_b_();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableLighting();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    private double getDistance(SpacePosition a, SpacePosition b) {
        double deltaX = a.x - b.x;
        double deltaY = a.y - b.y;
        double deltaZ = a.z - b.z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public void renderStar(StellarBody entity, MatrixStack matrix, SpacePosition position, SpacePosition playerSpacePosition) {
        StellarBody body = entity;
        if (body == null) {
            return;
        }
        if (entity.isBlackHole()) {
            float sunSize = (float)entity.getDisplayRadius() / 50.0f;
            matrix.func_227860_a_();
            matrix.func_227861_a_(position.x, position.y, position.z);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.locationBlackHole);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.color4f((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
            matrix.func_227860_a_();
            float f10 = sunSize * 5.0f;
            float phase = (float)(-(System.currentTimeMillis() % 3600L)) / 3600.0f;
            float scale = 1.0f + (float)Math.sin((double)phase * 3.14) * 0.1f;
            scale = (float)((double)scale * 0.1);
            matrix.func_227863_a_(new Quaternion(0.0f, phase *= 360.0f, 0.0f, true));
            matrix.func_227862_a_(scale, scale, scale);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.renderEastFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227865_b_();
            this.mc.func_110434_K().func_110577_a(TextureResources.locationAccretionDisk);
            RenderSystem.depthMask((boolean)false);
            for (int i = 0; i < 3; ++i) {
                float speedMult = (float)i * 1.01f + 1.0f;
                matrix.func_227860_a_();
                matrix.func_227863_a_(new Quaternion(-80.0f, 80.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(speedMult * 36000.0f))) / (100.0f * speedMult), 0.0f, true));
                RenderSystem.color4f((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 40.0f;
                buffer.func_225582_a_((double)(-f10), 0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_((double)f10, 0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_((double)f10, 0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_((double)(-f10), 0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)-0.1f, 0.0);
                matrix.func_227863_a_(new Quaternion(-80.0f, 80.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 50.0f))) / (50.0f * speedMult), 0.0f, true));
                RenderSystem.color4f((float)0.8f, (float)0.7f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 30.0f;
                buffer.func_225582_a_((double)(-f10), 0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_((double)f10, 0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_((double)f10, 0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_((double)(-f10), 0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)-0.2f, 0.0);
                matrix.func_227863_a_(new Quaternion(-80.0f, 80.0f, 0.0f, true));
                matrix.func_227863_a_(new Quaternion(0.0f, (float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 25.0f))) / (25.0f * speedMult), 1.0f, 0.0f));
                RenderSystem.color4f((float)0.2f, (float)0.4f, (float)1.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 15.0f;
                buffer.func_225582_a_((double)(-f10), 0.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_((double)f10, 0.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_((double)f10, 0.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_225582_a_((double)(-f10), 0.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                matrix.func_227865_b_();
            }
            matrix.func_227865_b_();
            RenderSystem.enableDepthTest();
            RenderSystem.enableLighting();
            RenderSystem.disableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.blendFunc((int)770, (int)771);
        } else {
            matrix.func_227860_a_();
            matrix.func_227861_a_(position.x, position.y, position.z);
            matrix.func_227862_a_(10.0f, 10.0f, 10.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.locationSunNew);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.color3f((float)body.getColor()[0], (float)body.getColor()[1], (float)body.getColor()[2]);
            RenderSystem.alphaFunc((int)516, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.renderEastFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.renderEastFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227860_a_();
            RenderSystem.disableTexture();
            RenderSystem.blendFunc((int)770, (int)1);
            float[] skyColor = entity.getColor();
            RenderSystem.color4f((float)(skyColor[0] * 0.02f), (float)(skyColor[1] * 0.02f), (float)(skyColor[2] * 0.02f), (float)1.0f);
            matrix.func_227862_a_(7.1f, 7.1f, 7.1f);
            for (int i = 0; i < 10; ++i) {
                matrix.func_227862_a_(1.05f, 1.05f, 1.05f);
                sphere.renderAll(matrix);
            }
            RenderSystem.enableTexture();
            matrix.func_227865_b_();
            matrix.func_227865_b_();
            RenderSystem.enableLighting();
            RenderSystem.disableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.blendFunc((int)770, (int)771);
        }
    }

    private void renderStars(BufferBuilder buffer) {
        Random random = new Random(10842L);
        for (int i = 0; i < 2000; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                buffer.func_225582_a_(d5 + d24, d6 + d22, d7 + d25).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void getAllPlanets(List<IDimensionProperties> allPlanets, IDimensionProperties planet) {
        for (ResourceLocation i : planet.getChildPlanets()) {
            DimensionProperties childProps = DimensionManager.getInstance().getDimensionProperties(i);
            allPlanets.add(DimensionManager.getInstance().getDimensionProperties(i));
            this.getAllPlanets(allPlanets, childProps);
        }
    }

    private void buildSolarSystem(SpacePosition playerPosition, MatrixStack matrix) {
        List<IDimensionProperties> planets = playerPosition.star.getPlanets();
        if (playerPosition.world != null) {
            float sizeScale = playerPosition.world.getRenderSizePlanetView();
            SpacePosition newSpacePos = new SpacePosition();
            this.renderPlanet(playerPosition.world, matrix, newSpacePos, playerPosition, sizeScale);
            LinkedList<IDimensionProperties> subPlanets = new LinkedList<IDimensionProperties>();
            this.getAllPlanets(subPlanets, playerPosition.world);
            for (IDimensionProperties iDimensionProperties : subPlanets) {
                SpacePosition subPlanetPos = iDimensionProperties.getSpacePosition();
                sizeScale = iDimensionProperties.getRenderSizePlanetView();
                subPlanetPos.x += newSpacePos.x;
                subPlanetPos.y += newSpacePos.y;
                subPlanetPos.z += newSpacePos.z;
                this.renderPlanet(iDimensionProperties, matrix, subPlanetPos, playerPosition, sizeScale);
            }
            subPlanets.add(playerPosition.world);
            this.mc.func_110434_K().func_110577_a(TextureResources.locationReticle);
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.color4f((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (IDimensionProperties subPlanet : subPlanets) {
                List<ISpaceObject> stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(subPlanet.getId());
                if (stations == null) continue;
                for (ISpaceObject property : stations) {
                    SpacePosition spacePos = ((SpaceStationObject)property).getSpacePosition();
                    this.renderCrossHair(buffer, spacePos, 50.0f);
                }
            }
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 3.0, 0.0);
            for (IDimensionProperties subPlanet : subPlanets) {
                SpacePosition spacePos = subPlanet.getId() == playerPosition.world.getId() ? new SpacePosition() : subPlanet.getSpacePosition();
                float distance = (float)this.getDistance(playerPosition, spacePos);
                List<ISpaceObject> stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(subPlanet.getId());
                if (stations == null) continue;
                for (ISpaceObject property : stations) {
                    spacePos = ((SpaceStationObject)property).getSpacePosition();
                    distance = (float)this.getDistance(playerPosition, spacePos);
                }
            }
            matrix.func_227865_b_();
            RenderSystem.enableBlend();
        } else {
            for (IDimensionProperties property : planets) {
                SpacePosition spacePos = property.getSpacePosition();
                float sizeScale = property.getRenderSizeSolarView();
                double d = this.getDistance(playerPosition, spacePos);
                sizeScale = property.isMoon() ? sizeScale * 0.2f : sizeScale;
                this.renderPlanet(property, matrix, spacePos, playerPosition, sizeScale);
                LinkedList<IDimensionProperties> subPlanets = new LinkedList<IDimensionProperties>();
                this.getAllPlanets(subPlanets, property);
                for (IDimensionProperties subproperty : subPlanets) {
                    SpacePosition subPlanetPos = subproperty.getSpacePosition();
                    sizeScale = subproperty.getRenderSizeSolarView();
                    subPlanetPos.x = subPlanetPos.x / 10.0 + spacePos.x;
                    subPlanetPos.y = subPlanetPos.y / 10.0 + spacePos.y;
                    subPlanetPos.z = subPlanetPos.z / 10.0 + spacePos.z;
                    this.renderPlanet(subproperty, matrix, subPlanetPos, playerPosition, sizeScale);
                }
            }
            matrix.func_227860_a_();
            float adjustmentScale = 4.0f;
            matrix.func_227862_a_(adjustmentScale, adjustmentScale, adjustmentScale);
            List<StellarBody> subStars = playerPosition.star.getSubStars();
            StellarBody star = playerPosition.star;
            SpacePosition mainStarPos = star.getSpacePosition();
            this.renderStar(star, matrix, mainStarPos, playerPosition);
            if (subStars != null && !subStars.isEmpty()) {
                float f = 360 / subStars.size();
                double phase = 0.0;
                for (StellarBody subStar : subStars) {
                    float solarOrbitalDistance = 40.0f * subStar.getStarSeparation();
                    SpacePosition subStarSpacePosition = new SpacePosition();
                    double radius = solarOrbitalDistance;
                    double theta = phase;
                    phase += (double)f;
                    subStarSpacePosition = mainStarPos.getFromSpherical(radius, theta);
                    this.renderStar(subStar, matrix, subStarSpacePosition, playerPosition);
                }
            }
            matrix.func_227865_b_();
            this.mc.func_110434_K().func_110577_a(TextureResources.locationReticle);
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.color3f((float)0.0f, (float)1.0f, (float)0.0f);
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (IDimensionProperties property : planets) {
                SpacePosition spacePos = property.getSpacePosition();
                this.renderCrossHair(bufferBuilder, spacePos, 200.0f);
            }
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 3.0, 0.0);
            matrix.func_227865_b_();
            RenderSystem.enableBlend();
        }
    }

    private void renderCrossHair(BufferBuilder buffer, SpacePosition spacePos, float size) {
    }

    private MatrixStack setupSpaceCam(float partialTicks) {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        MatrixStack matrix = new MatrixStack();
        double fov = this.mc.field_71474_y.field_74334_X;
        matrix.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_195876_a((double)fov, (float)((float)this.mc.func_228018_at_().func_198109_k() / (float)this.mc.func_228018_at_().func_198091_l()), (float)0.05f, (float)1000000.0f));
        RenderSystem.matrixMode((int)5888);
        return matrix;
    }

    private MatrixStack undoSpaceCam(float partialTicks) {
        float farplane = this.mc.field_71474_y.field_151451_c * 16;
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        MatrixStack matrix = new MatrixStack();
        double fov = this.mc.field_71474_y.field_74334_X;
        matrix.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_195876_a((double)fov, (float)((float)this.mc.func_228018_at_().func_198109_k() / (float)this.mc.func_228018_at_().func_198091_l()), (float)0.05f, (float)(farplane * MathHelper.field_180189_a)));
        RenderSystem.matrixMode((int)5888);
        return matrix;
    }

    @Override
    public void render(MatrixStack matrix, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        this.setupSpaceCam(partialTicks);
        SpacePosition spacePosition = null;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Entity ridingEntity = player.func_184187_bx();
        if (!(ridingEntity instanceof EntityRocket)) {
            return;
        }
        spacePosition = ((EntityRocket)ridingEntity).getSpacePosition();
        this.celestialAngle = mc.field_71441_e.func_72929_e(partialTicks);
        RenderSystem.enableTexture();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        matrix.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
        matrix.func_227863_a_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
        if (spacePosition.world != null) {
            matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, -((float)(spacePosition.world.getOrbitTheta() * 180.0 / Math.PI)), true));
        }
        GL11.glScaled((double)100.0, (double)100.0, (double)100.0);
        RenderSystem.disableTexture();
        RenderSystem.disableFog();
        float f18 = 1.0f;
        if (f18 > 0.0f) {
            RenderSystem.color4f((float)f18, (float)f18, (float)f18, (float)f18);
            matrix.func_227860_a_();
            this.starGLCallList.func_177359_a();
            DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
            this.starGLCallList.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_181705_e.func_227895_d_();
            RenderSystem.color4f((float)f18, (float)f18, (float)f18, (float)(f18 / 2.0f));
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
            this.starGLCallList.func_177359_a();
            DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
            this.starGLCallList.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_181705_e.func_227895_d_();
            matrix.func_227865_b_();
            RenderSystem.color4f((float)f18, (float)f18, (float)f18, (float)(f18 / 4.0f));
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            this.starGLCallList.func_177359_a();
            DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
            this.starGLCallList.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_181705_e.func_227895_d_();
            matrix.func_227865_b_();
            RenderSystem.color4f((float)f18, (float)f18, (float)f18, (float)f18);
            matrix.func_227865_b_();
        }
        if (spacePosition.world != null) {
            RenderSystem.enableBlend();
            RenderSystem.enableTexture();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            DimensionProperties properties = spacePosition.world;
            StellarBody sun = spacePosition.star;
            sun.getSize();
            float[] suncolorfloat = sun.getColor();
            Vector3d color = new Vector3d((double)suncolorfloat[0], (double)suncolorfloat[1], (double)suncolorfloat[2]);
            this.drawStarAndSubStars(bufferBuilder, matrix, spacePosition.star, spacePosition.world, properties.getSolarOrbitalDistance(), sun.getSize(), color, 1.0f);
            RenderSystem.disableBlend();
        }
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-spacePosition.x, -spacePosition.y, -spacePosition.z);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableCull();
        RenderSystem.enableTexture();
        RenderSystem.disableFog();
        this.buildSolarSystem(spacePosition, matrix);
        RenderSystem.enableFog();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        matrix.func_227865_b_();
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RocketEventHandler.onPostWorldRender(matrix, partialTicks);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.clear((int)256, (boolean)false);
    }

    @Override
    protected ResourceLocation getTextureForPlanet(DimensionProperties properties) {
        return properties.getPlanetIcon();
    }

    @Override
    protected ResourceLocation getTextureForPlanetLEO(DimensionProperties properties) {
        return properties.getPlanetIcon();
    }

    @Override
    protected Direction getRotationAxis(DimensionProperties properties, BlockPos pos) {
        return Direction.EAST;
    }

    protected void renderPlanet(BufferBuilder buffer, MatrixStack matrix, DimensionProperties properties, float planetOrbitalDistance, float alphaMultiplier, double shadowAngle, boolean hasAtmosphere, boolean hasRing) {
        this.renderPlanet2(buffer, matrix, properties, 10.0f * (200.0f - planetOrbitalDistance) / 100.0f, alphaMultiplier, shadowAngle, hasRing);
    }

    @Override
    protected void renderPlanet2(BufferBuilder buffer, MatrixStack matrix, DimensionProperties properties, float size, float alphaMultiplier, double shadowAngle, boolean hasRing) {
        ResourceLocation icon = this.getTextureForPlanet(properties);
        boolean hasAtmosphere = properties.hasAtmosphere();
        boolean gasGiant = properties.isGasGiant();
        boolean hasDecorators = properties.hasDecorators();
        float[] skyColor = properties.skyColor;
        float[] ringColor = properties.skyColor;
        RenderSpaceTravelSky.renderPlanetPubHelper(buffer, matrix, icon, 0, 0, -20.0, size * 0.2f, alphaMultiplier, shadowAngle, hasAtmosphere, skyColor, ringColor, gasGiant, hasRing, hasDecorators);
    }

    @Override
    protected void rotateAroundAxis(MatrixStack matrix) {
        Vector3F<Float> axis = this.getRotateAxis();
        float x = this.getSkyRotationAmount() * 360.0f * ((Float)axis.x).floatValue();
        float y = this.getSkyRotationAmount() * 360.0f * ((Float)axis.y).floatValue();
        float z = this.getSkyRotationAmount() * 360.0f * ((Float)axis.z).floatValue();
        matrix.func_227863_a_(new Quaternion(x, y, z, true));
    }

    @Override
    protected float getSkyRotationAmount() {
        return this.celestialAngle;
    }

    @Override
    protected Vector3F<Float> getRotateAxis() {
        return this.axis;
    }

    public static void renderPlanetPubHelper(BufferBuilder buffer, MatrixStack matrix, ResourceLocation icon, int locationX, int locationY, double zLevel, float size, float alphaMultiplier, double shadowAngle, boolean hasAtmosphere, float[] skyColor, float[] ringColor, boolean gasGiant, boolean hasRing, boolean hasDecorators) {
        float f15;
        RenderSystem.enableBlend();
        float f10 = size;
        float f14 = 1.0f;
        float f16 = f15 = 0.0f;
        float f17 = f14;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)locationX, zLevel, (double)locationY);
        if (hasDecorators) {
            matrix.func_227860_a_();
            GL11.glRotated((double)(90.0 - shadowAngle * 180.0 / Math.PI), (double)0.0, (double)1.0, (double)0.0);
            if (hasRing) {
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.color4f((float)ringColor[0], (float)ringColor[1], (float)ringColor[2], (float)(alphaMultiplier * 0.2f));
                float ringSize = f10 * 1.4f;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.planetRings);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_225582_a_((double)(-ringSize), zLevel - (double)0.01f, (double)ringSize).func_225583_a_(f16, f17).func_181675_d();
                buffer.func_225582_a_((double)ringSize, zLevel - (double)0.01f, (double)ringSize).func_225583_a_(f14, f17).func_181675_d();
                buffer.func_225582_a_((double)ringSize, zLevel - (double)0.01f, (double)(-ringSize)).func_225583_a_(f14, f15).func_181675_d();
                buffer.func_225582_a_((double)(-ringSize), zLevel - (double)0.01f, (double)(-ringSize)).func_225583_a_(f16, f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)alphaMultiplier);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.planetRingShadow);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_225582_a_((double)(-ringSize), zLevel - (double)0.01f, (double)ringSize).func_225583_a_(f16, f17).func_181675_d();
                buffer.func_225582_a_((double)ringSize, zLevel - (double)0.01f, (double)ringSize).func_225583_a_(f14, f17).func_181675_d();
                buffer.func_225582_a_((double)ringSize, zLevel - (double)0.01f, (double)(-ringSize)).func_225583_a_(f14, f15).func_181675_d();
                buffer.func_225582_a_((double)(-ringSize), zLevel - (double)0.01f, (double)(-ringSize)).func_225583_a_(f16, f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
            RenderSystem.blendFunc((int)770, (int)1);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.atmGlow);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
            buffer.func_225582_a_((double)(-f10), zLevel + (double)0.01f, (double)f10).func_225583_a_(f16, f17).func_181675_d();
            buffer.func_225582_a_((double)f10, zLevel + (double)0.01f, (double)f10).func_225583_a_(f14, f17).func_181675_d();
            buffer.func_225582_a_((double)f10, zLevel + (double)0.01f, (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
            buffer.func_225582_a_((double)(-f10), zLevel + (double)0.01f, (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            matrix.func_227865_b_();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        RenderSystem.blendFunc((int)770, (int)771);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
        buffer.func_225582_a_((double)(-f10), zLevel, (double)f10).func_225583_a_(f16, f17).func_181675_d();
        buffer.func_225582_a_((double)f10, zLevel, (double)f10).func_225583_a_(f14, f17).func_181675_d();
        buffer.func_225582_a_((double)f10, zLevel, (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
        buffer.func_225582_a_((double)(-f10), zLevel, (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        if (hasDecorators) {
            if (hasAtmosphere) {
                RenderSystem.blendFunc((int)770, (int)1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.getAtmosphereResource());
                RenderSystem.color4f((float)skyColor[0], (float)skyColor[1], (float)skyColor[2], (float)alphaMultiplier);
                buffer.func_225582_a_((double)(-f10), zLevel, (double)f10).func_225583_a_(f16, f17).func_181675_d();
                buffer.func_225582_a_((double)f10, zLevel, (double)f10).func_225583_a_(f14, f17).func_181675_d();
                buffer.func_225582_a_((double)f10, zLevel, (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
                buffer.func_225582_a_((double)(-f10), zLevel, (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
            GL11.glRotated((double)(90.0 - shadowAngle * 180.0 / Math.PI), (double)0.0, (double)1.0, (double)0.0);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DimensionProperties.getShadowResource());
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
            buffer.func_225582_a_((double)(-f10), zLevel - (double)0.01f, (double)f10).func_225583_a_(f16, f17).func_181675_d();
            buffer.func_225582_a_((double)f10, zLevel - (double)0.01f, (double)f10).func_225583_a_(f14, f17).func_181675_d();
            buffer.func_225582_a_((double)f10, zLevel - (double)0.01f, (double)(-f10)).func_225583_a_(f14, f15).func_181675_d();
            buffer.func_225582_a_((double)(-f10), zLevel - (double)0.01f, (double)(-f10)).func_225583_a_(f16, f15).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        matrix.func_227865_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawStar(BufferBuilder buffer, MatrixStack matrix, StellarBody sun, DimensionProperties properties, int solarOrbitalDistance, float sunSize, Vector3d sunColor, float multiplier) {
        if (sun == null || sun.isBlackHole()) {
            // empty if block
        }
        this.mc.func_110434_K().func_110577_a(TextureResources.locationSunPng);
        RenderSystem.color4f((float)((float)sunColor.field_72450_a), (float)((float)sunColor.field_72448_b), (float)((float)sunColor.field_72449_c), (float)Math.min(multiplier * 2.0f, 1.0f));
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float f10 = sunSize * 30.0f * (float)(202 - solarOrbitalDistance) / 100.0f;
        buffer.func_225582_a_((double)(-f10), 100.0, (double)(-f10)).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)f10, 100.0, (double)(-f10)).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)f10, 100.0, (double)f10).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(-f10), 100.0, (double)f10).func_225583_a_(0.0f, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    static {
        planetUIBG = new ResourceLocation("advancedrocketry:textures/gui/planetUIOverlay.png");
        planetUIFG = new ResourceLocation("advancedrocketry:textures/gui/planetUIOverlayFG.png");
        try {
            sphere = new WavefrontObject(new ResourceLocation("advancedrocketry:models/atmosphere.obj"));
        }
        catch (ModelFormatException e) {
            throw new RuntimeException(e);
        }
    }
}

