/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.command.ReflectionArgument;
import zmaster587.advancedRocketry.command.StarArgument;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.item.ItemMultiData;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public class PlanetCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"advRocketry").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"planet").executes(value -> PlanetCommand.commandPlanetHelp((CommandSource)value.getSource()))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset").executes(value -> PlanetCommand.commandPlanetReset((CommandSource)value.getSource(), null))).then((ArgumentBuilder)Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()))).executes(value -> PlanetCommand.commandPlanetReset((CommandSource)value.getSource(), (World)DimensionArgument.func_212592_a((CommandContext)value, (String)"dim"))))).then(Commands.func_197057_a((String)"list").executes(value -> PlanetCommand.commandPlanetList((CommandSource)value.getSource())))).then(Commands.func_197057_a((String)"delete").then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(value -> PlanetCommand.commandPlanetDelete((CommandSource)value.getSource(), DimensionArgument.func_212592_a((CommandContext)value, (String)"dim")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"generate").then(Commands.func_197057_a((String)"moon").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"atm", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"dist", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"gravity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(value -> PlanetCommand.commandMoonGenerate((CommandSource)value.getSource(), false, null, (World)DimensionArgument.func_212592_a((CommandContext)value, (String)"dim"), IntegerArgumentType.getInteger((CommandContext)value, (String)"atm"), IntegerArgumentType.getInteger((CommandContext)value, (String)"dist"), IntegerArgumentType.getInteger((CommandContext)value, (String)"grav"))))))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"atm", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"dist", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"gravity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(value -> PlanetCommand.commandMoonGenerate((CommandSource)value.getSource(), false, StringArgumentType.getString((CommandContext)value, (String)"name"), (World)DimensionArgument.func_212592_a((CommandContext)value, (String)"dim"), IntegerArgumentType.getInteger((CommandContext)value, (String)"atm"), IntegerArgumentType.getInteger((CommandContext)value, (String)"dist"), IntegerArgumentType.getInteger((CommandContext)value, (String)"grav")))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"gas").then(Commands.func_197056_a((String)"atm", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"dist", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"gravity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(value -> PlanetCommand.commandMoonGenerate((CommandSource)value.getSource(), true, null, (World)DimensionArgument.func_212592_a((CommandContext)value, (String)"dim"), IntegerArgumentType.getInteger((CommandContext)value, (String)"atm"), IntegerArgumentType.getInteger((CommandContext)value, (String)"dist"), IntegerArgumentType.getInteger((CommandContext)value, (String)"grav"))))))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"atm", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"dist", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"gravity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(value -> PlanetCommand.commandMoonGenerate((CommandSource)value.getSource(), true, StringArgumentType.getString((CommandContext)value, (String)"name"), (World)DimensionArgument.func_212592_a((CommandContext)value, (String)"dim"), IntegerArgumentType.getInteger((CommandContext)value, (String)"atm"), IntegerArgumentType.getInteger((CommandContext)value, (String)"dist"), IntegerArgumentType.getInteger((CommandContext)value, (String)"grav"))))))))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"starName", (ArgumentType)StarArgument.getStar()).then(Commands.func_197056_a((String)"atm", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"dist", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"gravity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(value -> PlanetCommand.commandPlanetGenerate((CommandSource)value.getSource(), false, null, StarArgument.getStarArgument((CommandContext<CommandSource>)value, "starName"), IntegerArgumentType.getInteger((CommandContext)value, (String)"atm"), IntegerArgumentType.getInteger((CommandContext)value, (String)"dist"), IntegerArgumentType.getInteger((CommandContext)value, (String)"grav"))))))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"atm", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"dist", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"gravity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(value -> PlanetCommand.commandPlanetGenerate((CommandSource)value.getSource(), false, StringArgumentType.getString((CommandContext)value, (String)"name"), StarArgument.getStarArgument((CommandContext<CommandSource>)value, "starName"), IntegerArgumentType.getInteger((CommandContext)value, (String)"atm"), IntegerArgumentType.getInteger((CommandContext)value, (String)"dist"), IntegerArgumentType.getInteger((CommandContext)value, (String)"grav")))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"gas").then(Commands.func_197056_a((String)"atm", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"dist", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"gravity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(value -> PlanetCommand.commandPlanetGenerate((CommandSource)value.getSource(), true, null, StarArgument.getStarArgument((CommandContext<CommandSource>)value, "starName"), IntegerArgumentType.getInteger((CommandContext)value, (String)"atm"), IntegerArgumentType.getInteger((CommandContext)value, (String)"dist"), IntegerArgumentType.getInteger((CommandContext)value, (String)"grav"))))))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"atm", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"dist", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"gravity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(value -> PlanetCommand.commandPlanetGenerate((CommandSource)value.getSource(), true, StringArgumentType.getString((CommandContext)value, (String)"name"), StarArgument.getStarArgument((CommandContext<CommandSource>)value, "starName"), IntegerArgumentType.getInteger((CommandContext)value, (String)"atm"), IntegerArgumentType.getInteger((CommandContext)value, (String)"dist"), IntegerArgumentType.getInteger((CommandContext)value, (String)"grav"))))))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"varName", (ArgumentType)ReflectionArgument.getReflected(DimensionProperties.class)).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.word()).executes(value -> PlanetCommand.commandPlanetSet((CommandSource)value.getSource(), null, ReflectionArgument.getReflectionArgument((CommandContext<CommandSource>)value, "varName", DimensionProperties.class), StringArgumentType.getString((CommandContext)value, (String)"value")))))).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"varName", (ArgumentType)ReflectionArgument.getReflected(DimensionProperties.class)).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.word()).executes(value -> PlanetCommand.commandPlanetSet((CommandSource)value.getSource(), (World)DimensionArgument.func_212592_a((CommandContext)value, (String)"dim"), ReflectionArgument.getReflectionArgument((CommandContext<CommandSource>)value, "varName", DimensionProperties.class), StringArgumentType.getString((CommandContext)value, (String)"value")))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").then(Commands.func_197056_a((String)"varName", (ArgumentType)ReflectionArgument.getReflected(DimensionProperties.class)).executes(value -> PlanetCommand.commandPlanetGet((CommandSource)value.getSource(), null, ReflectionArgument.getReflectionArgument((CommandContext<CommandSource>)value, "varName", DimensionProperties.class))))).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"varName", (ArgumentType)ReflectionArgument.getReflected(DimensionProperties.class)).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.word()).executes(value -> PlanetCommand.commandPlanetGet((CommandSource)value.getSource(), (World)DimensionArgument.func_212592_a((CommandContext)value, (String)"dim"), ReflectionArgument.getReflectionArgument((CommandContext<CommandSource>)value, "varName", DimensionProperties.class)))))))).then(Commands.func_197057_a((String)"delete").then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(value -> PlanetCommand.commandPlanetDelete((CommandSource)value.getSource(), DimensionArgument.func_212592_a((CommandContext)value, (String)"dim")))))).then(Commands.func_197057_a((String)"reset").then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(value -> PlanetCommand.commandPlanetReset((CommandSource)value.getSource(), (World)DimensionArgument.func_212592_a((CommandContext)value, (String)"dim")))))).then(Commands.func_197057_a((String)"help").executes(value -> PlanetCommand.commandPlanetHelp((CommandSource)value.getSource()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"goto").then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(value -> PlanetCommand.commandGoto((CommandSource)value.getSource(), DimensionArgument.func_212592_a((CommandContext)value, (String)"dim"))))).then(Commands.func_197057_a((String)"station").then(Commands.func_197056_a((String)"stationid", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(value -> PlanetCommand.commandGotoStation((CommandSource)value.getSource(), IntegerArgumentType.getInteger((CommandContext)value, (String)"stationid"))))))).then(Commands.func_197057_a((String)"giveStation").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"stationId", (ArgumentType)StringArgumentType.string()).executes(value -> PlanetCommand.commandGiveStation((CommandSource)value.getSource(), null, StringArgumentType.getString((CommandContext)value, (String)"stationId")))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(value -> PlanetCommand.commandGiveStation((CommandSource)value.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)value, (String)"player"), StringArgumentType.getString((CommandContext)value, (String)"stationId"))))))).then(Commands.func_197057_a((String)"fillData").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"dataType", (ArgumentType)StringArgumentType.word()).executes(value -> PlanetCommand.commandFillData((CommandSource)value.getSource(), StringArgumentType.getString((CommandContext)value, (String)"dataType"), -1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(value -> PlanetCommand.commandFillData((CommandSource)value.getSource(), StringArgumentType.getString((CommandContext)value, (String)"dataType"), IntegerArgumentType.getInteger((CommandContext)value, (String)"amount"))))))).then(Commands.func_197057_a((String)"star").then(Commands.func_197057_a((String)"list").executes(value -> PlanetCommand.commandListStars((CommandSource)value.getSource())))));
    }

    private static int commandListStars(CommandSource sender) {
        for (StellarBody star : DimensionManager.getInstance().getStars()) {
            sender.func_197030_a((ITextComponent)new StringTextComponent(String.format("Star ID: %d   Name: %s  Num Planets: %d", star.getId(), star.getName(), star.getNumPlanets())), false);
        }
        return 0;
    }

    private static int commandGoto(CommandSource sender, ServerWorld world) {
        ServerPlayerEntity player;
        if (sender.func_197022_f() != null && (player = (ServerPlayerEntity)sender.func_197022_f()) != null) {
            player.func_200619_a(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0f, 0.0f);
        } else {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Must be a player to use this command"), true);
        }
        return 0;
    }

    private static int commandGotoStation(CommandSource sender, int stationIdStr) {
        PlayerEntity player;
        ResourceLocation stationId = new ResourceLocation("station", String.valueOf(stationIdStr));
        ServerWorld world = ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId());
        if (sender.func_197022_f() != null && (player = (PlayerEntity)sender.func_197022_f()) != null) {
            ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStation(stationId);
            if (object != null) {
                HashedBlockPosition vec = object.getSpawnLocation();
                if (!ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)player.field_70170_p))) {
                    ((ServerPlayerEntity)player).func_200619_a(world, (double)vec.x, (double)vec.y, (double)vec.z, 0.0f, 0.0f);
                }
                player.func_70634_a((double)vec.x, (double)vec.y, (double)vec.z);
            } else {
                sender.func_197030_a((ITextComponent)new StringTextComponent("Station " + stationId + " does not exist!"), true);
            }
        } else {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Must be a player to use this command"), true);
        }
        return 0;
    }

    private static int commandFillData(CommandSource sender, String dataTypeStr, int amountFill) throws CommandSyntaxException {
        if (sender.func_197022_f() != null) {
            ItemStack stack = sender.func_197035_h().func_184586_b(Hand.MAIN_HAND);
            if (stack != null && stack.func_77973_b() instanceof ItemData) {
                ItemData item = (ItemData)stack.func_77973_b();
                int dataAmount = item.getMaxData(stack);
                DataStorage.DataType dataType = null;
                if (dataTypeStr != null) {
                    try {
                        dataType = DataStorage.DataType.valueOf(dataTypeStr.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        sender.func_197030_a((ITextComponent)new StringTextComponent("Not a valid datatype"), false);
                        String value = "";
                        for (DataStorage.DataType data : DataStorage.DataType.values()) {
                            if (data.name().equals("UNDEFINED")) continue;
                            value = value + data.name().toLowerCase() + ", ";
                        }
                        sender.func_197030_a((ITextComponent)new StringTextComponent("Try " + value), false);
                        return -1;
                    }
                }
                if (amountFill >= -1) {
                    dataAmount = amountFill;
                }
                if (dataType != null) {
                    item.setData(stack, dataAmount, dataType);
                } else {
                    for (DataStorage.DataType type : DataStorage.DataType.values()) {
                        item.setData(stack, dataAmount, type);
                    }
                }
                sender.func_197030_a((ITextComponent)new StringTextComponent("Data filled!"), false);
            } else if (stack != null && stack.func_77973_b() instanceof ItemMultiData) {
                ItemMultiData item = (ItemMultiData)stack.func_77973_b();
                int dataAmount = item.getMaxData(stack);
                DataStorage.DataType dataType = null;
                if (dataTypeStr != null) {
                    try {
                        dataType = DataStorage.DataType.valueOf(dataTypeStr.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        sender.func_197030_a((ITextComponent)new StringTextComponent("Not a valid datatype"), false);
                        String value = "";
                        for (DataStorage.DataType data : DataStorage.DataType.values()) {
                            if (data.name().equals("UNDEFINED")) continue;
                            value = value + data.name().toLowerCase() + ", ";
                        }
                        sender.func_197030_a((ITextComponent)new StringTextComponent("Try " + value), false);
                        return -1;
                    }
                }
                if (amountFill >= 0) {
                    dataAmount = amountFill;
                }
                if (dataType != null) {
                    item.setData(stack, dataAmount, dataType);
                } else {
                    for (DataStorage.DataType type : DataStorage.DataType.values()) {
                        item.setData(stack, dataAmount, type);
                    }
                }
                sender.func_197030_a((ITextComponent)new StringTextComponent("Data filled!"), false);
            } else {
                sender.func_197030_a((ITextComponent)new StringTextComponent("Not Holding data item"), false);
            }
        } else {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Ghosts don't have items!"), false);
        }
        return 0;
    }

    private static int commandGiveStation(CommandSource sender, @Nullable PlayerEntity player, String stationIdStr) {
        ResourceLocation stationId = new ResourceLocation(stationIdStr);
        if (player == null && sender.func_197022_f() != null) {
            try {
                player = sender.func_197035_h();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return -1;
            }
        }
        if (player != null) {
            ItemStack stack = new ItemStack((IItemProvider)AdvancedRocketryItems.itemSpaceStationChip);
            ItemStationChip.setUUID(stack, stationId);
            player.field_71071_by.func_70441_a(stack);
        }
        return 0;
    }

    private static int commandPlanetDelete(CommandSource sender, ServerWorld world) {
        ResourceLocation deletedDimId = ZUtils.getDimensionIdentifier((World)world);
        if (DimensionManager.getInstance().isDimensionCreated(deletedDimId)) {
            if (world == null || world.func_217369_A().isEmpty()) {
                DimensionManager.getInstance().deleteDimension(deletedDimId);
                PacketHandler.sendToAll((BasePacket)new PacketDimInfo(deletedDimId, null));
                sender.func_197030_a((ITextComponent)new StringTextComponent("Dim " + deletedDimId + " deleted!"), true);
            } else {
                sender.func_197030_a((ITextComponent)new StringTextComponent("World still has players:"), false);
                List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
                for (PlayerEntity player : world.func_217369_A()) {
                    sender.func_197030_a(player.func_145748_c_(), true);
                }
            }
        } else {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Dimension does not exist"), true);
        }
        return 0;
    }

    private static int commandMoonGenerate(CommandSource sender, boolean gas, @Nullable String name, World world, int atm, int dist, int gravity) {
        ResourceLocation planetId = ZUtils.getDimensionIdentifier((World)world);
        ResourceLocation starId = DimensionManager.getInstance().getDimensionProperties(planetId).getStarId();
        DimensionProperties properties = !gas ? DimensionManager.getInstance().generateRandom(starId, "unnamed", atm, dist, gravity) : DimensionManager.getInstance().generateRandomGasGiant(starId, "unnamed", atm, dist, gravity, 1, 1, 1);
        if (properties == null) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Dimension: " + name + " failed to generate!"), true);
        } else {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Dimension: " + name + " Generated!"), true);
        }
        properties.setParentPlanet(DimensionManager.getInstance().getDimensionProperties(planetId));
        DimensionManager.getInstance().getStar(starId).removePlanet(properties);
        return 0;
    }

    private static int commandPlanetGenerate(CommandSource sender, boolean gas, @Nullable String name, StellarBody starName, int atm, int dist, int gravity) {
        ResourceLocation starId = starName.getId();
        DimensionProperties properties = !gas ? DimensionManager.getInstance().generateRandom(starId, "unnamed", atm, dist, gravity) : DimensionManager.getInstance().generateRandomGasGiant(starId, "unnamed", atm, dist, gravity, 1, 1, 1);
        if (properties == null) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Dimension: " + name + " failed to generate!"), true);
        } else {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Dimension: " + name + " Generated!"), true);
        }
        return 0;
    }

    private static int commandPlanetSet(CommandSource sender, @Nullable World world, String fieldName, String value) {
        ResourceLocation dimId = ZUtils.getDimensionIdentifier((World)sender.func_197023_e());
        if (!DimensionManager.getInstance().isDimensionCreated(dimId)) {
            return -1;
        }
        String[] cmdString = value.split(" ");
        boolean commandOffset = false;
        if (world != null) {
            dimId = ZUtils.getDimensionIdentifier((World)world);
        }
        if (!DimensionManager.getInstance().isDimensionCreated(dimId)) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Invalid Dimensions"), true);
            return -1;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(dimId);
        try {
            if (!fieldName.equalsIgnoreCase("atmosphereDensity")) {
                Field field = properties.getClass().getDeclaredField(fieldName);
                if (field.getType().isArray()) {
                    int i;
                    String outString;
                    Object[] var;
                    if (Float.TYPE == field.getType().getComponentType() && cmdString.length == (var = (float[])field.get(properties)).length) {
                        outString = "";
                        for (i = 0; i < var.length; ++i) {
                            var[i] = Float.parseFloat(cmdString[i]);
                            outString = outString + cmdString[i] + " ";
                        }
                        field.set(properties, var);
                        sender.func_197030_a((ITextComponent)new StringTextComponent("Setting " + fieldName + " for dimension " + dimId + " to " + outString), true);
                    }
                    if (Integer.TYPE == field.getType().getComponentType() && cmdString.length == (var = (Object[])((int[])field.get(properties))).length) {
                        outString = "";
                        for (i = 0; i < var.length; ++i) {
                            var[i] = Integer.parseInt(cmdString[i]);
                            outString = outString + cmdString[i] + " ";
                        }
                        field.set(properties, var);
                        sender.func_197030_a((ITextComponent)new StringTextComponent("Setting " + fieldName + " for dimension " + dimId + " to " + outString), true);
                    }
                } else {
                    if (Integer.TYPE == field.getType()) {
                        field.set(properties, Integer.parseInt(value));
                    } else if (Float.TYPE == field.getType()) {
                        field.set(properties, Float.valueOf(Float.parseFloat(value)));
                    } else if (Double.TYPE == field.getType()) {
                        field.set(properties, Double.parseDouble(value));
                    } else if (Boolean.TYPE == field.getType()) {
                        field.set(properties, Boolean.parseBoolean(value));
                    } else {
                        field.set(properties, value);
                    }
                    sender.func_197030_a((ITextComponent)new StringTextComponent("Setting " + fieldName + " for dimension " + dimId + " to " + value), true);
                }
                PacketHandler.sendToAll((BasePacket)new PacketDimInfo(dimId, properties));
                return 0;
            }
            properties.setAtmosphereDensityDirect(Integer.parseUnsignedInt(value));
            sender.func_197030_a((ITextComponent)new StringTextComponent("Setting " + fieldName + " for dimension " + dimId + " to " + value), true);
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(dimId, properties));
        }
        catch (NumberFormatException e) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Invalid Argument for parameter " + fieldName), true);
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int commandPlanetGet(CommandSource sender, @Nullable World world, String fieldName) {
        ResourceLocation dimId = ZUtils.getDimensionIdentifier((World)sender.func_197023_e());
        if (!DimensionManager.getInstance().isDimensionCreated(dimId)) {
            return -1;
        }
        boolean commandOffset = false;
        if (world != null) {
            try {
                dimId = ZUtils.getDimensionIdentifier((World)world);
                commandOffset = true;
            }
            catch (NumberFormatException e) {
                sender.func_197030_a((ITextComponent)new StringTextComponent("Invalid Dimensions"), true);
            }
        }
        if (!DimensionManager.getInstance().isDimensionCreated(dimId)) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Invalid Dimensions"), true);
            return -1;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(dimId);
        if (fieldName.equalsIgnoreCase("atmosphereDensity")) {
            sender.func_197030_a((ITextComponent)new StringTextComponent(Integer.toString(properties.getAtmosphereDensity())), true);
        } else {
            try {
                Field field = properties.getClass().getDeclaredField(fieldName);
                sender.func_197030_a((ITextComponent)new StringTextComponent(field.get(properties).toString()), true);
            }
            catch (Exception e) {
                e.printStackTrace();
                sender.func_197030_a((ITextComponent)new StringTextComponent("An error has occured, please check logs"), true);
            }
        }
        return 0;
    }

    private static int commandPlanetList(CommandSource sender) {
        sender.func_197030_a((ITextComponent)new StringTextComponent("Dimensions:"), false);
        for (ResourceLocation i : DimensionManager.getInstance().getRegisteredDimensions()) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("DIM" + i + ":  " + DimensionManager.getInstance().getDimensionProperties(i).getName()), false);
        }
        return 0;
    }

    private static int commandPlanetHelp(CommandSource sender) {
        sender.func_197030_a((ITextComponent)new StringTextComponent("Planet:"), false);
        sender.func_197030_a((ITextComponent)new StringTextComponent("planet delete [dimid]"), false);
        sender.func_197030_a((ITextComponent)new StringTextComponent("planet generate [starId] (moon/gas) [name] [atmosphere randomness] [distance Randomness] [gravity randomness] (atmosphere base) (distance base) (gravity base)"), false);
        sender.func_197030_a((ITextComponent)new StringTextComponent("planet list"), false);
        sender.func_197030_a((ITextComponent)new StringTextComponent("planet reset [dimid]"), false);
        sender.func_197030_a((ITextComponent)new StringTextComponent("planet set [property]"), false);
        sender.func_197030_a((ITextComponent)new StringTextComponent("planet get [property]"), false);
        return 0;
    }

    private static int commandPlanetReset(CommandSource sender, World dimension) {
        if (dimension != null) {
            try {
                ResourceLocation dimId = ZUtils.getDimensionIdentifier((World)dimension);
                DimensionManager.getInstance().getDimensionProperties(dimId).resetProperties();
                PacketHandler.sendToAll((BasePacket)new PacketDimInfo(dimId, DimensionManager.getInstance().getDimensionProperties(dimId)));
            }
            catch (NumberFormatException e) {
                sender.func_197030_a((ITextComponent)new StringTextComponent("Invalid dimId"), true);
            }
        } else if (sender.func_197022_f() != null) {
            ResourceLocation dimId = ZUtils.getDimensionIdentifier((World)sender.func_197023_e());
            if (DimensionManager.getInstance().isDimensionCreated(dimId)) {
                DimensionManager.getInstance().getDimensionProperties(dimId).resetProperties();
                PacketHandler.sendToAll((BasePacket)new PacketDimInfo(dimId, DimensionManager.getInstance().getDimensionProperties(dimId)));
            }
        } else {
            sender.func_197030_a((ITextComponent)new StringTextComponent("Please specify dimension ID"), true);
        }
        return 0;
    }
}

