/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.dimension;

import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.io.FileUtils;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.IGalaxy;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.backwardCompat.VersionCompat;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.advancedRocketry.util.FluidGasGiantGas;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.util.XMLPlanetLoader;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.ZUtils;

public class DimensionManager
implements IGalaxy {
    private Random random;
    public static final String workingPath = "advRocketry";
    public static final String tempFile = "/ARdata.dat";
    public static final String worldXML = "/planetDefs.xml";
    public static final String datapackPath = "datapacks";
    private boolean hasBeenInitiallized = false;
    public static String prevBuild;
    public static boolean hasReachedMoon;
    public static boolean hasReachedWarp;
    private HashMap<ResourceLocation, DimensionProperties> dimensionListResource = new HashMap();
    private HashMap<ResourceLocation, StellarBody> starList = new HashMap();
    public static final int GASGIANT_DIMID_OFFSET = 256;
    private static long nextSatelliteId;
    private static StellarBody sol;
    public Set<ResourceLocation> knownPlanets;
    public static DimensionProperties overworldProperties;
    public static DimensionProperties defaultSpaceDimensionProperties;
    public static DimensionProperties warpDimensionProperties;

    @Deprecated
    public static StellarBody getSol() {
        if (sol == null) {
            sol = new StellarBody();
        }
        return sol;
    }

    public static DimensionManager getInstance() {
        return AdvancedRocketry.proxy.getDimensionManager();
    }

    public DimensionManager() {
        sol = new StellarBody();
        sol.setTemperature(100);
        sol.setId(new ResourceLocation("star", "0"));
        sol.setName("Sol");
        overworldProperties = new DimensionProperties(new ResourceLocation("minecraft", DimensionType.field_235999_c_.func_240901_a_().func_110623_a()));
        overworldProperties.setAtmosphereDensityDirect(100);
        DimensionManager.overworldProperties.averageTemperature = 286;
        DimensionManager.overworldProperties.gravitationalMultiplier = 1.0f;
        DimensionManager.overworldProperties.orbitalDist = 100;
        DimensionManager.overworldProperties.skyColor = new float[]{1.0f, 1.0f, 1.0f};
        overworldProperties.setName("Earth");
        DimensionManager.overworldProperties.isNativeDimension = false;
        overworldProperties.setStar(sol);
        defaultSpaceDimensionProperties = new DimensionProperties(SpaceObjectManager.WARPDIMID, false);
        defaultSpaceDimensionProperties.setAtmosphereDensityDirect(0);
        DimensionManager.defaultSpaceDimensionProperties.averageTemperature = 0;
        DimensionManager.defaultSpaceDimensionProperties.gravitationalMultiplier = 0.1f;
        DimensionManager.defaultSpaceDimensionProperties.orbitalDist = 100;
        DimensionManager.defaultSpaceDimensionProperties.skyColor = new float[]{0.0f, 0.0f, 0.0f};
        defaultSpaceDimensionProperties.setName("Space");
        DimensionManager.defaultSpaceDimensionProperties.fogColor = new float[]{0.0f, 0.0f, 0.0f};
        DimensionManager.defaultSpaceDimensionProperties.orbitalDist = 1;
        warpDimensionProperties = new DimensionProperties(SpaceObjectManager.WARPDIMID, false);
        warpDimensionProperties.setAtmosphereDensityDirect(0);
        DimensionManager.warpDimensionProperties.averageTemperature = 0;
        DimensionManager.warpDimensionProperties.gravitationalMultiplier = 0.1f;
        DimensionManager.warpDimensionProperties.orbitalDist = 100;
        DimensionManager.warpDimensionProperties.skyColor = new float[]{0.0f, 0.0f, 0.0f};
        warpDimensionProperties.setName("Warp");
        DimensionManager.warpDimensionProperties.fogColor = new float[]{0.0f, 0.0f, 0.0f};
        DimensionManager.warpDimensionProperties.orbitalDist = 1;
        this.random = new Random(System.currentTimeMillis());
        this.knownPlanets = new HashSet<ResourceLocation>();
    }

    @Override
    public ResourceLocation[] getRegisteredDimensions() {
        ResourceLocation[] ret = new ResourceLocation[this.dimensionListResource.size()];
        return this.dimensionListResource.keySet().toArray(ret);
    }

    public ResourceLocation[] getLoadedDimensions() {
        return this.getRegisteredDimensions();
    }

    public boolean isSpaceDimension(ResourceLocation dimid) {
        if (dimid == null) {
            return false;
        }
        return dimid.equals((Object)ARConfiguration.GetSpaceDimId());
    }

    public boolean isSpaceDimension(World dimid) {
        if (dimid == null) {
            return false;
        }
        return this.isSpaceDimension(ZUtils.getDimensionIdentifier((World)dimid));
    }

    public long getNextSatelliteId() {
        return nextSatelliteId++;
    }

    @Override
    public SatelliteBase getSatellite(long satId) {
        SatelliteBase satellite;
        if (!this.hasBeenInitiallized && EffectiveSide.get().isServer()) {
            DimensionManager.getInstance().loadDimensions(ServerLifecycleHooks.getCurrentServer().func_240776_a_(new FolderName(workingPath)).toString());
        }
        if ((satellite = overworldProperties.getSatellite(satId)) != null) {
            return satellite;
        }
        for (ResourceLocation i : DimensionManager.getInstance().getLoadedDimensions()) {
            satellite = DimensionManager.getInstance().getDimensionProperties(i).getSatellite(satId);
            if (satellite == null) continue;
            return satellite;
        }
        return null;
    }

    public Collection<SatelliteBase> getSatellites() {
        if (!this.hasBeenInitiallized && EffectiveSide.get().isServer()) {
            DimensionManager.getInstance().loadDimensions(ServerLifecycleHooks.getCurrentServer().func_240776_a_(new FolderName(workingPath)).toString());
        }
        LinkedList<SatelliteBase> satellites = new LinkedList<SatelliteBase>();
        for (ResourceLocation i : DimensionManager.getInstance().getLoadedDimensions()) {
            satellites.addAll(DimensionManager.getInstance().getDimensionProperties(i).getAllSatellites());
        }
        return satellites;
    }

    private String getNextName(ResourceLocation starId, ResourceLocation dimId) {
        return this.getStar(starId).getName() + " " + dimId;
    }

    public void tickDimensions() {
        for (ResourceLocation i : DimensionManager.getInstance().getLoadedDimensions()) {
            DimensionManager.getInstance().getDimensionProperties(i).tick();
        }
    }

    public void tickDimensionsClient() {
        for (ResourceLocation i : DimensionManager.getInstance().getLoadedDimensions()) {
            DimensionManager.getInstance().getDimensionProperties(i).updateOrbit();
        }
    }

    public void setDimProperties(ResourceLocation dimId, DimensionProperties properties) {
        this.dimensionListResource.put(dimId, properties);
    }

    public ResourceLocation getNextFreeDim() {
        for (int i = 0; i < 10000; ++i) {
            ResourceLocation planetID = new ResourceLocation("planet", "planet-" + String.valueOf(i));
            if (this.dimensionListResource.containsKey(planetID) || ZUtils.isWorldRegistered((ResourceLocation)planetID)) continue;
            return planetID;
        }
        return Constants.INVALID_PLANET;
    }

    public ResourceLocation getNextFreeStarId() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            ResourceLocation starId = new ResourceLocation("star", "star" + String.valueOf(i));
            if (this.starList.containsKey(starId)) continue;
            return starId;
        }
        return Constants.INVALID_PLANET;
    }

    public DimensionProperties generateRandom(ResourceLocation starId, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, 100, 100, 100, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandom(ResourceLocation starId, String name, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, name, 100, 100, 100, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandom(ResourceLocation starId, String name, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        double minDistance;
        DimensionProperties properties = new DimensionProperties(this.getNextFreeDim());
        if (Constants.INVALID_PLANET.equals((Object)properties.getId())) {
            return null;
        }
        if (name == "") {
            properties.setName(this.getNextName(starId, properties.getId()));
        } else {
            properties.setName(name);
        }
        properties.setAtmosphereDensityDirect(MathHelper.func_76125_a((int)(baseAtmosphere + this.random.nextInt(atmosphereFactor) - atmosphereFactor / 2), (int)0, (int)1600));
        int newDist = properties.orbitalDist = MathHelper.func_76125_a((int)(baseDistance + this.random.nextInt(distanceFactor)), (int)1, (int)Integer.MAX_VALUE);
        properties.gravitationalMultiplier = Math.min(Math.max(0.05f, (float)(baseGravity + this.random.nextInt(gravityFactor) - gravityFactor / 2) / 100.0f), 1.3f);
        int walkDist = 0;
        do {
            minDistance = Double.MAX_VALUE;
            for (IDimensionProperties properties2 : this.getStar(starId).getPlanets()) {
                int dist = Math.abs(((DimensionProperties)properties2).orbitalDist - newDist);
                if (!(minDistance > (double)dist)) continue;
                minDistance = dist;
            }
            newDist = properties.orbitalDist + walkDist;
            walkDist = walkDist > -1 ? -walkDist - 1 : -walkDist;
        } while (minDistance < 4.0);
        properties.orbitalDist = newDist;
        properties.baseOrbitTheta = (double)this.random.nextInt(360) * Math.PI / 180.0;
        properties.orbitalPhi = (this.random.nextGaussian() - 0.5) * 180.0;
        properties.rotationalPhi = (this.random.nextGaussian() - 0.5) * 180.0;
        properties.setStar(this.getStar(starId));
        properties.averageTemperature = AstronomicalBodyHelper.getAverageTemperature(properties.getStar(), properties.getSolarOrbitalDistance(), properties.getAtmosphereDensity());
        if (DimensionProperties.AtmosphereTypes.getAtmosphereTypeFromValue(properties.getAtmosphereDensity()) == DimensionProperties.AtmosphereTypes.NONE && this.random.nextInt() % 5 == 0) {
            properties.setOceanBlock(((FlowingFluidBlock)AdvancedRocketryBlocks.blockOxygenFluid.get()).func_176223_P());
            properties.setSeaLevel(this.random.nextInt(6) + 72);
        }
        if (this.random.nextInt() % 10 == 0) {
            properties.setSeaLevel(this.random.nextInt(40) + 43);
        }
        properties.skyColor[0] = properties.skyColor[0] * (1.0f - MathHelper.func_76131_a((float)(this.random.nextFloat() * 0.1f + (float)(70 - properties.averageTemperature / 3) / 100.0f), (float)0.2f, (float)1.0f));
        properties.skyColor[1] = properties.skyColor[1] * (1.0f - this.random.nextFloat() * 0.5f);
        properties.skyColor[2] = properties.skyColor[2] * (1.0f - MathHelper.func_76131_a((float)(this.random.nextFloat() * 0.1f + (float)(properties.averageTemperature / 3 - 70) / 100.0f), (float)0.0f, (float)1.0f));
        if (this.random.nextInt() % 50 == 0) {
            properties.setHasRings(true);
            properties.ringColor[0] = properties.skyColor[0];
            properties.ringColor[1] = properties.skyColor[1];
            properties.ringColor[2] = properties.skyColor[2];
        }
        properties.rotationalPeriod = (int)(Math.pow(1.0f / properties.gravitationalMultiplier, 3.0) * 24000.0);
        properties.addBiomes(properties.getViableBiomes());
        properties.initDefaultAttributes();
        this.registerDim(properties, true);
        return properties;
    }

    public DimensionProperties generateRandom(ResourceLocation starId, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, "", baseAtmosphere, baseDistance, baseGravity, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandomGasGiant(ResourceLocation starId, String name, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        double minDistance;
        DimensionProperties properties = new DimensionProperties(this.getNextFreeDim());
        if (name == "") {
            properties.setName(this.getNextName(starId, properties.getId()));
        } else {
            properties.setName(name);
        }
        properties.setAtmosphereDensityDirect(MathHelper.func_76125_a((int)(baseAtmosphere + this.random.nextInt(atmosphereFactor) - atmosphereFactor / 2), (int)0, (int)1600));
        properties.orbitalDist = MathHelper.func_76125_a((int)(baseDistance + this.random.nextInt(distanceFactor)), (int)1, (int)800);
        properties.gravitationalMultiplier = Math.min(Math.max(0.05f, (float)(baseGravity + this.random.nextInt(gravityFactor) - gravityFactor / 2) / 100.0f), 1.3f);
        do {
            minDistance = Double.MAX_VALUE;
            properties.orbitTheta = (double)this.random.nextInt(360) * (Math.PI * 2) / 360.0;
            for (IDimensionProperties properties2 : this.getStar(starId).getPlanets()) {
                double dist = Math.abs(((DimensionProperties)properties2).orbitTheta - properties.orbitTheta);
                if (!(dist < minDistance)) continue;
                minDistance = dist;
            }
        } while (minDistance < 0.07853981633974483);
        properties.setStar(this.getStar(starId));
        properties.averageTemperature = AstronomicalBodyHelper.getAverageTemperature(properties.getStar(), properties.getSolarOrbitalDistance(), properties.getAtmosphereDensity());
        properties.setGasGiant(true);
        for (FluidGasGiantGas gas : AdvancedRocketryFluids.getGasGiantGasses()) {
            if (!(properties.gravitationalMultiplier * 100.0f >= (float)gas.getMinGravity()) || !((float)gas.getMaxGravity() >= properties.gravitationalMultiplier * 100.0f) || !(0.0 > Math.random() - gas.getChance())) continue;
            properties.getHarvestableGasses().add(gas.getFluid());
        }
        this.registerDim(properties, true);
        return properties;
    }

    @Override
    public boolean canTravelTo(ResourceLocation dimId) {
        return ZUtils.isWorldRegistered((ResourceLocation)dimId) && this.getDimensionProperties(dimId).hasSurface();
    }

    public boolean canTravelTo(ServerWorld dimId) {
        return this.getDimensionProperties(ZUtils.getDimensionIdentifier((World)dimId)).hasSurface();
    }

    public boolean registerDim(DimensionProperties properties, boolean registerWithForge) {
        boolean bool = this.registerDimNoUpdate(properties, registerWithForge);
        if (bool) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(properties.getId(), properties));
        }
        return bool;
    }

    public void writeDimAsJSON(DimensionProperties properties) throws IOException {
        File saveDir = ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile();
        String fileContents = properties.generateDimJSON();
        File file = new File(saveDir, "datapacks/ar_datapack/data/" + properties.getId().func_110624_b() + "/dimension/" + properties.getId().func_110623_a() + ".json");
        File dir = new File(saveDir, "datapacks/ar_datapack/data/" + properties.getId().func_110624_b() + "/dimension");
        File mcMeta = new File(saveDir, "datapacks/ar_datapack/pack.mcmeta");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!mcMeta.exists()) {
            mcMeta.createNewFile();
            FileOutputStream fileString = new FileOutputStream(mcMeta);
            PrintWriter tmpFileOut = new PrintWriter(fileString);
            tmpFileOut.write("{\n    \"pack\": {\n        \"description\": \"Advanced Rocketry resources pt2\",\n        \"pack_format\": 6\n    }\n}\n");
            tmpFileOut.close();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        File tmpFile = File.createTempFile("dimprops", ".DAT", saveDir);
        FileOutputStream fileString = new FileOutputStream(tmpFile);
        PrintWriter tmpFileOut = new PrintWriter(fileString);
        try {
            tmpFileOut.print(fileContents);
            tmpFileOut.flush();
            fileString.getFD().sync();
            tmpFileOut.close();
            Files.copy((File)tmpFile, (File)file);
            tmpFile.delete();
        }
        catch (Exception e) {
            AdvancedRocketry.logger.error("Cannot save advanced rocketry planet file, you may be able to find backups in " + saveDir);
            e.printStackTrace();
        }
    }

    public boolean registerDimNoUpdate(DimensionProperties properties, boolean registerWithForge) {
        ResourceLocation dimId = properties.getId();
        if (this.dimensionListResource.containsKey(dimId)) {
            return false;
        }
        this.dimensionListResource.put(dimId, properties);
        return true;
    }

    public void registerSpaceDimension(ResourceLocation dimId) {
        defaultSpaceDimensionProperties.setId(dimId);
    }

    public void unregisterAllDimensions() {
        for (Map.Entry<ResourceLocation, DimensionProperties> dimSet : this.dimensionListResource.entrySet()) {
            if (!dimSet.getValue().isNativeDimension || !dimSet.getValue().hasSurface() || !ZUtils.isWorldRegistered((ResourceLocation)dimSet.getKey())) continue;
            ZUtils.unregisterDimension((ResourceLocation)dimSet.getKey());
        }
        this.dimensionListResource.clear();
        this.starList.clear();
    }

    public void deleteDimension(ResourceLocation dimId) {
        if (ZUtils.isWorldLoaded((ResourceLocation)dimId)) {
            AdvancedRocketry.logger.warn("Cannot delete dimension " + dimId + " it is still loaded");
            return;
        }
        DimensionProperties properties = this.dimensionListResource.get(dimId);
        if (properties == null) {
            return;
        }
        if (properties.getStar() != null) {
            properties.getStar().removePlanet(properties);
        }
        if (properties.isMoon()) {
            properties.getParentProperties().removeChild(properties.getId());
        }
        if (properties.hasChildren()) {
            Iterator<ResourceLocation> iterator = properties.getChildPlanets().iterator();
            while (iterator.hasNext()) {
                ResourceLocation child = iterator.next();
                iterator.remove();
                this.deleteDimension(child);
                PacketHandler.sendToAll((BasePacket)new PacketDimInfo(child, null));
            }
        }
        if (properties.isNativeDimension && ZUtils.isWorldRegistered((ResourceLocation)dimId)) {
            if (!ZUtils.isWorldLoaded((ResourceLocation)dimId)) {
                ZUtils.unloadWorld((ResourceLocation)dimId);
            }
            ZUtils.unregisterDimension((ResourceLocation)dimId);
        }
        this.dimensionListResource.remove(dimId);
        File file = ServerLifecycleHooks.getCurrentServer().func_240776_a_(new FolderName("advRocketry/DIM" + dimId)).toFile();
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isInitialized() {
        return this.hasBeenInitiallized;
    }

    public void onServerStopped() {
        this.unregisterAllDimensions();
        this.knownPlanets.clear();
        overworldProperties.resetProperties();
        this.hasBeenInitiallized = false;
    }

    @Override
    public DimensionProperties getDimensionProperties(ResourceLocation resourceLocation) {
        if (SpaceObjectManager.WARPDIMID.equals((Object)resourceLocation)) {
            return warpDimensionProperties;
        }
        if (this.isStar(resourceLocation)) {
            DimensionProperties starProps = new DimensionProperties(resourceLocation);
            starProps.setStar(resourceLocation);
            starProps.setName(starProps.getStar().getName());
            return starProps;
        }
        DimensionProperties properties = this.dimensionListResource.get(resourceLocation);
        if (ARConfiguration.GetSpaceDimId().equals((Object)resourceLocation) || resourceLocation == null) {
            return defaultSpaceDimensionProperties;
        }
        return properties == null ? overworldProperties : properties;
    }

    public DimensionProperties getDimensionProperties(ResourceLocation resourceLocation, BlockPos pos) {
        if (ARConfiguration.GetSpaceDimId().equals((Object)resourceLocation)) {
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
            if (obj == null) {
                return defaultSpaceDimensionProperties;
            }
            return (DimensionProperties)obj.getProperties();
        }
        DimensionProperties properties = this.dimensionListResource.get(resourceLocation);
        return properties == null ? overworldProperties : properties;
    }

    public DimensionProperties getDimensionProperties(World world) {
        return this.getDimensionProperties(ZUtils.getDimensionIdentifier((World)world));
    }

    public DimensionProperties getDimensionProperties(World world, BlockPos pos) {
        return this.getDimensionProperties(ZUtils.getDimensionIdentifier((World)world), pos);
    }

    @Override
    public StellarBody getStar(ResourceLocation id) {
        return this.starList.get(id);
    }

    public Set<ResourceLocation> getStarIds() {
        return this.starList.keySet();
    }

    public boolean isStar(ResourceLocation id) {
        return this.starList.keySet().contains(id);
    }

    @Override
    public Collection<StellarBody> getStars() {
        return this.starList.values();
    }

    public void addStar(StellarBody star) {
        this.starList.put(star.getId(), star);
    }

    public void removeStar(ResourceLocation starId) {
        this.starList.remove(starId);
    }

    public void saveDimensions(String filePath) throws Exception {
        File saveDir = ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).toFile();
        if (this.starList.isEmpty() || this.dimensionListResource.isEmpty()) {
            throw new Exception("Missing Stars");
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("nextSatelliteId", nextSatelliteId);
        CompoundNBT stats = new CompoundNBT();
        stats.func_74757_a("hasReachedMoon", hasReachedMoon);
        stats.func_74757_a("hasReachedWarp", hasReachedWarp);
        nbt.func_218657_a("stat", (INBT)stats);
        CompoundNBT nbtTag = new CompoundNBT();
        SpaceObjectManager.getSpaceManager().writeToNBT(nbtTag);
        nbt.func_218657_a("spaceObjects", (INBT)nbtTag);
        String xmlOutput = XMLPlanetLoader.writeXML(this);
        try {
            File planetXMLOutput = new File(saveDir, filePath + worldXML);
            File advRocketrySaveDir = new File(saveDir, filePath);
            if (!advRocketrySaveDir.exists()) {
                advRocketrySaveDir.mkdirs();
            }
            if (!planetXMLOutput.exists()) {
                planetXMLOutput.createNewFile();
            }
            File tmpFileXml = File.createTempFile("ARXMLdata_", ".DAT", saveDir);
            FileOutputStream bufoutStream = new FileOutputStream(tmpFileXml);
            bufoutStream.write(xmlOutput.getBytes());
            bufoutStream.flush();
            bufoutStream.getFD().sync();
            bufoutStream.close();
            Files.copy((File)tmpFileXml, (File)planetXMLOutput);
            tmpFileXml.delete();
            File file = new File(saveDir, filePath + tempFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            ListNBT satelliteNbt = new ListNBT();
            for (SatelliteBase sat : this.getSatellites()) {
                CompoundNBT satTag = new CompoundNBT();
                sat.writeToNBT(satTag);
                satelliteNbt.add((Object)satTag);
            }
            nbt.func_218657_a("satellites", (INBT)satelliteNbt);
            File tmpFile = File.createTempFile("dimprops", ".DAT", saveDir);
            FileOutputStream tmpFileOut = new FileOutputStream(tmpFile);
            DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(tmpFileOut)));
            try {
                CompressedStreamTools.func_74800_a((CompoundNBT)nbt, (DataOutput)outStream);
                outStream.flush();
                tmpFileOut.getFD().sync();
                outStream.close();
                Files.copy((File)tmpFile, (File)file);
                tmpFile.delete();
            }
            catch (Exception e) {
                AdvancedRocketry.logger.error("Cannot save advanced rocketry planet file, you may be able to find backups in " + saveDir);
                e.printStackTrace();
            }
            for (ResourceLocation location : this.getRegisteredDimensions()) {
                DimensionProperties properties = this.getDimensionProperties(location);
                if (!properties.isNativeDimension) continue;
                this.writeDimAsJSON(properties);
            }
        }
        catch (IOException e) {
            AdvancedRocketry.logger.error("Cannot save advanced rocketry planet files, you may be able to find backups in " + saveDir);
            e.printStackTrace();
        }
    }

    @Override
    public boolean isDimensionCreated(ResourceLocation dimId) {
        return this.dimensionListResource.containsKey(dimId) || ARConfiguration.GetSpaceDimId().equals((Object)dimId);
    }

    public boolean isDimensionCreated(World dimId) {
        return this.isDimensionCreated(ZUtils.getDimensionIdentifier((World)dimId));
    }

    private List<DimensionProperties> generateRandomPlanets(StellarBody star, int numRandomGeneratedPlanets, int numRandomGeneratedGasGiants) {
        DimensionProperties moonProperties;
        int ii;
        int numMoons;
        DimensionProperties properties;
        int baseDistance;
        int baseAtm;
        int i;
        LinkedList<DimensionProperties> dimPropList = new LinkedList<DimensionProperties>();
        Random random = new Random(System.currentTimeMillis());
        for (i = 0; i < numRandomGeneratedGasGiants; ++i) {
            baseAtm = 180;
            baseDistance = 100;
            properties = DimensionManager.getInstance().generateRandomGasGiant(star.getId(), "", baseDistance + 50, baseAtm, 125, 100, 100, 75);
            dimPropList.add(properties);
            if (!(properties.gravitationalMultiplier >= 1.0f)) continue;
            numMoons = random.nextInt(8);
            for (ii = 0; ii < numMoons; ++ii) {
                moonProperties = DimensionManager.getInstance().generateRandom(star.getId(), properties.getName() + ": " + ii, 25, 100, (int)(properties.gravitationalMultiplier / 0.02f), 25, 100, 50);
                if (moonProperties == null) continue;
                dimPropList.add(moonProperties);
                moonProperties.setParentPlanet(properties);
                star.removePlanet(moonProperties);
            }
        }
        for (i = 0; i < numRandomGeneratedPlanets; ++i) {
            baseAtm = 75;
            baseDistance = 100;
            if (i % 4 == 0) {
                baseAtm = 0;
            } else if (i != 6 && (i + 2) % 4 == 0) {
                baseAtm = 120;
            }
            if (i % 3 == 0) {
                baseDistance = 170;
            } else if ((i + 1) % 3 == 0) {
                baseDistance = 30;
            }
            properties = DimensionManager.getInstance().generateRandom(star.getId(), baseDistance, baseAtm, 125, 100, 100, 75);
            if (properties == null) continue;
            dimPropList.add(properties);
            if (!(properties.gravitationalMultiplier >= 1.0f)) continue;
            numMoons = random.nextInt(4);
            for (ii = 0; ii < numMoons; ++ii) {
                moonProperties = DimensionManager.getInstance().generateRandom(star.getId(), properties.getName() + ": " + ii, 25, 100, (int)(properties.gravitationalMultiplier / 0.02f), 25, 100, 50);
                if (moonProperties == null) continue;
                dimPropList.add(moonProperties);
                moonProperties.setParentPlanet(properties);
                star.removePlanet(moonProperties);
            }
        }
        return dimPropList;
    }

    public void createAndLoadDimensions(boolean resetFromXml) {
        Map<ResourceLocation, IDimensionProperties> loadedPlanets;
        File file;
        boolean dimOffset = false;
        XMLPlanetLoader.DimensionPropertyCoupling dimCouplingList = null;
        XMLPlanetLoader loader = null;
        boolean loadedFromXML = false;
        File localFile = file = ServerLifecycleHooks.getCurrentServer().func_240776_a_(new FolderName("advRocketry/planetDefs.xml")).toFile();
        AdvancedRocketry.logger.info("Checking for config at " + file.getAbsolutePath());
        if (!file.exists() || resetFromXml) {
            String newFilePath = "./config/advRocketry/planetDefs.xml";
            if (!file.exists()) {
                AdvancedRocketry.logger.info("File not found.  Now checking for config at " + newFilePath);
            }
            if ((file = new File(newFilePath)).exists()) {
                AdvancedRocketry.logger.info("Advanced Planet Config file Found!  Copying to world specific directory");
                try {
                    File dir = new File(localFile.getAbsolutePath().substring(0, localFile.getAbsolutePath().length() - localFile.getName().length()));
                    if ((dir.exists() || dir.mkdir()) && localFile.createNewFile()) {
                        Object buffer = new char[1024];
                        FileReader reader = new FileReader(file);
                        FileWriter writer = new FileWriter(localFile);
                        int numChars = 0;
                        while ((numChars = reader.read((char[])buffer)) > 0) {
                            writer.write((char[])buffer, 0, numChars);
                        }
                        reader.close();
                        writer.close();
                        AdvancedRocketry.logger.info("Copy success!");
                    } else {
                        AdvancedRocketry.logger.warn("Unable to create file " + localFile.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    AdvancedRocketry.logger.warn("Unable to write file " + localFile.getAbsolutePath());
                }
            }
        }
        if (file.exists()) {
            AdvancedRocketry.logger.info("Advanced Planet Config file Found!  Loading from file.");
            loader = new XMLPlanetLoader();
            try {
                loader.loadFile(file);
                if (!loader.isValid()) {
                    throw new Exception("Cannot read XML");
                }
                dimCouplingList = loader.readAllPlanets();
            }
            catch (Exception e) {
                e.printStackTrace();
                AdvancedRocketry.logger.fatal("A serious error has occured while loading the planetDefs XML");
                ServerLifecycleHooks.handleExit((int)-1);
            }
        }
        if (dimCouplingList != null) {
            for (StellarBody star : dimCouplingList.stars) {
                if (DimensionManager.getInstance().getStar(star.getId()) == null) {
                    DimensionManager.getInstance().addStar(star);
                }
                DimensionManager.getInstance().getStar(star.getId()).setName(star.getName());
                DimensionManager.getInstance().getStar(star.getId()).setPosX(star.getPosX());
                DimensionManager.getInstance().getStar(star.getId()).setPosZ(star.getPosZ());
                DimensionManager.getInstance().getStar(star.getId()).setSize(star.getSize());
                DimensionManager.getInstance().getStar(star.getId()).setTemperature(star.getTemperature());
                DimensionManager.getInstance().getStar((ResourceLocation)star.getId()).subStars = star.subStars;
                DimensionManager.getInstance().getStar(star.getId()).setBlackHole(star.isBlackHole());
            }
            for (DimensionProperties properties : dimCouplingList.dims) {
                DimensionProperties loadedProps;
                for (StellarBody star : dimCouplingList.stars) {
                    for (StellarBody loadedStar : DimensionManager.getInstance().getStars()) {
                        if (star.getId() != properties.getStarId() || !star.getName().equals(loadedStar.getName())) continue;
                        DimensionManager.getInstance().registerDimNoUpdate(properties, false);
                        properties.setStar(loadedStar);
                    }
                }
                if (properties.isNativeDimension) {
                    DimensionManager.getInstance().registerDim(properties, properties.isNativeDimension);
                }
                if (!properties.customIcon.isEmpty() && DimensionManager.getInstance().isDimensionCreated(properties.getId())) {
                    loadedProps = DimensionManager.getInstance().getDimensionProperties(properties.getId());
                    loadedProps.customIcon = properties.customIcon;
                }
                if (DimensionManager.getInstance().isDimensionCreated(properties.getId())) {
                    loadedProps = DimensionManager.getInstance().getDimensionProperties(properties.getId());
                    LinkedList<ItemStack> list = new LinkedList<ItemStack>(properties.getRequiredArtifacts());
                    loadedProps.getRequiredArtifacts().clear();
                    loadedProps.getRequiredArtifacts().addAll((Collection<ItemStack>)list);
                    LinkedList<SpawnListEntryNBT> list2 = new LinkedList<SpawnListEntryNBT>(properties.getSpawnListEntries());
                    loadedProps.getSpawnListEntries().clear();
                    loadedProps.getSpawnListEntries().addAll(list2);
                }
                if (properties.oreProperties == null || (loadedProps = DimensionManager.getInstance().getDimensionProperties(properties.getId())) == null) continue;
                loadedProps.oreProperties = properties.oreProperties;
            }
        }
        if ((loadedPlanets = this.loadDimensions(workingPath)).isEmpty() && (dimCouplingList == null || dimCouplingList.dims == null || dimCouplingList.dims.isEmpty())) {
            int numRandomGeneratedPlanets = 9;
            int numRandomGeneratedGasGiants = 1;
            if (dimCouplingList != null) {
                AdvancedRocketry.logger.info("Loading initial planet config!");
                for (StellarBody star : dimCouplingList.stars) {
                    DimensionManager.getInstance().addStar(star);
                }
                for (DimensionProperties properties : dimCouplingList.dims) {
                    DimensionManager.getInstance().registerDimNoUpdate(properties, properties.isNativeDimension);
                    properties.setStar(properties.getStarId());
                }
                for (StellarBody star : dimCouplingList.stars) {
                    numRandomGeneratedPlanets = loader.getMaxNumPlanets(star);
                    numRandomGeneratedGasGiants = loader.getMaxNumGasGiants(star);
                    dimCouplingList.dims.addAll(this.generateRandomPlanets(star, numRandomGeneratedPlanets, numRandomGeneratedGasGiants));
                }
                loadedFromXML = true;
            }
            if (!loadedFromXML) {
                StellarBody star;
                StellarBody sol = new StellarBody();
                sol.setTemperature(100);
                sol.setId(new ResourceLocation("star", "0"));
                sol.setName("Sol");
                DimensionManager.getInstance().addStar(sol);
                DimensionManager.getInstance().registerDimNoUpdate(overworldProperties, false);
                sol.addPlanet(overworldProperties);
                if (Constants.INVALID_PLANET.equals((Object)ARConfiguration.getCurrentConfig().MoonId)) {
                    ARConfiguration.getCurrentConfig().MoonId = new ResourceLocation("planet", "luna");
                }
                if (!Constants.INVALID_PLANET.equals((Object)ARConfiguration.getCurrentConfig().MoonId)) {
                    DimensionProperties dimensionProperties = new DimensionProperties(ARConfiguration.getCurrentConfig().MoonId);
                    dimensionProperties.setAtmosphereDensityDirect(0);
                    dimensionProperties.averageTemperature = 20;
                    dimensionProperties.rotationalPeriod = 128000;
                    dimensionProperties.gravitationalMultiplier = 0.166f;
                    dimensionProperties.setName("Luna");
                    dimensionProperties.orbitalDist = 150;
                    dimensionProperties.addBiome(AdvancedRocketryBiomes.moonBiome);
                    dimensionProperties.addBiome(AdvancedRocketryBiomes.moonBiomeDark);
                    dimensionProperties.setParentPlanet(overworldProperties);
                    dimensionProperties.setStar(DimensionManager.getSol());
                    dimensionProperties.isNativeDimension = !ModList.get().isLoaded("GalacticraftCore");
                    dimensionProperties.initDefaultAttributes();
                    DimensionManager.getInstance().registerDimNoUpdate(dimensionProperties, !ModList.get().isLoaded("GalacticraftCore"));
                }
                this.generateRandomPlanets(DimensionManager.getSol(), numRandomGeneratedPlanets, numRandomGeneratedGasGiants);
                star = new StellarBody();
                star.setTemperature(10);
                star.setPosX(300);
                star.setPosZ(-200);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Wolf 12");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 5, 0);
                star = new StellarBody();
                star.setTemperature(170);
                star.setPosX(-200);
                star.setPosZ(80);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Epsilon ire");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 7, 0);
                star = new StellarBody();
                star.setTemperature(200);
                star.setPosX(-150);
                star.setPosZ(250);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Proxima Centaurs");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 3, 0);
                star = new StellarBody();
                star.setTemperature(70);
                star.setPosX(-150);
                star.setPosZ(-250);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Magnis Vulpes");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 2, 0);
                star = new StellarBody();
                star.setTemperature(200);
                star.setPosX(50);
                star.setPosZ(-250);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Ma-Roo");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 6, 0);
                star = new StellarBody();
                star.setTemperature(120);
                star.setPosX(75);
                star.setPosZ(200);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Alykitt");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 3, 1);
            }
        } else {
            VersionCompat.upgradeDimensionManagerPostLoad(prevBuild);
        }
        if (dimCouplingList != null && !loadedFromXML) {
            for (StellarBody star : dimCouplingList.stars) {
                int numRandomGeneratedPlanets = loader.getMaxNumPlanets(star);
                int numRandomGeneratedGasGiants = loader.getMaxNumGasGiants(star);
                this.generateRandomPlanets(star, numRandomGeneratedPlanets, numRandomGeneratedGasGiants);
            }
        }
        DimensionManager.getInstance().knownPlanets.addAll(ARConfiguration.getCurrentConfig().initiallyKnownPlanets);
        for (ISpaceObject i : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
            ResourceLocation orbitingId = i.getOrbitingPlanetId();
            if (this.isDimensionCreated(orbitingId) || SpaceObjectManager.WARPDIMID.equals((Object)orbitingId) || !orbitingId.func_110624_b().equals("planet")) continue;
            AdvancedRocketry.logger.warn("Dimension ID " + i.getOrbitingPlanetId() + " is not registered and a space station is orbiting it, moving to dimid 0");
            i.setOrbitingBody(defaultSpaceDimensionProperties.getId());
        }
    }

    public Map<ResourceLocation, IDimensionProperties> loadDimensions(String filePath) {
        CompoundNBT nbt;
        this.hasBeenInitiallized = true;
        HashMap<ResourceLocation, IDimensionProperties> loadedDimProps = new HashMap<ResourceLocation, IDimensionProperties>();
        try {
            File file = ServerLifecycleHooks.getCurrentServer().func_240776_a_(new FolderName(filePath + tempFile)).toFile();
            if (!file.exists()) {
                new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - file.getName().length())).mkdirs();
                file.createNewFile();
                return loadedDimProps;
            }
            FileInputStream inStream = new FileInputStream(file);
            nbt = CompressedStreamTools.func_74796_a((InputStream)inStream);
            inStream.close();
        }
        catch (EOFException e) {
            return loadedDimProps;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return loadedDimProps;
        }
        catch (IOException e) {
            e.printStackTrace();
            return loadedDimProps;
        }
        CompoundNBT stats = nbt.func_74775_l("stat");
        hasReachedMoon = stats.func_74767_n("hasReachedMoon");
        hasReachedWarp = stats.func_74767_n("hasReachedWarp");
        nextSatelliteId = nbt.func_74763_f("nextSatelliteId");
        if (nbt.func_74764_b("spaceObjects")) {
            CompoundNBT nbtTag = nbt.func_74775_l("spaceObjects");
            SpaceObjectManager.getSpaceManager().readFromNBT(nbtTag);
        }
        ListNBT satNbtList = nbt.func_150295_c("satellites", 10);
        for (int i = 0; i < satNbtList.size(); ++i) {
            CompoundNBT satTag = satNbtList.func_150305_b(i);
            SatelliteBase sat = SatelliteRegistry.createFromNBT(satTag);
            sat.getDimensionId().ifPresent(r -> {
                DimensionProperties dimprops = this.getDimensionProperties((ResourceLocation)r);
                if (dimprops != null) {
                    dimprops.addSatellite(sat);
                }
            });
        }
        prevBuild = nbt.func_74779_i("prevVersion");
        nbt.func_74778_a("prevVersion", "@MAJOR@.@MINOR@.@REVIS@@BUILD@");
        return loadedDimProps;
    }

    @Override
    public boolean areDimensionsInSamePlanetMoonSystem(ResourceLocation destinationDimId, ResourceLocation dimension) {
        return PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(destinationDimId, dimension);
    }

    private boolean areDimensionsInSamePlanetMoonSystem(DimensionProperties properties, ResourceLocation id) {
        if (properties.getId().equals((Object)id)) {
            return true;
        }
        for (ResourceLocation child : properties.getChildPlanets()) {
            if (!this.areDimensionsInSamePlanetMoonSystem(this.getDimensionProperties(child), id)) continue;
            return true;
        }
        return false;
    }

    public static DimensionProperties getEffectiveDimId(ResourceLocation dimId, BlockPos pos) {
        if (ARConfiguration.GetSpaceDimId().equals((Object)dimId)) {
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
            if (obj != null) {
                return (DimensionProperties)obj.getProperties().getParentProperties();
            }
            return defaultSpaceDimensionProperties;
        }
        return DimensionManager.getInstance().getDimensionProperties(dimId);
    }

    public static DimensionProperties getEffectiveDimId(World world, BlockPos pos) {
        ResourceLocation dimId = ZUtils.getDimensionIdentifier((World)world);
        if (ARConfiguration.GetSpaceDimId().equals((Object)dimId)) {
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
            if (obj != null) {
                return (DimensionProperties)obj.getProperties().getParentProperties();
            }
            return defaultSpaceDimensionProperties;
        }
        return DimensionManager.getInstance().getDimensionProperties(dimId);
    }

    public static DimensionProperties getEffectiveDimId(World world, Vector3d positionVec) {
        return DimensionManager.getEffectiveDimId(ZUtils.getDimensionIdentifier((World)world), new BlockPos(positionVec));
    }
}

