/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.dimension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.client.render.planet.ISkyRenderer;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.advancedRocketry.util.OreGenProperties;
import zmaster587.advancedRocketry.util.SpacePosition;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.VulpineMath;
import zmaster587.libVulpes.util.ZUtils;

public class DimensionProperties
implements Cloneable,
IDimensionProperties {
    public static final ResourceLocation atmosphere = new ResourceLocation("advancedrocketry:textures/planets/atmosphere2.png");
    public static final ResourceLocation atmosphereLEO = new ResourceLocation("advancedrocketry:textures/planets/atmosphereleo.png");
    public static final ResourceLocation atmGlow = new ResourceLocation("advancedrocketry:textures/planets/atmglow.png");
    public static final ResourceLocation planetRings = new ResourceLocation("advancedrocketry:textures/planets/rings.png");
    public static final ResourceLocation planetRingShadow = new ResourceLocation("advancedrocketry:textures/planets/ringshadow.png");
    public static final ResourceLocation shadow = new ResourceLocation("advancedrocketry:textures/planets/shadow.png");
    public static final ResourceLocation shadow3 = new ResourceLocation("advancedrocketry:textures/planets/shadow3.png");
    public static final int MAX_ATM_PRESSURE = 1600;
    public static final int MIN_ATM_PRESSURE = 0;
    public static final int MAX_DISTANCE = Integer.MAX_VALUE;
    public static final int MIN_DISTANCE = 1;
    public static final int MAX_GRAVITY = 400;
    public static final int MIN_GRAVITY = 0;
    public boolean isNativeDimension;
    public float[] skyColor;
    public float[] fogColor;
    public float[] ringColor;
    public float gravitationalMultiplier;
    public int orbitalDist;
    public boolean hasOxygen;
    private int originalAtmosphereDensity;
    public double peakInsolationMultiplier;
    public double peakInsolationMultiplierWithoutAtmosphere;
    private int atmosphereDensity;
    public int averageTemperature;
    public int rotationalPeriod;
    public double orbitTheta;
    public double baseOrbitTheta;
    public double prevOrbitalTheta;
    public double orbitalPhi;
    public double rotationalPhi;
    public boolean isRetrograde;
    public OreGenProperties oreProperties = null;
    public List<ItemStack> laserDrillOres;
    public List<String> geodeOres;
    public List<String> craterOres;
    public String laserDrillOresRaw;
    public String customIcon;
    IAtmosphere atmosphereType;
    StellarBody star;
    ResourceLocation starId;
    private String name = "Temp";
    public float[] sunriseSunsetColors;
    private LinkedList<Biome> allowedBiomes;
    private LinkedList<Biome> terraformedBiomes;
    private boolean isRegistered = false;
    private boolean isTerraformed = false;
    public boolean hasRings = false;
    public List<ItemStack> requiredArtifacts;
    private HashSet<ResourceLocation> childPlanets;
    private ResourceLocation parentPlanet;
    private ResourceLocation planetId;
    private boolean isStation;
    private boolean isGasGiant;
    private boolean canGenerateCraters;
    private boolean canGenerateGeodes;
    private boolean canGenerateVolcanos;
    private boolean canGenerateStructures;
    private boolean canDecorate;
    private boolean overrideDecoration;
    private float craterFrequencyMultiplier;
    private float volcanoFrequencyMultiplier;
    private float geodeFrequencyMultiplier;
    ISkyRenderer sky;
    private HashMap<Long, SatelliteBase> satellites;
    private HashMap<Long, SatelliteBase> tickingSatellites;
    private List<Fluid> harvestableAtmosphere;
    private List<SpawnListEntryNBT> spawnableEntities;
    private HashSet<HashedBlockPosition> beaconLocations;
    private BlockState oceanBlock;
    private BlockState fillerBlock;
    private int sealevel;
    private int generatorType;

    public DimensionProperties(ResourceLocation id) {
        this.resetProperties();
        this.planetId = id;
        this.parentPlanet = Constants.INVALID_PLANET;
        this.childPlanets = new HashSet();
        this.orbitalPhi = 0.0;
        this.isRetrograde = false;
        this.ringColor = new float[]{0.4f, 0.4f, 0.7f};
        this.oceanBlock = null;
        this.fillerBlock = null;
        this.laserDrillOres = new ArrayList<ItemStack>();
        this.geodeOres = new ArrayList<String>();
        this.craterOres = new ArrayList<String>();
        this.allowedBiomes = new LinkedList();
        this.terraformedBiomes = new LinkedList();
        this.satellites = new HashMap();
        this.requiredArtifacts = new LinkedList<ItemStack>();
        this.tickingSatellites = new HashMap();
        this.isNativeDimension = true;
        this.hasOxygen = true;
        this.isGasGiant = false;
        this.hasRings = false;
        this.canGenerateCraters = false;
        this.canGenerateGeodes = false;
        this.canGenerateStructures = false;
        this.canGenerateVolcanos = false;
        this.craterFrequencyMultiplier = 1.0f;
        this.volcanoFrequencyMultiplier = 1.0f;
        this.geodeFrequencyMultiplier = 1.0f;
        this.canDecorate = true;
        this.customIcon = "";
        this.harvestableAtmosphere = new LinkedList<Fluid>();
        this.spawnableEntities = new LinkedList<SpawnListEntryNBT>();
        this.beaconLocations = new HashSet();
        this.sealevel = 63;
        this.generatorType = 0;
    }

    public DimensionProperties(ResourceLocation id, String name) {
        this(id);
        this.name = name;
    }

    public DimensionProperties(ResourceLocation id, boolean shouldRegister) {
        this(id);
        this.isStation = !shouldRegister;
    }

    public void copySatellites(DimensionProperties props) {
        this.satellites = props.satellites;
    }

    public void copyTerraformedBiomes(DimensionProperties props) {
        this.terraformedBiomes = props.terraformedBiomes;
        this.isTerraformed = props.isTerraformed;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public OreGenProperties getOreGenProperties(World world) {
        if (this.oreProperties != null) {
            return this.oreProperties;
        }
        return OreGenProperties.getOresForPressure(AtmosphereTypes.getAtmosphereTypeFromValue(this.originalAtmosphereDensity), Temps.getTempFromValue(this.getAverageTemp()));
    }

    public void resetProperties() {
        this.fogColor = new float[]{1.0f, 1.0f, 1.0f};
        this.skyColor = new float[]{1.0f, 1.0f, 1.0f};
        this.sunriseSunsetColors = new float[]{0.7f, 0.2f, 0.2f, 1.0f};
        this.ringColor = new float[]{0.4f, 0.4f, 0.7f};
        this.gravitationalMultiplier = 1.0f;
        this.rotationalPeriod = 24000;
        this.orbitalDist = 100;
        this.atmosphereDensity = 100;
        this.originalAtmosphereDensity = 100;
        this.childPlanets = new HashSet();
        this.requiredArtifacts = new LinkedList<ItemStack>();
        this.parentPlanet = Constants.INVALID_PLANET;
        this.starId = Constants.INVALID_STAR;
        this.averageTemperature = 100;
        this.hasRings = false;
        this.harvestableAtmosphere = new LinkedList<Fluid>();
        this.spawnableEntities = new LinkedList<SpawnListEntryNBT>();
        this.beaconLocations = new HashSet();
        this.sealevel = 63;
        this.oceanBlock = null;
        this.fillerBlock = null;
        this.generatorType = 0;
        this.sky = null;
        this.laserDrillOres = new ArrayList<ItemStack>();
    }

    public ISkyRenderer getSkyRenderer() {
        return this.sky;
    }

    public void setSkyRenderer(ISkyRenderer sky) {
        this.sky = sky;
    }

    public List<Fluid> getHarvestableGasses() {
        return this.harvestableAtmosphere;
    }

    public List<ItemStack> getRequiredArtifacts() {
        return this.requiredArtifacts;
    }

    @Override
    public float getGravitationalMultiplier() {
        return this.gravitationalMultiplier;
    }

    public float getGravitationalMultiplier(BlockPos blockPos) {
        ISpaceObject station;
        if (this.isStation() && (station = AdvancedRocketryAPI.spaceObjectManager.getSpaceStationFromBlockCoords(blockPos)) != null) {
            return station.getProperties().getGravitationalMultiplier();
        }
        return this.getGravitationalMultiplier();
    }

    @Override
    public void setGravitationalMultiplier(float mult) {
        this.gravitationalMultiplier = mult;
    }

    public List<SpawnListEntryNBT> getSpawnListEntries() {
        return this.spawnableEntities;
    }

    @Override
    public float[] getSunColor() {
        if (this.getStar() == null) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        return this.getStar().getColor();
    }

    public void setStar(StellarBody star) {
        if (star == null) {
            this.starId = Constants.INVALID_STAR;
            return;
        }
        this.starId = star.getId();
        this.star = star;
        if (!(this.isMoon() || this.isStation() || this.isStar())) {
            this.star.addPlanet(this);
        }
    }

    public void setStar(ResourceLocation id) {
        this.starId = id;
        if (DimensionManager.getInstance().getStar(id) != null) {
            this.setStar(DimensionManager.getInstance().getStar(id));
        }
    }

    @Override
    public StellarBody getStar() {
        if (this.isStar()) {
            return this.getStarData();
        }
        if (this.star == null) {
            this.star = DimensionManager.getInstance().getStar(this.starId);
        }
        return this.star;
    }

    public boolean hasSurface() {
        return !this.isGasGiant() && !this.isStar();
    }

    @Override
    public boolean isGasGiant() {
        return this.isGasGiant;
    }

    public boolean isStar() {
        return "star".equals(this.planetId.func_110624_b());
    }

    public StellarBody getStarData() {
        return DimensionManager.getInstance().getStar(this.planetId);
    }

    public void setGasGiant(boolean gas) {
        this.isGasGiant = gas;
    }

    @Override
    public boolean hasRings() {
        return this.hasRings;
    }

    public void setHasRings(boolean value) {
        this.hasRings = value;
    }

    public void addBeaconLocation(World world, HashedBlockPosition pos) {
        this.beaconLocations.add(pos);
        DimensionManager.getInstance().knownPlanets.add(this.getId());
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
        }
    }

    public HashSet<HashedBlockPosition> getBeacons() {
        return this.beaconLocations;
    }

    public void removeBeaconLocation(World world, HashedBlockPosition pos) {
        this.beaconLocations.remove(pos);
        if (this.beaconLocations.isEmpty() && !ARConfiguration.getCurrentConfig().initiallyKnownPlanets.contains(this.getId())) {
            DimensionManager.getInstance().knownPlanets.remove(this.getId());
        }
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
        }
    }

    @Override
    public ResourceLocation getPlanetIcon() {
        if (!this.customIcon.isEmpty()) {
            try {
                String resource_location = "advancedrocketry:textures/planets/" + this.customIcon.toLowerCase() + ".png";
                if (TextureResources.planetResources.containsKey(resource_location)) {
                    return TextureResources.planetResources.get(resource_location);
                }
                ResourceLocation new_resource = new ResourceLocation(resource_location);
                TextureResources.planetResources.put(resource_location, new_resource);
                return new_resource;
            }
            catch (IllegalArgumentException e) {
                return PlanetIcons.UNKNOWN.resource;
            }
        }
        AtmosphereTypes atmType = AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity);
        Temps tempType = Temps.getTempFromValue(this.getAverageTemp());
        if (this.isStar() && this.getStarData().isBlackHole()) {
            return TextureResources.locationBlackHole_icon;
        }
        if (this.isGasGiant()) {
            return PlanetIcons.GASGIANTBLUE.resource;
        }
        if (this.isAsteroid()) {
            return PlanetIcons.ASTEROID.resource;
        }
        if (tempType == Temps.TOOHOT) {
            return PlanetIcons.MARSLIKE.resource;
        }
        if (atmType != AtmosphereTypes.NONE && VulpineMath.isBetween((int)tempType.ordinal(), (int)Temps.COLD.ordinal(), (int)Temps.TOOHOT.ordinal())) {
            return PlanetIcons.EARTHLIKE.resource;
        }
        if (tempType.compareTo(Temps.COLD) > 0) {
            if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
                return PlanetIcons.MOON.resource;
            }
            return PlanetIcons.ICEWORLD.resource;
        }
        if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
            if (tempType.compareTo(Temps.COLD) < 0) {
                return PlanetIcons.MARSLIKE.resource;
            }
            return PlanetIcons.MOON.resource;
        }
        return PlanetIcons.LAVA.resource;
    }

    @Override
    public ResourceLocation getPlanetIconLEO() {
        if (!this.customIcon.isEmpty()) {
            try {
                String resource_location = "advancedrocketry:textures/planets/" + this.customIcon.toLowerCase() + "leo.jpg";
                if (TextureResources.planetResources.containsKey(resource_location)) {
                    return TextureResources.planetResources.get(resource_location);
                }
                ResourceLocation new_resource = new ResourceLocation(resource_location);
                TextureResources.planetResources.put(resource_location, new_resource);
                return new_resource;
            }
            catch (IllegalArgumentException e) {
                return PlanetIcons.UNKNOWN.resource;
            }
        }
        AtmosphereTypes atmType = AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity);
        Temps tempType = Temps.getTempFromValue(this.getAverageTemp());
        if (this.isGasGiant()) {
            return PlanetIcons.GASGIANTBLUE.resourceLEO;
        }
        if (tempType == Temps.TOOHOT) {
            return PlanetIcons.MARSLIKE.resourceLEO;
        }
        if (atmType != AtmosphereTypes.NONE && VulpineMath.isBetween((int)tempType.ordinal(), (int)Temps.COLD.ordinal(), (int)Temps.TOOHOT.ordinal())) {
            return PlanetIcons.EARTHLIKE.resourceLEO;
        }
        if (tempType.compareTo(Temps.COLD) > 0) {
            if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
                return PlanetIcons.MOON.resourceLEO;
            }
            return PlanetIcons.ICEWORLD.resourceLEO;
        }
        if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
            if (tempType.compareTo(Temps.COLD) < 0) {
                return PlanetIcons.MARSLIKE.resourceLEO;
            }
            return PlanetIcons.MOON.resourceLEO;
        }
        return PlanetIcons.LAVA.resourceLEO;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ResourceLocation getId() {
        return this.planetId;
    }

    @Override
    public ResourceLocation getParentPlanet() {
        return this.parentPlanet;
    }

    @Override
    public DimensionProperties getParentProperties() {
        if (!Constants.INVALID_PLANET.equals((Object)this.parentPlanet)) {
            return DimensionManager.getInstance().getDimensionProperties(this.parentPlanet);
        }
        return null;
    }

    @Override
    public int getParentOrbitalDistance() {
        return this.orbitalDist;
    }

    @Override
    public int getSolarOrbitalDistance() {
        if (!Constants.INVALID_PLANET.equals((Object)this.parentPlanet)) {
            return this.getParentProperties().getSolarOrbitalDistance();
        }
        return this.orbitalDist;
    }

    public double getSolarTheta() {
        if (!Constants.INVALID_PLANET.equals((Object)this.parentPlanet)) {
            return this.getParentProperties().getSolarTheta();
        }
        return this.orbitTheta;
    }

    public void setParentPlanet(DimensionProperties parent) {
        this.setParentPlanet(parent, true);
    }

    public void setParentPlanet(DimensionProperties parent, boolean update) {
        if (update) {
            if (!Constants.INVALID_PLANET.equals((Object)this.parentPlanet)) {
                this.getParentProperties().childPlanets.remove(this.getId());
            }
            if (parent == null) {
                this.parentPlanet = Constants.INVALID_PLANET;
            } else {
                this.parentPlanet = parent.getId();
                this.star = parent.getStar();
                if (!Constants.INVALID_PLANET.equals((Object)parent.getId())) {
                    parent.childPlanets.add(this.getId());
                }
            }
        } else if (parent == null) {
            this.parentPlanet = Constants.INVALID_PLANET;
        } else {
            this.star = parent.getStar();
            this.starId = this.star == null ? Constants.INVALID_STAR : this.star.getId();
            this.parentPlanet = parent.getId();
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.childPlanets.isEmpty();
    }

    @Override
    public boolean isMoon() {
        return !Constants.INVALID_PLANET.equals((Object)this.parentPlanet) && !SpaceObjectManager.WARPDIMID.equals((Object)this.parentPlanet);
    }

    @Override
    public boolean isTerraformed() {
        return this.isTerraformed;
    }

    @Override
    public int getAtmosphereDensity() {
        return this.atmosphereDensity;
    }

    @Override
    public void setAtmosphereDensity(int atmosphereDensity) {
        int prevAtm = this.atmosphereDensity;
        this.atmosphereDensity = atmosphereDensity;
        if (AtmosphereTypes.getAtmosphereTypeFromValue(prevAtm) != AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity)) {
            // empty if block
        }
        PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
    }

    public void setAtmosphereDensityDirect(int atmosphereDensity) {
        this.originalAtmosphereDensity = this.atmosphereDensity = atmosphereDensity;
    }

    public boolean isStation() {
        return this.isStation;
    }

    @Override
    public IAtmosphere getAtmosphere() {
        if (this.hasAtmosphere() && this.hasOxygen) {
            if (this.averageTemperature >= 900) {
                return AtmosphereType.SUPERHEATED;
            }
            if (Temps.getTempFromValue(this.getAverageTemp()) == Temps.TOOHOT) {
                return AtmosphereType.VERYHOT;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.SUPERHIGHPRESSURE) {
                return AtmosphereType.SUPERHIGHPRESSURE;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.HIGHPRESSURE) {
                return AtmosphereType.HIGHPRESSURE;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.LOW) {
                return AtmosphereType.LOWOXYGEN;
            }
            return AtmosphereType.AIR;
        }
        if (this.hasAtmosphere() && !this.hasOxygen) {
            if (this.averageTemperature >= 900) {
                return AtmosphereType.SUPERHEATEDNOO2;
            }
            if (Temps.getTempFromValue(this.averageTemperature) == Temps.TOOHOT) {
                return AtmosphereType.VERYHOTNOO2;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.SUPERHIGHPRESSURE) {
                return AtmosphereType.SUPERHIGHPRESSURENOO2;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.HIGHPRESSURE) {
                return AtmosphereType.HIGHPRESSURENOO2;
            }
            return AtmosphereType.NOO2;
        }
        return AtmosphereType.VACUUM;
    }

    public static ResourceLocation getAtmosphereResource() {
        return atmosphere;
    }

    public static ResourceLocation getShadowResource() {
        return shadow;
    }

    public static ResourceLocation getAtmosphereLEOResource() {
        return atmosphereLEO;
    }

    @Override
    public boolean hasAtmosphere() {
        return AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity).compareTo(AtmosphereTypes.NONE) < 0;
    }

    @Override
    public double getPeakInsolationMultiplier() {
        return this.peakInsolationMultiplier;
    }

    @Override
    public double getPeakInsolationMultiplierWithoutAtmosphere() {
        return this.peakInsolationMultiplierWithoutAtmosphere;
    }

    public boolean isAsteroid() {
        return this.generatorType == 2;
    }

    public boolean hasDecorators() {
        return !this.isAsteroid() && !this.isStar() || this.canDecorate && this.overrideDecoration;
    }

    public void setDecoratoration(boolean value) {
        this.canDecorate = value;
        this.overrideDecoration = true;
    }

    public boolean isDecorationOverridden() {
        return this.overrideDecoration;
    }

    public void unsetDecoratoration() {
        this.overrideDecoration = false;
    }

    @Override
    public Set<ResourceLocation> getChildPlanets() {
        return this.childPlanets;
    }

    @Override
    public int getPathLengthToStar() {
        if (this.isMoon()) {
            return 1 + this.getParentProperties().getPathLengthToStar();
        }
        return 1;
    }

    public boolean addChildPlanet(DimensionProperties child) {
        if (child == this) {
            return false;
        }
        this.childPlanets.add(child.getId());
        child.setParentPlanet(this);
        return true;
    }

    public void removeChild(ResourceLocation id) {
        this.childPlanets.remove(id);
    }

    @Override
    public void addSatellite(SatelliteBase satellite, World world) {
        if (this.satellites.containsKey(satellite.getId())) {
            this.satellites.remove(satellite.getId());
            this.tickingSatellites.remove(satellite.getId());
        }
        this.satellites.put(satellite.getId(), satellite);
        satellite.setDimensionId(world);
        if (satellite.canTick()) {
            this.tickingSatellites.put(satellite.getId(), satellite);
        }
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(satellite));
        }
    }

    public void addSatellite(SatelliteBase satellite, ResourceLocation world, boolean isRemote) {
        if (this.satellites.containsKey(satellite.getId())) {
            this.satellites.remove(satellite.getId());
            this.tickingSatellites.remove(satellite.getId());
        }
        this.satellites.put(satellite.getId(), satellite);
        satellite.setDimensionId(world);
        if (satellite.canTick()) {
            this.tickingSatellites.put(satellite.getId(), satellite);
        }
        if (!isRemote) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(satellite));
        }
    }

    @Override
    public void addSatellite(SatelliteBase satellite) {
        if (this.satellites.containsKey(satellite.getId())) {
            this.satellites.remove(satellite.getId());
            this.tickingSatellites.remove(satellite.getId());
        }
        this.satellites.put(satellite.getId(), satellite);
        if (satellite.canTick()) {
            this.tickingSatellites.put(satellite.getId(), satellite);
        }
    }

    @Override
    public SatelliteBase removeSatellite(long satelliteId) {
        SatelliteBase satellite = this.satellites.remove(satelliteId);
        if (satellite != null && satellite.canTick() && this.tickingSatellites.containsKey(satelliteId)) {
            this.tickingSatellites.get(satelliteId).remove();
        }
        return satellite;
    }

    @Override
    public SatelliteBase getSatellite(long id) {
        return this.satellites.get(id);
    }

    @Override
    public Collection<SatelliteBase> getAllSatellites() {
        return this.satellites.values();
    }

    public void tick() {
        Iterator<SatelliteBase> iterator = this.tickingSatellites.values().iterator();
        while (iterator.hasNext()) {
            SatelliteBase satellite = iterator.next();
            satellite.tickEntity();
            if (!satellite.isDead()) continue;
            iterator.remove();
            this.satellites.remove(satellite.getId());
        }
        this.updateOrbit();
    }

    public void updateOrbit() {
        try {
            this.prevOrbitalTheta = this.orbitTheta;
            if (this.isMoon()) {
                this.orbitTheta = (AstronomicalBodyHelper.getMoonOrbitalTheta(this.orbitalDist, this.getParentProperties().gravitationalMultiplier) + this.baseOrbitTheta) * (double)(this.isRetrograde ? -1 : 1);
            } else if (!this.isMoon()) {
                this.orbitTheta = (AstronomicalBodyHelper.getOrbitalTheta(this.orbitalDist, this.getStar().getSize()) + this.baseOrbitTheta) * (double)(this.isRetrograde ? -1 : 1);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean hasRivers() {
        return AtmosphereTypes.getAtmosphereTypeFromValue(this.originalAtmosphereDensity).compareTo(AtmosphereTypes.LOW) <= 0 && Temps.getTempFromValue(this.getAverageTemp()).isInRange(Temps.COLD, Temps.HOT);
    }

    public List<Biome> getBiomes() {
        return this.allowedBiomes;
    }

    public List<Biome> getTerraformedBiomes() {
        return this.terraformedBiomes;
    }

    public boolean isBiomeblackListed(Biome biome) {
        return AdvancedRocketryBiomes.instance.getBlackListedBiomes().contains(AdvancedRocketryBiomes.getBiomeResource(biome));
    }

    public List<Biome> getViableBiomes() {
        Temps biomeTemp;
        Iterator<Biome> itr;
        Biome biome;
        Random random = new Random(System.nanoTime());
        ArrayList<Biome> viableBiomes = new ArrayList<Biome>();
        if (this.atmosphereDensity > AtmosphereTypes.LOW.value && random.nextInt(3) == 0) {
            LinkedList<Biome> list = new LinkedList<Biome>(AdvancedRocketryBiomes.instance.getSingleBiome());
            while (list.size() > 1) {
                biome = (Biome)list.get(random.nextInt(list.size()));
                Temps temp = Temps.getTempFromValue(this.averageTemperature);
                Temps biomeTemp2 = AdvancedRocketryBiomes.getBiomeTemp(biome);
                if (biomeTemp2 == Temps.COLD && temp.isInRange(Temps.FRIGID, Temps.NORMAL) || (biomeTemp2 == Temps.NORMAL || biome.func_201856_r() == Biome.Category.OCEAN) && temp.isInRange(Temps.COLD, Temps.HOT) || biomeTemp2 == Temps.HOT && temp.isInRange(Temps.NORMAL, Temps.HOT)) {
                    viableBiomes.add(biome);
                    return viableBiomes;
                }
                list.remove(biome);
            }
        }
        if (this.atmosphereDensity <= AtmosphereTypes.LOW.value) {
            viableBiomes.add(AdvancedRocketryBiomes.moonBiome);
            viableBiomes.add(AdvancedRocketryBiomes.moonBiomeDark);
        } else if (this.averageTemperature > Temps.TOOHOT.getTemp()) {
            viableBiomes.add(AdvancedRocketryBiomes.hotDryBiome);
            viableBiomes.add(AdvancedRocketryBiomes.volcanic);
            viableBiomes.add(AdvancedRocketryBiomes.volcanicBarren);
        } else if (this.averageTemperature > Temps.HOT.getTemp()) {
            itr = AdvancedRocketryBiomes.getAllBiomes();
            while (itr.hasNext()) {
                biome = itr.next();
                biomeTemp = AdvancedRocketryBiomes.getBiomeTemp(biome);
                if (biome == null || biomeTemp != Temps.HOT && biome.func_201856_r() != Biome.Category.OCEAN || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        } else if (this.averageTemperature > Temps.NORMAL.getTemp()) {
            itr = AdvancedRocketryBiomes.getAllBiomes();
            while (itr.hasNext()) {
                biome = itr.next();
                biomeTemp = AdvancedRocketryBiomes.getBiomeTemp(biome);
                if ((biome == null || !biomeTemp.isInRange(Temps.COLD, Temps.HOT) || this.isBiomeblackListed(biome)) && biome.func_201856_r() != Biome.Category.OCEAN) continue;
                viableBiomes.add(biome);
            }
        } else if (this.averageTemperature > Temps.COLD.getTemp()) {
            itr = AdvancedRocketryBiomes.getAllBiomes();
            while (itr.hasNext()) {
                biome = itr.next();
                biomeTemp = AdvancedRocketryBiomes.getBiomeTemp(biome);
                if ((biome == null || !biomeTemp.isInRange(Temps.FRIGID, Temps.NORMAL) || this.isBiomeblackListed(biome)) && biome.func_201856_r() != Biome.Category.OCEAN) continue;
                viableBiomes.add(biome);
            }
        } else if (this.averageTemperature > Temps.FRIGID.getTemp()) {
            itr = AdvancedRocketryBiomes.getAllBiomes();
            while (itr.hasNext()) {
                biome = itr.next();
                biomeTemp = AdvancedRocketryBiomes.getBiomeTemp(biome);
                if (biome == null || !biomeTemp.isInRange(Temps.SNOWBALL, Temps.COLD) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        } else {
            itr = AdvancedRocketryBiomes.getAllBiomes();
            while (itr.hasNext()) {
                biome = itr.next();
                biomeTemp = AdvancedRocketryBiomes.getBiomeTemp(biome);
                if (biome == null || !biomeTemp.isInRange(Temps.SNOWBALL, Temps.FRIGID) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        }
        if (viableBiomes.size() > 5) {
            viableBiomes = ZUtils.copyRandomElements(viableBiomes, (int)5);
        }
        if (this.atmosphereDensity > AtmosphereTypes.HIGHPRESSURE.value && Temps.getTempFromValue(this.averageTemperature).isInRange(Temps.NORMAL, Temps.HOT)) {
            viableBiomes.addAll(AdvancedRocketryBiomes.instance.getHighPressureBiomes());
        }
        return viableBiomes;
    }

    public boolean addBiome(Biome biome) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        biomes.add(biome);
        this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
        return true;
    }

    public boolean addBiome(ResourceLocation biomeId) {
        if (AdvancedRocketryBiomes.doesBiomeExist(biomeId)) {
            Biome biome = AdvancedRocketryBiomes.getBiomeFromResourceLocation(biomeId);
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            biomes.add(biome);
            this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
            return true;
        }
        return false;
    }

    public void addBiomes(List<Biome> biomes) {
        this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public void setBiomes(List<Biome> biomes) {
        this.allowedBiomes.clear();
        this.addBiomes(biomes);
    }

    public void setBiomeEntries(List<Biome> biomes) {
        if (biomes != this.allowedBiomes) {
            this.allowedBiomes.clear();
            this.allowedBiomes.addAll(biomes);
        }
    }

    public void setTerraformedBiomes(List<Biome> biomes) {
        this.terraformedBiomes.clear();
        this.terraformedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    private List<Biome> getBiomesEntries(List<Biome> biomeIds) {
        return biomeIds;
    }

    public void initDefaultAttributes() {
        if (Temps.getTempFromValue(this.averageTemperature).hotterThan(Temps.HOT)) {
            this.setOceanBlock(Blocks.field_150353_l.func_176223_P());
        }
        this.setGenerateCraters(AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()).lessDenseThan(AtmosphereTypes.NORMAL));
        this.setGenerateVolcanos(Temps.getTempFromValue(this.averageTemperature).hotterThan(Temps.HOT));
        this.setGenerateStructures(this.isHabitable());
        this.setGenerateGeodes(this.getAtmosphereDensity() > 125);
    }

    private void readFromTechnicalNBT(CompoundNBT nbt) {
        this.isTerraformed = nbt.func_74767_n("terraformed");
        if (nbt.func_74764_b("beaconLocations")) {
            ListNBT list = nbt.func_150295_c("beaconLocations", 11);
            for (int i = 0; i < list.size(); ++i) {
                int[] location = list.func_150306_c(i);
                this.beaconLocations.add(new HashedBlockPosition(location[0], location[1], location[2]));
            }
            DimensionManager.getInstance().knownPlanets.add(this.getId());
        } else {
            this.beaconLocations.clear();
        }
        if (nbt.func_74764_b("biomesTerra")) {
            this.terraformedBiomes.clear();
            ListNBT terraformedList = nbt.func_150295_c("biomesTerra", 8);
            ArrayList<Biome> biomesList = new ArrayList<Biome>();
            for (int i = 0; i < terraformedList.size(); ++i) {
                biomesList.add(AdvancedRocketryBiomes.getBiomeFromResourceLocation(new ResourceLocation(terraformedList.func_150307_f(i))));
            }
            this.terraformedBiomes.addAll(this.getBiomesEntries(biomesList));
        }
        if (nbt.func_74764_b("satellites")) {
            CompoundNBT allSatelliteNbt = nbt.func_74775_l("satellites");
            for (Object keyObject : allSatelliteNbt.func_150296_c()) {
                String key = (String)keyObject;
                Long longKey = Long.parseLong(key);
                CompoundNBT satelliteNBT = allSatelliteNbt.func_74775_l(key);
                if (this.satellites.containsKey(longKey)) {
                    this.satellites.get(longKey).readFromNBT(satelliteNBT);
                    continue;
                }
                try {
                    SatelliteBase satellite = SatelliteRegistry.createFromNBT(satelliteNBT);
                    this.satellites.put(longKey, satellite);
                    if (!satellite.canTick()) continue;
                    this.tickingSatellites.put(satellite.getId(), satellite);
                }
                catch (NullPointerException e) {
                    AdvancedRocketry.logger.warn("Satellite with bad NBT detected, Removing");
                }
            }
        }
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        int f;
        ListNBT list;
        if (nbt.func_74764_b("skyColor")) {
            list = nbt.func_150295_c("skyColor", 5);
            this.skyColor = new float[list.size()];
            for (f = 0; f < list.size(); ++f) {
                this.skyColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("ringColor")) {
            list = nbt.func_150295_c("ringColor", 5);
            this.ringColor = new float[list.size()];
            for (f = 0; f < list.size(); ++f) {
                this.ringColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("sunriseSunsetColors")) {
            list = nbt.func_150295_c("sunriseSunsetColors", 5);
            this.sunriseSunsetColors = new float[list.size()];
            for (f = 0; f < list.size(); ++f) {
                this.sunriseSunsetColors[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("fogColor")) {
            list = nbt.func_150295_c("fogColor", 5);
            this.fogColor = new float[list.size()];
            for (f = 0; f < list.size(); ++f) {
                this.fogColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("biomes")) {
            this.allowedBiomes.clear();
            ListNBT biomeIds = nbt.func_150295_c("biomes", 8);
            ArrayList<Biome> biomesList = new ArrayList<Biome>();
            for (int i = 0; i < biomeIds.size(); ++i) {
                biomesList.add(AdvancedRocketryBiomes.getBiomeFromResourceLocation(new ResourceLocation(biomeIds.func_150307_f(i))));
            }
            this.allowedBiomes.addAll(this.getBiomesEntries(biomesList));
        }
        if (nbt.func_74764_b("laserDrillOres")) {
            this.laserDrillOres.clear();
            list = nbt.func_150295_c("laserDrillOres", 10);
            for (INBT entry : list) {
                assert (entry instanceof CompoundNBT);
                this.laserDrillOres.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)entry)));
            }
        }
        if (nbt.func_74764_b("laserDrillOresRaw")) {
            this.laserDrillOresRaw = nbt.func_74779_i("laserDrillOresRaw");
        }
        if (nbt.func_74764_b("geodeOres")) {
            this.geodeOres.clear();
            list = nbt.func_150295_c("geodeOres", 8);
            for (INBT entry : list) {
                assert (entry instanceof StringNBT);
                this.geodeOres.add(((StringNBT)entry).func_150285_a_());
            }
        }
        if (nbt.func_74764_b("craterOres")) {
            this.craterOres.clear();
            list = nbt.func_150295_c("craterOres", 8);
            for (INBT entry : list) {
                assert (entry instanceof StringNBT);
                this.craterOres.add(((StringNBT)entry).func_150285_a_());
            }
        }
        this.gravitationalMultiplier = nbt.func_74760_g("gravitationalMultiplier");
        this.orbitalDist = nbt.func_74762_e("orbitalDist");
        this.orbitTheta = nbt.func_74769_h("orbitTheta");
        this.baseOrbitTheta = nbt.func_74769_h("baseOrbitTheta");
        this.orbitalPhi = nbt.func_74769_h("orbitPhi");
        this.rotationalPhi = nbt.func_74769_h("rotationalPhi");
        this.isRetrograde = nbt.func_74767_n("isRetrograde");
        this.hasOxygen = nbt.func_74767_n("hasOxygen");
        this.atmosphereDensity = nbt.func_74762_e("atmosphereDensity");
        this.originalAtmosphereDensity = nbt.func_74764_b("originalAtmosphereDensity") ? nbt.func_74762_e("originalAtmosphereDensity") : this.atmosphereDensity;
        this.peakInsolationMultiplier = nbt.func_74769_h("peakInsolationMultiplier");
        this.peakInsolationMultiplierWithoutAtmosphere = nbt.func_74769_h("peakInsolationMultiplierWithoutAtmosphere");
        this.averageTemperature = nbt.func_74762_e("avgTemperature");
        this.rotationalPeriod = nbt.func_74762_e("rotationalPeriod");
        this.name = nbt.func_74779_i("name");
        this.isNativeDimension = nbt.func_74764_b("isNative") ? nbt.func_74767_n("isNative") : true;
        this.isGasGiant = nbt.func_74767_n("isGasGiant");
        this.hasRings = nbt.func_74767_n("hasRings");
        this.sealevel = nbt.func_74762_e("sealevel");
        this.generatorType = nbt.func_74762_e("genType");
        this.canGenerateCraters = nbt.func_74767_n("canGenerateCraters");
        this.canGenerateGeodes = nbt.func_74767_n("canGenerateGeodes");
        this.canGenerateStructures = nbt.func_74767_n("canGenerateStructures");
        this.canGenerateVolcanos = nbt.func_74767_n("canGenerateVolcanos");
        this.geodeFrequencyMultiplier = nbt.func_74760_g("geodeFrequencyMultiplier");
        this.craterFrequencyMultiplier = nbt.func_74760_g("craterFrequencyMultiplier");
        this.volcanoFrequencyMultiplier = nbt.func_74760_g("volcanoFrequencyMultiplier");
        if (nbt.func_74764_b("childrenPlanets")) {
            ListNBT childList = nbt.func_150295_c("childrenPlanets", 8);
            for (int i = 0; i < childList.size(); ++i) {
                this.childPlanets.add(new ResourceLocation(childList.func_150307_f(i)));
            }
        }
        if (nbt.func_74764_b("parentPlanet")) {
            this.parentPlanet = new ResourceLocation(nbt.func_74779_i("parentPlanet"));
        }
        this.starId = new ResourceLocation(nbt.func_74779_i("starId"));
        this.setStar(DimensionManager.getInstance().getStar(new ResourceLocation(nbt.func_74779_i("starId"))));
        if (this.isGasGiant) {
            ListNBT fluidList = nbt.func_150295_c("fluids", 8);
            this.getHarvestableGasses().clear();
            for (int i = 0; i < fluidList.size(); ++i) {
                Fluid f2 = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidList.func_150307_f(i)));
                if (f2 == null) continue;
                this.getHarvestableGasses().add(f2);
            }
            if (this.getHarvestableGasses().isEmpty()) {
                this.getHarvestableGasses().addAll(AtmosphereRegister.getInstance().getHarvestableGasses());
            }
        }
        if (nbt.func_74764_b("oceanBlock")) {
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(nbt.func_74779_i("oceanBlock")))) {
                this.oceanBlock = null;
            } else {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("oceanBlock")));
                int meta = nbt.func_74762_e("oceanBlockMeta");
                this.oceanBlock = block.func_176223_P();
            }
        } else {
            this.oceanBlock = null;
        }
        if (nbt.func_74764_b("fillBlock")) {
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(nbt.func_74779_i("fillBlock")))) {
                this.fillerBlock = null;
            } else {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("fillBlock")));
                int meta = nbt.func_74762_e("fillBlockMeta");
                this.fillerBlock = block.func_176223_P();
            }
        } else {
            this.fillerBlock = null;
        }
        this.readFromTechnicalNBT(nbt);
    }

    private void writeTechnicalNBT(CompoundNBT nbt) {
        nbt.func_74757_a("terraformed", this.isTerraformed);
        if (!this.beaconLocations.isEmpty()) {
            ListNBT list = new ListNBT();
            for (HashedBlockPosition pos : this.beaconLocations) {
                list.add((Object)new IntArrayNBT(new int[]{pos.x, pos.y, pos.z}));
            }
            nbt.func_218657_a("beaconLocations", (INBT)list);
        }
        if (!this.terraformedBiomes.isEmpty()) {
            ListNBT terraformedBiomeList = new ListNBT();
            for (int i = 0; i < this.terraformedBiomes.size(); ++i) {
                terraformedBiomeList.add((Object)StringNBT.func_229705_a_((String)AdvancedRocketryBiomes.getBiomeResource(this.terraformedBiomes.get(i)).toString()));
            }
            nbt.func_218657_a("biomesTerra", (INBT)terraformedBiomeList);
        }
        if (!this.satellites.isEmpty()) {
            CompoundNBT allSatalliteNbt = new CompoundNBT();
            for (Map.Entry<Long, SatelliteBase> entry : this.satellites.entrySet()) {
                CompoundNBT satalliteNbt = new CompoundNBT();
                entry.getValue().writeToNBT(satalliteNbt);
                allSatalliteNbt.func_218657_a(entry.getKey().toString(), (INBT)satalliteNbt);
            }
            nbt.func_218657_a("satellites", (INBT)allSatalliteNbt);
        }
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        ListNBT list;
        if (this.skyColor != null) {
            list = new ListNBT();
            for (float f : this.skyColor) {
                list.add((Object)FloatNBT.func_229689_a_((float)f));
            }
            nbt.func_218657_a("skyColor", (INBT)list);
        }
        if (this.sunriseSunsetColors != null) {
            list = new ListNBT();
            for (float f : this.sunriseSunsetColors) {
                list.add((Object)FloatNBT.func_229689_a_((float)f));
            }
            nbt.func_218657_a("sunriseSunsetColors", (INBT)list);
        }
        list = new ListNBT();
        for (float f : this.fogColor) {
            list.add((Object)FloatNBT.func_229689_a_((float)f));
        }
        nbt.func_218657_a("fogColor", (INBT)list);
        if (this.hasRings) {
            list = new ListNBT();
            for (float f : this.ringColor) {
                list.add((Object)FloatNBT.func_229689_a_((float)f));
            }
            nbt.func_218657_a("ringColor", (INBT)list);
        }
        if (!this.allowedBiomes.isEmpty()) {
            ListNBT biomeList = new ListNBT();
            for (int i = 0; i < this.allowedBiomes.size(); ++i) {
                biomeList.add((Object)StringNBT.func_229705_a_((String)AdvancedRocketryBiomes.getBiomeResource(this.allowedBiomes.get(i)).toString()));
            }
            nbt.func_218657_a("biomes", (INBT)biomeList);
        }
        if (!this.laserDrillOres.isEmpty()) {
            list = new ListNBT();
            for (ItemStack ore : this.laserDrillOres) {
                CompoundNBT entry = new CompoundNBT();
                ore.func_77955_b(entry);
                list.add((Object)entry);
            }
            nbt.func_218657_a("laserDrillOres", (INBT)list);
        }
        if (this.laserDrillOresRaw != null) {
            nbt.func_218657_a("laserDrillOresRaw", (INBT)StringNBT.func_229705_a_((String)this.laserDrillOresRaw));
        }
        if (!this.geodeOres.isEmpty()) {
            list = new ListNBT();
            for (String ore : this.geodeOres) {
                list.add((Object)StringNBT.func_229705_a_((String)ore));
            }
            nbt.func_218657_a("geodeOres", (INBT)list);
        }
        if (!this.craterOres.isEmpty()) {
            list = new ListNBT();
            for (String ore : this.craterOres) {
                list.add((Object)StringNBT.func_229705_a_((String)ore));
            }
            nbt.func_218657_a("craterOres", (INBT)list);
        }
        nbt.func_74778_a("starId", this.starId.toString());
        nbt.func_74776_a("gravitationalMultiplier", this.gravitationalMultiplier);
        nbt.func_74768_a("orbitalDist", this.orbitalDist);
        nbt.func_74780_a("orbitTheta", this.orbitTheta);
        nbt.func_74780_a("baseOrbitTheta", this.baseOrbitTheta);
        nbt.func_74780_a("orbitPhi", this.orbitalPhi);
        nbt.func_74780_a("rotationalPhi", this.rotationalPhi);
        nbt.func_74757_a("hasOxygen", this.hasOxygen);
        nbt.func_74768_a("atmosphereDensity", this.atmosphereDensity);
        nbt.func_74768_a("originalAtmosphereDensity", this.originalAtmosphereDensity);
        nbt.func_74780_a("peakInsolationMultiplier", this.peakInsolationMultiplier);
        nbt.func_74780_a("peakInsolationMultiplierWithoutAtmosphere", this.peakInsolationMultiplierWithoutAtmosphere);
        nbt.func_74768_a("avgTemperature", this.averageTemperature);
        nbt.func_74768_a("rotationalPeriod", this.rotationalPeriod);
        nbt.func_74778_a("name", this.name);
        nbt.func_74757_a("isNative", this.isNativeDimension);
        nbt.func_74757_a("isGasGiant", this.isGasGiant);
        nbt.func_74757_a("hasRings", this.hasRings);
        nbt.func_74768_a("sealevel", this.sealevel);
        nbt.func_74768_a("genType", this.generatorType);
        nbt.func_74757_a("canGenerateCraters", this.canGenerateCraters);
        nbt.func_74757_a("canGenerateGeodes", this.canGenerateGeodes);
        nbt.func_74757_a("canGenerateStructures", this.canGenerateStructures);
        nbt.func_74757_a("canGenerateVolcanos", this.canGenerateVolcanos);
        nbt.func_74776_a("geodeFrequencyMultiplier", this.geodeFrequencyMultiplier);
        nbt.func_74776_a("craterFrequencyMultiplier", this.craterFrequencyMultiplier);
        nbt.func_74776_a("volcanoFrequencyMultiplier", this.volcanoFrequencyMultiplier);
        if (!this.childPlanets.isEmpty()) {
            ListNBT childList = new ListNBT();
            for (ResourceLocation childPlanet : this.childPlanets) {
                childList.add((Object)StringNBT.func_229705_a_((String)childPlanet.toString()));
            }
            nbt.func_218657_a("childrenPlanets", (INBT)childList);
        }
        if (this.parentPlanet != null) {
            nbt.func_74778_a("parentPlanet", this.parentPlanet.toString());
        }
        if (this.isGasGiant) {
            ListNBT fluidList = new ListNBT();
            for (Fluid f : this.getHarvestableGasses()) {
                fluidList.add((Object)StringNBT.func_229705_a_((String)f.getRegistryName().toString()));
            }
            nbt.func_218657_a("fluids", (INBT)fluidList);
        }
        if (this.oceanBlock != null) {
            nbt.func_74778_a("oceanBlock", this.oceanBlock.func_177230_c().getRegistryName().toString());
            nbt.func_74768_a("oceanBlockMeta", Block.func_196246_j((BlockState)this.oceanBlock));
        }
        if (this.fillerBlock != null) {
            nbt.func_74778_a("fillBlock", this.fillerBlock.func_177230_c().getRegistryName().toString());
            nbt.func_74768_a("fillBlockMeta", Block.func_196246_j((BlockState)this.fillerBlock));
        }
        this.writeTechnicalNBT(nbt);
    }

    public String generateDimJSON() {
        long seed = 0L;
        LinkedList<String> structures = new LinkedList<String>();
        LinkedList<String> biomeConditionalStructures = new LinkedList<String>();
        LinkedList<String> biomeStrings = new LinkedList<String>();
        Random random = new Random("Yes, I know that temp, altidude and humidity are not the same as the noise generator, but im coming in anywayyy".hashCode());
        if (!this.isAsteroid()) {
            if (this.canGenerateCraters()) {
                structures.add("\"advancedrocketry:crater\"");
                biomeConditionalStructures.add("\t          \"advancedrocketry:crater\": {\n\t            \"spacing\": " + String.valueOf(40.0f * this.getCraterMultiplier()) + ",\n\t            \"separation\": " + String.valueOf(20.0f * this.getCraterMultiplier()) + ",\n\t            \"salt\": 0\n\t          }");
            }
            if (this.canGenerateVolcanos()) {
                structures.add("\"advancedrocketry:volcano\"");
                biomeConditionalStructures.add("\t          \"advancedrocketry:volcano\": {\n\t            \"spacing\": " + String.valueOf(40.0f * this.getVolcanoMultiplier()) + ",\n\t            \"separation\": " + String.valueOf(20.0f * this.getVolcanoMultiplier()) + ",\n\t            \"salt\": 0\n\t          }");
            }
            if (this.canGenerateGeodes()) {
                structures.add("\"advancedrocketry:geode\"");
                biomeConditionalStructures.add("\t          \"advancedrocketry:geode\": {\n\t            \"spacing\": " + String.valueOf(40.0f * this.getGeodeMultiplier()) + ",\n\t            \"separation\": " + String.valueOf(20.0f * this.getGeodeMultiplier()) + ",\n\t            \"salt\": 0\n\t          }");
            }
            for (Biome biome : this.getBiomes()) {
                biomeStrings.add("\t    {\n              \"biome\": \"" + biome.getRegistryName().toString() + "\",\n              \"parameters\": {\n                \"altitude\": " + String.valueOf(random.nextFloat()) + ",\n\t\t\"humidity\": " + String.valueOf(biome.func_76727_i()) + ",\n                \"temperature\": " + String.valueOf(biome.func_242445_k()) + ",\t\t\t\t\n                \"weirdness\": " + String.valueOf(biome.func_185360_m()) + ",\n                \"offset\": 0\n              }\n            }");
            }
            return "{\n      \"generator\": {\n        \"type\": \"advancedrocketry:planetary_noise\",\n        \"seed\": " + String.valueOf(seed) + ",\n" + (structures.isEmpty() ? "        \"starts\": [],\n" : "        \"starts\": [" + String.join((CharSequence)", ", structures) + "],\n") + "        \"dimension_props\": \"" + this.getId().toString() + "\",\n        \"biome_source\": {\n\t\t\n\t\t\n\t\t\"altitude_noise\": {\"firstOctave\": -7,\"amplitudes\": [1.0,1.0]},\n\t\t\"humidity_noise\": {\"firstOctave\": -7,\"amplitudes\": [1.0,1.0]},\n\t\t\"temperature_noise\": {\"firstOctave\": -7,\"amplitudes\": [1.0,1.0]},\n\t\t\"weirdness_noise\": {\"firstOctave\": -7,\"amplitudes\": [1.0,1.0]},\n\t\t\n\t\t\n          \"type\": \"advancedrocketry:planetary\",\n          \"seed\": " + String.valueOf(seed) + ",\n          \"biomes\": [\n" + String.join((CharSequence)",\n", biomeStrings) + "\n          ]\n        },\n    \"settings\": {\n      \"name\": \"" + this.getId().toString() + "\",\n      \"bedrock_roof_position\": -10,\n      \"bedrock_floor_position\": 0,\n      \"sea_level\": " + String.valueOf(this.getSeaLevel()) + ",\n      \"disable_mob_generation\": " + (this.isHabitable() ? "true" : "false") + ",\n      \"default_block\": {\n        \"Name\": \"" + this.getStoneBlock().func_177230_c().getRegistryName().toString() + "\"\n      },\n      \"default_fluid\": {\n        \"Name\": \"" + this.getOceanBlock().func_177230_c().getRegistryName().toString() + "\",\n        \"Properties\": {\n          \"level\": \"0\"\n        }\n      },\n      \"noise\": {\n        \"density_factor\": 1,\n        \"density_offset\": -0.46875,\n        \"simplex_surface_noise\": true,\n        \"random_density_offset\": true,\n        \"island_noise_override\": false,\n        \"amplified\": false,\n        \"size_horizontal\": 1,\n        \"size_vertical\": 2,\n        \"height\": 256,\n        \"sampling\": {\n          \"xz_scale\": 1,\n          \"y_scale\": 1,\n          \"xz_factor\": 80,\n          \"y_factor\": 160\n        },\n        \"bottom_slide\": {\n          \"target\": -30,\n          \"size\": 0,\n          \"offset\": 0\n        },\n        \"top_slide\": {\n          \"target\": -10,\n          \"size\": 3,\n          \"offset\": 0\n        }\n      },\n      \"structures\": {\n        \"structures\": {\n" + String.join((CharSequence)",\n", biomeConditionalStructures) + "        }\n      }\n    }\n      },\n      \"type\": \"advancedrocketry:planet\"\n    }";
        }
        Biome biome = AdvancedRocketryBiomes.moonBiomeDark;
        biomeStrings.add("\t    {\n              \"biome\": \"" + biome.getRegistryName().toString() + "\",\n              \"parameters\": {\n                \"altitude\": " + String.valueOf(random.nextFloat()) + ",\n\t\t\"humidity\": " + String.valueOf(biome.func_76727_i()) + ",\n                \"temperature\": " + String.valueOf(biome.func_242445_k()) + ",\t\t\t\t\n                \"weirdness\": " + String.valueOf(biome.func_185360_m()) + ",\n                \"offset\": 0\n              }\n            }");
        return "{\n      \"generator\": {\n        \"type\": \"advancedrocketry:planetary_noise\",\n        \"seed\": " + String.valueOf(seed) + ",\n" + (structures.isEmpty() ? "        \"starts\": [],\n" : "        \"starts\": [" + String.join((CharSequence)", ", structures) + "],\n") + "        \"dimension_props\": \"" + this.getId().toString() + "\",\n        \"biome_source\": {\n\t\t\n\t\t\n\t\t\"altitude_noise\": {\"firstOctave\": -7,\"amplitudes\": [1.0,1.0]},\n\t\t\"humidity_noise\": {\"firstOctave\": -7,\"amplitudes\": [1.0,1.0]},\n\t\t\"temperature_noise\": {\"firstOctave\": -7,\"amplitudes\": [1.0,1.0]},\n\t\t\"weirdness_noise\": {\"firstOctave\": -7,\"amplitudes\": [1.0,1.0]},\n\t\t\n\t\t\n          \"type\": \"advancedrocketry:planetary\",\n          \"seed\": " + String.valueOf(seed) + ",\n          \"biomes\": [\n" + String.join((CharSequence)",\n", biomeStrings) + "\n          ]\n        },\n    \"settings\": {\n      \"name\": \"" + this.getId().toString() + "\",\n      \"bedrock_roof_position\": -10,\n      \"bedrock_floor_position\": -10,\n      \"sea_level\": " + String.valueOf(this.getSeaLevel()) + ",\n      \"disable_mob_generation\": " + (this.isHabitable() ? "true" : "false") + ",\n      \"default_block\": {\n        \"Name\": \"" + this.getStoneBlock().func_177230_c().getRegistryName().toString() + "\"\n      },\n      \"default_fluid\": {\n        \"Name\": \"" + this.getOceanBlock().func_177230_c().getRegistryName().toString() + "\",\n        \"Properties\": {\n          \"level\": \"0\"\n        }\n      },\n      \"noise\": {\n        \"density_factor\": 0,\n        \"density_offset\": -0.46875,\n        \"simplex_surface_noise\": true,\n        \"random_density_offset\": false,\n        \"island_noise_override\": true,\n        \"amplified\": false,\n        \"size_horizontal\": 2,\n        \"size_vertical\": 1,\n        \"height\": 256,\n        \"sampling\": {\n          \"xz_scale\": 2,\n          \"y_scale\": 1,\n          \"xz_factor\": 80,\n          \"y_factor\": 160\n        },\n        \"bottom_slide\": {\n          \"target\": -30,\n          \"size\": 7,\n          \"offset\": 1\n        },\n        \"top_slide\": {\n          \"target\": -3000,\n          \"size\": 64,\n          \"offset\": -46\n        }\n      },\n      \"structures\": {\n        \"structures\": {\n" + String.join((CharSequence)",\n", biomeConditionalStructures) + "        }\n      }\n    }\n      },\n      \"type\": \"advancedrocketry:planet\"\n    }";
    }

    @Override
    public int getAverageTemp() {
        if (this.getStar() == null) {
            return this.averageTemperature;
        }
        this.averageTemperature = AstronomicalBodyHelper.getAverageTemperature(this.getStar(), this.getSolarOrbitalDistance(), this.getAtmosphereDensity());
        return this.averageTemperature;
    }

    public BlockState getOceanBlock() {
        return this.oceanBlock == null ? Blocks.field_150355_j.func_176223_P() : this.oceanBlock;
    }

    public void setOceanBlock(BlockState block) {
        this.oceanBlock = block;
    }

    public BlockState getStoneBlock() {
        return this.fillerBlock == null ? Blocks.field_150348_b.func_176223_P() : this.fillerBlock;
    }

    public void setStoneBlock(BlockState block) {
        this.fillerBlock = block;
    }

    public static DimensionProperties createFromNBT(ResourceLocation id, CompoundNBT nbt) {
        DimensionProperties properties = new DimensionProperties(id);
        properties.readFromNBT(nbt);
        properties.planetId = id;
        return properties;
    }

    @Override
    public float getAtmosphereDensityAtHeight(double y) {
        return (float)this.atmosphereDensity * MathHelper.func_76131_a((float)((float)(1.0 + (256.0 - y) / 200.0)), (float)0.0f, (float)1.0f) / 100.0f;
    }

    public float[] getFogColorAtHeight(double y, Vector3d fogColor) {
        float atmDensity = this.getAtmosphereDensityAtHeight(y);
        return new float[]{(float)((double)atmDensity * fogColor.field_72450_a), (float)((double)atmDensity * fogColor.field_72448_b), (float)((double)atmDensity * fogColor.field_72449_c)};
    }

    public boolean isHabitable() {
        return this.getAtmosphere().isBreathable() && Temps.getTempFromValue(this.averageTemperature).isInRange(Temps.COLD, Temps.HOT);
    }

    public void setId(ResourceLocation id) {
        this.planetId = id;
    }

    @Override
    public void setParentOrbitalDistance(int distance) {
        this.orbitalDist = distance;
    }

    public double[] getPlanetPositon() {
        double orbitalDistance = this.orbitalDist;
        double theta = this.orbitTheta;
        double phi = this.orbitalPhi;
        double[] coords = new double[]{orbitalDistance * Math.cos(theta), orbitalDistance * Math.sin(phi), orbitalDistance * Math.sin(theta)};
        return coords;
    }

    @Override
    public ResourceLocation getStarId() {
        return this.starId;
    }

    public String toString() {
        return String.format("Dimension ID: %d.  Dimension Name: %s.  Parent Star %d ", this.getId(), this.getName(), this.getStarId());
    }

    @Override
    public double getOrbitTheta() {
        return this.orbitTheta;
    }

    @Override
    public int getOrbitalDist() {
        return this.orbitalDist;
    }

    public int getSeaLevel() {
        return this.sealevel;
    }

    public void setSeaLevel(int sealevel) {
        this.sealevel = MathHelper.func_76125_a((int)sealevel, (int)0, (int)255);
    }

    public void setGenType(int genType) {
        this.generatorType = genType;
    }

    public int getGenType() {
        return this.generatorType;
    }

    public void setGenerateCraters(boolean canGenerateCraters) {
        this.canGenerateCraters = canGenerateCraters;
    }

    public boolean canGenerateCraters() {
        return this.canGenerateCraters;
    }

    public float getCraterMultiplier() {
        return this.craterFrequencyMultiplier;
    }

    public void setCraterMultiplier(float craterFrequencyMultiplier) {
        this.craterFrequencyMultiplier = craterFrequencyMultiplier;
    }

    public void setGenerateGeodes(boolean canGenerateGeodes) {
        this.canGenerateGeodes = canGenerateGeodes;
    }

    public boolean canGenerateGeodes() {
        return this.canGenerateGeodes;
    }

    public float getGeodeMultiplier() {
        return this.volcanoFrequencyMultiplier;
    }

    public void setGeodeMultiplier(float geodeFrequencyMultiplier) {
        this.geodeFrequencyMultiplier = geodeFrequencyMultiplier;
    }

    public void setGenerateVolcanos(boolean canGenerateVolcanos) {
        this.canGenerateVolcanos = canGenerateVolcanos;
    }

    public boolean canGenerateVolcanos() {
        return this.canGenerateVolcanos;
    }

    public float getVolcanoMultiplier() {
        return this.volcanoFrequencyMultiplier;
    }

    public void setVolcanoMultiplier(float volcanoFrequencyMultiplier) {
        this.volcanoFrequencyMultiplier = volcanoFrequencyMultiplier;
    }

    public void setGenerateStructures(boolean canGenerateStructures) {
        this.canGenerateStructures = canGenerateStructures;
    }

    public boolean canGenerateStructures() {
        return this.canGenerateStructures;
    }

    @Override
    public float getRenderSizePlanetView() {
        return (this.isMoon() ? 8.0f : 10.0f) * Math.max(this.getGravitationalMultiplier() * this.getGravitationalMultiplier(), 0.5f) * 100.0f;
    }

    @Override
    public float getRenderSizeSolarView() {
        return (this.isMoon() ? 0.2f : 1.0f) * Math.max(this.getGravitationalMultiplier() * this.getGravitationalMultiplier(), 0.5f) * 100.0f;
    }

    @Override
    public SpacePosition getSpacePosition() {
        float distanceMultiplier = this.isMoon() ? 75.0f : 100.0f;
        SpacePosition spacePosition = new SpacePosition();
        spacePosition.star = this.getStar();
        spacePosition.world = this;
        spacePosition.isInInterplanetarySpace = this.isMoon();
        spacePosition.pitch = 0.0;
        spacePosition.roll = 0.0;
        spacePosition.yaw = 0.0;
        spacePosition = spacePosition.getFromSpherical(distanceMultiplier * (float)this.orbitalDist + (float)(this.isMoon() ? 100 : 0), this.orbitTheta);
        return spacePosition;
    }

    @Override
    public float[] getRingColor() {
        return this.ringColor;
    }

    @Override
    public float[] getSkyColor() {
        return this.skyColor;
    }

    public static enum PlanetIcons {
        EARTHLIKE(new ResourceLocation("advancedrocketry:textures/planets/earthlike.png")),
        LAVA(new ResourceLocation("advancedrocketry:textures/planets/lava.png")),
        MARSLIKE(new ResourceLocation("advancedrocketry:textures/planets/marslike.png")),
        MOON(new ResourceLocation("advancedrocketry:textures/planets/moon.png")),
        WATERWORLD(new ResourceLocation("advancedrocketry:textures/planets/waterworld.png")),
        ICEWORLD(new ResourceLocation("advancedrocketry:textures/planets/iceworld.png")),
        DESERT(new ResourceLocation("advancedrocketry:textures/planets/desertworld.png")),
        CARBON(new ResourceLocation("advancedrocketry:textures/planets/carbonworld.png")),
        VENUSIAN(new ResourceLocation("advancedrocketry:textures/planets/venusian.png")),
        GASGIANTBLUE(new ResourceLocation("advancedrocketry:textures/planets/gasgiantblue.png")),
        GASGIANTRED(new ResourceLocation("advancedrocketry:textures/planets/gasgiantred.png")),
        GASGIANTBROWN(new ResourceLocation("advancedrocketry:textures/planets/gasgiantbrown.png")),
        ASTEROID(new ResourceLocation("advancedrocketry:textures/planets/asteroid.png")),
        UNKNOWN(new ResourceLocation("advancedrocketry:textures/planets/unknown.png"));

        private ResourceLocation resource;
        private ResourceLocation resourceLEO;

        private PlanetIcons(ResourceLocation resource) {
            this.resource = resource;
            this.resourceLEO = new ResourceLocation(resource.toString().substring(0, resource.toString().length() - 4) + "leo.jpg");
        }

        private PlanetIcons(ResourceLocation resource, ResourceLocation leo) {
            this.resource = resource;
            this.resourceLEO = atmosphereLEO;
        }

        public ResourceLocation getResource() {
            return this.resource;
        }

        public ResourceLocation getResourceLEO() {
            return this.resourceLEO;
        }
    }

    public static enum AtmosphereTypes {
        SUPERHIGHPRESSURE(800),
        HIGHPRESSURE(200),
        NORMAL(75),
        LOW(25),
        NONE(0);

        private int value;

        private AtmosphereTypes(int value) {
            this.value = value;
        }

        public int getAtmosphereValue() {
            return this.value;
        }

        public boolean denserThan(AtmosphereTypes type) {
            return this.compareTo(type) < 0;
        }

        public boolean lessDenseThan(AtmosphereTypes type) {
            return this.compareTo(type) > 0;
        }

        public static AtmosphereTypes getAtmosphereTypeFromValue(int value) {
            for (AtmosphereTypes type : AtmosphereTypes.values()) {
                if (value <= type.value) continue;
                return type;
            }
            return NONE;
        }
    }

    public static enum Temps {
        TOOHOT(450),
        HOT(325),
        NORMAL(275),
        COLD(250),
        FRIGID(175),
        SNOWBALL(0);

        private int temp;

        private Temps(int i) {
            this.temp = i;
        }

        @Deprecated
        public int getTemp() {
            return this.temp;
        }

        public boolean hotterThan(Temps type) {
            return this.compareTo(type) < 0;
        }

        public boolean colderThan(Temps type) {
            return this.compareTo(type) > 0;
        }

        public boolean isInRange(Temps lowerBound, Temps upperBound) {
            return this.compareTo(lowerBound) <= 0 && this.compareTo(upperBound) >= 0;
        }

        public static Temps getTempFromValue(int value) {
            for (Temps type : Temps.values()) {
                if (value <= type.temp) continue;
                return type;
            }
            return SNOWBALL;
        }
    }
}

