/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryEntities;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.tile.multiblock.TileSpaceElevator;
import zmaster587.advancedRocketry.util.DimensionBlockPosition;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.IEntitySpawnNBT;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketSpawnEntity;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public class EntityElevatorCapsule
extends Entity
implements INetworkEntity,
IEntityAdditionalSpawnData,
IEntitySpawnNBT {
    public static final double MAX_HEIGHT = ((Integer)ARConfiguration.getCurrentConfig().orbit.get()).intValue();
    public static final double MAX_STANDTIME = 200.0;
    byte field_213327_at = 0;
    int standTime;
    int idleTime;
    DimensionBlockPosition dstTilePos;
    DimensionBlockPosition srcTilePos;
    private static final byte PACKET_WRITE_DST_INFO = 0;
    private static final byte PACKET_RECIEVE_NBT = 1;
    private static final byte PACKET_LAUNCH_EVENT = 2;
    private static final byte PACKET_DEORBIT = 3;
    private static final byte PACKET_WRITE_SRC_INFO = 4;
    protected static final DataParameter<Byte> motionDir = EntityDataManager.func_187226_a(EntityElevatorCapsule.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> standTimeCounter = EntityDataManager.func_187226_a(EntityElevatorCapsule.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityElevatorCapsule(World worldIn) {
        super(AdvancedRocketryEntities.ENTITY_ELEVATOR_CAPSULE, worldIn);
        this.field_70158_ak = true;
    }

    public EntityElevatorCapsule(EntityType<? extends EntityElevatorCapsule> type, World worldIn) {
        this(worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(motionDir, (Object)this.field_213327_at);
        this.field_70180_af.func_187214_a(standTimeCounter, (Object)this.standTime);
    }

    public boolean isAscending() {
        return (Byte)this.field_70180_af.func_187225_a(motionDir) > 0;
    }

    public boolean func_226274_bn_() {
        return (Byte)this.field_70180_af.func_187225_a(motionDir) < 0;
    }

    public boolean isInMotion() {
        return (Byte)this.field_70180_af.func_187225_a(motionDir) != 0;
    }

    public void setCapsuleMotion(int motion) {
        this.field_70180_af.func_187227_b(motionDir, (Object)((byte)motion));
        this.field_213327_at = (byte)motion;
    }

    public int getStandTime() {
        this.standTime = (Integer)this.field_70180_af.func_187225_a(standTimeCounter);
        return this.standTime;
    }

    public void setStandTime(int time) {
        this.field_70180_af.func_187227_b(standTimeCounter, (Object)this.standTime);
    }

    public int decrStandTime() {
        this.standTime = this.getStandTime() - 1;
        this.field_70180_af.func_187227_b(standTimeCounter, (Object)this.standTime);
        return this.standTime;
    }

    protected void func_70037_a(CompoundNBT nbt) {
        int[] loc;
        this.setCapsuleMotion(nbt.func_74771_c("motionDir"));
        if (nbt.func_74764_b("dstDimid")) {
            this.dstTilePos = new DimensionBlockPosition(Constants.INVALID_PLANET, null);
            this.dstTilePos.dimid = new ResourceLocation(nbt.func_74779_i("dstDimid"));
            loc = nbt.func_74759_k("dstLoc");
            this.dstTilePos.pos = new HashedBlockPosition(loc[0], loc[1], loc[2]);
        } else {
            this.dstTilePos = null;
        }
        if (nbt.func_74764_b("srcDimid")) {
            this.srcTilePos = new DimensionBlockPosition(Constants.INVALID_PLANET, null);
            this.srcTilePos.dimid = new ResourceLocation(nbt.func_74779_i("srcDimid"));
            loc = nbt.func_74759_k("srcLoc");
            this.srcTilePos.pos = new HashedBlockPosition(loc[0], loc[1], loc[2]);
        } else {
            this.srcTilePos = null;
        }
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74774_a("motionDir", this.field_213327_at);
        if (this.dstTilePos != null) {
            nbt.func_74778_a("dstDimid", this.dstTilePos.dimid.toString());
            nbt.func_74783_a("dstLoc", new int[]{this.dstTilePos.pos.x, this.dstTilePos.pos.y, this.dstTilePos.pos.z});
        }
        if (this.srcTilePos != null) {
            nbt.func_74778_a("srcDimid", this.srcTilePos.dimid.toString());
            nbt.func_74783_a("srcLoc", new int[]{this.srcTilePos.pos.x, this.srcTilePos.pos.y, this.srcTilePos.pos.z});
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void setDst(DimensionBlockPosition location) {
        this.dstTilePos = location;
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 0), (Entity)this);
        }
    }

    public void setSourceTile(DimensionBlockPosition location) {
        this.srcTilePos = location;
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 4), (Entity)this);
        }
    }

    public Entity func_241206_a_(ServerWorld newDimId) {
        return this.changeDimension(newDimId, this.func_226277_ct_(), ((Integer)ARConfiguration.getCurrentConfig().orbit.get()).intValue(), this.func_226281_cx_());
    }

    public void func_180432_n(Entity entityIn) {
        super.func_180432_n(entityIn);
        this.func_184188_bt().clear();
    }

    public Entity changeDimension(ServerWorld world, ITeleporter teleporter) {
        return super.changeDimension(world, teleporter);
    }

    @Nullable
    public Entity changeDimension(ServerWorld dimensionIn, double posX, double y, double posZ) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            float yaw = this.field_70177_z;
            float pitch = this.field_70125_A;
            List passengers = this.func_184188_bt();
            MinecraftServer minecraftserver = this.func_184102_h();
            ServerWorld worldserver = (ServerWorld)this.func_130014_f_();
            ServerWorld worldserver1 = dimensionIn;
            PortalInfo info = new PortalInfo(new Vector3d(posX, y, posZ), this.func_213322_ci(), this.field_70177_z, this.field_70125_A);
            TeleporterNoPortal teleporter = new TeleporterNoPortal(worldserver1, info);
            Entity entity = this.changeDimension(dimensionIn, teleporter);
            if (entity == null) {
                return null;
            }
            entity.func_70080_a(posX, y, posZ, yaw, pitch);
            int timeOffset = 1;
            for (Entity e : passengers) {
                PlanetEventHandler.addDelayedTransition(new TransitionEntity(worldserver.func_82737_E() + (long)(++timeOffset), e, dimensionIn, new BlockPos(posX, y, posZ), entity));
            }
            return entity;
        }
        return null;
    }

    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70071_h_() {
        super.func_70071_h_();
        boolean isInSpaceDim = ZUtils.getDimensionIdentifier((World)this.func_130014_f_()).equals(ARConfiguration.getCurrentConfig().spaceDimId);
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 5) {
            if (this.dstTilePos != null) {
                this.setDst(this.dstTilePos);
            }
            if (this.srcTilePos != null) {
                this.setSourceTile(this.srcTilePos);
            }
        }
        if (this.isAscending()) {
            if (this.func_226278_cu_() > 255.0) {
                this.func_213317_d(new Vector3d(this.func_213322_ci().field_72450_a, 2.85, this.func_213322_ci().field_72449_c));
            } else {
                this.func_213317_d(new Vector3d(this.func_213322_ci().field_72450_a, 0.85, this.func_213322_ci().field_72449_c));
            }
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ());
                for (Entity ent : list) {
                    if (this.func_184187_bx() != null) continue;
                    ent.func_184220_m((Entity)this);
                }
                if (this.func_226278_cu_() > MAX_HEIGHT) {
                    double landingLocZ;
                    double landingLocX;
                    TileEntity tile;
                    this.setCapsuleMotion(1);
                    ServerWorld world = ZUtils.getWorld((ResourceLocation)this.dstTilePos.dimid);
                    if (world != null) {
                        tile = world.func_175625_s(this.dstTilePos.pos.getBlockPos());
                        if (!(tile instanceof TileSpaceElevator)) {
                            this.func_70106_y();
                            return;
                        }
                        landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                        landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                    } else {
                        this.dstTilePos = this.srcTilePos;
                        world = this.func_130014_f_();
                        tile = world.func_175625_s(this.dstTilePos.pos.getBlockPos());
                        if (!(tile instanceof TileSpaceElevator)) {
                            this.func_70106_y();
                            return;
                        }
                        landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                        landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                    }
                    this.changeDimension(ZUtils.getWorld((ResourceLocation)this.dstTilePos.dimid), landingLocX, 10.0, landingLocZ);
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
                }
            }
            if (this.func_226278_cu_() >= (double)(this.dstTilePos.pos.y - 4) && isInSpaceDim) {
                this.setCapsuleMotion(0);
                this.func_70107_b(this.dstTilePos.pos.x, this.dstTilePos.pos.y - 5, this.dstTilePos.pos.z);
                TileEntity e = this.field_70170_p.func_175625_s(this.dstTilePos.pos.getBlockPos());
                if (e instanceof TileSpaceElevator) {
                    ((TileSpaceElevator)e).notifyLanded(this);
                    this.standTime = 0;
                } else {
                    this.func_241204_bJ_();
                }
                for (Entity ent : this.func_184188_bt()) {
                    ent.func_233575_bb_();
                }
            }
            this.func_213315_a(MoverType.SELF, new Vector3d(0.0, this.func_213322_ci().field_72448_b, 0.0));
            return;
        }
        if (this.func_226274_bn_()) {
            this.field_70122_E = false;
            if (this.func_226278_cu_() > 255.0) {
                this.func_213317_d(new Vector3d(this.func_213322_ci().field_72450_a, -2.85, this.func_213322_ci().field_72449_c));
            } else {
                this.func_213317_d(new Vector3d(this.func_213322_ci().field_72450_a, -0.85, this.func_213322_ci().field_72449_c));
            }
            if (this.field_70170_p.field_72995_K) {
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                return;
            }
            if (this.field_70173_aa == 20) {
                PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 3), (Entity)this);
            }
            List list = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ());
            for (Object ent : list) {
                if (this.func_184187_bx() != null) continue;
                ent.func_184220_m((Entity)this);
            }
            if (this.func_226278_cu_() <= (double)(this.dstTilePos.pos.y + 1) && !isInSpaceDim) {
                Object ent;
                this.setCapsuleMotion(0);
                this.func_70107_b(this.dstTilePos.pos.x, this.dstTilePos.pos.y + 1, this.dstTilePos.pos.z);
                TileEntity e = this.field_70170_p.func_175625_s(this.dstTilePos.pos.getBlockPos());
                if (e instanceof TileSpaceElevator) {
                    ((TileSpaceElevator)e).notifyLanded(this);
                    this.standTime = 0;
                } else {
                    this.func_70106_y();
                }
                ent = this.func_184188_bt().iterator();
                while (ent.hasNext()) {
                    Entity ent2 = (Entity)ent.next();
                    ent2.func_184210_p();
                }
                return;
            }
            if (this.func_226278_cu_() <= 15.0 && isInSpaceDim) {
                double landingLocZ;
                double landingLocX;
                this.setCapsuleMotion(-1);
                ServerWorld world = ZUtils.getWorld((ResourceLocation)this.dstTilePos.dimid);
                if (world == null) {
                    ZUtils.initDimension((ResourceLocation)this.dstTilePos.dimid);
                    world = ZUtils.getWorld((ResourceLocation)this.dstTilePos.dimid);
                }
                if (world != null) {
                    TileEntity tile = world.func_175625_s(this.dstTilePos.pos.getBlockPos());
                    if (!(tile instanceof TileSpaceElevator)) {
                        this.func_241204_bJ_();
                        return;
                    }
                    landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                    landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                } else {
                    this.dstTilePos = this.srcTilePos;
                    world = this.func_130014_f_();
                    TileEntity tile = world.func_175625_s(this.dstTilePos.pos.getBlockPos());
                    if (!(tile instanceof TileSpaceElevator)) {
                        this.func_241204_bJ_();
                        return;
                    }
                    landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                    landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                }
                this.changeDimension(ZUtils.getWorld((ResourceLocation)this.dstTilePos.dimid), landingLocX, ((Integer)ARConfiguration.getCurrentConfig().orbit.get()).intValue(), landingLocZ);
                MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
                return;
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            return;
        }
        List list = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ());
        if (!this.field_70170_p.field_72995_K) {
            TileEntity srcTile = null;
            if (list.isEmpty()) {
                this.standTime = 0;
            } else if (this.dstTilePos != null && TileSpaceElevator.isDestinationValid(this.dstTilePos.dimid, this.dstTilePos, new HashedBlockPosition(this.func_233580_cy_()), ZUtils.getDimensionIdentifier((World)this.field_70170_p))) {
                ++this.standTime;
            }
            if (this.srcTilePos != null && this.srcTilePos.pos != null) {
                srcTile = this.field_70170_p.func_175625_s(this.srcTilePos.pos.getBlockPos());
            }
            if (srcTile != null && srcTile instanceof TileSpaceElevator && !((TileSpaceElevator)srcTile).getMachineEnabled()) {
                this.standTime = 0;
            }
            this.setStandTime(this.standTime);
            if (!((double)this.standTime > 200.0)) return;
            if (this.srcTilePos == null) return;
            if (this.srcTilePos.pos == null) return;
            srcTile = this.field_70170_p.func_175625_s(this.srcTilePos.pos.getBlockPos());
            if (!(srcTile instanceof TileSpaceElevator)) return;
            if (!((TileSpaceElevator)srcTile).attemptLaunch()) return;
            if (isInSpaceDim) {
                this.setCapsuleMotion(-1);
            } else {
                this.setCapsuleMotion(1);
            }
            List list2 = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ());
            Iterator iterator = list2.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
                    PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 2), (Entity)this);
                    return;
                }
                Entity ent = (Entity)iterator.next();
                if (this.func_184187_bx() != null) continue;
                ent.func_184220_m((Entity)this);
            }
        }
        if (list.isEmpty()) return;
        TileEntity srcTile = null;
        if (this.srcTilePos != null && this.srcTilePos.pos != null) {
            srcTile = this.field_70170_p.func_175625_s(this.srcTilePos.pos.getBlockPos());
        }
        if (srcTile != null && srcTile instanceof TileSpaceElevator && !((TileSpaceElevator)srcTile).getMachineEnabled()) {
            AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.spaceelevator.turnedoff"), 5);
            return;
        }
        if (this.dstTilePos != null) {
            AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.spaceelevator.ascentready") + ": " + (int)((200.0 - (double)this.getStandTime()) / 20.0) + "\nDST " + this.dstTilePos, 5);
            return;
        }
        AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.label.noneselected"), 5);
    }

    public double func_70042_X() {
        return 0.3;
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double par1) {
        return par1 < 1.6777216E7;
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 0) {
            out.writeBoolean(this.dstTilePos != null);
            if (this.dstTilePos != null) {
                out.func_192572_a(this.dstTilePos.dimid);
                out.writeInt(this.dstTilePos.pos.x);
                out.writeInt((int)this.dstTilePos.pos.y);
                out.writeInt(this.dstTilePos.pos.z);
            }
        } else if (id == 4) {
            out.writeBoolean(this.dstTilePos != null);
            if (this.srcTilePos != null) {
                out.func_192572_a(this.srcTilePos.dimid);
                out.writeInt(this.srcTilePos.pos.x);
                out.writeInt((int)this.srcTilePos.pos.y);
                out.writeInt(this.srcTilePos.pos.z);
            }
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if ((packetId == 0 || packetId == 4) && in.readBoolean()) {
            nbt.func_74778_a("dimid", in.func_192575_l().toString());
            nbt.func_74768_a("x", in.readInt());
            nbt.func_74768_a("y", in.readInt());
            nbt.func_74768_a("z", in.readInt());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == 0 && this.field_70170_p.field_72995_K) {
            this.dstTilePos = nbt.func_74764_b("dimid") ? new DimensionBlockPosition(new ResourceLocation(nbt.func_74779_i("dimid")), new HashedBlockPosition(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))) : null;
        } else if (id == 4 && this.field_70170_p.field_72995_K) {
            this.srcTilePos = nbt.func_74764_b("dimid") ? new DimensionBlockPosition(new ResourceLocation(nbt.func_74779_i("dimid")), new HashedBlockPosition(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))) : null;
        } else if (id == 1) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 0), (Entity)this);
        } else if (id == 2 && this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ());
            for (Entity ent : list) {
                if (this.func_184187_bx() != null) continue;
                ent.func_184220_m((Entity)this);
            }
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
        } else if (id == 3 && this.field_70170_p.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT nbt = new CompoundNBT();
        this.func_213281_b(nbt);
        new PacketSpawnEntity((Entity)this, nbt).write(buffer);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        PacketSpawnEntity packet = new PacketSpawnEntity();
        packet.read(additionalData);
        packet.execute((Entity)this);
    }

    public void readSpawnNBT(CompoundNBT nbt) {
        this.dstTilePos = nbt.func_74764_b("dimid") ? new DimensionBlockPosition(new ResourceLocation(nbt.func_74779_i("dimid")), new HashedBlockPosition(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))) : null;
    }
}

