/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.api.AdvancedRocketryEntities;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketSpawnEntity;
import zmaster587.libVulpes.util.EmbeddedInventory;

public class EntityHoverCraft
extends Entity
implements IInventory,
INetworkEntity,
IEntityAdditionalSpawnData {
    protected double speedMultiplier;
    public boolean cruiseControl;
    protected float fanLoc;
    protected int freshBurnTime;
    protected int currentBurnTime;
    protected EmbeddedInventory inv = new EmbeddedInventory(1);
    private boolean turningLeft;
    private boolean turningRight;
    private boolean turningUp;
    private boolean turningDownforWhat;

    public EntityHoverCraft(EntityType<?> type, World par1World) {
        super(AdvancedRocketryEntities.ENTITY_HOVER_CRAFT, par1World);
    }

    public EntityHoverCraft(World par1World, double par2, double par4, double par6) {
        this(AdvancedRocketryEntities.ENTITY_HOVER_CRAFT, par1World);
        this.func_70107_b(par2, par4 + this.func_70033_W(), par6);
        this.field_70169_q = par2;
        this.field_70167_r = par4;
        this.field_70166_s = par6;
        this.inv = new EmbeddedInventory(1);
    }

    public double func_70033_W() {
        return 0.0;
    }

    public boolean func_225502_at_() {
        return false;
    }

    public void func_70296_d() {
    }

    public void updateRiderPosition() {
        if (!this.func_184188_bt().isEmpty()) {
            // empty if block
        }
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.0 + 0.5;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.func_184188_bt().isEmpty() && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && par1DamageSource.func_76364_f() instanceof PlayerEntity && !this.func_184188_bt().contains(par1DamageSource.func_76364_f())) {
            for (ItemStack i : this.getItemsDropOnDeath()) {
                if (i == null) continue;
                this.func_70099_a(i, 0.0f);
            }
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public ItemStack[] getItemsDropOnDeath() {
        ItemStack[] stack = new ItemStack[]{this.inv.func_70301_a(0), new ItemStack((IItemProvider)AdvancedRocketryItems.itemHovercraft)};
        return stack;
    }

    public float getMaxHeight() {
        return 250.0f;
    }

    public double getMaxVelocity() {
        return 0.75;
    }

    public double getMaxVerticalSpeed() {
        return 0.1;
    }

    public double getMaxAcceleration() {
        return 0.05;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return this.inv.func_70298_a(slot, amt);
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inv.func_70299_a(slot, itemstack);
    }

    public void onTurnRight(boolean state) {
        this.turningRight = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.TURNUPDATE.ordinal()));
    }

    public void onTurnLeft(boolean state) {
        this.turningLeft = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.TURNUPDATE.ordinal()));
    }

    public void onUp(boolean state) {
        this.turningUp = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.TURNUPDATE.ordinal()));
    }

    public void onDown(boolean state) {
        this.turningDownforWhat = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.TURNUPDATE.ordinal()));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_184188_bt().isEmpty()) {
            this.turningDownforWhat = true;
        }
        this.field_70177_z += (float)((this.turningRight ? 5 : 0) - (this.turningLeft ? 5 : 0));
        double acc = (double)this.getPassengerMovingForward() * this.getMaxAcceleration();
        float yawAngle = (float)((double)this.field_70177_z * Math.PI / 180.0);
        Vector3d motion = this.func_213322_ci();
        float friction = 0.9f;
        float motionYMult = 1.0f;
        if (this.func_226278_cu_() > (double)this.getMaxHeight() * 1.1) {
            motionYMult = 0.0f;
        } else if (this.func_226278_cu_() > (double)this.getMaxHeight()) {
            motionYMult = (float)((double)motionYMult * 0.1);
        }
        if (this.func_184187_bx() != null) {
            this.func_184187_bx().field_70143_R = 0.0f;
        }
        Vector3d newMotion = new Vector3d((double)friction * (motion.field_72450_a + acc * (double)MathHelper.func_76126_a((float)(-yawAngle))), (double)(motionYMult * friction) * (motion.field_72448_b + (this.turningUp ? this.getMaxAcceleration() : 0.0) - (this.turningDownforWhat ? this.getMaxAcceleration() : 0.0)), (double)friction * (motion.field_72449_c + acc * (double)MathHelper.func_76134_b((float)(-yawAngle))));
        this.func_213317_d(newMotion);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public float getPassengerMovingForward() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof PlayerEntity)) continue;
            return ((PlayerEntity)entity).field_191988_bg;
        }
        return 0.0f;
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == EntityRocket.PacketType.TURNUPDATE.ordinal()) {
            nbt.func_74757_a("left", in.readBoolean());
            nbt.func_74757_a("right", in.readBoolean());
            nbt.func_74757_a("up", in.readBoolean());
            nbt.func_74757_a("down", in.readBoolean());
        }
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == EntityRocket.PacketType.TURNUPDATE.ordinal()) {
            out.writeBoolean(this.turningLeft);
            out.writeBoolean(this.turningRight);
            out.writeBoolean(this.turningUp);
            out.writeBoolean(this.turningDownforWhat);
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == EntityRocket.PacketType.TURNUPDATE.ordinal()) {
            this.turningLeft = nbt.func_74767_n("left");
            this.turningRight = nbt.func_74767_n("right");
            this.turningUp = nbt.func_74767_n("up");
            this.turningDownforWhat = nbt.func_74767_n("down");
        }
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    public void func_174889_b(PlayerEntity player) {
        this.inv.func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.inv.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inv.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.inv.readFromNBT(compound);
    }

    protected void func_213281_b(CompoundNBT compound) {
        this.inv.write(compound);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        new PacketSpawnEntity((Entity)this).write(buffer);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        PacketSpawnEntity packet = new PacketSpawnEntity();
        packet.read(additionalData);
        packet.execute((Entity)this);
    }

    public static enum VehicleType {
        submarine,
        blimp;

    }
}

