/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.SandBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.achievements.ARAdvancements;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryEntities;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.client.SoundRocketEngine;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.inventory.modules.ModulePlanetSelector;
import zmaster587.advancedRocketry.inventory.modules.ModuleStellarBackground;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.item.ItemPackedStructure;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.mission.MissionOreMining;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.AsteroidSmall;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.advancedRocketry.util.RocketInventoryHelper;
import zmaster587.advancedRocketry.util.SpacePosition;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleSlotButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.IEntitySpawnNBT;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketSpawnEntity;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.IconResource;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class EntityRocket
extends EntityRocketBase
implements INetworkEntity,
IEntityAdditionalSpawnData,
IModularInventory,
IProgressBar,
IButtonInventory,
ISelectionNotify,
IPlanetDefiner,
INamedContainerProvider,
IEntitySpawnNBT {
    private boolean isInOrbit = false;
    private boolean isInFlight;
    private ResourceLocation lastDimensionFrom = Constants.INVALID_PLANET;
    private boolean turningLeft;
    private boolean turningRight;
    private boolean turningUp;
    private boolean turningDownforWhat;
    public StorageChunk storage;
    private String errorStr;
    private long lastErrorTime = Long.MIN_VALUE;
    private static long ERROR_DISPLAY_TIME = 100L;
    private static int DESCENT_TIMER = 500;
    private static int BUTTON_ID_OFFSET = 25;
    private static final int STATION_LOC_OFFSET = 50;
    private static final int ENGINE_IGNITION_CNT = 100;
    private ModuleText landingPadDisplayText;
    protected long lastWorldTickTicked;
    private SatelliteBase satellite;
    protected ResourceLocation destinationDimId;
    private int tilebuttonOffset = 3;
    private int autoDescendTimer;
    protected ModulePlanetSelector container;
    boolean acceptedPacket = false;
    SpacePosition spacePosition;
    private int rcs_mode_counter = 0;
    private boolean rcs_mode = false;
    private EntitySize mySize;
    private static final DataParameter<Integer> fuelLevelMonopropellant = EntityDataManager.func_187226_a(EntityRocket.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> fuelLevelBipropellant = EntityDataManager.func_187226_a(EntityRocket.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> fuelLevelOxidizer = EntityDataManager.func_187226_a(EntityRocket.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> INFLIGHT = EntityDataManager.func_187226_a(EntityRocket.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INORBIT = EntityDataManager.func_187226_a(EntityRocket.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INSPACEFLIGHT = EntityDataManager.func_187226_a(EntityRocket.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RCS_MODE = EntityDataManager.func_187226_a(EntityRocket.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LAUNCH_COUNTER = EntityDataManager.func_187226_a(EntityRocket.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityRocket(EntityType<?> type, World p_i1582_1_) {
        super(type, p_i1582_1_);
        this.stats = new StatsRocket();
        this.isInFlight = false;
        this.connectedInfrastructure = new LinkedList();
        this.infrastructureCoords = new HashSet();
        this.lastWorldTickTicked = p_i1582_1_.func_82737_E();
        this.autoDescendTimer = 5000;
        this.landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);
        this.landingPadDisplayText.setColor(65280);
        this.spacePosition = new SpacePosition();
        DimensionManager.getInstance();
        this.spacePosition.star = DimensionManager.getSol();
    }

    public EntityRocket(EntityType<?> type, World world, StorageChunk storage, StatsRocket stats, double x, double y, double z) {
        this(AdvancedRocketryEntities.ENTITY_ROCKET, world);
        this.stats = stats;
        this.func_70107_b(x, y, z);
        this.storage = storage;
        this.storage.setEntity(this);
        this.initFromBounds();
        this.isInFlight = false;
        this.lastWorldTickTicked = world.func_82737_E();
        this.autoDescendTimer = 5000;
        this.landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);
        this.landingPadDisplayText.setColor(65280);
    }

    public EntityRocket(World world, StorageChunk storage, StatsRocket stats, double x, double y, double z) {
        this(AdvancedRocketryEntities.ENTITY_ROCKET, world, storage, stats, x, y, z);
    }

    public void toggleRCS() {
        if (DimensionManager.getInstance().getDimensionProperties(this.field_70170_p).isAsteroid()) {
            this.rcs_mode = !this.rcs_mode;
            this.setRCS(this.rcs_mode);
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        } else {
            this.rcs_mode = false;
            this.setRCS(this.rcs_mode);
        }
    }

    private void setRCS(boolean status) {
        this.field_70180_af.func_187227_b(RCS_MODE, (Object)status);
    }

    public boolean getRCS() {
        return (Boolean)this.field_70180_af.func_187225_a(RCS_MODE);
    }

    private void setInSpaceFlight(boolean status) {
        this.field_70180_af.func_187227_b(INSPACEFLIGHT, (Object)status);
    }

    public boolean getInSpaceFlight() {
        return (Boolean)this.field_70180_af.func_187225_a(INSPACEFLIGHT);
    }

    public int getRCSRotateProgress() {
        return this.rcs_mode_counter;
    }

    public AxisAlignedBB func_174813_aQ() {
        if (this.storage != null) {
            return super.func_174813_aQ();
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void func_174826_a(AxisAlignedBB bb) {
        super.func_174826_a(bb);
    }

    public SpacePosition getSpacePosition() {
        return this.spacePosition;
    }

    @Override
    public int getFuelAmountMonopropellant() {
        int amount = (Integer)this.field_70180_af.func_187225_a(fuelLevelMonopropellant);
        this.stats.setFuelAmount(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, amount);
        return amount;
    }

    @Override
    public int getFuelAmountBipropellant() {
        int amount = (Integer)this.field_70180_af.func_187225_a(fuelLevelBipropellant);
        this.stats.setFuelAmount(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, amount);
        return amount;
    }

    @Override
    public int getFuelAmountOxidizer() {
        int amount = (Integer)this.field_70180_af.func_187225_a(fuelLevelOxidizer);
        this.stats.setFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER, amount);
        return amount;
    }

    @Override
    public int addFuelAmountMonopropellant(int amount) {
        int ret = this.stats.addFuelAmount(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, amount);
        this.setFuelAmountMonoproellant(this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT));
        return ret;
    }

    @Override
    public int addFuelAmountBipropellant(int amount) {
        int ret = this.stats.addFuelAmount(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, amount);
        this.setFuelAmountBipropellant(this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID_BIPROPELLANT));
        return ret;
    }

    @Override
    public int addFuelAmountOxidizer(int amount) {
        int ret = this.stats.addFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER, amount);
        this.setFuelAmountOxidizer(this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER));
        return ret;
    }

    public void disconnectInfrastructure(IInfrastructure infrastructure) {
        infrastructure.unlinkRocket();
        this.infrastructureCoords.remove(new HashedBlockPosition(((TileEntity)infrastructure).func_174877_v()));
        if (!this.field_70170_p.field_72995_K) {
            int[] pos = new int[]{((TileEntity)infrastructure).func_174877_v().func_177958_n(), ((TileEntity)infrastructure).func_174877_v().func_177956_o(), ((TileEntity)infrastructure).func_174877_v().func_177952_p()};
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74783_a("pos", pos);
        }
    }

    @Override
    public void linkInfrastructure(IInfrastructure tile) {
        super.linkInfrastructure(tile);
        if (tile instanceof TileEntity) {
            this.infrastructureCoords.add(new HashedBlockPosition(((TileEntity)tile).func_174877_v()));
        }
    }

    @Override
    public String getTextOverlay() {
        if (this.field_70170_p.func_82737_E() < this.lastErrorTime + ERROR_DISPLAY_TIME) {
            return this.errorStr;
        }
        String displayStr = LibVulpes.proxy.getLocalizedString("msg.na");
        if (this.storage != null) {
            ResourceLocation dimid = this.storage.getDestinationDimId(ZUtils.getDimensionIdentifier((World)this.field_70170_p), (int)this.func_226277_ct_(), (int)this.func_226281_cx_());
            if (dimid.equals((Object)ARConfiguration.GetSpaceDimId())) {
                ISpaceObject obj;
                Vector3F<Float> vec = this.storage.getDestinationCoordinates(dimid, false);
                if (vec != null && (obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos((double)((Float)vec.x).floatValue(), (double)((Float)vec.y).floatValue(), (double)((Float)vec.z).floatValue()))) != null) {
                    displayStr = " " + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.station") + " " + obj.getId();
                    StationLandingLocation location = this.storage.getGuidanceComputer().getLandingLocation(obj.getId());
                    if (location != null) {
                        displayStr = displayStr + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.pad") + location;
                    }
                }
            } else if (!Constants.INVALID_PLANET.equals((Object)dimid) && !SpaceObjectManager.WARPDIMID.equals((Object)dimid)) {
                boolean goingToOrbit;
                boolean bl = goingToOrbit = (Boolean)ARConfiguration.getCurrentConfig().experimentalSpaceFlight.get() != false && this.storage.getGuidanceComputer().func_191420_l() && !Constants.INVALID_PLANET.equals((Object)dimid);
                if (goingToOrbit) {
                    displayStr = " Orbit";
                } else {
                    displayStr = " " + DimensionManager.getInstance().getDimensionProperties(dimid).getName();
                    Vector3F<Float> loc = this.storage.getDestinationCoordinates(dimid, false);
                    if (loc != null) {
                        String name = this.storage.getDestinationName(dimid);
                        if (!name.isEmpty()) {
                            displayStr = displayStr + String.format("\n%s: %s", LibVulpes.proxy.getLocalizedString("msg.label.destname"), name);
                        }
                        displayStr = displayStr + String.format("\n%s: %.0f, %.0f", LibVulpes.proxy.getLocalizedString("msg.label.coords"), loc.x, loc.z);
                    } else {
                        displayStr = displayStr + "\nCoords: ???, ???";
                    }
                }
            }
        }
        if ((Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) >= 0) {
            return LibVulpes.proxy.getLocalizedString("msg.entity.rocket.launch") + " " + (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) / 20 + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.launch2");
        }
        if (DimensionManager.getInstance().getDimensionProperties(this.field_70170_p).isAsteroid()) {
            if (this.getRCS()) {
                return LibVulpes.proxy.getLocalizedString("msg.entity.rocket.rcs") + ": " + this.getRCS();
            }
            displayStr = displayStr + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.rcs") + ": " + this.getRCS();
        }
        if (this.isInOrbit() && !this.isInFlight()) {
            return LibVulpes.proxy.getLocalizedString("msg.entity.rocket.descend.1") + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.descend.2") + " " + (DESCENT_TIMER - this.field_70173_aa) / 20;
        }
        if (!this.isInFlight()) {
            return LibVulpes.proxy.getLocalizedString("msg.entity.rocket.ascend.1") + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.ascend.2") + displayStr;
        }
        return super.getTextOverlay();
    }

    private void setError(String error) {
        this.errorStr = error;
        this.lastErrorTime = this.field_70170_p.func_82737_E();
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.storage != null) {
            if (this.getRCS()) {
                float sizeX = (float)this.storage.getSizeX() / 2.0f;
                float sizeY = (float)this.storage.getSizeY() / 2.0f;
                float sizeZ = this.storage.getSizeZ();
                this.func_174826_a(new AxisAlignedBB(x - (double)sizeX, y - this.func_70033_W() + (double)sizeZ * 0.5 + 0.5, z - (double)sizeY, x + (double)sizeX, y + (double)sizeZ * 1.5 + 0.5 - this.func_70033_W(), z + (double)sizeY));
            } else {
                float sizeX = (float)this.storage.getSizeX() / 2.0f;
                float sizeY = this.storage.getSizeY();
                float sizeZ = (float)this.storage.getSizeZ() / 2.0f;
                this.func_174826_a(new AxisAlignedBB(x - (double)sizeX, y - this.func_70033_W(), z - (double)sizeZ, x + (double)sizeX, y + (double)sizeY - this.func_70033_W(), z + (double)sizeZ));
            }
        }
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        if (this.storage != null && this.getRCS()) {
            float sizeX = (float)this.storage.getSizeX() / 2.0f;
            float sizeY = (float)this.storage.getSizeY() / 2.0f;
            float sizeZ = this.storage.getSizeZ();
            this.func_70107_b((axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0, axisalignedbb.field_72338_b - (double)sizeZ * 0.5 - 0.5, (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0);
        } else {
            super.func_174829_m();
        }
    }

    public void setFuelAmountMonoproellant(int amt) {
        this.field_70180_af.func_187227_b(fuelLevelMonopropellant, (Object)amt);
    }

    public void setFuelAmountBipropellant(int amt) {
        this.field_70180_af.func_187227_b(fuelLevelBipropellant, (Object)amt);
    }

    public void setFuelAmountOxidizer(int amt) {
        this.field_70180_af.func_187227_b(fuelLevelOxidizer, (Object)amt);
    }

    @Override
    public void setFuelRateMonopropellant(int rate) {
        this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, rate);
    }

    @Override
    public void setFuelRateBipropellant(int rate) {
        this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, rate);
    }

    @Override
    public void setFuelRateOxidizer(int rate) {
        this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER, rate);
    }

    @Override
    public int getFuelCapacityMonopropellant() {
        return this.stats.getFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT);
    }

    @Override
    public int getFuelCapacityBipropellant() {
        return this.stats.getFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT);
    }

    @Override
    public int getFuelCapacityOxidizer() {
        return this.stats.getFuelCapacity(FuelRegistry.FuelType.LIQUID_OXIDIZER);
    }

    @Override
    public int getFuelRateMonopropellant() {
        return this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT);
    }

    @Override
    public int getFuelRateBipropellant() {
        return this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT);
    }

    @Override
    public int getFuelRateOxidizer() {
        return this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER);
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean isInFlight() {
        if (!this.field_70170_p.field_72995_K) {
            return this.isInFlight;
        }
        return (Boolean)this.field_70180_af.func_187225_a(INFLIGHT);
    }

    public void setInOrbit(boolean inOrbit) {
        this.isInOrbit = inOrbit;
        this.field_70180_af.func_187227_b(INORBIT, (Object)inOrbit);
    }

    public boolean isInOrbit() {
        if (!this.field_70170_p.field_72995_K) {
            return this.isInOrbit;
        }
        return (Boolean)this.field_70180_af.func_187225_a(INORBIT);
    }

    public void setInFlight(boolean inflight) {
        this.isInFlight = inflight;
        this.field_70180_af.func_187227_b(INFLIGHT, (Object)inflight);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INFLIGHT, (Object)false);
        this.field_70180_af.func_187214_a(fuelLevelMonopropellant, (Object)0);
        this.field_70180_af.func_187214_a(fuelLevelBipropellant, (Object)0);
        this.field_70180_af.func_187214_a(fuelLevelOxidizer, (Object)0);
        this.field_70180_af.func_187214_a(INORBIT, (Object)false);
        this.field_70180_af.func_187214_a(RCS_MODE, (Object)false);
        this.field_70180_af.func_187214_a(LAUNCH_COUNTER, (Object)-1);
        this.field_70180_af.func_187214_a(INSPACEFLIGHT, (Object)false);
    }

    public void initFromBounds() {
        if (this.storage != null) {
            this.setSize(Math.max(this.storage.getSizeX(), this.storage.getSizeZ()), this.storage.getSizeY());
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    protected ActionResultType interact(PlayerEntity player) {
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        boolean isHoldingFluidItemOrLinker = false;
        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() instanceof ItemLinker) {
                isHoldingFluidItemOrLinker = true;
                if (ItemLinker.isSet((ItemStack)heldItem)) {
                    TileEntity tile = this.field_70170_p.func_175625_s(ItemLinker.getMasterCoords((ItemStack)heldItem));
                    if (tile instanceof IInfrastructure) {
                        IInfrastructure infrastructure = (IInfrastructure)tile;
                        if (Math.sqrt(this.func_70092_e(ItemLinker.getMasterX((ItemStack)heldItem), this.func_226278_cu_(), ItemLinker.getMasterZ((ItemStack)heldItem))) < (double)(infrastructure.getMaxLinkDistance() + Math.max(this.storage.getSizeX(), this.storage.getSizeZ()))) {
                            if (!this.connectedInfrastructure.contains(tile)) {
                                this.linkInfrastructure(infrastructure);
                                if (!this.field_70170_p.field_72995_K) {
                                    player.func_145747_a((ITextComponent)new StringTextComponent("Linked Sucessfully"), Util.field_240973_b_);
                                }
                                ItemLinker.resetPosition((ItemStack)heldItem);
                                return ActionResultType.SUCCESS;
                            }
                            if (!this.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new StringTextComponent("Already linked!"), Util.field_240973_b_);
                            }
                        } else if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new StringTextComponent("The object you are trying to link is too far away"), Util.field_240973_b_);
                        }
                    } else if (!this.field_70170_p.field_72995_K) {
                        player.func_145747_a((ITextComponent)new StringTextComponent("This cannot be linked to a rocket!"), Util.field_240973_b_);
                    }
                } else if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Nothing to be linked"), Util.field_240973_b_);
                }
                return ActionResultType.PASS;
            }
            if (FluidUtils.containsFluid((ItemStack)heldItem) && FluidUtils.getFluidForItem((ItemStack)heldItem) != null && ((Boolean)ARConfiguration.getCurrentConfig().canBeFueledByHand.get()).booleanValue()) {
                isHoldingFluidItemOrLinker = true;
                FluidStack fluidStack = FluidUtils.getFluidForItem((ItemStack)heldItem);
                if (this.canRocketFitFluid(fluidStack)) {
                    if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluidStack.getFluid())) {
                        this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, (int)(this.stats.getBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) * FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluidStack.getFluid())));
                        FluidTank rocketFakeTank = new FluidTank(this.getFuelCapacityMonopropellant() - this.getFuelAmountMonopropellant());
                        FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)Hand.MAIN_HAND, (IFluidHandler)rocketFakeTank);
                        this.addFuelAmountMonopropellant(rocketFakeTank.getFluidAmount());
                    } else if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluidStack.getFluid())) {
                        this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, (int)(this.stats.getBaseFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT) * FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluidStack.getFluid())));
                        FluidTank rocketFakeTank = new FluidTank(this.getFuelCapacityBipropellant() - this.getFuelAmountBipropellant());
                        FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)Hand.MAIN_HAND, (IFluidHandler)rocketFakeTank);
                        this.addFuelAmountBipropellant(rocketFakeTank.getFluidAmount());
                    } else if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluidStack.getFluid())) {
                        this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER, (int)(this.stats.getBaseFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER) * FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluidStack.getFluid())));
                        FluidTank rocketFakeTank = new FluidTank(this.getFuelCapacityBipropellant() - this.getFuelAmountBipropellant());
                        FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)Hand.MAIN_HAND, (IFluidHandler)rocketFakeTank);
                        this.addFuelAmountOxidizer(rocketFakeTank.getFluidAmount());
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        if (player.func_225608_bj_() || !this.stats.hasSeat() && !isHoldingFluidItemOrLinker) {
            if (!this.field_70170_p.field_72995_K) {
                this.openGui(player);
            }
        } else if (this.stats.hasSeat() && this.func_184188_bt().size() < this.stats.getNumPassengerSeats() && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return ActionResultType.SUCCESS;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.stats.getNumPassengerSeats();
    }

    public boolean canRocketFitFluid(FluidStack fluidStack) {
        if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluidStack.getFluid())) {
            boolean isCorrectFluid;
            boolean bl = isCorrectFluid = this.stats.getFuelFluid() == null ? true : FluidUtils.areFluidsSameType((ResourceLocation)this.stats.getFuelFluid(), (Fluid)fluidStack.getFluid());
            if (this.stats.getFuelFluid() == null && isCorrectFluid) {
                this.stats.setFuelFluid(fluidStack.getFluid().getRegistryName());
            }
            return isCorrectFluid;
        }
        if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluidStack.getFluid())) {
            boolean isCorrectFluid;
            boolean bl = isCorrectFluid = this.stats.getFuelFluid() == null ? true : FluidUtils.areFluidsSameType((ResourceLocation)this.stats.getFuelFluid(), (Fluid)fluidStack.getFluid());
            if (this.stats.getFuelFluid() == null && isCorrectFluid) {
                this.stats.setFuelFluid(fluidStack.getFluid().getRegistryName());
            }
            return isCorrectFluid;
        }
        if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluidStack.getFluid())) {
            boolean isCorrectFluid;
            boolean bl = isCorrectFluid = this.stats.getOxidizerFluid() == null ? true : FluidUtils.areFluidsSameType((ResourceLocation)this.stats.getOxidizerFluid(), (Fluid)fluidStack.getFluid());
            if (this.stats.getOxidizerFluid() == null && isCorrectFluid) {
                this.stats.setOxidizerFluid(fluidStack.getFluid().getRegistryName());
            }
            return isCorrectFluid;
        }
        return false;
    }

    public void openGui(PlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, packetBuffer -> {
            packetBuffer.writeInt(this.getModularInvType().ordinal());
            packetBuffer.writeInt(this.func_145782_y());
        });
        if (!this.field_70170_p.field_72995_K) {
            RocketInventoryHelper.addPlayerToInventoryBypass(player);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.field_70170_p.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDINTERACT.ordinal()));
            return this.interact(player);
        }
        return ActionResultType.PASS;
    }

    public boolean isBurningFuel() {
        return (this.getFuelAmountMonopropellant() > 0 || this.getFuelAmountBipropellant() > 0 && this.getFuelAmountOxidizer() > 0 || (Boolean)ARConfiguration.getCurrentConfig().rocketRequireFuel.get() == false) && (!this.func_184188_bt().isEmpty() && this.getPassengerMovingForward() > 0.0f || !this.isInOrbit());
    }

    public float getPassengerMovingForward() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof PlayerEntity)) continue;
            return ((PlayerEntity)entity).field_191988_bg;
        }
        return 0.0f;
    }

    private boolean hasHumanPassenger() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof PlayerEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescentPhase() {
        return (Boolean)ARConfiguration.getCurrentConfig().automaticRetroRockets.get() != false && this.isInOrbit() && this.func_226278_cu_() < 300.0 && (this.func_213322_ci().field_72448_b < (double)-0.4f || this.field_70170_p.field_72995_K);
    }

    public boolean isStartupPhase() {
        return (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) < 100 && (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) != -1;
    }

    public float getEnginePower() {
        float mult = 1.0f;
        int countdown = (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER);
        if (countdown > -1 && this.isStartupPhase()) {
            mult = (float)(100 - countdown) / 100.0f;
        }
        if (this.areEnginesRunning()) {
            return mult * Math.max(DimensionManager.getInstance().getDimensionProperties(this.field_70170_p).getAtmosphereDensityAtHeight(this.func_226278_cu_()), 0.05f);
        }
        return 0.0f;
    }

    public boolean areEnginesRunning() {
        return this.func_213322_ci().field_72448_b > 0.0 || this.isDescentPhase() || this.getPassengerMovingForward() > 0.0f || this.isStartupPhase();
    }

    private void runEngines() {
        int engineNum = 0;
        if (this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74362_aa != ParticleStatus.MINIMAL && this.areEnginesRunning()) {
            for (Vector3F<Float> vec : this.stats.getEngineLocations()) {
                AtmosphereHandler handler;
                if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.ALL && this.field_70170_p.func_82737_E() % 10L == 0L && (engineNum < 8 || this.field_70170_p.func_82737_E() / 10L % (long)Math.max(this.stats.getEngineLocations().size() / 8, 1) == (long)(engineNum / 8)) && ((handler = AtmosphereHandler.getOxygenHandler(this.field_70170_p)) == null || handler.getAtmosphereType(this) != null && handler.getAtmosphereType(this).allowsCombustion())) {
                    AdvancedRocketry.proxy.spawnParticle("rocketSmoke", this.field_70170_p, this.func_226277_ct_() + (double)((Float)vec.x).floatValue(), this.func_226278_cu_() + (double)((Float)vec.y).floatValue() - 0.75, this.func_226281_cx_() + (double)((Float)vec.z).floatValue(), 0.0, 0.0, 0.0);
                }
                for (int i = 0; i < 4; ++i) {
                    AdvancedRocketry.proxy.spawnParticle("rocketFlame", this.field_70170_p, this.func_226277_ct_() + (double)((Float)vec.x).floatValue(), this.func_226278_cu_() + (double)((Float)vec.y).floatValue() - 0.75, this.func_226281_cx_() + (double)((Float)vec.z).floatValue(), (this.field_70146_Z.nextFloat() - 0.5f) / 8.0f, -0.75, (this.field_70146_Z.nextFloat() - 0.5f) / 8.0f);
                }
            }
        }
    }

    private BlockPos getTopBlock(BlockPos pos) {
        Chunk chunk = this.field_70170_p.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            if (!this.field_70170_p.func_175623_d(blockpos)) break;
            blockpos = blockpos1;
        }
        return blockpos;
    }

    private Vector3d calculatePullFromPlanets() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double gravityMultiplier = 0.01;
        if (this.spacePosition.world != null) {
            SpacePosition planetSpacePosition = new SpacePosition();
            double acceleration = 100.0 * gravityMultiplier;
            double distanceSq = planetSpacePosition.distanceToSpacePosition2(this.spacePosition);
            double shipAcceleration = acceleration / distanceSq;
            Vector3d vector = this.spacePosition.getNormalVectorTo(planetSpacePosition);
            if (distanceSq > 0.0) {
                x += shipAcceleration * vector.field_72450_a;
                y += shipAcceleration * vector.field_72448_b;
                z += shipAcceleration * vector.field_72449_c;
            }
        } else if (this.spacePosition.star != null) {
            for (IDimensionProperties planet : this.spacePosition.star.getPlanets()) {
                SpacePosition planetSpacePosition = planet.getSpacePosition();
                double acceleration = (double)(planet.getGravitationalMultiplier() * 9.81f) * gravityMultiplier;
                double distanceSq = planet.getSpacePosition().distanceToSpacePosition2(this.spacePosition);
                double shipAcceleration = acceleration / distanceSq;
                Vector3d vector = this.spacePosition.getNormalVectorTo(planetSpacePosition);
                x += shipAcceleration * vector.field_72450_a;
                y += shipAcceleration * vector.field_72448_b;
                z += shipAcceleration * vector.field_72449_c;
            }
            SpacePosition planetSpacePosition = new SpacePosition();
            double acceleration = 100.0 * gravityMultiplier;
            double distanceSq = planetSpacePosition.distanceToSpacePosition2(this.spacePosition);
            double shipAcceleration = acceleration / distanceSq;
            Vector3d vector = this.spacePosition.getNormalVectorTo(planetSpacePosition);
            if (distanceSq > 0.0) {
                x += shipAcceleration * vector.field_72450_a;
                y += shipAcceleration * vector.field_72448_b;
                z += shipAcceleration * vector.field_72449_c;
            }
        }
        return new Vector3d(x, y, z);
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        long deltaTime = this.field_70170_p.func_82737_E() - this.lastWorldTickTicked;
        this.lastWorldTickTicked = this.field_70170_p.func_82737_E();
        if (this.field_70173_aa == 20) {
            Iterator itr = new LinkedList(this.infrastructureCoords).listIterator();
            while (itr.hasNext()) {
                HashedBlockPosition temp = (HashedBlockPosition)itr.next();
                TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(temp.x, (int)temp.y, temp.z));
                if (!(tile instanceof IInfrastructure)) continue;
                this.linkInfrastructure((IInfrastructure)tile);
            }
            if (this.field_70170_p.field_72995_K) {
                LibVulpes.proxy.playSound((Object)new SoundRocketEngine(AudioRegistry.combustionRocket, SoundCategory.NEUTRAL, this));
            } else {
                BlockPos pos;
                int z;
                int rocketSizeX = this.storage.getSizeX() / 2 + 1;
                int rocketSizeZ = this.storage.getSizeZ() / 2 + 1;
                int bufferSize = 3;
                boolean safeLanding = false;
                int x = (int)this.func_226277_ct_() - rocketSizeX;
                while ((double)x < this.func_226277_ct_() + (double)rocketSizeX && !safeLanding) {
                    z = (int)this.func_226281_cx_() - rocketSizeZ;
                    while ((double)z < this.func_226281_cx_() + (double)rocketSizeZ && !safeLanding) {
                        pos = new BlockPos((double)x, this.func_226278_cu_(), (double)z);
                        safeLanding = !this.field_70170_p.func_180495_p(pos = this.getTopBlock(pos)).func_185904_a().func_76224_d() || this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
                        ++z;
                    }
                    ++x;
                }
                if (!safeLanding) {
                    x = (int)this.func_226277_ct_() - rocketSizeX - 3;
                    while ((double)x < this.func_226277_ct_() + (double)rocketSizeX + 3.0) {
                        z = (int)this.func_226281_cx_() - rocketSizeZ - 3;
                        while ((double)z < this.func_226281_cx_() + (double)rocketSizeZ + 3.0) {
                            pos = new BlockPos((double)x, this.func_226278_cu_(), (double)z);
                            pos = this.getTopBlock(pos);
                            this.field_70170_p.func_175656_a(pos, AdvancedRocketryBlocks.blockLandingFloat.func_176223_P());
                            ++z;
                        }
                        ++x;
                    }
                }
            }
        }
        if (this.field_70173_aa > DESCENT_TIMER && this.isInOrbit() && !this.isInFlight()) {
            this.setInFlight(true);
        }
        if (!this.field_70170_p.field_72995_K && (this.isInFlight() || this.isInOrbit()) && this.field_70173_aa == 20) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
            PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.ROCKETLANDEVENT.ordinal()), (World)this.field_70170_p, (int)((int)this.func_226277_ct_()), (int)((int)this.func_226278_cu_()), (int)((int)this.func_226281_cx_()), (double)64.0);
            for (Entity riddenByEntity : this.func_184188_bt()) {
                PlayerEntity player;
                if (!(riddenByEntity instanceof PlayerEntity) || !((player = (PlayerEntity)riddenByEntity) instanceof PlayerEntity)) continue;
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.FORCEMOUNT.ordinal()), (PlayerEntity)player);
            }
        }
        if (this.getRCS() && this.rcs_mode_counter < 100) {
            ++this.rcs_mode_counter;
        } else if (!this.getRCS() && this.rcs_mode_counter > 0) {
            --this.rcs_mode_counter;
            this.field_70177_z = 0.0f;
        }
        int launchCount = (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER);
        if (launchCount >= 0) {
            if (launchCount == 0) {
                this.launch();
            }
            this.field_70180_af.func_187227_b(LAUNCH_COUNTER, (Object)(--launchCount));
            if (launchCount == 20 && ((Boolean)ARConfiguration.getCurrentConfig().launchingDestroysBlocks.get()).booleanValue()) {
                this.damageGroundBelowRocket(this.field_70170_p, (int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_(), (int)Math.pow(this.stats.getThrust(), 0.3333));
            }
        }
        if (this.getInSpaceFlight()) {
            double distanceFromPlanetToLeaveOrbitMult = 16.0;
            double motionX = this.func_213322_ci().field_72450_a;
            double motionY = this.func_213322_ci().field_72448_b;
            double motionZ = this.func_213322_ci().field_72449_c;
            this.field_70177_z += (float)((this.turningRight ? 5 : 0) - (this.turningLeft ? 5 : 0));
            double acc = (double)(10.0f * this.getPassengerMovingForward()) * 0.2;
            float yawAngle = (float)((double)this.field_70177_z * Math.PI / 180.0);
            Vector3d planetPull = Vector3d.field_186680_a;
            motionX += acc * (double)MathHelper.func_76126_a((float)(-yawAngle)) + planetPull.field_72450_a;
            motionY += (this.turningUp ? 0.02 : 0.0) - (this.turningDownforWhat ? 0.02 : 0.0) + planetPull.field_72448_b;
            motionZ += acc * (double)MathHelper.func_76134_b((float)(-yawAngle)) + planetPull.field_72449_c;
            if (acc == 0.0) {
                motionX *= 0.98;
                motionY *= 0.98;
                motionZ *= 0.98;
            }
            this.func_213293_j(motionX, motionY, motionZ);
            this.spacePosition.x += motionX;
            this.spacePosition.y += motionY;
            this.spacePosition.z += motionZ;
            if (this.spacePosition.world == null && this.spacePosition.star != null) {
                for (IDimensionProperties properties : this.spacePosition.star.getPlanets()) {
                    SpacePosition worldSpacePosition = properties.getSpacePosition();
                    double d = this.spacePosition.distanceToSpacePosition2(worldSpacePosition);
                    if (!(d < (double)(properties.getRenderSizeSolarView() * properties.getRenderSizeSolarView() * 8.0f))) continue;
                    this.spacePosition.world = (DimensionProperties)properties;
                    double radius = -properties.getRenderSizePlanetView() * 16.0f;
                    SpacePosition planetPosition = new SpacePosition();
                    double theta = Math.atan2(this.func_213322_ci().field_72449_c, this.func_213322_ci().field_72450_a);
                    this.spacePosition.x = planetPosition.x + Math.cos(theta) * radius;
                    this.spacePosition.y = planetPosition.y;
                    this.spacePosition.z = planetPosition.z + Math.sin(theta) * radius;
                    PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDSPACEPOS.ordinal()));
                    break;
                }
            } else if (this.spacePosition.world != null) {
                double distanceSq = this.spacePosition.distanceToSpacePosition2(new SpacePosition());
                if (!this.field_70170_p.field_72995_K) {
                    if (distanceSq < (double)(0.5f * this.spacePosition.world.getRenderSizePlanetView() * this.spacePosition.world.getRenderSizePlanetView())) {
                        this.destinationDimId = this.spacePosition.world.getId();
                        this.setRCS(false);
                        this.func_213293_j(0.0, 1.0, 0.0);
                        this.field_70177_z = 0.0f;
                        this.rcs_mode = false;
                        this.reachSpaceManned();
                        this.setInSpaceFlight(false);
                    } else {
                        for (ResourceLocation resourceLocation : this.spacePosition.world.getChildPlanets()) {
                            List<ISpaceObject> stations;
                            DimensionProperties subPlanetProperties = DimensionManager.getInstance().getDimensionProperties(resourceLocation);
                            distanceSq = this.spacePosition.distanceToSpacePosition2(subPlanetProperties.getSpacePosition());
                            if (distanceSq < (double)(0.5f * subPlanetProperties.getRenderSizePlanetView() * subPlanetProperties.getRenderSizePlanetView())) {
                                this.destinationDimId = subPlanetProperties.getId();
                                this.setRCS(false);
                                this.rcs_mode = false;
                                this.field_70177_z = 0.0f;
                                this.reachSpaceManned();
                                this.setInSpaceFlight(false);
                            }
                            if ((stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(resourceLocation)) == null) continue;
                            for (ISpaceObject station : stations) {
                                distanceSq = this.spacePosition.distanceToSpacePosition2(((SpaceStationObject)station).getSpacePosition());
                                if (!(distanceSq < 10000.0)) continue;
                                this.destinationDimId = ARConfiguration.GetSpaceDimId();
                                this.storage.getGuidanceComputer().overrideLandingStation(station);
                                this.setRCS(false);
                                this.field_70177_z = 0.0f;
                                this.rcs_mode = false;
                                this.reachSpaceManned();
                                this.setInSpaceFlight(false);
                            }
                        }
                    }
                    List<ISpaceObject> stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(this.spacePosition.world.getId());
                    if (stations != null) {
                        for (ISpaceObject station : stations) {
                            distanceSq = this.spacePosition.distanceToSpacePosition2(((SpaceStationObject)station).getSpacePosition());
                            if (!(distanceSq < 10000.0)) continue;
                            this.destinationDimId = ARConfiguration.GetSpaceDimId();
                            this.storage.getGuidanceComputer().overrideLandingStation(station);
                            this.setRCS(false);
                            this.rcs_mode = false;
                            this.reachSpaceManned();
                            this.setInSpaceFlight(false);
                        }
                    }
                } else if (distanceSq > (double)(this.spacePosition.world.getRenderSizePlanetView() * this.spacePosition.world.getRenderSizePlanetView()) * distanceFromPlanetToLeaveOrbitMult * distanceFromPlanetToLeaveOrbitMult) {
                    double radius = this.spacePosition.world.getRenderSizeSolarView() * 10.0f;
                    SpacePosition planetPosition = this.spacePosition.world.getSpacePosition();
                    this.spacePosition.world = null;
                    double theta = Math.atan2(this.func_213322_ci().field_72449_c, this.func_213322_ci().field_72450_a);
                    this.spacePosition.x = planetPosition.x + Math.cos(theta) * radius;
                    this.spacePosition.y = planetPosition.y;
                    this.spacePosition.z = planetPosition.z + Math.sin(theta) * radius;
                    this.func_213293_j(0.0, 0.0, 0.0);
                }
            }
            if (this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 20L == 0L) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDSPACEPOS.ordinal()));
            }
        } else if (this.isInFlight()) {
            boolean burningFuel = this.isBurningFuel();
            boolean descentPhase = this.isDescentPhase();
            double motionX = this.func_213322_ci().field_72450_a;
            double motionY = this.func_213322_ci().field_72448_b;
            double motionZ = this.func_213322_ci().field_72449_c;
            if (burningFuel || descentPhase) {
                if (!this.field_70170_p.field_72995_K && !descentPhase) {
                    this.setFuelAmountBipropellant(this.getFuelAmountBipropellant() - this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT));
                    this.setFuelAmountOxidizer(this.getFuelAmountOxidizer() - this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER));
                    this.setFuelAmountMonoproellant(this.getFuelAmountMonopropellant() - this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT));
                    if (this.getFuelAmountBipropellant() == 0 && this.getFuelAmountMonopropellant() == 0) {
                        this.stats.setFuelFluid(null);
                    }
                    if (this.getFuelAmountOxidizer() == 0) {
                        this.stats.setOxidizerFluid(null);
                    }
                }
                this.runEngines();
            }
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity entity : this.func_184188_bt()) {
                    entity.field_70143_R = 0.0f;
                    this.field_70143_R = 0.0f;
                }
                if (this.isInOrbit() && (burningFuel || descentPhase)) {
                    float vel = descentPhase ? 1.0f : this.getPassengerMovingForward();
                    motionY -= motionY * (double)vel / 50.0;
                }
                this.field_70133_I = true;
            } else if (this.isInOrbit() && descentPhase) {
                motionY -= motionY / 50.0;
                this.field_70133_I = true;
            }
            if (!this.field_70170_p.field_72995_K) {
                boolean landedOnGround;
                motionY = this.isInOrbit() || !burningFuel ? Math.min(motionY - 0.001, 1.0) : (motionY += (double)(this.stats.getAcceleration(DimensionManager.getInstance().getDimensionProperties(this.field_70170_p).getGravitationalMultiplier()) * (float)deltaTime));
                double lastPosY = this.func_226278_cu_();
                double prevMotion = motionY;
                this.func_213315_a(MoverType.SELF, new Vector3d(0.0, prevMotion * (double)deltaTime, 0.0));
                boolean landedInSpace = DimensionManager.getInstance().getDimensionProperties(this.field_70170_p).isAsteroid() && this.func_226278_cu_() < 64.0;
                boolean bl = landedOnGround = lastPosY + prevMotion != this.func_226278_cu_() && this.func_226278_cu_() < 256.0;
                if ((this.isInOrbit() || !burningFuel) && this.isInFlight() && (landedOnGround || landedInSpace)) {
                    PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.ROCKETLANDEVENT.ordinal()), (Entity)this);
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
                    motionY = 0.0;
                    this.setInFlight(false);
                    this.setInOrbit(false);
                }
                if (!this.isInOrbit() && this.func_226278_cu_() > (double)this.stats.orbitHeight) {
                    this.onOrbitReached();
                }
                this.func_213293_j(motionX, motionY, motionZ);
                if (this.func_226278_cu_() < 0.0) {
                    ResourceLocation dimId = ZUtils.getDimensionIdentifier((World)this.field_70170_p);
                    if (ARConfiguration.GetSpaceDimId().equals((Object)dimId)) {
                        ISpaceObject iSpaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos(this.func_213303_ch()));
                        if (iSpaceObject != null) {
                            ResourceLocation targetDimID = iSpaceObject.getOrbitingPlanetId();
                            Vector3F<Float> pos = this.storage.getDestinationCoordinates(targetDimID, true);
                            if (pos != null) {
                                this.setInOrbit(true);
                                this.setInFlight(false);
                                this.changeDimension(ZUtils.getWorld((ResourceLocation)targetDimID), ((Float)pos.x).floatValue(), this.getEntryHeight(targetDimID), ((Float)pos.z).floatValue());
                            } else {
                                this.func_70106_y();
                            }
                        } else {
                            Vector3F<Float> pos = this.storage.getDestinationCoordinates(Constants.INVALID_PLANET, true);
                            if (pos != null) {
                                this.setInOrbit(true);
                                this.setInFlight(false);
                                this.changeDimension(ZUtils.getWorld((ResourceLocation)this.lastDimensionFrom), ((Float)pos.x).floatValue(), ((Integer)ARConfiguration.getCurrentConfig().orbit.get()).intValue(), ((Float)pos.z).floatValue());
                            } else {
                                this.func_70106_y();
                            }
                        }
                    } else {
                        this.func_70106_y();
                    }
                }
            } else {
                this.func_213315_a(MoverType.SELF, new Vector3d(0.0, this.func_213322_ci().field_72448_b, 0.0));
            }
        } else if (DimensionManager.getInstance().getDimensionProperties(this.field_70170_p).isAsteroid() && this.getRCS()) {
            double motionX = this.func_213322_ci().field_72450_a;
            double motionY = this.func_213322_ci().field_72448_b;
            double motionZ = this.func_213322_ci().field_72449_c;
            this.field_70177_z += (float)((this.turningRight ? 5 : 0) - (this.turningLeft ? 5 : 0));
            double acc = (double)this.getPassengerMovingForward() * 0.02;
            float yawAngle = (float)((double)this.field_70177_z * Math.PI / 180.0);
            motionX += acc * (double)MathHelper.func_76126_a((float)(-yawAngle));
            motionY += (this.turningUp ? 0.02 : 0.0) - (this.turningDownforWhat ? 0.02 : 0.0);
            motionZ += acc * (double)MathHelper.func_76134_b((float)(-yawAngle));
            this.func_213293_j(motionX *= 0.9, motionY *= 0.9, motionZ *= 0.9);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else if (this.isStartupPhase()) {
            this.runEngines();
        }
        if ((int)this.func_226278_cu_() == this.field_70170_p.func_205770_a(Heightmap.Type.WORLD_SURFACE, this.func_233580_cy_()).func_177956_o() + 2 && ((Boolean)ARConfiguration.getCurrentConfig().launchingDestroysBlocks.get()).booleanValue() && this.isDescentPhase()) {
            this.damageGroundBelowRocket(this.field_70170_p, (int)this.func_226277_ct_(), (int)this.func_226278_cu_() - 1, (int)this.func_226281_cx_(), (int)Math.pow(this.stats.getThrust(), 0.3333));
        }
    }

    public void onTurnRight(boolean state) {
        this.turningRight = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.TURNUPDATE.ordinal()));
    }

    public void onTurnLeft(boolean state) {
        this.turningLeft = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.TURNUPDATE.ordinal()));
    }

    public void onUp(boolean state) {
        this.turningUp = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.TURNUPDATE.ordinal()));
    }

    public void onDown(boolean state) {
        this.turningDownforWhat = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.TURNUPDATE.ordinal()));
    }

    public List<SatelliteBase> getSatellites() {
        ArrayList<SatelliteBase> satellites = new ArrayList<SatelliteBase>();
        for (TileSatelliteHatch tile : this.storage.getSatelliteHatches()) {
            SatelliteBase satellite = tile.getSatellite();
            if (satellite == null) continue;
            satellites.add(satellite);
        }
        return satellites;
    }

    @Override
    public void onOrbitReached() {
        long targetSatellite;
        super.onOrbitReached();
        if (this.storage.getGuidanceComputer() != null && (targetSatellite = this.storage.getGuidanceComputer().getTargetSatellite()) != -1L) {
            SatelliteBase sat = DimensionManager.getInstance().getSatellite(targetSatellite);
            for (TileEntity tile : this.storage.getTileEntityList()) {
                if (!(tile instanceof TileSatelliteHatch) || !((IInventory)tile).func_70301_a(0).func_190926_b()) continue;
                ((IInventory)tile).func_70299_a(0, sat.getItemStackFromSatellite());
                DimensionManager.getInstance().getDimensionProperties(sat.getDimensionId().get()).removeSatellite(targetSatellite);
                break;
            }
            this.func_213293_j(this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
            this.setInOrbit(true);
            return;
        }
        if (!this.stats.hasSeat()) {
            this.reachSpaceUnmanned();
        } else {
            this.reachSpaceManned();
        }
    }

    private int getEntryHeight(ResourceLocation entryLocationDimID) {
        if (entryLocationDimID.func_110623_a() == ARConfiguration.getCurrentConfig().spaceDimId.get()) {
            return (Integer)ARConfiguration.getCurrentConfig().stationClearanceHeight.get();
        }
        return (Integer)ARConfiguration.getCurrentConfig().orbit.get();
    }

    private void reachSpaceUnmanned() {
        TileGuidanceComputer computer = this.storage.getGuidanceComputer();
        if (computer != null && computer.func_70301_a(0) != null && computer.func_70301_a(0).func_77973_b() instanceof ItemAsteroidChip) {
            float drillingPower = this.stats.getDrillingPower();
            float asteroidDrillingMult = 1.0f;
            ItemStack stack = this.storage.getGuidanceComputer().func_70301_a(0);
            AsteroidSmall asteroid = ARConfiguration.getCurrentConfig().asteroidTypes.get(((ItemAsteroidChip)stack.func_77973_b()).getType(stack));
            if (asteroid != null) {
                asteroidDrillingMult = asteroid.timeMultiplier;
            }
            MissionOreMining miningMission = new MissionOreMining((long)((double)asteroidDrillingMult * (Double)ARConfiguration.getCurrentConfig().asteroidMiningTimeMult.get() * (double)(drillingPower == 0.0f ? 36000.0f : 360.0f / this.stats.getDrillingPower())), this, this.connectedInfrastructure);
            DimensionProperties properties = DimensionManager.getEffectiveDimId(this.field_70170_p, new BlockPos(this.func_213303_ch()));
            miningMission.setDimensionId(this.field_70170_p);
            properties.addSatellite(miningMission, this.field_70170_p);
            if (!this.field_70170_p.field_72995_K) {
                PacketHandler.sendToAll((BasePacket)new PacketSatellite(miningMission));
            }
            for (IInfrastructure i : this.connectedInfrastructure) {
                i.linkMission(miningMission);
            }
            this.func_70106_y();
            return;
        }
        this.unpackSatellites();
        this.destinationDimId = this.storage.getDestinationDimId(this.field_70170_p, (int)this.func_226277_ct_(), (int)this.func_226281_cx_());
        if (this.destinationDimId == ZUtils.getDimensionIdentifier((World)this.field_70170_p)) {
            Vector3F<Float> pos = this.storage.getDestinationCoordinates(this.destinationDimId, true);
            this.storage.setDestinationCoordinates((Vector3F<Float>)new Vector3F((Object)Float.valueOf((float)this.func_226277_ct_()), (Object)Float.valueOf((float)this.func_226278_cu_()), (Object)Float.valueOf((float)this.func_226281_cx_())), ZUtils.getDimensionIdentifier((World)this.field_70170_p));
            if (pos != null) {
                this.setInOrbit(true);
                this.func_213293_j(this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                Iterator connectedTiles = this.connectedInfrastructure.iterator();
                while (connectedTiles.hasNext()) {
                    ((IInfrastructure)connectedTiles.next()).unlinkRocket();
                    connectedTiles.remove();
                }
                this.func_70634_a(((Float)pos.x).floatValue(), this.getEntryHeight(this.destinationDimId), ((Float)pos.z).floatValue());
                return;
            }
            if (this.hasHumanPassenger()) {
                this.setInFlight(false);
                pos.y = Float.valueOf(this.getEntryHeight(this.destinationDimId));
            }
            this.setInOrbit(true);
            this.func_213293_j(this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
            Iterator connectedTiles = this.connectedInfrastructure.iterator();
            while (connectedTiles.hasNext()) {
                ((IInfrastructure)connectedTiles.next()).unlinkRocket();
                connectedTiles.remove();
            }
            this.func_70634_a(this.func_226277_ct_(), this.getEntryHeight(this.destinationDimId), this.func_226281_cx_());
            return;
        }
        if (DimensionManager.getInstance().canTravelTo(this.destinationDimId)) {
            Vector3F<Float> pos = this.storage.getDestinationCoordinates(this.destinationDimId, true);
            this.storage.setDestinationCoordinates((Vector3F<Float>)new Vector3F((Object)Float.valueOf((float)this.func_226277_ct_()), (Object)Float.valueOf((float)this.func_226278_cu_()), (Object)Float.valueOf((float)this.func_226281_cx_())), ZUtils.getDimensionIdentifier((World)this.field_70170_p));
            if (pos != null) {
                this.setInOrbit(true);
                this.func_213293_j(this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                this.changeDimension(ZUtils.getWorld((ResourceLocation)this.destinationDimId), ((Float)pos.x).floatValue(), this.getEntryHeight(this.destinationDimId), ((Float)pos.z).floatValue());
                return;
            }
            if (this.hasHumanPassenger()) {
                this.setInFlight(false);
                pos.y = Float.valueOf(this.getEntryHeight(this.destinationDimId));
            }
            this.setInOrbit(true);
            this.func_213293_j(this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
            this.changeDimension(ZUtils.getWorld((ResourceLocation)this.destinationDimId), this.func_226277_ct_(), this.getEntryHeight(this.destinationDimId), this.func_226281_cx_());
            return;
        }
        int offX = this.field_70170_p.field_73012_v.nextInt() % 256 - 128;
        int offZ = this.field_70170_p.field_73012_v.nextInt() % 256 - 128;
        this.setInOrbit(true);
        this.func_213293_j(this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
        this.func_70107_b(this.func_226277_ct_() + (double)offX, this.func_226278_cu_(), this.func_226281_cx_() + (double)offZ);
        Iterator connectedTiles = this.connectedInfrastructure.iterator();
        while (connectedTiles.hasNext()) {
            ((IInfrastructure)connectedTiles.next()).unlinkRocket();
            connectedTiles.remove();
        }
    }

    private void reachSpaceManned() {
        this.unpackSatellites();
        Vector3F destPos = new Vector3F((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        if (((Boolean)ARConfiguration.getCurrentConfig().experimentalSpaceFlight.get()).booleanValue() && this.storage.getGuidanceComputer().func_191420_l() && this.hasHumanPassenger() && !this.getInSpaceFlight()) {
            DimensionProperties currentDim = DimensionManager.getEffectiveDimId(this.field_70170_p, new BlockPos(this.func_213303_ch()));
            while (currentDim.isMoon()) {
                currentDim = currentDim.getParentProperties();
            }
            SpacePosition planetSpacePos = currentDim.getSpacePosition();
            SpacePosition modifiedPosition = new SpacePosition().getFromSpherical((double)currentDim.getRenderSizePlanetView() * 1.1, 0.0);
            this.spacePosition.x = modifiedPosition.x;
            this.spacePosition.y = modifiedPosition.y;
            this.spacePosition.z = modifiedPosition.z;
            this.spacePosition.star = planetSpacePos.star;
            this.spacePosition.world = planetSpacePos.world;
            this.setInSpaceFlight(true);
            this.setRCS(true);
            this.setInOrbit(true);
            this.func_213293_j(0.0, 0.0, 0.0);
            this.destinationDimId = ARConfiguration.GetSpaceDimId();
            destPos.x = Float.valueOf(0.0f);
            destPos.y = Float.valueOf(this.getEntryHeight(this.destinationDimId));
            destPos.z = Float.valueOf(0.0f);
            for (Entity e : this.func_184188_bt()) {
                if (!(e instanceof PlayerEntity)) continue;
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDSPACEPOS.ordinal()), (PlayerEntity)((PlayerEntity)e));
            }
        } else {
            this.func_213293_j(this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
            this.setInOrbit(true);
            if ((ARConfiguration.GetSpaceDimId().equals((Object)this.destinationDimId) || ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_70170_p)) && !this.getInSpaceFlight()) && ZUtils.getDimensionIdentifier((World)this.field_70170_p) != this.destinationDimId) {
                Vector3F<Float> pos = this.storage.getDestinationCoordinates(this.destinationDimId, true);
                this.storage.setDestinationCoordinates((Vector3F<Float>)new Vector3F((Object)Float.valueOf((float)this.func_226277_ct_()), (Object)Float.valueOf((float)this.func_226278_cu_()), (Object)Float.valueOf((float)this.func_226281_cx_())), ZUtils.getDimensionIdentifier((World)this.field_70170_p));
                if (pos != null) {
                    if (this.hasHumanPassenger()) {
                        this.setInFlight(false);
                        pos.y = Float.valueOf(this.getEntryHeight(this.destinationDimId));
                    }
                    this.changeDimension(ZUtils.getWorld((ResourceLocation)this.destinationDimId), ((Float)pos.x).floatValue(), ((Float)pos.y).floatValue(), ((Float)pos.z).floatValue());
                    return;
                }
            }
            if ((destPos = this.storage.getDestinationCoordinates(this.destinationDimId, true)) == null) {
                destPos = new Vector3F((Object)Float.valueOf((float)this.func_226277_ct_()), (Object)Float.valueOf(this.getEntryHeight(this.destinationDimId)), (Object)Float.valueOf((float)this.func_226281_cx_()));
            }
            if (this.hasHumanPassenger()) {
                this.setInFlight(false);
                if (DimensionManager.getInstance().getDimensionProperties(this.destinationDimId).getName().equals("Luna")) {
                    for (Entity player : this.func_184188_bt()) {
                        if (!(player instanceof PlayerEntity)) continue;
                        ARAdvancements.triggerAchievement(ARAdvancements.MOON_LANDING, (ServerPlayerEntity)player);
                        if (DimensionManager.hasReachedMoon) continue;
                        ARAdvancements.triggerAchievement(ARAdvancements.ONE_SMALL_STEP, (ServerPlayerEntity)player);
                    }
                    DimensionManager.hasReachedMoon = true;
                }
            }
            destPos.y = Float.valueOf(this.getEntryHeight(this.destinationDimId));
        }
        this.setOverriddenCoords(Constants.INVALID_PLANET, 0.0f, 0.0f, 0.0f);
        if (this.destinationDimId != ZUtils.getDimensionIdentifier((World)this.field_70170_p)) {
            this.changeDimension(!DimensionManager.getInstance().isDimensionCreated(ZUtils.getDimensionIdentifier((World)this.field_70170_p)) ? ZUtils.getWorld((ResourceLocation)DimensionManager.defaultSpaceDimensionProperties.getId()) : ZUtils.getWorld((ResourceLocation)this.destinationDimId), ((Float)destPos.x).floatValue(), this.getEntryHeight(this.destinationDimId), ((Float)destPos.z).floatValue());
        } else {
            List eList = this.func_184188_bt();
            for (Entity e : eList) {
                e.func_184210_p();
                e.func_70634_a((double)((Float)destPos.x).floatValue(), (double)((Float)destPos.y).floatValue(), (double)((Float)destPos.z).floatValue());
            }
            this.func_70634_a(((Float)destPos.x).floatValue(), ((Float)destPos.y).floatValue(), ((Float)destPos.z).floatValue());
            this.field_70173_aa = 0;
            ((ServerWorld)this.field_70170_p).func_82742_i();
            for (Entity e : eList) {
                e.func_184205_a((Entity)this, true);
            }
        }
    }

    private void unpackSatellites() {
        List<TileSatelliteHatch> satelliteHatches = this.storage.getSatelliteHatches();
        for (TileSatelliteHatch tile : satelliteHatches) {
            SatelliteBase satellite = tile.getSatellite();
            if (satellite == null) {
                ItemStack stack = tile.func_70301_a(0);
                if (stack == null || stack.func_77973_b() != AdvancedRocketryItems.itemSpaceStation) continue;
                StorageChunk storage = ((ItemPackedStructure)stack.func_77973_b()).getStructure(stack);
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(stack));
                if (object == null) {
                    tile.func_70299_a(0, ItemStack.field_190927_a);
                    continue;
                }
                SpaceObjectManager.getSpaceManager().moveStationToBody(object, DimensionManager.getEffectiveDimId(ZUtils.getDimensionIdentifier((World)this.field_70170_p), new BlockPos(this.func_213303_ch())).getId());
                object.onModuleUnpack(storage);
                tile.func_70299_a(0, ItemStack.field_190927_a);
                continue;
            }
            ResourceLocation destinationId = this.storage.getDestinationDimId(ZUtils.getDimensionIdentifier((World)this.field_70170_p), (int)this.func_226277_ct_(), (int)this.func_226281_cx_());
            DimensionProperties properties = DimensionManager.getEffectiveDimId(ZUtils.getDimensionIdentifier((World)this.field_70170_p), new BlockPos(this.func_213303_ch()));
            ResourceLocation world2 = ARConfiguration.GetSpaceDimId().equals((Object)destinationId) || Constants.INVALID_PLANET.equals((Object)destinationId) ? properties.getId() : destinationId;
            properties.addSatellite(satellite, world2, this.field_70170_p.field_72995_K);
            tile.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void prepareLaunch() {
        if ((Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) > 0) {
            this.field_70180_af.func_187227_b(LAUNCH_COUNTER, (Object)-1);
            if (this.field_70170_p.field_72995_K) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.ABORTLAUNCH.ordinal()));
            }
            return;
        }
        if (this.isInOrbit()) {
            this.setInFlight(true);
            return;
        }
        RocketEvent.RocketPreLaunchEvent event = new RocketEvent.RocketPreLaunchEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (this.field_70170_p.field_72995_K) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.LAUNCH.ordinal()));
            }
            this.field_70180_af.func_187227_b(LAUNCH_COUNTER, (Object)200);
        }
    }

    @Override
    public void launch() {
        if (this.isInFlight()) {
            return;
        }
        boolean allowLaunch = false;
        if (!((Boolean)ARConfiguration.getCurrentConfig().experimentalSpaceFlight.get()).booleanValue() || this.storage.getGuidanceComputer() == null || !this.storage.getGuidanceComputer().func_191420_l()) {
            ISpaceObject object;
            this.destinationDimId = this.storage.getDestinationDimId(this.field_70170_p, (int)this.func_226277_ct_(), (int)this.func_226281_cx_());
            if (!(DimensionManager.getInstance().canTravelTo(this.destinationDimId) || Constants.INVALID_PLANET.equals((Object)this.destinationDimId) && this.storage.getSatelliteHatches().size() != 0)) {
                this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.cannotgetthere"));
                return;
            }
            ResourceLocation finalDest = this.destinationDimId;
            if (ARConfiguration.GetSpaceDimId().equals((Object)this.destinationDimId)) {
                ISpaceObject obj = null;
                Vector3F<Float> vec = this.storage.getDestinationCoordinates(this.destinationDimId, false);
                if (vec != null) {
                    obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos((double)((Float)vec.x).floatValue(), (double)((Float)vec.y).floatValue(), (double)((Float)vec.z).floatValue()));
                }
                if (obj != null) {
                    finalDest = obj.getOrbitingPlanetId();
                } else {
                    this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.destinationnotexist"));
                    return;
                }
            }
            ResourceLocation thisDimId = ZUtils.getDimensionIdentifier((World)this.field_70170_p);
            if (ARConfiguration.GetSpaceDimId().equals((Object)thisDimId) && (object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos(this.func_213303_ch()))) != null) {
                thisDimId = object.getProperties().getParentProperties().getId();
            }
            if (!(Constants.INVALID_PLANET.equals((Object)finalDest) || this.storage.hasWarpCore() && DimensionManager.getInstance().getDimensionProperties(thisDimId).getStarId().equals((Object)DimensionManager.getInstance().getDimensionProperties(finalDest).getStarId()) || PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(finalDest, thisDimId))) {
                this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.notsamesystem"));
                return;
            }
        } else {
            allowLaunch = true;
        }
        int n = this.stats.orbitHeight = this.storage.getGuidanceComputer() == null ? this.getEntryHeight(ZUtils.getDimensionIdentifier((World)this.field_70170_p)) : this.storage.getGuidanceComputer().getLaunchSequence(ZUtils.getDimensionIdentifier((World)this.field_70170_p), this.func_233580_cy_());
        if (allowLaunch || !this.stats.hasSeat() || DimensionManager.getInstance().isDimensionCreated(this.destinationDimId) || ARConfiguration.GetSpaceDimId().equals((Object)this.destinationDimId) || Constants.INVALID_PLANET.equals((Object)this.destinationDimId)) {
            this.setInFlight(true);
            Iterator connectedTiles = this.connectedInfrastructure.iterator();
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
            while (connectedTiles.hasNext()) {
                IInfrastructure i = (IInfrastructure)connectedTiles.next();
                if (!i.disconnectOnLiftOff()) continue;
                this.disconnectInfrastructure(i);
                connectedTiles.remove();
            }
        }
        if (((Boolean)ARConfiguration.getCurrentConfig().launchingDestroysBlocks.get()).booleanValue()) {
            this.damageGroundBelowRocket(this.field_70170_p, (int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_(), (int)Math.pow(this.stats.getThrust(), 0.3333));
        }
    }

    private void damageGroundBelowRocket(World world, int x, int y, int z, int radius) {
        --y;
        for (int i = 0; i <= radius; ++i) {
            for (int j = 0; j <= radius; ++j) {
                for (int k = 1; k >= -2; --k) {
                    BlockPos blocksAbove;
                    EntityRocket.setDamagedBlock(EntityRocket.getDamagedBlock(world.func_180495_p(new BlockPos(x + i, y + k, z + j))), world, new BlockPos(x + i, y + k, z + j));
                    if (j != 0) {
                        EntityRocket.setDamagedBlock(EntityRocket.getDamagedBlock(world.func_180495_p(new BlockPos(x + i, y + k, z - j))), world, new BlockPos(x + i, y + k, z - j));
                    }
                    if (i != 0) {
                        EntityRocket.setDamagedBlock(EntityRocket.getDamagedBlock(world.func_180495_p(new BlockPos(x - i, y + k, z + j))), world, new BlockPos(x - i, y + k, z + j));
                        if (j != 0) {
                            EntityRocket.setDamagedBlock(EntityRocket.getDamagedBlock(world.func_180495_p(new BlockPos(x - i, y + k, z - j))), world, new BlockPos(x - i, y + k, z - j));
                        }
                    }
                    if (!world.func_180495_p(blocksAbove = new BlockPos(x + i, y + k, z + j)).func_185904_a().func_76222_j() && world.func_180495_p(blocksAbove).func_177230_c() != Blocks.field_150350_a) continue;
                    world.func_175656_a(blocksAbove, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    private static BlockState getDamagedBlock(BlockState blockState) {
        boolean isRegolith = blockState.func_177230_c() == AdvancedRocketryBlocks.blockMoonTurf || blockState.func_177230_c() == AdvancedRocketryBlocks.blockMoonTurfDark;
        Material material = blockState.func_185904_a();
        if (ZUtils.isBlockTag((Block)blockState.func_177230_c(), (ResourceLocation)new ResourceLocation("minecraft:stone"))) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (ZUtils.isBlockTag((Block)blockState.func_177230_c(), (ResourceLocation)new ResourceLocation("minecraft:cobblestone")) || ZUtils.isBlockTag((Block)blockState.func_177230_c(), (ResourceLocation)new ResourceLocation("minecraft:stone"))) {
            return AdvancedRocketryBlocks.blockBasalt.func_176223_P();
        }
        if (blockState.func_177230_c() == AdvancedRocketryBlocks.blockBasalt) {
            return Blocks.field_196814_hQ.func_176223_P();
        }
        if (blockState.func_177230_c() == Blocks.field_150424_aL) {
            return Blocks.field_196814_hQ.func_176223_P();
        }
        if (blockState.func_177230_c() == Blocks.field_196814_hQ) {
            return Blocks.field_150353_l.func_176223_P();
        }
        if (blockState.func_177230_c() == Blocks.field_196658_i) {
            return Blocks.field_150346_d.func_176223_P();
        }
        if (material == Material.field_151578_c && !isRegolith) {
            return Blocks.field_150354_m.func_176223_P();
        }
        if (blockState.func_177230_c() instanceof SandBlock || ZUtils.isBlockTag((Block)blockState.func_177230_c(), (ResourceLocation)new ResourceLocation("advancedrocketry:regolith"))) {
            return Blocks.field_150359_w.func_176223_P();
        }
        if (material == Material.field_151588_w || material == Material.field_151598_x || (material == Material.field_151597_y || material == Material.field_151596_z) && blockState.func_177230_c() != Blocks.field_150433_aE) {
            return Blocks.field_150355_j.func_176223_P();
        }
        if (material == Material.field_151586_h || blockState.func_177230_c() == Blocks.field_150433_aE) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (material == Material.field_151575_d || material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151572_C || material == Material.field_151569_G || material == Material.field_151580_n || material == Material.field_151593_r || material == Material.field_151570_A || material == Material.field_151583_m) {
            return Blocks.field_150480_ab.func_176223_P();
        }
        return blockState;
    }

    private static void setDamagedBlock(BlockState blockState, World world, BlockPos position) {
        if (blockState != world.func_180495_p(position)) {
            world.func_175656_a(position, blockState);
        }
    }

    @Override
    public void deconstructRocket() {
        super.deconstructRocket();
        for (IInfrastructure infrastructure : this.connectedInfrastructure) {
            infrastructure.unlinkRocket();
        }
        this.storage.pasteInWorld(this.field_70170_p, (int)(this.func_226277_ct_() - (double)((float)this.storage.getSizeX() / 2.0f)), (int)this.func_226278_cu_(), (int)(this.func_226281_cx_() - (double)((float)this.storage.getSizeZ() / 2.0f)));
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        Iterator connectedTiles = this.connectedInfrastructure.iterator();
        while (connectedTiles.hasNext()) {
            ((IInfrastructure)connectedTiles.next()).unlinkRocket();
            connectedTiles.remove();
        }
    }

    public void setOverriddenCoords(ResourceLocation dimId, float x, float y, float z) {
        TileGuidanceComputer tile = this.storage.getGuidanceComputer();
        if (tile != null) {
            tile.setFallbackDestination(dimId, (Vector3F<Float>)new Vector3F((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z)));
        }
    }

    public Entity func_241206_a_(ServerWorld newDimId) {
        return this.changeDimension(newDimId, this.func_226277_ct_(), this.getEntryHeight(ZUtils.getDimensionIdentifier((World)newDimId)), this.func_226281_cx_());
    }

    @Nullable
    public Entity changeDimension(ServerWorld dimensionIn, double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (!DimensionManager.getInstance().canTravelTo(dimensionIn)) {
                AdvancedRocketry.logger.warn("Rocket trying to travel from Dim" + ZUtils.getDimensionIdentifier((World)this.field_70170_p) + " to Dim " + dimensionIn + ".  target not accessible by rocket from launch dim");
                return null;
            }
            this.lastDimensionFrom = ZUtils.getDimensionIdentifier((World)this.field_70170_p);
            List passengers = this.func_184188_bt();
            ServerWorld worldserver = (ServerWorld)this.field_70170_p;
            ServerWorld worldserver1 = dimensionIn;
            PortalInfo info = new PortalInfo(new Vector3d(x, y, z), this.func_213322_ci(), this.field_70177_z, this.field_70125_A);
            TeleporterNoPortal teleporter = new TeleporterNoPortal(worldserver1, info);
            Entity entity = this.changeDimension(dimensionIn, teleporter);
            if (entity == null) {
                return null;
            }
            int timeOffset = 1;
            for (Entity e : passengers) {
                PlanetEventHandler.addDelayedTransition(new TransitionEntity(worldserver.func_82737_E() + (long)(++timeOffset), e, dimensionIn, new BlockPos(x, y, z), entity));
            }
            return entity;
        }
        return null;
    }

    public void func_180432_n(Entity entityIn) {
        super.func_180432_n(entityIn);
        this.func_184188_bt().clear();
    }

    protected void readNetworkableNBT(CompoundNBT nbt) {
        this.func_70037_a(nbt);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.mySize;
    }

    private void setSize(float x, float z) {
        this.mySize = new EntitySize(x, z, false);
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.isInOrbit = nbt.func_74767_n("orbit");
        this.setInOrbit(this.isInOrbit);
        this.rcs_mode_counter = nbt.func_74762_e("rcs_mode_cnt");
        this.setInSpaceFlight(nbt.func_74767_n("inSpaceFlight"));
        this.rcs_mode = nbt.func_74767_n("rcs_mode") || this.getInSpaceFlight();
        this.setRCS(this.rcs_mode);
        this.stats.readFromNBT(nbt);
        this.setFuelAmountMonoproellant(this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT));
        this.setFuelAmountBipropellant(this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID_BIPROPELLANT));
        this.setFuelAmountOxidizer(this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER));
        this.isInFlight = nbt.func_74767_n("flight");
        this.setInFlight(this.isInFlight);
        this.readMissionPersistantNBT(nbt);
        if (nbt.func_74764_b("data")) {
            if (this.storage == null) {
                this.storage = new StorageChunk();
            }
            this.storage.readFromNBT(nbt.func_74775_l("data"));
            this.storage.setEntity(this);
            this.setSize(Math.max(this.storage.getSizeX(), this.storage.getSizeZ()), this.storage.getSizeY());
        }
        if (nbt.func_74764_b("infrastructure")) {
            ListNBT tagList = nbt.func_150295_c("infrastructure", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                int[] coords = tagList.func_150305_b(i).func_74759_k("loc");
                this.infrastructureCoords.add(new HashedBlockPosition(coords[0], coords[1], coords[2]));
            }
        }
        if (nbt.func_74764_b("destinationDimId")) {
            this.destinationDimId = new ResourceLocation(nbt.func_74779_i("destinationDimId"));
        }
        if (nbt.func_74764_b("lastDimensionFrom")) {
            this.lastDimensionFrom = new ResourceLocation(nbt.func_74779_i("lastDimensionFrom"));
        }
        if (nbt.func_74764_b("satellite")) {
            CompoundNBT satalliteNbt = nbt.func_74775_l("satellite");
            this.satellite = SatelliteRegistry.createFromNBT(satalliteNbt);
        }
        this.spacePosition.readFromNBT(nbt);
    }

    protected void writeNetworkableNBT(CompoundNBT nbt) {
        this.writeMissionPersistantNBT(nbt);
        nbt.func_74757_a("orbit", this.isInOrbit());
        nbt.func_74757_a("flight", this.isInFlight());
        nbt.func_74757_a("rcs_mode", this.rcs_mode);
        nbt.func_74768_a("rcs_mode_cnt", this.rcs_mode_counter);
        nbt.func_74757_a("inSpaceFlight", this.getInSpaceFlight());
        this.stats.writeToNBT(nbt);
        if (!this.infrastructureCoords.isEmpty()) {
            ListNBT itemList = new ListNBT();
            for (HashedBlockPosition inf : this.infrastructureCoords) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74783_a("loc", new int[]{inf.x, inf.y, inf.z});
                itemList.add((Object)tag);
            }
            nbt.func_218657_a("infrastructure", (INBT)itemList);
        }
        if (this.destinationDimId != null) {
            nbt.func_74778_a("destinationDimId", this.destinationDimId.toString());
        }
        if (this.satellite != null) {
            CompoundNBT satalliteNbt = new CompoundNBT();
            this.satellite.writeToNBT(satalliteNbt);
            satalliteNbt.func_74778_a("DataType", SatelliteRegistry.getKey(this.satellite.getClass()));
            nbt.func_218657_a("satellite", (INBT)satalliteNbt);
        }
        this.spacePosition.writeToNBT(nbt);
    }

    public void writeMissionPersistantNBT(CompoundNBT nbt) {
    }

    public void readMissionPersistantNBT(CompoundNBT nbt) {
    }

    protected void func_213281_b(CompoundNBT nbt) {
        this.writeNetworkableNBT(nbt);
        if (this.storage != null) {
            CompoundNBT blocks = new CompoundNBT();
            this.storage.writeToNBT(blocks);
            nbt.func_218657_a("data", (INBT)blocks);
        }
        if (this.lastDimensionFrom != null) {
            nbt.func_74778_a("lastDimensionFrom", this.lastDimensionFrom.toString());
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == PacketType.RECIEVENBT.ordinal()) {
            this.storage = new StorageChunk();
            this.storage.setEntity(this);
            this.storage.readFromNetwork(in);
        } else if (packetId == PacketType.SENDPLANETDATA.ordinal()) {
            nbt.func_74778_a("selection", in.func_218666_n());
        } else if (packetId == PacketType.TURNUPDATE.ordinal()) {
            nbt.func_74757_a("left", in.readBoolean());
            nbt.func_74757_a("right", in.readBoolean());
            nbt.func_74757_a("up", in.readBoolean());
            nbt.func_74757_a("down", in.readBoolean());
        } else if (packetId == PacketType.SENDSPACEPOS.ordinal()) {
            boolean hasStar;
            SpacePosition position = new SpacePosition();
            position.x = in.readDouble();
            position.y = in.readDouble();
            position.z = in.readDouble();
            boolean hasWorld = in.readBoolean();
            if (hasWorld) {
                position.world = DimensionManager.getInstance().getDimensionProperties(new ResourceLocation(in.func_218666_n()));
            }
            if (hasStar = in.readBoolean()) {
                position.star = DimensionManager.getInstance().getStar(new ResourceLocation(in.func_218666_n()));
            }
            position.writeToNBT(nbt);
        }
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == PacketType.RECIEVENBT.ordinal()) {
            this.storage.writeToNetwork(out);
        } else if (id == PacketType.SENDPLANETDATA.ordinal()) {
            ItemStack stack;
            if (this.field_70170_p.field_72995_K) {
                out.func_180714_a(this.container.getSelectedSystem().toString());
            } else if (this.storage.getGuidanceComputer() != null && (stack = this.storage.getGuidanceComputer().func_70301_a(0)) != null && stack.func_77973_b() == AdvancedRocketryItems.itemPlanetIdChip) {
                out.func_180714_a(((ItemPlanetIdentificationChip)AdvancedRocketryItems.itemPlanetIdChip).getDimensionId(stack).toString());
            }
        } else if (id == PacketType.TURNUPDATE.ordinal()) {
            out.writeBoolean(this.turningLeft);
            out.writeBoolean(this.turningRight);
            out.writeBoolean(this.turningUp);
            out.writeBoolean(this.turningDownforWhat);
        } else if (id == PacketType.SENDSPACEPOS.ordinal()) {
            out.writeDouble(this.spacePosition.x);
            out.writeDouble(this.spacePosition.y);
            out.writeDouble(this.spacePosition.z);
            boolean hasWorld = this.spacePosition.world != null;
            boolean hasStar = this.spacePosition.star != null;
            out.writeBoolean(hasWorld);
            if (hasWorld) {
                out.func_180714_a(this.spacePosition.world.getId().toString());
            }
            out.writeBoolean(hasStar);
            if (hasStar) {
                out.func_180714_a(this.spacePosition.star.getId().toString());
            }
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == PacketType.RECIEVENBT.ordinal()) {
            this.func_70037_a(nbt);
            this.initFromBounds();
        } else if (id == PacketType.DECONSTRUCT.ordinal()) {
            this.deconstructRocket();
        } else if (id == PacketType.SENDINTERACT.ordinal()) {
            this.interact(player);
        } else if (id == PacketType.OPENGUI.ordinal()) {
            if (player.func_184187_bx() == this) {
                this.openGui(player);
            }
        } else if (id == PacketType.REQUESTNBT.ordinal()) {
            if (this.storage != null) {
                CompoundNBT nbtdata = new CompoundNBT();
                this.writeNetworkableNBT(nbtdata);
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.RECIEVENBT.ordinal(), nbtdata), (PlayerEntity)player);
            }
        } else if (id == PacketType.FORCEMOUNT.ordinal()) {
            if (!this.acceptedPacket) {
                this.acceptedPacket = true;
                player.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
                player.func_184220_m((Entity)this);
                MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
            }
        } else if (id == PacketType.LAUNCH.ordinal()) {
            if (this.func_184188_bt().contains(player)) {
                this.prepareLaunch();
            }
        } else if (id == PacketType.CHANGEWORLD.ordinal()) {
            AdvancedRocketry.proxy.changeClientPlayerWorld(this.storage.world);
        } else if (id == PacketType.REVERTWORLD.ordinal()) {
            AdvancedRocketry.proxy.changeClientPlayerWorld(this.field_70170_p);
        } else if (id == PacketType.OPENPLANETSELECTION.ordinal()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, packetBuffer -> {
                packetBuffer.writeInt(GuiHandler.guiId.MODULARFULLSCREEN.ordinal());
                packetBuffer.writeInt(this.func_145782_y());
            });
        } else if (id == PacketType.SENDPLANETDATA.ordinal()) {
            ItemStack stack = this.storage.getGuidanceComputer().func_70301_a(0);
            if (stack != null && stack.func_77973_b() == AdvancedRocketryItems.itemPlanetIdChip) {
                ((ItemPlanetIdentificationChip)AdvancedRocketryItems.itemPlanetIdChip).setDimensionId(stack, new ResourceLocation(nbt.func_74779_i("selection")));
                if (!this.field_70170_p.field_72995_K) {
                    PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDPLANETDATA.ordinal()), (Entity)this);
                }
            }
        } else if (id == PacketType.DISCONNECTINFRASTRUCTURE.ordinal()) {
            int[] pos = nbt.func_74759_k("pos");
            this.connectedInfrastructure.remove(new HashedBlockPosition(pos[0], pos[1], pos[2]));
            TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
            if (tile instanceof IInfrastructure) {
                ((IInfrastructure)tile).unlinkRocket();
                this.connectedInfrastructure.remove(tile);
            }
        } else if (id == PacketType.ROCKETLANDEVENT.ordinal() && this.field_70170_p.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
        } else if (id == PacketType.DISMOUNTCLIENT.ordinal() && this.field_70170_p.field_72995_K) {
            player.func_184210_p();
        } else if (id == PacketType.TOGGLE_RCS.ordinal() && !this.field_70170_p.field_72995_K) {
            this.toggleRCS();
        } else if (id == PacketType.TURNUPDATE.ordinal()) {
            this.turningLeft = nbt.func_74767_n("left");
            this.turningRight = nbt.func_74767_n("right");
            this.turningUp = nbt.func_74767_n("up");
            this.turningDownforWhat = nbt.func_74767_n("down");
        } else if (id == PacketType.ABORTLAUNCH.ordinal()) {
            this.field_70180_af.func_187227_b(LAUNCH_COUNTER, (Object)-1);
        } else if (id == PacketType.SENDSPACEPOS.ordinal()) {
            this.spacePosition.readFromNBT(nbt);
        } else if (id >= 50 + BUTTON_ID_OFFSET) {
            int id2 = id - (50 + BUTTON_ID_OFFSET) - 1;
            this.setDestLandingPad(id2);
            if (!this.field_70170_p.field_72995_K) {
                PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, id), (Entity)this);
            }
        } else if (id > BUTTON_ID_OFFSET) {
            TileEntity tile = this.storage.getGUItiles().get(id - BUTTON_ID_OFFSET - this.tilebuttonOffset);
            PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.CHANGEWORLD.ordinal()), (PlayerEntity)player);
            this.storage.func_180495_p(tile.func_174877_v()).func_177230_c().func_225533_a_(this.storage.func_180495_p(tile.func_174877_v()), (World)this.storage.world, tile.func_174877_v(), player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.DOWN, tile.func_174877_v(), false));
            PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.REVERTWORLD.ordinal()), (PlayerEntity)player);
        }
    }

    private void setDestLandingPad(int padIndex) {
        ResourceLocation uuid;
        ItemStack slot0 = this.storage.getGuidanceComputer().func_70301_a(0);
        if (slot0 != null && slot0.func_77973_b() instanceof ItemStationChip && !Constants.INVALID_PLANET.equals((Object)(uuid = ItemStationChip.getUUID(slot0)))) {
            StationLandingLocation location;
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStation(uuid);
            if (obj instanceof SpaceStationObject) {
                if (padIndex == -1) {
                    this.storage.getGuidanceComputer().setLandingLocation(uuid, null);
                } else {
                    location = ((SpaceStationObject)obj).getLandingPads().get(padIndex);
                    if (location != null && !location.getOccupied()) {
                        this.storage.getGuidanceComputer().setLandingLocation(uuid, location);
                    }
                }
            }
            this.landingPadDisplayText.setText((location = this.storage.getGuidanceComputer().getLandingLocation(uuid)) != null ? location.toString() : "None Selected");
        }
    }

    public void func_184232_k(Entity entity) {
        if (entity != null) {
            if (this.storage != null) {
                try {
                    HashedBlockPosition seatPos = this.stats.getPassengerSeat(this.func_184188_bt().indexOf(entity));
                    float xOffset = this.storage.getSizeX() % 2 == 0 ? 0.5f : 0.0f;
                    float zOffset = this.storage.getSizeZ() % 2 == 0 ? 0.5f : 0.0f;
                    float halfy = (float)this.storage.getSizeY() / 2.0f;
                    double xPos = (float)seatPos.x + xOffset;
                    double yPos = (float)seatPos.y - 0.5f - halfy;
                    double zPos = (float)seatPos.z + zOffset;
                    float angle = (float)((double)((float)this.getRCSRotateProgress() * 0.9f) * Math.PI / 180.0);
                    double yNew = yPos * (double)MathHelper.func_76134_b((float)angle) + (-zPos - 0.5) * (double)MathHelper.func_76126_a((float)angle);
                    double zNew = zPos * (double)MathHelper.func_76134_b((float)angle) + (yPos + 1.0) * (double)MathHelper.func_76126_a((float)angle);
                    yPos = yNew + this.func_226278_cu_() + (double)halfy;
                    zPos = zNew;
                    float yawAngle = (float)((double)this.field_70177_z * Math.PI / 180.0);
                    double xNew = xPos * (double)MathHelper.func_76134_b((float)(-yawAngle)) + zPos * (double)MathHelper.func_76126_a((float)(-yawAngle));
                    zNew = zPos * (double)MathHelper.func_76134_b((float)yawAngle) + xPos * (double)MathHelper.func_76126_a((float)yawAngle);
                    xPos = this.func_226277_ct_() + xNew;
                    zPos = this.func_226281_cx_() + zNew;
                    entity.func_70107_b(xPos, yPos, zPos);
                }
                catch (IndexOutOfBoundsException e) {
                    entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                }
            } else {
                entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            }
        }
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        if (ID == GuiHandler.guiId.MODULAR.ordinal()) {
            if (this.field_70170_p.field_72995_K) {
                modules.add((ModuleBase)new ModuleImage(173, 0, new IconResource(128, 0, 48, 86, CommonResources.genericBackground)));
                modules.add((ModuleBase)new ModuleImage(173, 86, new IconResource(98, 0, 78, 83, CommonResources.genericBackground)));
                modules.add((ModuleBase)new ModuleImage(173, 168, new IconResource(98, 168, 78, 3, CommonResources.genericBackground)));
            }
            modules.add((ModuleBase)new ModuleProgress(192, 7, 0, new ProgressBarImage(2, 173, 12, 71, 17, 6, 3, 69, 1, 1, Direction.UP, zmaster587.advancedRocketry.inventory.TextureResources.rocketHud), (IProgressBar)this));
            List<TileEntity> tiles = this.storage.getGUItiles();
            for (int i = 0; i < tiles.size(); ++i) {
                TileEntity tile = tiles.get(i);
                BlockState state = this.storage.func_180495_p(tile.func_174877_v());
                try {
                    modules.add((ModuleBase)new ModuleSlotButton(8 + 18 * (i % 9), 17 + 18 * (i / 9), (IButtonInventory)this, new ItemStack((IItemProvider)state.func_177230_c(), 1), this.field_70170_p).setAdditionalData((Object)(i + this.tilebuttonOffset)));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            modules.add((ModuleBase)new ModuleButton(180, 140, LibVulpes.proxy.getLocalizedString("msg.entity.rocket.disass"), (IButtonInventory)this, TextureResources.buttonBuild, 64, 20).setAdditionalData((Object)0));
            modules.add((ModuleBase)new ModuleButton(180, 114, LibVulpes.proxy.getLocalizedString("msg.entity.rocket.seldst"), (IButtonInventory)this, TextureResources.buttonBuild, 64, 20).setAdditionalData((Object)1));
        } else {
            ResourceLocation uuid;
            ItemStack slot0 = this.storage.getGuidanceComputer().func_70301_a(0);
            if (slot0 != null && slot0.func_77973_b() instanceof ItemStationChip && !Constants.INVALID_PLANET.equals((Object)(uuid = ItemStationChip.getUUID(slot0)))) {
                ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStation(uuid);
                modules.add(new ModuleStellarBackground(0, 0, TextureResources.starryBG));
                if (obj == null) {
                    return modules;
                }
                LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
                ModuleButton button = new ModuleButton(0, 0, LibVulpes.proxy.getLocalizedString("msg.entity.rocket.clear"), (IButtonInventory)this, zmaster587.advancedRocketry.inventory.TextureResources.buttonGeneric, 72, 18).setAdditionalData((Object)50);
                list2.add(button);
                int i = 1;
                for (StationLandingLocation pos : ((SpaceStationObject)obj).getLandingPads()) {
                    button = new ModuleButton(0, i * 18, pos.toString(), (IButtonInventory)this, zmaster587.advancedRocketry.inventory.TextureResources.buttonGeneric, 72, 18).setAdditionalData((Object)(i + 50));
                    list2.add(button);
                    if (pos.getOccupied()) {
                        button.setColor(0xFF0000);
                    }
                    ++i;
                }
                ModuleContainerPan pan = new ModuleContainerPan(25, 25, list2, new LinkedList(), null, 256, 256, 0, -48, 258, 256);
                modules.add((ModuleBase)pan);
                StationLandingLocation location = this.storage.getGuidanceComputer().getLandingLocation(uuid);
                this.landingPadDisplayText.setText(location != null ? location.toString() : LibVulpes.proxy.getLocalizedString("msg.entity.rocket.none"));
                modules.add((ModuleBase)this.landingPadDisplayText);
            } else {
                DimensionProperties properties = DimensionManager.getEffectiveDimId(this.field_70170_p, new BlockPos(this.func_213303_ch()));
                while (properties.getParentProperties() != null) {
                    properties = properties.getParentProperties();
                }
                this.container = this.storage.hasWarpCore() ? new ModulePlanetSelector(properties.getStarId(), TextureResources.starryBG, this, this, true) : new ModulePlanetSelector(properties.getId(), TextureResources.starryBG, this, false);
                this.container.setOffset(1000, 1000);
                modules.add((ModuleBase)this.container);
            }
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "Rocket";
    }

    public float getNormallizedProgress(int id) {
        if (id == 0) {
            if (this.getFuelCapacityMonopropellant() > 0) {
                return (float)this.getFuelAmountMonopropellant() / (float)this.getFuelCapacityMonopropellant();
            }
            return (float)(this.getFuelAmountBipropellant() + this.getFuelAmountOxidizer()) / (float)(this.getFuelCapacityBipropellant() + this.getFuelCapacityOxidizer());
        }
        return 0.0f;
    }

    public void setProgress(int id, int progress) {
    }

    public int getProgress(int id) {
        return 0;
    }

    public int getTotalProgress(int id) {
        return 0;
    }

    public void setTotalProgress(int id, int progress) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInventoryButtonPressed(ModuleButton button) {
        int buttonId = (Integer)button.getAdditionalData();
        switch (buttonId) {
            case 0: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.DECONSTRUCT.ordinal()));
                break;
            }
            case 1: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.OPENPLANETSELECTION.ordinal()));
                break;
            }
            default: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)(buttonId + BUTTON_ID_OFFSET)));
                if (buttonId >= 50) break;
            }
        }
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        boolean ret;
        boolean bl = ret = this.func_70089_S() && this.func_70068_e((Entity)entity) < 4096.0;
        if (!ret) {
            RocketInventoryHelper.removePlayerFromInventoryBypass(entity);
        }
        RocketInventoryHelper.updateTime(entity, this.field_70170_p.func_82737_E());
        return ret;
    }

    @Override
    public StatsRocket getRocketStats() {
        return this.stats;
    }

    public void onSelected(Object sender) {
    }

    public void onSelectionConfirmed(Object sender) {
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDPLANETDATA.ordinal()));
    }

    public void onSystemFocusChanged(Object sender) {
    }

    public LinkedList<IInfrastructure> getConnectedInfrastructure() {
        return this.connectedInfrastructure;
    }

    @Override
    public boolean isPlanetKnown(IDimensionProperties properties) {
        return (Boolean)ARConfiguration.getCurrentConfig().planetsMustBeDiscovered.get() == false || DimensionManager.getInstance().knownPlanets.contains(properties.getId());
    }

    @Override
    public boolean isStarKnown(StellarBody body) {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnNBT(CompoundNBT nbt) {
        this.readNetworkableNBT(nbt);
    }

    public Container createMenu(int winId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_ENTITY, winId, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT nbt = new CompoundNBT();
        this.func_213281_b(nbt);
        new PacketSpawnEntity((Entity)this, nbt).write(buffer);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        PacketSpawnEntity packet = new PacketSpawnEntity();
        packet.read(additionalData);
        packet.execute((Entity)this);
    }

    public static enum PacketType {
        RECIEVENBT,
        SENDINTERACT,
        REQUESTNBT,
        FORCEMOUNT,
        LAUNCH,
        DECONSTRUCT,
        OPENGUI,
        CHANGEWORLD,
        REVERTWORLD,
        OPENPLANETSELECTION,
        SENDPLANETDATA,
        DISCONNECTINFRASTRUCTURE,
        CONNECTINFRASTRUCTURE,
        ROCKETLANDEVENT,
        MENU_CHANGE,
        UPDATE_ATM,
        UPDATE_ORBIT,
        UPDATE_FLIGHT,
        DISMOUNTCLIENT,
        TOGGLE_RCS,
        TURNUPDATE,
        ABORTLAUNCH,
        SENDSPACEPOS;

    }
}

