/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.Ticket;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.client.SoundRocketEngine;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.mission.MissionGasCollection;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketSpawnEntity;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class EntityStationDeployedRocket
extends EntityRocket {
    public Direction launchDirection;
    public Direction forwardDirection;
    public HashedBlockPosition launchLocation;
    private ModuleText atmText;
    private short gasId;
    boolean coastMode;
    private Ticket<Entity> ticket;

    public EntityStationDeployedRocket(EntityType<?> type, World world) {
        super(type, world);
        this.launchDirection = Direction.DOWN;
        this.launchLocation = new HashedBlockPosition(0, 0, 0);
        this.atmText = new ModuleText(182, 114, "", 0x2D2D2D);
        this.gasId = 0;
        this.ticket = null;
    }

    public EntityStationDeployedRocket(World world, StorageChunk storage, StatsRocket stats, double x, double y, double z) {
        super(world, storage, stats, x, y, z);
        this.launchLocation = new HashedBlockPosition((int)x, (int)y, (int)z);
        this.launchDirection = Direction.DOWN;
        stats.setSeatLocation(-1, -1, -1);
        this.atmText = new ModuleText(182, 114, "", 0x2D2D2D);
        this.gasId = 0;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public void prepareLaunch() {
        RocketEvent.RocketPreLaunchEvent event = new RocketEvent.RocketPreLaunchEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (this.field_70170_p.field_72995_K) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.LAUNCH.ordinal()));
            }
            this.launch();
        }
    }

    @Override
    public void launch() {
        ISpaceObject spaceObj;
        if (this.isInFlight()) {
            return;
        }
        if (this.isInOrbit()) {
            this.setInFlight(true);
            return;
        }
        if (this.getFuelAmountMonopropellant() < this.getFuelCapacityMonopropellant()) {
            return;
        }
        if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_70170_p)) && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos(this.func_213303_ch()))) != null && ((DimensionProperties)spaceObj.getProperties().getParentProperties()).isGasGiant()) {
            this.setInFlight(true);
            this.launchLocation.x = (int)Math.floor(this.func_226277_ct_());
            this.launchLocation.y = (short)this.func_226278_cu_();
            this.launchLocation.z = (int)Math.floor(this.func_226281_cx_());
            Iterator connectedTiles = this.connectedInfrastructure.iterator();
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
            while (connectedTiles.hasNext()) {
                IInfrastructure i = (IInfrastructure)connectedTiles.next();
                if (!i.disconnectOnLiftOff()) continue;
                this.disconnectInfrastructure(i);
                connectedTiles.remove();
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void func_70071_h_() {
        block18: {
            block20: {
                block19: {
                    this.lastWorldTickTicked = this.field_70170_p.func_82737_E();
                    if (this.field_70173_aa == 20) {
                        itr = new LinkedList<E>(this.infrastructureCoords).listIterator();
                        while (itr.hasNext()) {
                            temp = (HashedBlockPosition)itr.next();
                            tile = this.field_70170_p.func_175625_s(new BlockPos(temp.x, (int)temp.y, temp.z));
                            if (!(tile instanceof IInfrastructure)) continue;
                            this.linkInfrastructure((IInfrastructure)tile);
                        }
                        if (this.field_70170_p.field_72995_K) {
                            LibVulpes.proxy.playSound((Object)new SoundRocketEngine(AudioRegistry.combustionRocket, SoundCategory.NEUTRAL, this));
                        }
                    }
                    if (!this.isInFlight()) break block18;
                    burningFuel = this.isBurningFuel();
                    if (this.launchLocation == null || this.storage == null) {
                        return;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        ((ServerWorld)this.field_70170_p).func_72863_F().func_217228_a(TicketType.field_219494_g, new ChunkPos(this.func_226270_aj_()), 3, (Object)new ChunkPos(this.func_226270_aj_()));
                    }
                    v0 = isCoasting = Math.abs(this.func_226277_ct_() - (double)this.launchLocation.x) < (double)(4 * this.storage.getSizeX()) && Math.abs(this.func_226278_cu_() - (double)this.launchLocation.y) < (double)(4 * this.storage.getSizeY()) && Math.abs(this.func_226281_cx_() - (double)this.launchLocation.z) < (double)(4 * this.storage.getSizeZ());
                    if (!isCoasting && this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74362_aa != ParticleStatus.MINIMAL) {
                        for (Vector3F vec : this.stats.getEngineLocations()) {
                            xMult = Math.abs(this.forwardDirection.func_82601_c());
                            zMult = Math.abs(this.forwardDirection.func_82599_e());
                            for (i = 0; i < 4; ++i) {
                                xVel = (1.0f - xMult) * ((this.field_70146_Z.nextFloat() - 0.5f) / 8.0f) + xMult * -0.15f;
                                zVel = (1.0f - zMult) * ((this.field_70146_Z.nextFloat() - 0.5f) / 8.0f) + zMult * -0.15f;
                                AdvancedRocketry.proxy.spawnParticle("rocketFlame", this.field_70170_p, this.func_226277_ct_() + (double)((Float)vec.x).floatValue() + this.func_213322_ci().field_72450_a, this.func_226278_cu_() + (double)((Float)vec.y).floatValue(), this.func_226281_cx_() + (double)((Float)vec.z).floatValue(), xVel, (this.field_70146_Z.nextFloat() - 0.5f) / 8.0f, (double)zVel + this.func_213322_ci().field_72449_c);
                            }
                        }
                    }
                    if (this.forwardDirection == null) {
                        return;
                    }
                    if (!this.isInOrbit()) break block19;
                    v1 = this.func_226277_ct_() - (double)this.launchLocation.x;
                    v2 = this.storage.getSizeX() % 2 == 0 ? 0.0f : 0.5f;
                    if (!(Math.abs(v1 - (double)v2) < 0.01)) ** GOTO lbl-1000
                    v3 = this.func_226281_cx_() - (double)this.launchLocation.z;
                    v4 = this.storage.getSizeZ() % 2 == 0 ? 0.0f : 0.5f;
                    if (Math.abs(v3 - (double)v4) < 0.01) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = isCoasting = false;
                    }
                    if (isCoasting) {
                        dir = this.launchDirection.func_176734_d();
                        speed = 0.075f;
                        this.func_213293_j(speed * (float)dir.func_82601_c(), speed * (float)dir.func_96559_d(), speed * (float)dir.func_82599_e());
                    } else {
                        dir = this.forwardDirection.func_176734_d();
                        acc = 0.01f;
                        this.func_213293_j((double)acc * ((double)this.launchLocation.x - this.func_226277_ct_() + (double)(this.storage.getSizeX() % 2 == 0 ? 0.0f : 0.5f)) + 0.01 * (double)dir.func_82601_c(), 0.0, (double)acc * ((double)this.launchLocation.z - this.func_226281_cx_() + (double)(this.storage.getSizeZ() % 2 == 0 ? 0.0f : 0.5f)) + 0.01 * (double)dir.func_82599_e());
                    }
                    if (this.func_226278_cu_() > (double)this.launchLocation.y) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.setInFlight(false);
                            this.setInOrbit(false);
                            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
                        }
                        this.func_213293_j(this.func_213322_ci().field_72450_a, 0.0, this.func_213322_ci().field_72449_c);
                        this.func_70107_b((float)this.launchLocation.x + (this.storage.getSizeX() % 2 == 0 ? 0.0f : 0.5f), this.launchLocation.y, (float)this.launchLocation.z + (this.storage.getSizeZ() % 2 == 0 ? 0.0f : 0.5f));
                    }
                    break block20;
                }
                if (isCoasting) {
                    speed = 0.01f;
                    motionX = this.func_213322_ci().field_72450_a;
                    motionY = this.func_213322_ci().field_72448_b;
                    motionZ = this.func_213322_ci().field_72449_c;
                    this.func_213293_j(motionX + (double)(speed * (float)this.launchDirection.func_82601_c()) * (2.1 * (double)this.storage.getSizeX() - Math.abs((double)(2 * this.storage.getSizeX()) - Math.abs(this.func_226277_ct_() - (double)this.launchLocation.x)) + 0.05), motionY + (double)(speed * (float)this.launchDirection.func_96559_d()) * (2.1 * (double)this.storage.getSizeY() - Math.abs((double)(2 * this.storage.getSizeY()) - Math.abs(this.func_226278_cu_() - (double)this.launchLocation.y)) + 0.05), motionZ + (double)(speed * (float)this.launchDirection.func_82599_e()) * (2.1 * (double)this.storage.getSizeZ() - Math.abs((double)(2 * this.storage.getSizeZ()) - Math.abs(this.func_226281_cx_() - (double)this.launchLocation.z)) + 0.05));
                } else {
                    acc = 0.01f;
                    motionX = this.func_213322_ci().field_72450_a;
                    motionY = this.func_213322_ci().field_72448_b;
                    motionZ = this.func_213322_ci().field_72449_c;
                    this.func_213293_j(motionX + (double)(acc * (float)this.forwardDirection.func_82601_c()), motionY + (double)(acc * (float)this.forwardDirection.func_96559_d()), motionZ + (double)(acc * (float)this.forwardDirection.func_82599_e()));
                }
                if (!this.field_70170_p.field_72995_K && this.func_70092_e(this.launchLocation.x, this.launchLocation.y, this.launchLocation.z) > 16384.0) {
                    this.onOrbitReached();
                    return;
                }
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
    }

    @Override
    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        DimensionProperties props;
        List<ModuleBase> modules = super.getModules(ID, player);
        Iterator<ModuleBase> itr = modules.iterator();
        while (itr.hasNext()) {
            ModuleBase module = itr.next();
            if (!(module instanceof ModuleButton) || ((ModuleButton)module).buttonId != 1) continue;
            itr.remove();
            break;
        }
        if ((props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_213303_ch())).isGasGiant()) {
            try {
                this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getRegistryName().toString());
            }
            catch (IndexOutOfBoundsException e) {
                this.gasId = 0;
                this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getRegistryName().toString());
            }
        } else {
            this.atmText.setText(LibVulpes.proxy.getLocalizedString("msg.entityDeployedRocket.notgasgiant"));
        }
        modules.add((ModuleBase)new ModuleButton(170, 114, "", (IButtonInventory)this, TextureResources.buttonLeft, 5, 8).setAdditionalData((Object)1));
        modules.add((ModuleBase)this.atmText);
        modules.add((ModuleBase)new ModuleButton(240, 114, "", (IButtonInventory)this, TextureResources.buttonRight, 5, 8).setAdditionalData((Object)2));
        return modules;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInventoryButtonPressed(ModuleButton button) {
        int buttonId = (Integer)button.getAdditionalData();
        switch (buttonId) {
            case 0: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.DECONSTRUCT.ordinal()));
                break;
            }
            case 1: {
                DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_213303_ch());
                if (!props.isGasGiant()) break;
                this.gasId = (short)(this.gasId + 1);
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()));
                break;
            }
            case 2: {
                DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_213303_ch());
                if (!props.isGasGiant()) break;
                this.gasId = (short)(this.gasId - 1);
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()));
                break;
            }
            default: {
                super.onInventoryButtonPressed(button);
            }
        }
    }

    @Override
    public void onOrbitReached() {
        if (!this.func_70089_S()) {
            return;
        }
        ISpaceObject spaceObj = null;
        this.setInOrbit(true);
        if (!ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_70170_p)) || (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos(this.func_213303_ch()))) == null || !((DimensionProperties)spaceObj.getProperties().getParentProperties()).isGasGiant()) {
            this.setInOrbit(true);
            return;
        }
        this.func_70107_b((double)this.forwardDirection.func_82601_c() * 64.0 + (double)this.launchLocation.x + (this.storage.getSizeX() % 2 == 0 ? 0.0 : 0.5), this.func_226278_cu_(), (double)this.forwardDirection.func_82599_e() * 64.0 + (double)this.launchLocation.z + (this.storage.getSizeZ() % 2 == 0 ? 0.0 : 0.5));
        DimensionProperties properties = (DimensionProperties)spaceObj.getProperties().getParentProperties();
        if (this.gasId >= properties.getHarvestableGasses().size() || this.gasId < 0) {
            this.setInOrbit(true);
            return;
        }
        float intakePower = ((Integer)this.stats.getStatTag("intakePower")).intValue();
        MissionGasCollection miningMission = new MissionGasCollection(intakePower == 0.0f ? 360L : (long)(2.0f * ((float)((Integer)this.stats.getStatTag("liquidCapacity")).intValue() / intakePower)), this, this.connectedInfrastructure, properties.getHarvestableGasses().get(this.gasId));
        miningMission.setDimensionId(properties.getId());
        properties.addSatellite(miningMission);
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(miningMission));
        }
        for (IInfrastructure i : this.connectedInfrastructure) {
            i.linkMission(miningMission);
        }
        this.func_70106_y();
    }

    @Override
    protected void writeNetworkableNBT(CompoundNBT nbt) {
        super.writeNetworkableNBT(nbt);
    }

    @Override
    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    public void writeDataToNetwork(PacketBuffer out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            out.writeShort((int)this.gasId);
        } else {
            super.writeDataToNetwork(out, id);
        }
    }

    @Override
    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            nbt.func_74777_a("gas", in.readShort());
        } else {
            super.readDataFromNetwork(in, packetId, nbt);
        }
    }

    @Override
    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_213303_ch());
            if (props.isGasGiant()) {
                this.gasId = nbt.func_74765_d("gas");
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                if (!this.field_70170_p.field_72995_K) {
                    PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()), (World)this.field_70170_p, (int)((int)this.func_226277_ct_()), (int)((int)this.func_226278_cu_()), (int)((int)this.func_226281_cx_()), (double)64.0);
                } else {
                    this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getRegistryName().toString());
                }
            }
        } else {
            super.useNetworkData(player, side, id, nbt);
        }
    }

    @Override
    public void writeMissionPersistantNBT(CompoundNBT nbt) {
        super.writeMissionPersistantNBT(nbt);
        nbt.func_74768_a("fwd", this.forwardDirection.ordinal());
        nbt.func_74768_a("launchX", this.launchLocation.x);
        nbt.func_74768_a("launchY", (int)this.launchLocation.y);
        nbt.func_74768_a("launchZ", this.launchLocation.z);
        nbt.func_74777_a("gas", this.gasId);
    }

    @Override
    public void readMissionPersistantNBT(CompoundNBT nbt) {
        super.readMissionPersistantNBT(nbt);
        this.forwardDirection = Direction.values()[nbt.func_74762_e("fwd")];
        this.launchLocation.x = nbt.func_74762_e("launchX");
        this.launchLocation.y = (short)nbt.func_74762_e("launchY");
        this.launchLocation.z = nbt.func_74762_e("launchZ");
        this.gasId = nbt.func_74765_d("gas");
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        new PacketSpawnEntity((Entity)this).write(buffer);
    }

    @Override
    public void readSpawnData(PacketBuffer additionalData) {
        PacketSpawnEntity packet = new PacketSpawnEntity();
        packet.read(additionalData);
        packet.execute((Entity)this);
    }
}

