/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.api.AdvancedRocketryEntities;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.tile.station.TileHolographicPlanetSelector;
import zmaster587.libVulpes.network.PacketSpawnEntity;

public class EntityUIPlanet
extends Entity
implements IEntityAdditionalSpawnData {
    DimensionProperties properties;
    protected TileHolographicPlanetSelector tile;
    protected static final DataParameter<String> planetID = EntityDataManager.func_187226_a(EntityUIPlanet.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Float> scale = EntityDataManager.func_187226_a(EntityUIPlanet.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> selected = EntityDataManager.func_187226_a(EntityUIPlanet.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected EntitySize field_213325_aI;

    public EntityUIPlanet(World worldIn, DimensionProperties properties, TileHolographicPlanetSelector tile, double x, double y, double z) {
        this(AdvancedRocketryEntities.ENTITY_UIPLANET, worldIn);
        this.func_70107_b(x, y, z);
        this.setProperties(properties);
        this.tile = tile;
    }

    public EntityUIPlanet(EntityType<?> type, World worldIn, DimensionProperties properties, TileHolographicPlanetSelector tile, double x, double y, double z) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.setProperties(properties);
        this.tile = tile;
    }

    public EntityUIPlanet(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.setSize(0.2f, 0.2f);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn);
    }

    public void setSize(float x, float z) {
        this.field_213325_aI = new EntitySize(x, z, false);
    }

    public float getScale() {
        float scale = ((Float)this.field_70180_af.func_187225_a(EntityUIPlanet.scale)).floatValue();
        this.setSize(0.1f * scale, 0.1f * scale);
        return scale;
    }

    public void setScale(float myScale) {
        this.setSize(0.08f * myScale, 0.08f * myScale);
        this.field_70180_af.func_187227_b(scale, (Object)Float.valueOf(myScale));
    }

    public boolean func_184198_c(CompoundNBT compound) {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(planetID, (Object)(this.properties == null ? Constants.INVALID_PLANET.toString() : this.properties.getId().toString()));
        this.field_70180_af.func_187214_a(scale, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(selected, (Object)false);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && this.tile != null) {
            this.tile.selectSystem(this.properties.getId());
        }
        return ActionResultType.PASS;
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    public DimensionProperties getProperties() {
        if (this.properties == null && this.getPlanetID() != Constants.INVALID_PLANET || this.properties != null && this.getPlanetID() != this.properties.getId()) {
            this.properties = DimensionManager.getInstance().getDimensionProperties(this.getPlanetID());
        }
        return this.properties;
    }

    public ResourceLocation getPlanetID() {
        if (!this.field_70170_p.field_72995_K) {
            return this.properties == null ? Constants.INVALID_PLANET : this.properties.getId();
        }
        ResourceLocation planetId = new ResourceLocation((String)this.field_70180_af.func_187225_a(planetID));
        if (this.properties != null && this.properties.getId() != planetId) {
            this.properties = Constants.INVALID_PLANET.equals((Object)planetId) ? null : DimensionManager.getInstance().getDimensionProperties(planetId);
        }
        return planetId;
    }

    public void setProperties(DimensionProperties properties) {
        this.properties = properties;
        if (properties != null) {
            this.field_70180_af.func_187227_b(planetID, (Object)properties.getId().toString());
        } else {
            this.field_70180_af.func_187227_b(planetID, (Object)Constants.INVALID_PLANET.toString());
        }
    }

    public void setSelected(boolean isSelected) {
        this.field_70180_af.func_187227_b(selected, (Object)isSelected);
    }

    public boolean isSelected() {
        return (Boolean)this.field_70180_af.func_187225_a(selected);
    }

    public void setPositionPolar(double originX, double originY, double originZ, double radius, double theta) {
        this.func_70107_b(originX += radius * (double)MathHelper.func_76134_b((float)((float)theta)), originY, originZ += radius * (double)MathHelper.func_76126_a((float)((float)theta)));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        new PacketSpawnEntity((Entity)this).write(buffer);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        PacketSpawnEntity packet = new PacketSpawnEntity();
        packet.read(additionalData);
        packet.execute((Entity)this);
    }
}

