/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.AdvancedRocketryEntities;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityUIPlanet;
import zmaster587.advancedRocketry.tile.station.TileHolographicPlanetSelector;

public class EntityUIStar
extends EntityUIPlanet {
    StellarBody star;
    int subStar = -1;
    public static final int starIDoffset = 10000;
    protected static final DataParameter<Integer> subStarData = EntityDataManager.func_187226_a(EntityUIStar.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityUIStar(World worldIn, StellarBody properties, TileHolographicPlanetSelector tile, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.setProperties(properties);
        this.tile = tile;
        this.subStar = -1;
    }

    public EntityUIStar(World worldIn, StellarBody properties, int subStar, TileHolographicPlanetSelector tile, double x, double y, double z) {
        this(worldIn, properties, tile, x, y, z);
        this.subStar = subStar;
        this.field_70180_af.func_187227_b(subStarData, (Object)this.subStar);
    }

    public EntityUIStar(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.setSize(0.2f, 0.2f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(subStarData, (Object)-1);
    }

    public EntityUIStar(World worldIn) {
        super(AdvancedRocketryEntities.ENTITY_UISTAR, worldIn);
        this.setSize(0.2f, 0.2f);
        this.subStar = -1;
    }

    public void setProperties(StellarBody properties) {
        this.star = properties;
        if (properties != null) {
            this.field_70180_af.func_187227_b(planetID, (Object)this.star.getId().toString());
        } else {
            this.field_70180_af.func_187227_b(planetID, (Object)Constants.INVALID_STAR.toString());
        }
    }

    @Override
    public ResourceLocation getPlanetID() {
        if (!this.field_70170_p.field_72995_K) {
            return this.star == null ? Constants.INVALID_STAR : this.star.getId();
        }
        ResourceLocation planetId = new ResourceLocation((String)this.field_70180_af.func_187225_a(planetID));
        if (this.star != null && this.star.getId() != planetId) {
            this.star = Constants.INVALID_PLANET.equals((Object)planetId) ? null : DimensionManager.getInstance().getStar(planetId);
        }
        return planetId;
    }

    public StellarBody getStarProperties() {
        if (this.star == null && this.getPlanetID() != Constants.INVALID_PLANET || this.star != null && this.getPlanetID() != this.star.getId()) {
            this.star = DimensionManager.getInstance().getStar(this.getPlanetID());
            this.subStar = (Integer)this.field_70180_af.func_187225_a(subStarData);
            if (this.subStar != -1 && !this.star.getSubStars().isEmpty()) {
                this.star = this.star.getSubStars().get(this.subStar);
            }
        }
        return this.star;
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && this.tile != null) {
            this.tile.selectSystem(this.star.getId());
        }
        return ActionResultType.PASS;
    }
}

