/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.cable.NetworkRegistry;
import zmaster587.advancedRocketry.tile.cables.TilePipe;

public class CableTickHandler {
    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent tick) {
        try {
            if (tick.phase == TickEvent.Phase.END) {
                NetworkRegistry.dataNetwork.tickAllNetworks();
                NetworkRegistry.energyNetwork.tickAllNetworks();
                NetworkRegistry.liquidNetwork.tickAllNetworks();
            }
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void chunkLoadedEvent(ChunkEvent.Load event) {
        Set map = event.getChunk().func_203066_o();
        Iterator iter = map.iterator();
        try {
            while (iter.hasNext()) {
                TileEntity obj = event.getChunk().func_175625_s((BlockPos)iter.next());
                if (!(obj instanceof TilePipe)) continue;
                ((TilePipe)obj).func_70296_d();
            }
        }
        catch (ConcurrentModificationException e) {
            AdvancedRocketry.logger.warn("You have been visited by the rare pepe.. I mean error of pipes not loading, this is not good, some pipe systems may not work right away.  But it's better than a corrupt world");
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c().hasTileEntity(event.getState())) {
            TileEntity homeTile = event.getWorld().func_175625_s(event.getPos());
            if (homeTile instanceof TilePipe) {
                TileEntity tile;
                ((TilePipe)homeTile).setDestroyed();
                ((TilePipe)homeTile).setInvalid();
                int pipecount = 0;
                for (Direction dir : Direction.values()) {
                    tile = event.getWorld().func_175625_s(event.getPos().func_177972_a(dir));
                    if (!(tile instanceof TilePipe)) continue;
                    ++pipecount;
                }
                if (pipecount > 1) {
                    for (Direction dir : Direction.values()) {
                        tile = event.getWorld().func_175625_s(event.getPos().func_177972_a(dir));
                        if (!(tile instanceof TilePipe)) continue;
                        ((TilePipe)tile).getNetworkHandler().removeNetworkByID(((TilePipe)tile).getNetworkID());
                        ((TilePipe)tile).setInvalid();
                    }
                }
                if (pipecount == 0) {
                    ((TilePipe)homeTile).getNetworkHandler().removeNetworkByID(((TilePipe)homeTile).getNetworkID());
                }
                ((TilePipe)homeTile).func_70296_d();
            } else if (homeTile != null) {
                for (Direction dir : Direction.values()) {
                    TileEntity tile = event.getWorld().func_175625_s(event.getPos().func_177972_a(dir));
                    if (!(tile instanceof TilePipe)) continue;
                    ((TilePipe)tile).getNetworkHandler().removeFromAllTypes((TilePipe)tile, homeTile);
                }
            }
        }
    }
}

