/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.achievements.ARAdvancements;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStellarInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.advancedRocketry.world.util.WorldDummy;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public class PlanetEventHandler {
    public static long time = 0L;
    private static long endTime;
    private static long duration;
    private static List<TransitionEntity> transitionMap;
    static final ItemStack component;

    public static void addDelayedTransition(TransitionEntity entity) {
        transitionMap.add(entity);
    }

    @SubscribeEvent
    public void CheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        DimensionProperties properties;
        IWorld world = event.getWorld();
        DimensionManager manager = DimensionManager.getInstance();
        if (manager.isInitialized() && world instanceof World && (properties = manager.getDimensionProperties(ZUtils.getDimensionIdentifier((World)((World)world)))) != null && !properties.getAtmosphere().isImmune(event.getEntityLiving().getClass())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void SpawnEntity(WorldEvent.PotentialSpawns event) {
        List<SpawnListEntryNBT> entries;
        World world = (World)event.getWorld();
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(world);
        if (properties != null && !(entries = properties.getSpawnListEntries()).isEmpty() && event.getType() != EntityClassification.MONSTER) {
            event.getList().addAll(entries);
        }
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity().func_226278_cu_() > 260.0 && event.getEntity().func_226278_cu_() < 270.0 && event.getEntity().func_213322_ci().field_72448_b < -0.1) {
            RocketEventHandler.destroyOrbitalTextures(event.getEntity().field_70170_p);
        }
        if (event.getEntity().func_70090_H() && AtmosphereType.LOWOXYGEN.isImmune(event.getEntityLiving())) {
            event.getEntity().func_70050_g(300);
        }
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity().field_70170_p.func_82737_E() % 20L == 0L && event.getEntity() instanceof PlayerEntity) {
            if (DimensionManager.getInstance().getDimensionProperties(event.getEntity().field_70170_p).getName().equals("Luna") && event.getEntity().func_213303_ch().func_186679_c(2347.0, 80.0, 67.0) < 512.0) {
                ARAdvancements.triggerAchievement(ARAdvancements.WENT_TO_THE_MOON, (ServerPlayerEntity)event.getEntity());
            }
            if (event.getEntity() instanceof PlayerEntity && ZUtils.getDimensionIdentifier((World)event.getEntity().field_70170_p).equals(ARConfiguration.getCurrentConfig().spaceDimId) && SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(event.getEntity().func_233580_cy_()) == null) {
                double distance = 0.0;
                HashedBlockPosition teleportPosition = null;
                for (ISpaceObject object : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
                    if (!(object instanceof SpaceStationObject)) continue;
                    SpaceStationObject station = (SpaceStationObject)object;
                    double distanceTo = event.getEntity().func_70092_e((double)station.getSpawnLocation().x, (double)station.getSpawnLocation().y, (double)station.getSpawnLocation().z);
                    if (!(distanceTo > distance)) continue;
                    distance = distanceTo;
                    teleportPosition = station.getSpawnLocation();
                }
                if (teleportPosition != null) {
                    event.getEntity().func_145747_a((ITextComponent)new TranslationTextComponent("msg.chat.nostation1"), Util.field_240973_b_);
                    event.getEntity().func_145747_a((ITextComponent)new TranslationTextComponent("msg.chat.nostation2"), Util.field_240973_b_);
                    event.getEntity().func_70634_a((double)teleportPosition.x, (double)teleportPosition.y, (double)teleportPosition.z);
                }
            }
        }
    }

    @SubscribeEvent
    public void sleepEvent(PlayerSleepInBedEvent event) {
        DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(event.getEntity().func_130014_f_());
        if (props != DimensionManager.defaultSpaceDimensionProperties && !((Boolean)ARConfiguration.getCurrentConfig().forcePlayerRespawnInSpace.get()).booleanValue() && AtmosphereHandler.hasAtmosphereHandler(event.getEntity().field_70170_p) && !AtmosphereHandler.getOxygenHandler(event.getEntity().field_70170_p).getAtmosphereType(event.getPos()).isBreathable()) {
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public void blockPlacedEvent(BlockEvent.EntityPlaceEvent event) {
        World world = event.getEntity().func_130014_f_();
        if (!world.field_72995_K && AtmosphereHandler.getOxygenHandler(world) != null && !AtmosphereHandler.getOxygenHandler(world).getAtmosphereType(event.getPos()).allowsCombustion()) {
            if (event.getPlacedBlock().func_177230_c() == Blocks.field_150478_aa) {
                event.getWorld().func_180501_a(event.getPos(), AdvancedRocketryBlocks.blockUnlitTorch.func_176223_P(), 20);
            } else if (event.getPlacedBlock().func_177230_c() == Blocks.field_196591_bQ) {
                BlockState stateToPlace = (BlockState)AdvancedRocketryBlocks.blockUnlitTorchWall.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, event.getPlacedBlock().func_177229_b((Property)WallTorchBlock.field_196532_a));
                event.getWorld().func_180501_a(event.getPos(), stateToPlace, 20);
            } else if (ARConfiguration.getCurrentConfig().torchBlocks.contains(event.getPlacedBlock().func_177230_c())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void blockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        Direction direction = event.getFace();
        if (!(event.getWorld().field_72995_K || direction == null || event.getPlayer() == null || AtmosphereHandler.getOxygenHandler(event.getWorld()) == null || AtmosphereHandler.getOxygenHandler(event.getWorld()).getAtmosphereType(event.getPos().func_177972_a(direction)).allowsCombustion() || event.getPlayer().func_184586_b(event.getHand()) == null || event.getPlayer().func_184586_b(event.getHand()).func_77973_b() != Items.field_151033_d && event.getPlayer().func_184586_b(event.getHand()).func_77973_b() != Items.field_151059_bz && event.getPlayer().func_184586_b(event.getHand()).func_77973_b() != Items.field_151065_br && event.getPlayer().func_184586_b(event.getHand()).func_77973_b() != Items.field_151072_bj)) {
            event.setCanceled(true);
        }
        if (!event.getWorld().field_72995_K && event.getItemStack() != null && event.getItemStack().func_77973_b() == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockGenericSeat) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150335_W) {
            ARAdvancements.triggerAchievement(ARAdvancements.BEER, (ServerPlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void disconnected(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        ARConfiguration.useClientDiskConfig();
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        TickEvent.Phase cfr_ignored_0 = event.phase;
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.getInstance().tickDimensions();
            ++time;
            if (!transitionMap.isEmpty()) {
                Iterator<TransitionEntity> itr = transitionMap.iterator();
                while (itr.hasNext()) {
                    TransitionEntity ent = itr.next();
                    if (ent.entity.field_70170_p.func_82737_E() < ent.time) continue;
                    ServerWorld newWorld = ent.dimId;
                    if (ent.entity instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)ent.entity).func_200619_a(newWorld, (double)ent.location.func_177958_n(), (double)ent.location.func_177956_o(), (double)ent.location.func_177952_p(), ent.entity.field_70177_z, ent.entity.field_70125_A);
                    } else {
                        PortalInfo info = new PortalInfo(new Vector3d((double)ent.location.func_177958_n(), (double)ent.location.func_177956_o(), (double)ent.location.func_177952_p()), ent.entity.func_213322_ci(), ent.entity.field_70177_z, ent.entity.field_70125_A);
                        ent.entity.changeDimension(newWorld, (ITeleporter)new TeleporterNoPortal(newWorld, info));
                    }
                    Entity rocket = newWorld.func_217461_a(ent.entity2.func_110124_au());
                    if (rocket != null) {
                        ent.entity.func_184220_m(rocket);
                    }
                    itr.remove();
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void tickClient(TickEvent.ClientTickEvent event) {
        TickEvent.Phase cfr_ignored_0 = event.phase;
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.getInstance().tickDimensionsClient();
        }
    }

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity mgr = event.getPlayer();
        for (ResourceLocation i : DimensionManager.getInstance().getStarIds()) {
            PacketHandler.sendToPlayer((BasePacket)new PacketStellarInfo(i, DimensionManager.getInstance().getStar(i)), (PlayerEntity)mgr);
        }
        for (ResourceLocation i : DimensionManager.getInstance().getRegisteredDimensions()) {
            PacketHandler.sendToPlayer((BasePacket)new PacketDimInfo(i, DimensionManager.getInstance().getDimensionProperties(i)), (PlayerEntity)mgr);
        }
        for (ISpaceObject obj : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
            PacketHandler.sendToPlayer((BasePacket)new PacketSpaceStationInfo(obj.getId(), obj), (PlayerEntity)mgr);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void connectToServer(NetworkEvent.ClientCustomPayloadLoginEvent event) {
        DimensionManager.getInstance().unregisterAllDimensions();
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            AtmosphereHandler.registerWorld((World)event.getWorld());
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        if (!event.getWorld().func_201670_d()) {
            AtmosphereHandler.unregisterWorld((World)event.getWorld());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void runBurst(long endTime, long duration) {
        PlanetEventHandler.endTime = endTime;
        PlanetEventHandler.duration = duration;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void fogColor(EntityViewRenderEvent.FogColors event) {
        Entity entity = event.getInfo().func_216773_g();
        World world = entity.field_70170_p;
        BlockState state = event.getInfo().getBlockAtCamera();
        if (state.func_185904_a() == Material.field_151586_h) {
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(world);
        if (properties != null) {
            float fog = Math.min(properties.getAtmosphereDensityAtHeight(entity.func_226278_cu_()), 200.0f);
            float[] color = properties.getSkyColor();
            event.setRed(Math.min(event.getRed() * color[0] * 1.0f, 1.0f));
            event.setGreen(Math.min(event.getGreen() * color[1] * 1.0f, 1.0f));
            event.setBlue(Math.min(event.getBlue() * color[2] * 1.0f, 1.0f));
            if (endTime > 0L) {
                double amt = (double)(endTime - Minecraft.func_71410_x().field_71441_e.func_82737_E()) / (double)duration;
                if (amt < 0.0) {
                    endTime = 0L;
                } else {
                    event.setRed((float)amt);
                    event.setGreen((float)amt);
                    event.setBlue((float)amt);
                }
            } else {
                event.setRed(event.getRed() * fog);
                event.setGreen(event.getGreen() * fog);
                event.setBlue(event.getBlue() * fog);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void fogColor(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getInfo().func_216773_g().func_130014_f_() == null || event.getInfo().func_216773_g().func_130014_f_() instanceof WorldDummy) {
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(event.getInfo().func_216773_g().func_130014_f_());
        if (properties != null && event.getInfo().getBlockAtCamera().func_177230_c() != Blocks.field_150355_j && event.getInfo().getBlockAtCamera().func_177230_c() != Blocks.field_150353_l) {
            float far;
            float fog = Math.min(properties.getAtmosphereDensityAtHeight(event.getInfo().func_216773_g().func_226278_cu_()), 200.0f);
            GlStateManager.func_227750_p_((int)GlStateManager.FogMode.LINEAR.field_187351_d);
            float f1 = event.getFarPlaneDistance();
            int atmosphere = Math.min(properties.getAtmosphereDensity(), 200);
            ItemStack armor = Minecraft.func_71410_x().field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
            if (armor != null && armor.func_77973_b() instanceof IModularArmor) {
                for (ItemStack i : ((IModularArmor)armor.func_77973_b()).getComponents(armor)) {
                    if (!i.func_77969_a(component)) continue;
                    atmosphere = Math.min(atmosphere, 100);
                    break;
                }
            }
            if (AtmosphereHandler.currentPressure != -1) {
                atmosphere = Math.min(AtmosphereHandler.currentPressure, 200);
            }
            if (atmosphere > 100) {
                float near = 0.75f * f1 * (2.0f - (float)(atmosphere * atmosphere) / 10000.0f);
                far = f1;
            } else {
                float near = 0.1f * f1 * (2.0f - (float)atmosphere / 100.0f);
                far = f1 * (2.002f - (float)atmosphere / 100.0f);
            }
            RenderSystem.fogEnd((float)far);
            RenderSystem.fogDensity((float)0.0f);
        }
    }

    @SubscribeEvent
    public void worldSaveEvent(WorldEvent.Save event) {
        if (event.getWorld() instanceof World && ZUtils.getDimensionIdentifier((World)((World)event.getWorld())).equals((Object)DimensionType.field_242710_a)) {
            try {
                DimensionManager.getInstance().saveDimensions("advRocketry");
            }
            catch (Exception e) {
                AdvancedRocketry.logger.fatal("An error has occured saving planet data, this can happen if another mod causes the game to crash during game load.  If the game has fully loaded, then this is a serious error, Advanced Rocketry data has not been saved.");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void fallEvent(LivingFallEvent event) {
        if (DimensionManager.getInstance().isDimensionCreated(ZUtils.getDimensionIdentifier((World)event.getEntity().field_70170_p))) {
            DimensionProperties planet = DimensionManager.getInstance().getDimensionProperties(ZUtils.getDimensionIdentifier((World)event.getEntity().field_70170_p));
            event.setDistance(event.getDistance() * planet.getGravitationalMultiplier(new BlockPos(event.getEntity().func_213303_ch())));
        }
    }

    static {
        transitionMap = new LinkedList<TransitionEntity>();
        component = new ItemStack((IItemProvider)AdvancedRocketryItems.itemUpgradeFogGoggles, 1);
    }
}

