/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.armor.IFillableArmor;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.client.render.ClientDynamicTexture;
import zmaster587.advancedRocketry.client.render.planet.ISkyRenderer;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.util.ItemAirUtils;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.client.ResourceIcon;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.ZUtils;

public class RocketEventHandler
extends Screen {
    private ResourceLocation background = TextureResources.rocketHud;
    private static ClientDynamicTexture earth;
    private static ClientDynamicTexture outerBounds;
    private static final int getImgSize = 512;
    private static final int outerImgSize = 64;
    private static boolean mapReady;
    private static boolean mapNeedsBinding;
    private static IntBuffer table;
    private static IntBuffer outerBoundsTable;
    private static ISkyRenderer prevRenderHanlder;
    Thread thread = null;
    public static GuiBox suitPanel;
    public static GuiBox oxygenBar;
    public static GuiBox hydrogenBar;
    public static GuiBox atmBar;
    private static GuiBox currentlySelectedBox;
    private static final int numTicksToDisplay = 100;
    private static String displayString;
    private static long lastDisplayTime;

    public RocketEventHandler() {
        super((ITextComponent)new StringTextComponent(""));
    }

    @SubscribeEvent
    public void onRocketDeorbit(RocketEvent.RocketDeOrbitingEvent event) {
        if (event.world.field_72995_K) {
            mapReady = true;
            if (((Boolean)ARConfiguration.getCurrentConfig().planetSkyOverride.get()).booleanValue() && !DimensionManager.getInstance().isDimensionCreated(event.world)) {
                DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(event.world);
                prevRenderHanlder = props.getSkyRenderer();
                props.setSkyRenderer(new RenderPlanetarySky());
            }
        }
    }

    @SubscribeEvent
    public void playerTeleportEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        lastDisplayTime = -1000L;
    }

    @SubscribeEvent
    public void onRocketLaunch(RocketEvent.RocketLaunchEvent event) {
        if (((Boolean)ARConfiguration.getCurrentConfig().planetSkyOverride.get()).booleanValue() && event.world.field_72995_K && !event.getEntity().func_184188_bt().isEmpty() && event.getEntity().func_184188_bt().contains(Minecraft.func_71410_x().field_71439_g)) {
            mapReady = true;
            DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(event.world);
            prevRenderHanlder = props.getSkyRenderer();
            props.setSkyRenderer(new RenderPlanetarySky());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setOverlay(long endTime, String msg) {
        displayString = msg;
        lastDisplayTime = endTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void destroyOrbitalTextures(World world) {
        if (!((Boolean)ARConfiguration.getCurrentConfig().skyOverride.get()).booleanValue() && !DimensionManager.getInstance().isDimensionCreated(ZUtils.getDimensionIdentifier((World)world))) {
            DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(world);
            props.setSkyRenderer(prevRenderHanlder);
            prevRenderHanlder = null;
        }
        if (earth != null) {
            GL11.glDeleteTextures((int)earth.getTextureId());
        }
        if (outerBounds != null) {
            GL11.glDeleteTextures((int)outerBounds.getTextureId());
        }
        outerBounds = null;
        earth = null;
        mapReady = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void prepareOrbitalMap(RocketEvent event) {
        mapReady = false;
        if (earth == null) {
            earth = new ClientDynamicTexture(512, 512);
            outerBounds = new ClientDynamicTexture(64, 64);
        }
        if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)event.world))) {
            RocketEventHandler.destroyOrbitalTextures(event.world);
            mapReady = false;
            return;
        }
        final World worldObj = event.world;
        final Entity entity = event.getEntity();
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int numChunksLoaded = 0;
                    long[] rightEdge = new long[]{0L, 0L, 0L};
                    long[] leftEdge = rightEdge;
                    long[] bottomEdge = rightEdge;
                    long[] topEdge = rightEdge;
                    long[] total = rightEdge;
                    int numtries = 0;
                    do {
                        ++numtries;
                        for (int i = 0; i < 262144; ++i) {
                            int intColor;
                            int b;
                            int g;
                            int r;
                            int color2;
                            int zPosition;
                            int xOffset = i % 512;
                            int yOffset = i / 512;
                            int xPosition = (int)entity.func_226277_ct_() - 256 + xOffset;
                            BlockPos thisPos = new BlockPos(xPosition, 0, zPosition = (int)entity.func_226281_cx_() - 256 + yOffset);
                            Chunk chunk = worldObj.func_175726_f(thisPos);
                            if (chunk.func_76621_g()) continue;
                            ++numChunksLoaded;
                            int heightValue = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, xPosition + (chunk.func_76632_l().field_77276_a >= 0 ? -(Math.abs(chunk.func_76632_l().field_77276_a) << 4) : Math.abs(chunk.func_76632_l().field_77276_a) << 4), zPosition + (chunk.func_76632_l().field_77275_b >= 0 ? -(Math.abs(chunk.func_76632_l().field_77275_b) << 4) : Math.abs(chunk.func_76632_l().field_77275_b) << 4));
                            MaterialColor color = MaterialColor.field_151660_b;
                            BlockState block = null;
                            for (int yPosition = heightValue; yPosition > 0 && (color = (block = worldObj.func_180495_p(new BlockPos(xPosition, yPosition, zPosition))).func_185909_g((IBlockReader)worldObj, thisPos)) == MaterialColor.field_151660_b; --yPosition) {
                            }
                            if (block == null) continue;
                            if (block.func_177230_c() == Blocks.field_196658_i || block.func_177230_c() == Blocks.field_196804_gh) {
                                color2 = worldObj.func_226691_t_(thisPos).func_225528_a_((double)thisPos.func_177958_n(), (double)thisPos.func_177952_p());
                                r = color2 & 0xFF;
                                g = color2 >>> 8 & 0xFF;
                                b = color2 >>> 16 & 0xFF;
                                intColor = b | g << 8 | r << 16;
                            } else if (block.func_177230_c() == Blocks.field_196642_W) {
                                color2 = worldObj.func_226691_t_(thisPos).func_225527_a_();
                                r = color2 & 0xFF;
                                g = color2 >>> 8 & 0xFF;
                                b = color2 >>> 16 & 0xFF;
                                intColor = b | g << 8 | r << 16;
                            } else {
                                intColor = (color.field_76291_p & 0xFF) << 16 | color.field_76291_p >>> 16 & 0xFF | color.field_76291_p & 0xFF00;
                            }
                            table.put(i, intColor | 0xFF000000);
                            total[0] = total[0] + (long)(intColor & 0xFF);
                            total[1] = total[1] + (long)((intColor & 0xFF00) >>> 8);
                            total[2] = total[2] + (long)((intColor & 0xFF0000) >>> 16);
                        }
                    } while (numChunksLoaded == 0 && numtries < 5000);
                    int multiplierGreen = 1;
                    int multiplierBlue = 1;
                    total[0] = ZUtils.getAverageColor((long)total[0], (long)(total[1] * (long)multiplierGreen), (long)(total[2] * (long)multiplierBlue), (int)numChunksLoaded);
                    Random random = new Random();
                    int randomMax = 42;
                    for (int i = 0; i < 4096; ++i) {
                        int randR = randomMax - random.nextInt(randomMax) / 2;
                        int randG = randomMax - random.nextInt(randomMax) / 2 << 8;
                        int randB = randomMax - random.nextInt(randomMax) / 2 << 16;
                        int color = MathHelper.func_76125_a((int)((int)((total[0] & 0xFFL) + (long)randR)), (int)0, (int)255) | MathHelper.func_76125_a((int)((int)(total[0] & 0xFF00L) + randG), (int)256, (int)65280) | MathHelper.func_76125_a((int)((int)((total[0] & 0xFF0000L) + (long)randB)), (int)65536, (int)0xFF0000);
                        outerBoundsTable.put(i, color | 0xFF000000);
                    }
                    outerBoundsTable.flip();
                    table.flip();
                    mapNeedsBinding = true;
                    mapReady = true;
                }
            }, "Planet Texture Creator");
            this.thread.start();
        }
    }

    public static void onPostWorldRender(MatrixStack matrix, float partialTicks) {
        if (!mapReady) {
            return;
        }
        if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)Minecraft.func_71410_x().func_175606_aa().field_70170_p))) {
            RocketEventHandler.destroyOrbitalTextures(Minecraft.func_71410_x().func_175606_aa().field_70170_p);
            mapReady = false;
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.func_226278_cu_() < 260.0) {
            return;
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, -5.0, 0.0);
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableFog();
        RenderSystem.alphaFunc((int)516, (float)0.01f);
        RenderSystem.blendFunc((int)770, (int)771);
        float brightness = 16.0f;
        if (Minecraft.func_71410_x().func_175606_aa() != null && Minecraft.func_71410_x().func_175606_aa().field_70170_p != null) {
            brightness = Minecraft.func_71410_x().func_175606_aa().field_70170_p.func_205052_D(new BlockPos(Minecraft.func_71410_x().func_175606_aa().func_213303_ch()));
        }
        double deltaY = (Minecraft.func_71410_x().func_175606_aa().func_226278_cu_() - Minecraft.func_71410_x().func_175606_aa().field_70137_T) * (double)partialTicks;
        double size = 2560.0 / (72.0 - Minecraft.func_71410_x().func_175606_aa().func_226278_cu_() * 1000.0 / (double)((Integer)ARConfiguration.getCurrentConfig().orbit.get()).intValue());
        DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(Minecraft.func_71410_x().func_175606_aa().field_70170_p);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(props.getPlanetIconLEO());
        double size2 = size * 16.0;
        float brightness2 = brightness;
        RenderHelper.renderTopFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)-10.1, (double)size2, (double)size2, (double)(-size2), (double)(-size2), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)brightness2, (float)brightness2, (float)brightness2, (float)MathHelper.func_76131_a((float)(((float)Minecraft.func_71410_x().func_175606_aa().func_226278_cu_() - 400.0f) / 50.0f), (float)0.0f, (float)1.0f));
        Tessellator.func_178181_a().func_78381_a();
        int skyColorI = Minecraft.func_71410_x().func_175606_aa().field_70170_p.func_226691_t_(new BlockPos(Minecraft.func_71410_x().func_175606_aa().func_213303_ch())).func_225529_c_();
        Vector3d skyColor = new Vector3d((double)(skyColorI >> 8 & 0xFF), (double)(skyColorI >> 4 & 0xFF), (double)(skyColorI & 0xFF));
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableTexture();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderSystem.color4f((float)((float)skyColor.field_72450_a), (float)((float)skyColor.field_72448_b), (float)((float)skyColor.field_72449_c), (float)0.15f);
        size = 51200.0 / (180.0 - Minecraft.func_71410_x().func_175606_aa().func_226278_cu_() - deltaY);
        int i = 0;
        while ((float)i < 5.0f * MathHelper.func_76131_a((float)(((float)DimensionManager.getInstance().getDimensionProperties(Minecraft.func_71410_x().func_175606_aa().field_70170_p).getAtmosphereDensity() * 0.01f * (float)Minecraft.func_71410_x().func_175606_aa().func_226278_cu_() - 280.0f) / 150.0f), (float)0.0f, (float)2.0f)) {
            RenderHelper.renderTopFace((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(-9.0 + (double)i * 0.6), (double)size, (double)size, (double)(-size), (double)(-size), (float)((float)skyColor.field_72450_a / 255.0f), (float)((float)skyColor.field_72448_b / 255.0f), (float)((float)skyColor.field_72449_c / 255.0f), (float)0.1f);
            ++i;
        }
        RenderSystem.enableTexture();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.disableBlend();
        RenderSystem.enableFog();
        matrix.func_227865_b_();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    @SubscribeEvent
    public void onScreenRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            boolean isCreativeOrSpec;
            Entity ride = Minecraft.func_71410_x().field_71439_g.func_184187_bx();
            if (ride instanceof EntityRocket) {
                EntityRocket rocket = (EntityRocket)ride;
                RenderSystem.enableBlend();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.background);
                this.func_238474_b_(event.getMatrixStack(), 0, 0, 0, 0, 17, 252);
                float percentOrbit = MathHelper.func_76131_a((float)((float)((rocket.func_226278_cu_() - (double)rocket.field_70170_p.func_181545_F()) / (double)((Integer)ARConfiguration.getCurrentConfig().orbit.get() - rocket.field_70170_p.func_181545_F()))), (float)0.0f, (float)1.0f);
                this.func_238474_b_(event.getMatrixStack(), 3, 8 + (int)(79.0f * (1.0f - percentOrbit)), 17, 0, 6, 6);
                this.func_238474_b_(event.getMatrixStack(), 3, 94 + (int)(69.0 * (0.5 - (double)(MathHelper.func_76131_a((float)((float)rocket.func_213322_ci().field_72448_b), (float)-1.0f, (float)1.0f) / 2.0f))), 17, 0, 6, 6);
                int size = 0;
                size = rocket.getFuelCapacityMonopropellant() > 0 ? (int)(68.0f * ((float)rocket.getFuelAmountMonopropellant() / (float)rocket.getFuelCapacityMonopropellant())) : (int)(68.0f * ((float)(rocket.getFuelAmountBipropellant() + rocket.getFuelAmountOxidizer()) / (float)(rocket.getFuelCapacityBipropellant() + rocket.getFuelCapacityOxidizer())));
                this.func_238474_b_(event.getMatrixStack(), 3, 242 - size, 17, 75 - size, 3, size);
                RenderSystem.disableBlend();
                String str = rocket.getTextOverlay();
                if (!str.isEmpty()) {
                    String[] strs = str.split("\n");
                    int vertPos = 0;
                    for (String strPart : strs) {
                        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                        float scale = str.length() < 50 ? 1.0f : 0.5f;
                        int screenX = (int)((float)Minecraft.func_71410_x().func_228018_at_().func_198107_o() / (scale * 6.0f) - (float)(fontRenderer.func_78256_a(strPart) / 2));
                        int screenY = (int)((float)(Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 18) / scale) + 18 * vertPos;
                        GL11.glPushMatrix();
                        GL11.glScalef((float)(scale * 3.0f), (float)(scale * 3.0f), (float)(scale * 3.0f));
                        fontRenderer.func_243246_a(event.getMatrixStack(), (ITextComponent)new StringTextComponent(strPart), (float)screenX, (float)screenY, 0xFFFFFF);
                        GL11.glPopMatrix();
                        ++vertPos;
                    }
                }
            }
            boolean bl = isCreativeOrSpec = Minecraft.func_71410_x().field_71439_g.func_184812_l_() || Minecraft.func_71410_x().field_71439_g.func_175149_v();
            if (!isCreativeOrSpec) {
                ItemStack chestPiece = Minecraft.func_71410_x().field_71439_g.func_184582_a(EquipmentSlotType.CHEST);
                IFillableArmor fillable = null;
                if (!chestPiece.func_190926_b() && chestPiece.func_77973_b() instanceof IFillableArmor) {
                    fillable = (IFillableArmor)chestPiece.func_77973_b();
                } else if (ItemAirUtils.INSTANCE.isStackValidAirContainer(chestPiece)) {
                    fillable = new ItemAirUtils.ItemAirWrapper(chestPiece);
                }
                if (fillable != null) {
                    float size = (float)fillable.getAirRemaining(chestPiece) / (float)fillable.getMaxAir(chestPiece);
                    RenderSystem.enableBlend();
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.background);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int width = 83;
                    int screenX = oxygenBar.getRenderX();
                    int screenY = oxygenBar.getRenderY();
                    this.func_238474_b_(event.getMatrixStack(), screenX, screenY, 23, 0, width, 17);
                    this.func_238474_b_(event.getMatrixStack(), screenX, screenY, 23, 17, (int)((float)width * size), 17);
                }
            }
            if (!isCreativeOrSpec && Minecraft.func_71410_x().field_71439_g.func_184582_a(EquipmentSlotType.HEAD) != null && Minecraft.func_71410_x().field_71439_g.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof IModularArmor) {
                for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                    this.renderModuleSlots(Minecraft.func_71410_x().field_71439_g.func_184582_a(slot), 4 - slot.func_188454_b(), (RenderGameOverlayEvent)event);
                }
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - AtmosphereHandler.lastSuffocationTime < 0L) {
                AtmosphereHandler.lastSuffocationTime = 0L;
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - AtmosphereHandler.lastSuffocationTime < 100L) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                String str = "";
                if (AtmosphereHandler.currentAtm != null) {
                    str = AtmosphereHandler.currentAtm.getDisplayMessage();
                }
                int screenX = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 6 - fontRenderer.func_78256_a(str) / 2;
                int screenY = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 18;
                GL11.glPushMatrix();
                GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
                fontRenderer.func_243246_a(event.getMatrixStack(), (ITextComponent)new StringTextComponent(str), (float)screenX, (float)screenY, 0xFF5656);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.progressBars);
                this.func_238474_b_(event.getMatrixStack(), screenX + fontRenderer.func_78256_a(str) / 2 - 8, screenY - 16, 0, 156, 16, 16);
                GL11.glPopMatrix();
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() <= lastDisplayTime) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                GL11.glPushMatrix();
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                int loc = 0;
                for (String str : displayString.split("\n")) {
                    int screenX = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 4 - fontRenderer.func_78256_a(str) / 2;
                    int screenY = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 12 + loc * Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 12;
                    fontRenderer.func_243246_a(event.getMatrixStack(), (ITextComponent)new StringTextComponent(str), (float)screenX, (float)screenY, 0xFF5656);
                    ++loc;
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    @SubscribeEvent
    public void mouseInputEvent(InputEvent.MouseInputEvent event) {
        if (!((Boolean)ARConfiguration.getCurrentConfig().lockUI.get()).booleanValue() && Minecraft.func_71410_x().field_71417_B.func_198035_h()) {
            if (event.getButton() == 1) {
                int i = this.getMinecraft().func_228018_at_().func_198107_o();
                int j = this.getMinecraft().func_228018_at_().func_198087_p();
                int mouseX = (int)(Minecraft.func_71410_x().field_71417_B.func_198024_e() * (double)i / (double)this.getMinecraft().func_228018_at_().func_198105_m());
                int mouseY = (int)((double)j - Minecraft.func_71410_x().field_71417_B.func_198026_f() * (double)j / (double)this.getMinecraft().func_228018_at_().func_198083_n() - 1.0);
                if (currentlySelectedBox == null && mouseX >= suitPanel.getX(i) && mouseX < suitPanel.getX(i) + RocketEventHandler.suitPanel.sizeX && mouseY >= suitPanel.getY(j) && mouseY < suitPanel.getY(j) + RocketEventHandler.suitPanel.sizeY) {
                    currentlySelectedBox = suitPanel;
                }
                if (currentlySelectedBox == null && mouseX >= oxygenBar.getX(i) && mouseX < oxygenBar.getX(i) + RocketEventHandler.oxygenBar.sizeX && mouseY >= oxygenBar.getY(j) && mouseY < oxygenBar.getY(j) + RocketEventHandler.oxygenBar.sizeY) {
                    currentlySelectedBox = oxygenBar;
                }
                if (currentlySelectedBox == null && mouseX >= hydrogenBar.getX(i) && mouseX < hydrogenBar.getX(i) + RocketEventHandler.hydrogenBar.sizeX && mouseY >= hydrogenBar.getY(j) && mouseY < hydrogenBar.getY(j) + RocketEventHandler.hydrogenBar.sizeY) {
                    currentlySelectedBox = hydrogenBar;
                }
                if (currentlySelectedBox == null && mouseX >= atmBar.getX(i) && mouseX < atmBar.getX(i) + RocketEventHandler.atmBar.sizeX && mouseY >= atmBar.getY(j) && mouseY < atmBar.getY(j) + RocketEventHandler.atmBar.sizeY) {
                    currentlySelectedBox = atmBar;
                }
                if (currentlySelectedBox != null) {
                    currentlySelectedBox.setRenderX(mouseX, i);
                    currentlySelectedBox.setRenderY(mouseY, j);
                }
            } else {
                currentlySelectedBox = null;
            }
        }
    }

    private void renderModuleSlots(ItemStack armorStack, int slot, RenderGameOverlayEvent event) {
        boolean modularArmorFlag;
        int index = 1;
        float color = 0.85f + 0.15f * MathHelper.func_76126_a((float)((float)Math.PI * 2 * (float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 60L) / 60.0f));
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFunc((int)770, (int)771);
        float alpha = 0.6f;
        MatrixStack matrix = event.getMatrixStack();
        if (armorStack != null && ((modularArmorFlag = armorStack.func_77973_b() instanceof IModularArmor) || ItemAirUtils.INSTANCE.isStackValidAirContainer(armorStack))) {
            int size = 24;
            int screenY = suitPanel.getRenderY() + (slot - 1) * (size + 8);
            int screenX = suitPanel.getRenderX();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.frameHUDBG);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(this.func_230927_p_() - 1), (double)(screenX - 4), (double)(screenY - 4), (double)(screenX + size), (double)(screenY + size + 4), (float)0.0f, (float)0.5f, (float)0.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.frameHUDBG);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(this.func_230927_p_() - 1), (double)(screenX + size), (double)(screenY - 3), (double)(screenX + 2 + size), (double)(screenY + size + 3), (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f);
            Tessellator.func_178181_a().func_78381_a();
            RenderSystem.color4f((float)color, (float)color, (float)color, (float)color);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.armorSlots[slot - 1]);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(this.func_230927_p_() - 1), (double)screenX, (double)screenY, (double)(screenX + size), (double)(screenY + size), (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            Tessellator.func_178181_a().func_78381_a();
            if (modularArmorFlag) {
                List stacks = ((IModularArmor)armorStack.func_77973_b()).getComponents(armorStack);
                for (ItemStack stack : stacks) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ((IArmorComponent)stack.func_77973_b()).renderScreen(event.getMatrixStack(), stack, stacks, event, (Screen)this);
                    ResourceIcon icon = ((IArmorComponent)stack.func_77973_b()).getComponentIcon(stack);
                    ResourceLocation texture = null;
                    if (icon != null) {
                        texture = icon.getResourceLocation();
                    }
                    screenX = suitPanel.getRenderX() + 4 + index * (size + 2);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.frameHUDBG);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(this.func_230927_p_() - 1), (double)(screenX - 4), (double)(screenY - 4), (double)(screenX + size - 2), (double)(screenY + size + 4), (float)0.5f, (float)0.5f, (float)0.0f, (float)1.0f);
                    Tessellator.func_178181_a().func_78381_a();
                    if (texture != null) {
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                        RenderSystem.color4f((float)color, (float)color, (float)color, (float)alpha);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)(this.func_230927_p_() - 1), (double)screenX, (double)screenY, (double)(screenX + size), (double)(screenY + size), (float)icon.getMinU(), (float)icon.getMaxU(), (float)icon.getMaxV(), (float)icon.getMinV());
                        Tessellator.func_178181_a().func_78381_a();
                    } else {
                        GL11.glPushMatrix();
                        RenderSystem.translatef((float)screenX, (float)screenY, (float)0.0f);
                        RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.5f);
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, 0, 0);
                        GL11.glPopMatrix();
                    }
                    ++index;
                }
            }
            screenX = index * (size + 2) + suitPanel.getRenderX() - 12;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.frameHUDBG);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)((double)this.func_230927_p_() - 1.0), (double)((double)screenX + 12.0), (double)((double)screenY - 4.0), (double)((double)screenX + (double)size), (double)((double)screenY + (double)size + 4.0), (float)0.75f, (float)1.0f, (float)0.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
        }
        RenderSystem.disableAlphaTest();
    }

    static {
        mapReady = false;
        mapNeedsBinding = false;
        prevRenderHanlder = null;
        suitPanel = new GuiBox(8, 8, 24, 24);
        oxygenBar = new GuiBox(8, -57, 80, 48);
        hydrogenBar = new GuiBox(8, -74, 80, 48);
        atmBar = new GuiBox(8, 27, 200, 48);
        currentlySelectedBox = null;
        displayString = "";
        lastDisplayTime = -1000L;
    }

    public static class GuiBox {
        private int x;
        private int y;
        int modeX = -1;
        int modeY = -1;
        int sizeX;
        int sizeY;
        boolean isVisible = true;

        public GuiBox(int x, int y, int sizeX, int sizeY) {
            this.setRawX(x);
            this.setRawY(y);
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }

        public int getX(int scaledW) {
            if (this.modeX == 1) {
                return scaledW - this.getRawX();
            }
            if (this.modeX == 0) {
                return scaledW / 2 - this.getRawX();
            }
            return this.getRawX();
        }

        public int getY(int scaledH) {
            if (this.modeY == 1) {
                return scaledH - this.getRawY();
            }
            if (this.modeY == 0) {
                return scaledH / 2 - this.getRawY();
            }
            return this.getRawY();
        }

        public void setRenderX(int x, double scaleX) {
            double i = scaleX;
            if ((double)x < i / 3.0) {
                this.modeX = -1;
                this.setRawX(x);
            } else if ((double)x > i * 2.0 / 3.0) {
                this.setRawX((int)(i - (double)x));
                this.modeX = 1;
            } else {
                this.setRawX((int)(i / 2.0 - (double)x));
                this.modeX = 0;
            }
        }

        public void setRenderY(int y, double scaleY) {
            double i = scaleY;
            if ((double)y < i / 3.0) {
                this.modeY = -1;
                this.setRawY(y);
            } else if ((double)y > i * 2.0 / 3.0) {
                this.setRawY((int)(i - (double)y));
                this.modeY = 1;
            } else {
                this.setRawY((int)(i / 2.0 - (double)y));
                this.modeY = 0;
            }
        }

        public int getRenderX() {
            int i = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            if (this.modeX == 1) {
                return i - this.getRawX();
            }
            if (this.modeX == 0) {
                return i / 2 - this.getRawX();
            }
            return this.getRawX();
        }

        public int getRenderY() {
            int i = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
            if (this.modeY == 1) {
                return i - this.getRawY();
            }
            if (this.modeY == 0) {
                return i / 2 - this.getRawY();
            }
            return this.getRawY();
        }

        public int getRawX() {
            return this.x;
        }

        public void setRawX(int x) {
            this.x = x;
        }

        public int getRawY() {
            return this.y;
        }

        public void setRawY(int y) {
            this.y = y;
        }

        public void setSizeModeX(int int1) {
            this.modeX = int1;
        }

        public void setSizeModeY(int int1) {
            this.modeY = int1;
        }

        public int getSizeModeX() {
            return this.modeX;
        }

        public int getSizeModeY() {
            return this.modeY;
        }
    }
}

