/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.advancedRocketry.integration.jei.MachineRecipe;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.recipe.RecipesMachine;

public abstract class MachineCategoryTemplate<T extends MachineRecipe>
implements IRecipeCategory<T> {
    IDrawable background;
    ProgressBarImage bar;
    IDrawable icon;

    public MachineCategoryTemplate(IGuiHelper helper, ProgressBarImage bar, ItemStack icon) {
        this.background = helper.createDrawable(new ResourceLocation("advancedrocketry:textures/gui/genericneibackground.png"), 7, 16, 163, 55);
        this.bar = bar;
        this.icon = helper.createDrawableIngredient((Object)icon);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw(recipe, matrixStack, mouseX, mouseY);
        ProgressBarImage progressBar = this.bar;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.progressBars);
        Minecraft.func_71410_x().field_71462_r.func_238474_b_(matrixStack, 65, 3, progressBar.getBackOffsetX(), progressBar.getBackOffsetY(), progressBar.getBackWidth(), progressBar.getBackHeight());
        progressBar.renderProgressBar(matrixStack, 65, 3, (float)(System.currentTimeMillis() % 3000L) / 3000.0f, (AbstractGui)Minecraft.func_71410_x().field_71462_r);
    }

    public void setIngredients(T recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, ((MachineRecipe)((Object)recipe)).getInputs());
        ingredients.setInputs(VanillaTypes.FLUID, recipe.getFluidIngredients());
        LinkedList<ItemStack> outputStacks = new LinkedList<ItemStack>();
        for (ItemStack stack : ((MachineRecipe)((Object)recipe)).getResults()) {
            outputStacks.add(stack);
        }
        LinkedList<FluidStack> outputFluids = new LinkedList<FluidStack>();
        for (RecipesMachine.ChanceFluidStack stack : recipe._getRawFluidOutput()) {
            outputFluids.add(stack.stack);
        }
        ingredients.setOutputs(VanillaTypes.ITEM, outputStacks);
        ingredients.setOutputs(VanillaTypes.FLUID, outputFluids);
    }

    public void setRecipe(IRecipeLayout recipeLayout, T recipeWrapper, IIngredients ingredients) {
        int i;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        int numOutputs = ingredients.getOutputs(VanillaTypes.ITEM).size() + ingredients.getOutputs(VanillaTypes.FLUID).size();
        for (i = 0; i < 10; ++i) {
            guiItemStacks.init(i, true, 18 * (i % 3), 18 * (i / 3));
            guiFluidStacks.init(i, true, 18 * (i % 3) + 1, 18 * (i / 3) + 1, 16, 16, 1, false, null);
        }
        for (i = 0; i < numOutputs; ++i) {
            guiItemStacks.init(i + 9, false, 108 + 18 * (i % 3), 18 * (i / 3));
            guiFluidStacks.init(i + 9, false, 108 + 18 * (i % 3) + 1, 18 * (i / 3) + 1, 16, 16, 1, false, null);
        }
        i = 0;
        for (List stacks : ingredients.getInputs(VanillaTypes.ITEM)) {
            guiItemStacks.set(i++, stacks);
        }
        for (List stacks : ingredients.getInputs(VanillaTypes.FLUID)) {
            guiFluidStacks.set(i++, stacks);
        }
        i = 9;
        for (List stacks : ingredients.getOutputs(VanillaTypes.ITEM)) {
            guiItemStacks.set(i++, stacks);
        }
        for (List stacks : ingredients.getOutputs(VanillaTypes.FLUID)) {
            guiFluidStacks.set(i++, stacks);
        }
    }
}

