/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.client.render.ClientDynamicTexture;
import zmaster587.advancedRocketry.inventory.ContainerOreMappingSatellite;
import zmaster587.advancedRocketry.satellite.SatelliteOreMapping;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.render.RenderHelper;

public class GuiOreMappingSatellite
extends ContainerScreen<ContainerOreMappingSatellite> {
    ClientDynamicTexture texture;
    Thread currentMapping;
    TileEntity masterConsole;
    boolean merged = false;
    private static final int SCREEN_SIZE = 146;
    private int maxZoom = 128;
    private static final int MAXRADIUS = 16;
    private static final int FANCYSCANMAXSIZE = 57;
    private int fancyScanOffset;
    private long prevWorldTickTime;
    private int prevSlot;
    private int mouseValue;
    private int scanSize = 2;
    private int radius = 1;
    private int zoomScale;
    private int xSelected;
    private int zSelected;
    private int xCenter;
    private int zCenter;
    private int playerPosX;
    private int playerPosZ;
    private static final ResourceLocation backdrop = new ResourceLocation("advancedrocketry", "textures/gui/VideoSatallite.png");
    int[][] oreMap;
    World world;
    SatelliteOreMapping satellite;
    Runnable mapper = new Runnable(){

        @Override
        public void run() {
            GuiOreMappingSatellite.this.oreMap = GuiOreMappingSatellite.this.satellite.scanChunk(GuiOreMappingSatellite.this.world, GuiOreMappingSatellite.this.xCenter, GuiOreMappingSatellite.this.zCenter, GuiOreMappingSatellite.this.scanSize / 2, GuiOreMappingSatellite.this.radius, GuiOreMappingSatellite.this.zoomScale);
            GuiOreMappingSatellite.this.merged = GuiOreMappingSatellite.this.oreMap != null && !Thread.interrupted();
        }
    };

    public GuiOreMappingSatellite(ContainerOreMappingSatellite container, PlayerInventory inventoryPlayer, ITextComponent title) {
        super((Container)container, inventoryPlayer, title);
        this.world = container.player.field_70170_p;
        this.prevSlot = -1;
        this.satellite = container.inv;
        this.playerPosX = this.xCenter = (int)container.player.func_226277_ct_();
        this.playerPosZ = this.zCenter = (int)container.player.func_226281_cx_();
        this.satellite = container.inv;
        if (this.satellite != null) {
            this.maxZoom = (int)Math.pow(2.0, this.satellite.getZoomRadius());
            this.zoomScale = this.satellite.getZoomRadius();
        }
        if (this.maxZoom == 1) {
            this.satellite = null;
        }
        this.scanSize = this.maxZoom;
        this.prevWorldTickTime = this.world.func_82737_E();
        this.fancyScanOffset = 0;
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    private void runMapperWithSelection() {
        if (this.satellite == null) {
            return;
        }
        this.currentMapping.interrupt();
        this.resetTexture();
        if (this.prevSlot == -1) {
            this.currentMapping = new Thread(this.mapper);
            this.currentMapping.setName("Ore Scan");
        } else {
            this.currentMapping = new Thread(new ItemMapper(this.field_213127_e.func_70301_a(this.prevSlot).getStack()));
            this.currentMapping.setName("Ore Scan");
        }
        this.currentMapping.start();
    }

    public boolean func_231048_c_(double x, double y, int button) {
        boolean val = super.func_231048_c_(x, y, button);
        int xOffset = 47 + (this.field_230708_k_ - 240) / 2;
        int yOffset = 20 + (this.field_230709_l_ - 192) / 2;
        if (button == 0 && this.satellite.getSelectedSlot() != this.prevSlot) {
            this.prevSlot = this.satellite.getSelectedSlot();
            this.runMapperWithSelection();
        }
        if (x < (double)xOffset || x > (double)(xOffset + 146) || y < (double)yOffset || y > (double)(yOffset + 146)) {
            return false;
        }
        if (this.oreMap != null) {
            double numPixels = (float)this.scanSize / (float)(146 * this.radius);
            this.mouseValue = this.oreMap[(int)((x - (double)xOffset) * numPixels)][(int)((y - (double)yOffset) * numPixels)] / 255;
            this.xSelected = (int)((x - (double)xOffset) * numPixels) + this.xCenter - this.radius * this.scanSize / 2;
            this.zSelected = (int)((y - (double)yOffset) * numPixels) + this.zCenter - this.radius * this.scanSize / 2;
        }
        return val;
    }

    protected boolean func_195363_d(int keyCode, int scanCode) {
        if (keyCode == 87) {
            this.zCenter -= this.radius;
            this.runMapperWithSelection();
        } else if (keyCode == 83) {
            this.zCenter += this.radius;
            this.runMapperWithSelection();
        } else if (keyCode == 65) {
            this.xCenter -= this.radius;
            this.runMapperWithSelection();
        } else if (keyCode == 65) {
            this.xCenter += this.radius;
            this.runMapperWithSelection();
        } else if (keyCode == 264) {
            this.scanSize = Math.min(this.scanSize * 2, this.maxZoom);
            this.runMapperWithSelection();
        } else if (keyCode == 265) {
            if (this.scanSize / 2 / this.radius > 0) {
                this.scanSize = Math.max(this.scanSize / 2, 2);
                this.runMapperWithSelection();
            }
        } else {
            return super.func_195363_d(keyCode, scanCode);
        }
        return true;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.texture = new ClientDynamicTexture(Math.max(this.scanSize / this.radius, 1), Math.max(this.scanSize / this.radius, 1));
        ItemStack stack = this.field_213127_e.func_70301_a(0).getStack();
        if (this.satellite != null) {
            this.currentMapping = new Thread(this.mapper);
            this.currentMapping.setName("Ore Scan");
            this.currentMapping.start();
        }
    }

    private void resetTexture() {
        GL11.glDeleteTextures((int)this.texture.getTextureId());
        this.texture = new ClientDynamicTexture(Math.max(this.scanSize / this.radius, 1), Math.max(this.scanSize / this.radius, 1));
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        GL11.glDeleteTextures((int)this.texture.getTextureId());
        if (this.currentMapping != null) {
            this.currentMapping.interrupt();
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int a, int b) {
        int slot;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)0.0f, (float)0.8f, (float)0.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_(-21.0, (double)(82 + this.fancyScanOffset), (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_(0.0, (double)(84 + this.fancyScanOffset), (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_(0.0, (double)(81 + this.fancyScanOffset), (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_(-21.0, (double)(81 + this.fancyScanOffset), (double)this.func_230927_p_()).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_(-21.0, (double)(82 - this.fancyScanOffset + 57), (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_(0.0, (double)(84 - this.fancyScanOffset + 57), (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_(0.0, (double)(81 - this.fancyScanOffset + 57), (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_(-21.0, (double)(81 - this.fancyScanOffset + 57), (double)this.func_230927_p_()).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)772);
        RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.0f, (float)(0.3f + (float)Math.sin(Math.PI * (double)((float)this.fancyScanOffset / 57.0f)) / 3.0f));
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderHelper.renderNorthFace((MatrixStack)matrix, (IVertexBuilder)buffer, (double)this.func_230927_p_(), (double)173.0, (double)82.0, (double)194.0, (double)141.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        if (this.world.func_82737_E() - this.prevWorldTickTime >= 1L) {
            this.prevWorldTickTime = this.world.func_82737_E();
            this.fancyScanOffset = this.fancyScanOffset >= 57 ? 0 : ++this.fancyScanOffset;
        }
        if (this.satellite != null && (slot = this.satellite.getSelectedSlot()) != -1) {
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)0.0f, (float)0.8f, (float)0.0f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)this.func_230927_p_(), (double)(13 + 18 * slot), (double)155.0, (double)(29 + 18 * slot), (double)171.0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            Tessellator.func_178181_a().func_78381_a();
            RenderSystem.enableTexture();
        }
    }

    protected void func_230450_a_(MatrixStack matrix, float f1, int i2, int i3) {
        Object buffer;
        int x = (this.field_230708_k_ - 240) / 2;
        int y = (this.field_230709_l_ - 192) / 2;
        if (this.merged) {
            buffer = this.texture.getByteBuffer();
            int scanWidth = Math.max(this.scanSize / this.radius, 1);
            try {
                for (int yt = 0; yt < this.texture.getHeight() * this.texture.getWidth(); ++yt) {
                    ((IntBuffer)buffer).put(yt, this.oreMap[yt % scanWidth][scanWidth - 1 - yt / scanWidth] | 0xFF000000);
                }
                ((IntBuffer)buffer).flip();
                this.texture.setByteBuffer((IntBuffer)buffer);
            }
            catch (IndexOutOfBoundsException yt) {
                // empty catch block
            }
            this.merged = false;
        }
        buffer = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(backdrop);
        this.func_238474_b_(matrix, x, y, 0, 0, 240, 192);
        RenderSystem.bindTexture((int)this.texture.getTextureId());
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)this.func_230927_p_(), (double)(47 + x), (double)(20 + y), (double)(47 + x + 146), (double)(20 + y + 146), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        Tessellator.func_178181_a().func_78381_a();
        float offsetX = (float)(this.playerPosX - this.xCenter) + 0.5f;
        float offsetY = (float)(this.zCenter - this.playerPosZ) + 0.5f;
        double numPixels = 146 / this.scanSize;
        float radius = 2.0f;
        if (Math.abs(offsetX) < (float)(this.scanSize / 2) && Math.abs(offsetY) < (float)(this.scanSize / 2)) {
            offsetX = (float)((double)offsetX * numPixels);
            offsetY = (float)((double)offsetY * numPixels);
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)0.4f, (float)1.0f, (float)0.4f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)this.func_230927_p_(), (double)(offsetX + 47.0f + (float)x + 73.0f - radius), (double)(offsetY + 20.0f + (float)y + 73.0f - radius), (double)(offsetX + 47.0f + (float)x + 73.0f + radius), (double)(offsetY + 20.0f + (float)y + 73.0f + radius), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableTexture();
            GuiOreMappingSatellite.drawCenteredString(matrix, this.field_230712_o_, "You", (int)(offsetX + 47.0f + (float)x + 73.0f - radius), (int)(offsetY + 20.0f + (float)y + 73.0f - radius) - 10, 0xF0F0F0);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(backdrop);
        this.func_238474_b_(matrix, 197 + x, 31 + y, 0, 192, 32, 14);
        GuiOreMappingSatellite.drawString(matrix, this.field_230712_o_, "Zoom", 198 + x, 22 + y, 0xF0F0F0);
        GuiOreMappingSatellite.drawString(matrix, this.field_230712_o_, "X: " + this.xSelected, 6 + x, 33 + y, 0xF0F0F0);
        GuiOreMappingSatellite.drawString(matrix, this.field_230712_o_, "Z: " + this.zSelected, 6 + x, 49 + y, 0xF0F0F0);
        GuiOreMappingSatellite.drawString(matrix, this.field_230712_o_, LibVulpes.proxy.getLocalizedString("msg.itemorescanner.value"), 6 + x, 65 + y, 0xF0F0F0);
        GuiOreMappingSatellite.drawString(matrix, this.field_230712_o_, String.valueOf(this.mouseValue), 6 + x, 79 + y, 0xF0F0F0);
    }

    public static void drawString(MatrixStack matrix, FontRenderer font, String str, int x, int z, int color) {
        font.func_243246_a(matrix, (ITextComponent)new StringTextComponent(str), (float)x, (float)z, 0);
    }

    public static void drawCenteredString(MatrixStack matrix, FontRenderer font, String str, int x, int z, int color) {
        font.func_243246_a(matrix, (ITextComponent)new StringTextComponent(str), (float)x, (float)z, 0);
    }

    public void drawScreen(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    class ItemMapper
    implements Runnable {
        private ItemStack myBlock;

        ItemMapper(ItemStack block) {
            this.myBlock = block.func_77946_l();
        }

        @Override
        public void run() {
            GuiOreMappingSatellite.this.oreMap = GuiOreMappingSatellite.this.satellite.scanChunk(GuiOreMappingSatellite.this.world, GuiOreMappingSatellite.this.xCenter, GuiOreMappingSatellite.this.zCenter, GuiOreMappingSatellite.this.scanSize / 2, GuiOreMappingSatellite.this.radius, this.myBlock, GuiOreMappingSatellite.this.zoomScale);
            GuiOreMappingSatellite.this.merged = GuiOreMappingSatellite.this.oreMap != null && !Thread.interrupted();
        }
    }
}

