/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.SlotData;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.util.IconResource;

public class ModuleAutoData
extends ModuleBase {
    static final int barYSize = 38;
    static final int barXSize = 6;
    static final int textureOffsetX = 0;
    static final int textureOffsetY = 215;
    DataStorage[] data;
    int[] prevData;
    int prevDataType;
    int slot1;
    int slot2;
    IDataInventory chipInput;
    IDataInventory chipOutput;
    IconResource icon = TextureResources.ioSlot;

    public ModuleAutoData(int offsetX, int offsetY, int slot1, int slot2, IDataInventory chipInput, IDataInventory chipOutput, DataStorage ... data) {
        super(offsetX, offsetY);
        this.data = data;
        this.prevData = new int[data.length];
        this.chipInput = chipInput;
        this.chipOutput = chipOutput;
        this.slot1 = slot1;
        this.slot2 = slot2;
    }

    public List<Slot> getSlots(Container container) {
        this.slotList.add(new SlotData(this.chipInput, this.slot1, this.offsetX + 10, this.offsetY));
        this.slotList.add(new SlotData(this.chipOutput, this.slot2, this.offsetX + 10, this.offsetY + 24));
        return this.slotList;
    }

    public int numberOfChangesToSend() {
        return this.data.length + 1;
    }

    public boolean needsUpdate(int localId) {
        if (localId < this.data.length) {
            return this.data[localId].getData() != this.prevData[localId];
        }
        return this.data[0].getDataType().ordinal() != this.prevDataType;
    }

    protected void updatePreviousState(int localId) {
        if (localId < this.data.length) {
            this.prevData[localId] = this.data[localId].getData();
        } else {
            this.prevDataType = this.data[0].getDataType().ordinal();
        }
    }

    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        if (localId < this.data.length) {
            crafter.func_71112_a(container, variableId, this.data[localId].getData());
        } else {
            crafter.func_71112_a(container, variableId, this.data[0].getDataType().ordinal());
        }
    }

    public void onChangeRecieved(int slot, int value) {
        if (slot < this.data.length) {
            this.data[slot].setData(value, DataStorage.DataType.UNDEFINED);
        } else {
            this.data[0].setDataType(DataStorage.DataType.values()[value]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderForeground(MatrixStack matrix, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        if (relativeX > 0 && relativeX < 6 && relativeY > 0 && relativeY < 38) {
            int totalData = 0;
            int totalMaxData = 0;
            for (DataStorage datum : this.data) {
                totalData += datum.getData();
                totalMaxData += datum.getMaxData();
            }
            LinkedList<String> list = new LinkedList<String>();
            list.add(totalData + " / " + totalMaxData + " Data");
            list.add("Type: " + I18n.func_135052_a((String)this.data[0].getDataType().toString(), (Object[])new Object[0]));
            this.drawTooltip(gui, matrix, list, mouseX, mouseY, zLevel, font);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack matrix, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        for (Slot slot : this.slotList) {
            gui.func_238474_b_(matrix, x + slot.field_75223_e - 1, y + slot.field_75221_f - 1, this.icon.getxLoc(), this.icon.getyLoc(), this.icon.getxSize(), this.icon.getySize());
        }
        int totalData = 0;
        int totalMaxData = 0;
        for (DataStorage datum : this.data) {
            totalData += datum.getData();
            totalMaxData += datum.getMaxData();
        }
        float percent = (float)totalData / (float)totalMaxData;
        gui.func_238474_b_(matrix, this.offsetX + x, this.offsetY + y, 176, 18, 8, 40);
        gui.func_238474_b_(matrix, this.offsetX + x - 1, this.offsetY + y + 38 + 4, 19, 171, 10, 10);
        gui.func_238474_b_(matrix, this.offsetX + x + 1, 1 + this.offsetY + y + (38 - (int)(percent * 38.0f)), 0, 38 - (int)(percent * 38.0f) + 215, 6, (int)(percent * 38.0f));
    }
}

