/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.client.render.ClientDynamicTexture;
import zmaster587.advancedRocketry.satellite.SatelliteOreMapping;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.render.RenderHelper;

@OnlyIn(value=Dist.CLIENT)
public class ModuleOreMapper
extends ModuleBase {
    ClientDynamicTexture texture;
    Thread currentMapping;
    TileEntity masterConsole;
    boolean merged = false;
    private static final int SCREEN_SIZE = 146;
    private static final int MAXZOOM = 128;
    private static final int MAXRADIUS = 16;
    private static final int FANCYSCANMAXSIZE = 57;
    private int fancyScanOffset;
    private long prevWorldTickTime;
    private int prevSlot;
    private int mouseValue;
    private int scanSize = 32;
    private int radius = 1;
    private int zoomScale = 1;
    private int maxZoom = 1;
    private int xSelected;
    private int zSelected;
    private int xCenter;
    private int zCenter;
    private static final ResourceLocation backdrop = new ResourceLocation("advancedrocketry", "textures/gui/VideoSatallite.png");
    int[][] oreMap;
    World world;
    SatelliteOreMapping tile;
    ItemStack selectedStack;
    SatelliteOreMapping satellite;
    Runnable mapper = new Runnable(){

        @Override
        public void run() {
            ModuleOreMapper.this.oreMap = ModuleOreMapper.this.satellite.scanChunk(ModuleOreMapper.this.world, ModuleOreMapper.this.xCenter, ModuleOreMapper.this.zCenter, ModuleOreMapper.this.scanSize / 2, ModuleOreMapper.this.radius, ModuleOreMapper.this.zoomScale);
            ModuleOreMapper.this.merged = ModuleOreMapper.this.oreMap != null && !Thread.interrupted();
        }
    };

    public ModuleOreMapper(int offsetX, int offsetY, SatelliteOreMapping satellite) {
        super(offsetX, offsetY);
        this.world = Minecraft.func_71410_x().field_71441_e;
        this.prevSlot = -1;
        this.tile = this.tile;
        if (satellite != null) {
            this.maxZoom = (int)Math.pow(2.0, satellite.getZoomRadius());
            this.zoomScale = satellite.getZoomRadius();
        }
        if (this.maxZoom == 1) {
            this.satellite = null;
        }
        this.scanSize = this.maxZoom;
        this.prevWorldTickTime = this.world.func_82737_E();
        this.fancyScanOffset = 0;
    }

    private void runMapperWithSelection() {
        this.currentMapping.interrupt();
        this.resetTexture();
        if (this.prevSlot == -1) {
            this.currentMapping = new Thread(this.mapper);
            this.currentMapping.setName("Ore Scan");
        } else {
            this.currentMapping.setName("Ore Scan");
        }
        this.currentMapping.start();
    }

    private void resetTexture() {
        GL11.glDeleteTextures((int)this.texture.getTextureId());
        this.texture = new ClientDynamicTexture(Math.max(this.scanSize / this.radius, 1), Math.max(this.scanSize / this.radius, 1));
    }

    public void renderForeground(MatrixStack matrix, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        int slot;
        super.renderForeground(matrix, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_227621_I_();
        buffer.func_227885_a_(0.0f, 0.8f, 0.0f, 1.0f);
        buffer.func_181668_a(7, buffer.getVertexFormat());
        buffer.func_225582_a_(-21.0, (double)(82 + this.fancyScanOffset), (double)zLevel).func_181675_d();
        buffer.func_225582_a_(0.0, (double)(84 + this.fancyScanOffset), (double)zLevel).func_181675_d();
        buffer.func_225582_a_(0.0, (double)(81 + this.fancyScanOffset), (double)zLevel).func_181675_d();
        buffer.func_225582_a_(-21.0, (double)(81 + this.fancyScanOffset), (double)zLevel).func_181675_d();
        buffer.func_178977_d();
        buffer.func_181668_a(7, buffer.getVertexFormat());
        buffer.func_225582_a_(-21.0, (double)(82 - this.fancyScanOffset + 57), (double)zLevel).func_181675_d();
        buffer.func_225582_a_(0.0, (double)(84 - this.fancyScanOffset + 57), (double)zLevel).func_181675_d();
        buffer.func_225582_a_(0.0, (double)(81 - this.fancyScanOffset + 57), (double)zLevel).func_181675_d();
        buffer.func_225582_a_(-21.0, (double)(81 - this.fancyScanOffset + 57), (double)zLevel).func_181675_d();
        buffer.func_178977_d();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)772);
        buffer.func_227885_a_(0.5f, 0.5f, 0.0f, 0.3f + (float)Math.sin(Math.PI * (double)((float)this.fancyScanOffset / 57.0f)) / 3.0f);
        buffer.func_181668_a(7, buffer.getVertexFormat());
        RenderHelper.renderNorthFace((MatrixStack)matrix, (IVertexBuilder)buffer, (double)zLevel, (double)173.0, (double)82.0, (double)194.0, (double)141.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_178977_d();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
        if (this.world.func_82737_E() - this.prevWorldTickTime >= 1L) {
            this.prevWorldTickTime = this.world.func_82737_E();
            this.fancyScanOffset = this.fancyScanOffset >= 57 ? 0 : ++this.fancyScanOffset;
        }
        if ((slot = this.tile.getSelectedSlot()) != -1) {
            GL11.glDisable((int)3553);
            GL11.glColor3f((float)0.0f, (float)0.8f, (float)0.0f);
            buffer.func_181668_a(7, buffer.getVertexFormat());
            RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)zLevel, (double)(13 + 18 * slot), (double)155.0, (double)(29 + 18 * slot), (double)171.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            buffer.func_178977_d();
            GL11.glEnable((int)3553);
        }
    }

    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack matrix, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, matrix, x, y, mouseX, mouseY, font);
        if (this.merged) {
            IntBuffer buffer = this.texture.getByteBuffer();
            int scanWidth = Math.max(this.scanSize / this.radius, 1);
            for (int yt = 0; yt < this.texture.getHeight() * this.texture.getWidth(); ++yt) {
                buffer.put(yt, this.oreMap[yt % scanWidth][yt / scanWidth] | 0xFF000000);
            }
            buffer.flip();
            this.texture.setByteBuffer(buffer);
            this.merged = false;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(backdrop);
        gui.func_238474_b_(matrix, x, y, 0, 0, 240, 192);
        int zLevel = 100;
        GL11.glBindTexture((int)3553, (int)this.texture.getTextureId());
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, buffer.getVertexFormat());
        RenderHelper.renderNorthFaceWithUV((MatrixStack)matrix, (IVertexBuilder)buffer, (double)zLevel, (double)(47 + x), (double)(20 + y), (double)(47 + x + 146), (double)(20 + y + 146), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        buffer.func_178977_d();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(backdrop);
        gui.func_238474_b_(matrix, 197 + x, 31 + y, 0, 192, 32, 14);
        font.func_243246_a(matrix, (ITextComponent)new StringTextComponent("Zoom"), (float)(198 + x), (float)(22 + y), 0xF0F0F0);
        font.func_243246_a(matrix, (ITextComponent)new StringTextComponent("X: " + this.xSelected), (float)(6 + x), (float)(33 + y), 0xF0F0F0);
        font.func_243246_a(matrix, (ITextComponent)new StringTextComponent("Z: " + this.zSelected), (float)(6 + x), (float)(49 + y), 0xF0F0F0);
        font.func_243246_a(matrix, (ITextComponent)new StringTextComponent("Value: "), (float)(6 + x), (float)(65 + y), 0xF0F0F0);
        font.func_243246_a(matrix, (ITextComponent)new StringTextComponent(String.valueOf(this.mouseValue)), (float)(6 + x), (float)(79 + y), 0xF0F0F0);
    }

    class ItemMapper
    implements Runnable {
        private ItemStack myBlock;

        ItemMapper(ItemStack block) {
            this.myBlock = block.func_77946_l();
        }

        @Override
        public void run() {
            ModuleOreMapper.this.oreMap = ModuleOreMapper.this.satellite.scanChunk(ModuleOreMapper.this.world, ModuleOreMapper.this.xCenter, ModuleOreMapper.this.zCenter, ModuleOreMapper.this.scanSize / 2, ModuleOreMapper.this.radius, this.myBlock, ModuleOreMapper.this.zoomScale);
            ModuleOreMapper.this.merged = ModuleOreMapper.this.oreMap != null;
        }
    }
}

