/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.IGalaxy;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleButtonPlanet;
import zmaster587.libVulpes.inventory.GuiModular;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleDualProgressBar;
import zmaster587.libVulpes.render.RenderHelper;

public class ModulePlanetSelector
extends ModuleContainerPan
implements IButtonInventory {
    ModuleButton btnUpLevel;
    ModuleButton btnConfirm;
    ModuleButton btnPlanetList;
    private static final int size = 2000;
    private ResourceLocation topLevel;
    ISelectionNotify hostTile;
    private ResourceLocation currentSystem;
    ResourceLocation selectedSystem;
    private double zoom;
    private boolean currentSystemChanged = false;
    private boolean stellarView;
    private List<ModuleButton> planetList;
    private ModuleContainerPan clickablePlanetList;
    private boolean allowStarSelection;
    private HashMap<ResourceLocation, PlanetRenderProperties> renderPropertiesMap;
    PlanetRenderProperties currentlySelectedPlanet;
    IPlanetDefiner planetDefiner;

    public ModulePlanetSelector(ResourceLocation planetId, ResourceLocation backdrop, ISelectionNotify tile, boolean star) {
        this(planetId, backdrop, tile, null, star);
    }

    public ModulePlanetSelector(ResourceLocation planetId, ResourceLocation backdrop, ISelectionNotify tile, IPlanetDefiner definer, boolean star) {
        super(0, 0, null, null, backdrop, 0, 0, 0, 0, 2000, 2000);
        this.planetDefiner = definer;
        this.hostTile = tile;
        int center = 1000;
        this.zoom = 1.0;
        this.planetList = new ArrayList<ModuleButton>();
        this.moduleList = new ArrayList();
        this.staticModuleList = new ArrayList();
        this.renderPropertiesMap = new HashMap();
        this.currentlySelectedPlanet = new PlanetRenderProperties();
        this.currentSystem = Constants.INVALID_STAR;
        this.selectedSystem = Constants.INVALID_PLANET;
        this.stellarView = false;
        this.btnUpLevel = new ModuleButton(0, 0, "<< Up", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild);
        this.staticModuleList.add(this.btnUpLevel);
        this.btnConfirm = new ModuleButton(0, 18, "Select", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild);
        this.staticModuleList.add(this.btnConfirm);
        this.btnPlanetList = new ModuleButton(0, 36, "PlanetList", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild);
        this.staticModuleList.add(this.btnPlanetList);
        ModuleDualProgressBar progressBar = new ModuleDualProgressBar(100, 0, 0, TextureResources.atmIndicator, (IProgressBar)tile, "%b -> %a Earth's atmospheric pressure");
        this.staticModuleList.add(progressBar);
        progressBar.setTooltipValueMultiplier(0.16f);
        progressBar = new ModuleDualProgressBar(200, 0, 2, TextureResources.massIndicator, (IProgressBar)tile, "%b -> %a Earth's mass");
        this.staticModuleList.add(progressBar);
        progressBar.setTooltipValueMultiplier(0.02f);
        progressBar = new ModuleDualProgressBar(300, 0, 1, TextureResources.distanceIndicator, (IProgressBar)tile, "%b -> %a Relative Distance units");
        this.staticModuleList.add(progressBar);
        progressBar.setTooltipValueMultiplier(0.16f);
        if (EffectiveSide.get().isClient()) {
            if (star) {
                this.topLevel = Constants.INVALID_PLANET;
                this.currentSystem = DimensionManager.getInstance().getStar(planetId).getId();
                this.renderStarSystem(DimensionManager.getInstance().getStar(planetId), center, center, 1.0f, 0.5f);
            } else {
                this.currentSystem = planetId;
                this.topLevel = planetId;
                this.renderPlanetarySystem(DimensionManager.getInstance().getDimensionProperties(planetId), center, center, 1.0f, 3.0f);
            }
            this.refreshSideBar(true, this.currentSystem);
        }
    }

    public void onScroll(double dwheel) {
        if (this.clickablePlanetList != null) {
            this.clickablePlanetList.onScroll(dwheel);
        }
    }

    public void setAllowStarSelection(boolean allow) {
        this.allowStarSelection = allow;
    }

    public ResourceLocation getSelectedSystem() {
        return this.selectedSystem;
    }

    public void setSelectedSystem(ResourceLocation id) {
        this.selectedSystem = id;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderGalaxyMap(IGalaxy galaxy, int posX, int posY, float distanceZoomMultiplier, float planetSizeMultiplier) {
        Collection<StellarBody> stars = galaxy.getStars();
        for (StellarBody star : stars) {
            ModuleButton button;
            if (this.planetDefiner != null && !this.planetDefiner.isStarKnown(star)) continue;
            int displaySize = (int)(planetSizeMultiplier * (float)star.getDisplayRadius());
            int offsetX = star.getPosX() + posX - displaySize / 2;
            int offsetY = star.getPosZ() + posY - displaySize / 2;
            if (star.getSubStars() != null && !star.getSubStars().isEmpty()) {
                float phaseInc = 360 / star.getSubStars().size();
                float phase = 0.0f;
                for (StellarBody star2 : star.getSubStars()) {
                    displaySize = (int)(planetSizeMultiplier * (float)star2.getDisplayRadius());
                    int deltaX = (int)((double)(star2.getStarSeparation() * MathHelper.func_76134_b((float)phase)) * 0.5);
                    int deltaY = (int)((double)(star2.getStarSeparation() * MathHelper.func_76126_a((float)phase)) * 0.5);
                    button = new ModuleButton(offsetX + deltaX, offsetY + deltaY, "", (IButtonInventory)this, new ResourceLocation[]{star.isBlackHole() ? TextureResources.locationBlackHole_icon : TextureResources.locationSunNew}, String.format("Name: %s\nNumber of Planets: %d", star.getName(), star.getNumPlanets()), displaySize, displaySize);
                    this.planetList.add(button);
                    button.setAdditionalData((Object)star.getId());
                    button.setSound("buttonblipa");
                    button.setBGColor(star2.getColorRGB8());
                    phase += phaseInc;
                }
            }
            button = new ModuleButton(offsetX, offsetY, "", (IButtonInventory)this, new ResourceLocation[]{star.isBlackHole() ? TextureResources.locationBlackHole_icon : TextureResources.locationSunNew}, String.format("Name: %s\nNumber of Planets: %d", star.getName(), star.getNumPlanets()), displaySize, displaySize);
            this.planetList.add(button);
            button.setAdditionalData((Object)star.getId());
            button.setSound("buttonblipa");
            button.setBGColor(star.getColorRGB8());
            this.renderPropertiesMap.put(star.getId(), new PlanetRenderProperties(displaySize, offsetX, offsetY));
        }
        this.moduleList.addAll(this.planetList);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderStarSystem(StellarBody star, int posX, int posY, float distanceZoomMultiplier, float planetSizeMultiplier) {
        ModuleButton button;
        int displaySize = (int)(planetSizeMultiplier * (float)star.getDisplayRadius());
        int offsetX = posX - displaySize / 2;
        int offsetY = posY - displaySize / 2;
        if (star.getSubStars() != null && !star.getSubStars().isEmpty()) {
            float phaseInc = 360 / star.getSubStars().size();
            float phase = 0.0f;
            for (StellarBody star2 : star.getSubStars()) {
                displaySize = (int)(planetSizeMultiplier * (float)star2.getDisplayRadius());
                int deltaX = (int)((double)(star2.getStarSeparation() * MathHelper.func_76134_b((float)phase)) * 0.5);
                int deltaY = (int)((double)(star2.getStarSeparation() * MathHelper.func_76126_a((float)phase)) * 0.5);
                button = new ModuleButton(offsetX + deltaX, offsetY + deltaY, "", (IButtonInventory)this, new ResourceLocation[]{star.isBlackHole() ? TextureResources.locationBlackHole_icon : TextureResources.locationSunNew}, String.format("Name: %s\nNumber of Planets: %d", star.getName(), star.getNumPlanets()), displaySize, displaySize);
                this.planetList.add(button);
                button.setAdditionalData((Object)star.getId());
                button.setSound("buttonblipa");
                button.setBGColor(star2.getColorRGB8());
                phase += phaseInc;
            }
        }
        displaySize = (int)(planetSizeMultiplier * (float)star.getDisplayRadius());
        offsetX = posX - displaySize / 2;
        offsetY = posY - displaySize / 2;
        button = new ModuleButton(offsetX, offsetY, "", (IButtonInventory)this, new ResourceLocation[]{star.isBlackHole() ? TextureResources.locationBlackHole_icon : TextureResources.locationSunNew}, String.format("Name: %s\nNumber of Planets: %d", star.getName(), star.getNumPlanets()), displaySize, displaySize);
        this.planetList.add(button);
        button.setAdditionalData((Object)star.getId());
        button.setSound("buttonblipa");
        button.setBGColor(star.getColorRGB8());
        this.renderPropertiesMap.put(star.getId(), new PlanetRenderProperties(displaySize, offsetX, offsetY));
        displaySize = (int)(planetSizeMultiplier * 100.0f);
        offsetX = posX - displaySize / 2;
        offsetY = posY - displaySize / 2;
        for (IDimensionProperties properties : star.getPlanets()) {
            if (this.planetDefiner != null && !this.planetDefiner.isPlanetKnown(properties) || properties.isMoon()) continue;
            this.renderPlanets((DimensionProperties)properties, offsetX + displaySize / 2, offsetY + displaySize / 2, displaySize, distanceZoomMultiplier, planetSizeMultiplier);
        }
        this.moduleList.addAll(this.planetList);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderPlanetarySystem(DimensionProperties planet, int posX, int posY, float distanceZoomMultiplier, float planetSizeMultiplier) {
        int displaySize = Math.max((int)(planetSizeMultiplier * planet.gravitationalMultiplier / 0.02f), 7);
        int offsetX = (int)(distanceZoomMultiplier * (float)posX) - displaySize / 2;
        int offsetY = (int)(distanceZoomMultiplier * (float)posY) - displaySize / 2;
        displaySize = (int)((float)displaySize * distanceZoomMultiplier);
        ModuleButtonPlanet button = new ModuleButtonPlanet(offsetX, offsetY, "", this, planet, planet.getName(), displaySize, displaySize);
        this.planetList.add(button);
        button.setAdditionalData(planet.getId());
        button.setSound("buttonblipa");
        this.renderPropertiesMap.put(planet.getId(), new PlanetRenderProperties(displaySize, offsetX, offsetY));
        for (ResourceLocation childId : planet.getChildPlanets()) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(childId);
            if (this.planetDefiner != null && !this.planetDefiner.isPlanetKnown(properties)) continue;
            this.renderPlanets(properties, offsetX + displaySize / 2, offsetY + displaySize / 2, displaySize, distanceZoomMultiplier, planetSizeMultiplier);
        }
        this.moduleList.addAll(this.planetList);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderPlanets(DimensionProperties planet, int parentOffsetX, int parentOffsetY, int parentRadius, float distanceMultiplier, float planetSizeMultiplier) {
        int displaySize = Math.max((int)(planetSizeMultiplier * planet.gravitationalMultiplier / 0.02f), 7);
        int offsetX = parentOffsetX + (int)(Math.cos(planet.orbitTheta) * (double)((float)planet.orbitalDist * distanceMultiplier + (float)parentRadius)) - displaySize / 2;
        int offsetY = parentOffsetY + (int)(Math.sin(planet.orbitTheta) * (double)((float)planet.orbitalDist * distanceMultiplier + (float)parentRadius)) - displaySize / 2;
        ModuleButtonPlanet button = new ModuleButtonPlanet(offsetX, offsetY, "", this, planet, planet.getName() + "\nMoons: " + planet.getChildPlanets().size(), displaySize, displaySize);
        this.planetList.add(button);
        button.setSound("buttonblipa");
        button.setAdditionalData(planet.getId());
        this.renderPropertiesMap.put(planet.getId(), new PlanetRenderProperties(displaySize, offsetX, offsetY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setPlanetAsKnown(ResourceLocation id) {
        for (ModuleBase module : this.moduleList) {
            if (!(module instanceof ModuleButton) || ((ModuleButton)module).getAdditionalData() != id) continue;
            ((ModuleButton)module).setImage(new ResourceLocation[]{DimensionManager.getInstance().getDimensionProperties(id).getPlanetIcon()});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Button> addButtons(int x, int y) {
        int screenSizeX = Minecraft.func_71410_x().func_228018_at_().func_198105_m();
        int screenSizeY = Minecraft.func_71410_x().func_228018_at_().func_198083_n();
        this.setOffset2(this.internalOffsetX - screenSizeX / 4, this.internalOffsetY - screenSizeY / 4);
        List list = super.addButtons(x, y);
        if (this.clickablePlanetList != null) {
            list.addAll(this.clickablePlanetList.addButtons(x, y));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void redrawSystem() {
        int offsetX = -this.currentPosX;
        int offsetY = -this.currentPosY;
        this.setOffset2(0, 0);
        for (int i = 0; i < this.planetList.size(); ++i) {
            ModuleBase module = (ModuleBase)this.planetList.get(i);
            if (!this.planetList.contains(module)) continue;
            this.buttonList.remove(((ModuleButton)module).button);
        }
        this.moduleList.removeAll(this.planetList);
        this.planetList.clear();
        if (!this.stellarView) {
            if (!DimensionManager.getInstance().isStar(this.currentSystem)) {
                DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.currentSystem);
                this.renderPlanetarySystem(properties, 1000, 1000, 1.0f, 3.0f * (float)properties.getPathLengthToStar());
            } else {
                this.renderStarSystem(DimensionManager.getInstance().getStar(this.currentSystem), 1000, 1000, 1.0f * (float)this.zoom, (float)this.zoom * 0.5f);
            }
        } else {
            this.renderGalaxyMap(DimensionManager.getInstance(), 1000, 1000, 1.0f * (float)this.zoom, (float)this.zoom * 0.25f);
        }
        int x = this.currentPosX - 1000;
        int y = this.currentPosY - 1000;
        this.screenSizeX = Minecraft.func_71410_x().func_228018_at_().func_198105_m();
        this.screenSizeY = Minecraft.func_71410_x().func_228018_at_().func_198083_n();
        for (ModuleBase moduleBase : this.planetList) {
            for (Button module2 : moduleBase.addButtons(this.currentPosX, this.currentPosY)) {
                if (module2.field_230690_l_ <= 128 + offsetX && this.clickablePlanetList != null && this.clickablePlanetList.isEnabled()) continue;
                this.buttonList.add(module2);
            }
        }
        this.setOffset2(offsetX, offsetY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onMouseClicked(GuiModular gui, double x, double y, int button) {
        if (this.clickablePlanetList != null) {
            this.clickablePlanetList.onMouseClicked(gui, x, y, button);
        }
        super.onMouseClicked(gui, x, y, button);
        int screenSizeX = Minecraft.func_71410_x().func_228018_at_().func_198105_m();
        int screenSizeY = Minecraft.func_71410_x().func_228018_at_().func_198083_n();
        if (this.currentSystemChanged) {
            this.currentPosX = 0;
            this.currentPosY = 0;
            this.zoom = 1.0;
            this.redrawSystem();
            this.setOffset2(this.internalOffsetX - screenSizeX / 4, this.internalOffsetY - screenSizeY / 4);
            this.currentSystemChanged = false;
            this.hostTile.onSystemFocusChanged((Object)this);
            this.refreshSideBar(true, this.selectedSystem);
        }
    }

    protected void moveContainerInterior(int deltaX, int deltaY) {
        super.moveContainerInterior(deltaX, deltaY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack matrix, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        if (!this.stellarView && System.currentTimeMillis() % 5L == 0L) {
            this.redrawSystem();
        }
        super.renderBackground(gui, matrix, x, y, mouseX, mouseY, font);
        int center = 1000;
        int numSegments = 50;
        float theta = (float)(Math.PI * 2 / (double)numSegments);
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        GL11.glPushMatrix();
        if (!this.stellarView) {
            for (int ii = 1; ii < 10; ++ii) {
                int radius = ii * 80;
                float x2 = radius;
                float y2 = 0.0f;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(center + this.currentPosX), (float)(center + this.currentPosY), (float)0.0f);
                GlStateManager.func_227621_I_();
                GlStateManager.func_227740_m_();
                GlStateManager.func_227676_b_((int)770, (int)771);
                GL11.glColor4f((float)0.8f, (float)0.8f, (float)1.0f, (float)0.2f);
                GL11.glEnable((int)2852);
                GL11.glLineStipple((int)5, (short)21845);
                buffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                for (int i = 0; i < numSegments; ++i) {
                    buffer.func_225582_a_((double)x2, (double)y2, 200.0).func_181675_d();
                    float t = x2;
                    x2 = cos * x2 - sin * y2;
                    y2 = sin * t + cos * y2;
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_227619_H_();
                GlStateManager.func_227737_l_();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
                GL11.glLineStipple((int)5, (short)-1);
            }
        }
        if (!Constants.INVALID_PLANET.equals((Object)this.selectedSystem)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.selectionCircle);
            GL11.glPushMatrix();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            float radius = this.currentlySelectedPlanet.radius / 2;
            if (this.renderPropertiesMap.containsKey(this.selectedSystem)) {
                PlanetRenderProperties base = this.renderPropertiesMap.get(this.selectedSystem);
                GL11.glTranslatef((float)(base.posX + this.currentPosX + base.radius / 2), (float)(base.posY + this.currentPosY + base.radius / 2), (float)0.0f);
            } else {
                GL11.glTranslatef((float)((float)(this.currentlySelectedPlanet.posX + this.currentPosX) + radius), (float)((float)(this.currentlySelectedPlanet.posY + this.currentPosY) + radius), (float)0.0f);
            }
            double progress = (float)(System.currentTimeMillis() % 20000L) / 50.0f;
            GL11.glPushMatrix();
            GL11.glRotated((double)progress, (double)0.0, (double)0.0, (double)1.0);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUVNoNormal((MatrixStack)matrix, (IVertexBuilder)buffer, (double)1.0, (double)(-radius), (double)(-radius), (double)radius, (double)radius, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            radius = (float)((double)radius * (1.2 + 0.1 * Math.sin(progress / 10.0)));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUVNoNormal((MatrixStack)matrix, (IVertexBuilder)buffer, (double)1.0, (double)(-radius), (double)(-radius), (double)radius, (double)radius, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
            GlStateManager.func_227737_l_();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInventoryButtonPressed(ModuleButton buttonId) {
        if (buttonId == this.btnUpLevel) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.currentSystem);
            if (Constants.INVALID_PLANET.equals((Object)this.topLevel) || this.currentSystem != this.topLevel) {
                if (!DimensionManager.getInstance().isStar(this.currentSystem) && properties.isMoon()) {
                    this.currentSystem = properties.getParentPlanet();
                } else {
                    if (DimensionManager.getInstance().isStar(this.currentSystem)) {
                        this.stellarView = true;
                    }
                    this.currentSystem = properties.getStar().getId();
                }
                this.currentSystemChanged = true;
                this.selectedSystem = Constants.INVALID_PLANET;
            }
        } else if (buttonId == this.btnConfirm) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.selectedSystem);
            if (!Constants.INVALID_PLANET.equals((Object)this.selectedSystem) && !DimensionManager.getInstance().isStar(this.selectedSystem) || this.allowStarSelection && properties.getStar().isBlackHole()) {
                this.hostTile.onSelectionConfirmed((Object)this);
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
            }
        } else if (buttonId == this.btnPlanetList) {
            if (this.clickablePlanetList != null) {
                boolean flag = !this.clickablePlanetList.isEnabled();
                this.clickablePlanetList.setEnabled(flag);
            }
        } else if (this.selectedSystem == buttonId.getAdditionalData()) {
            this.currentSystem = (ResourceLocation)buttonId.getAdditionalData();
            this.currentSystemChanged = true;
            this.stellarView = false;
        } else {
            this.selectedSystem = (ResourceLocation)buttonId.getAdditionalData();
            this.currentlySelectedPlanet = this.renderPropertiesMap.get(buttonId.getAdditionalData());
            this.hostTile.onSelected((Object)this);
            this.refreshSideBar(this.currentSystemChanged, this.selectedSystem);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void refreshSideBar(boolean planetChanged, ResourceLocation selectedPlanet) {
        LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
        if (!this.stellarView) {
            if (!DimensionManager.getInstance().isStar(this.currentSystem)) {
                DimensionProperties parent = DimensionManager.getInstance().getDimensionProperties(this.currentSystem);
                LinkedList<ResourceLocation> propertyList = new LinkedList<ResourceLocation>(parent.getChildPlanets());
                propertyList.add(parent.getId());
                int i = 0;
                Iterator iterator = propertyList.iterator();
                while (iterator.hasNext()) {
                    ResourceLocation childId = (ResourceLocation)iterator.next();
                    DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(childId);
                    if (this.planetDefiner != null && !this.planetDefiner.isPlanetKnown(properties)) continue;
                    ModuleButton button = new ModuleButton(0, i * 18, properties.getName(), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
                    button.setAdditionalData((Object)properties.getId());
                    list2.add(button);
                    if (properties.getId() == selectedPlanet) {
                        button.setColor(-56798);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                for (IDimensionProperties properties : DimensionManager.getInstance().getStar(this.currentSystem).getPlanets()) {
                    if (this.planetDefiner != null && !this.planetDefiner.isPlanetKnown(properties) || properties.isMoon() || ARConfiguration.GetSpaceDimId().equals((Object)properties.getId())) continue;
                    ModuleButton button = new ModuleButton(0, i * 18, properties.getName(), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
                    button.setAdditionalData((Object)properties.getId());
                    list2.add(button);
                    if (properties.getId() == selectedPlanet) {
                        button.setColor(-56798);
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            for (StellarBody properties : DimensionManager.getInstance().getStars()) {
                if (this.planetDefiner != null && !this.planetDefiner.isStarKnown(properties)) continue;
                ModuleButton button = new ModuleButton(0, i * 18, properties.getName(), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
                button.setAdditionalData((Object)properties.getId());
                list2.add(button);
                if (properties.getId() == selectedPlanet) {
                    button.setColor(-56798);
                }
                ++i;
            }
        }
        boolean enabled = this.clickablePlanetList != null && this.clickablePlanetList.isEnabled();
        int offX = 0;
        int offY = 0;
        if (this.clickablePlanetList != null) {
            this.staticModuleList.remove(this.clickablePlanetList);
            offX = this.clickablePlanetList.getScrollX();
            offY = this.clickablePlanetList.getScrollY();
        }
        this.clickablePlanetList = new ModuleContainerPan(0, 128, list2, new LinkedList(), null, 512, 256, 0, 0, 258, 8192);
        this.staticModuleList.add(this.clickablePlanetList);
        this.clickablePlanetList.addButtons(0, 0);
        if (!planetChanged) {
            this.clickablePlanetList.setOffset2(-offX, -offY);
        } else {
            this.clickablePlanetList.setOffset2(0, 64);
        }
        this.clickablePlanetList.setEnabled(enabled);
    }

    public boolean needsUpdate(int localId) {
        for (ModuleBase module : this.staticModuleList) {
            if (localId >= 0 && localId < module.numberOfChangesToSend()) {
                return module.needsUpdate(localId);
            }
            localId -= module.numberOfChangesToSend();
        }
        return false;
    }

    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        for (ModuleBase module : this.staticModuleList) {
            if (localId >= 0 && localId < module.numberOfChangesToSend()) {
                module.sendChanges(container, crafter, variableId, localId);
                return;
            }
            localId -= module.numberOfChangesToSend();
        }
    }

    public void onChangeRecieved(int slot, int value) {
        for (ModuleBase module : this.staticModuleList) {
            if (slot >= 0 && slot < module.numberOfChangesToSend()) {
                module.onChangeRecieved(slot, value);
                return;
            }
            slot -= module.numberOfChangesToSend();
        }
    }

    public int numberOfChangesToSend() {
        int numChanges = 0;
        for (ModuleBase module : this.staticModuleList) {
            numChanges += module.numberOfChangesToSend();
        }
        return numChanges;
    }

    private class PlanetRenderProperties {
        int radius;
        int posX;
        int posY;

        public PlanetRenderProperties() {
        }

        public PlanetRenderProperties(int radius, int posX, int posY) {
            this.radius = radius;
            this.posX = posX;
            this.posY = posY;
        }
    }
}

