/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import zmaster587.advancedRocketry.tile.TileFluidTank;

public class ItemBlockFluidTank
extends BlockItem {
    public ItemBlockFluidTank(Item.Properties props, Block block) {
        super(block, props);
    }

    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag bool) {
        super.func_77624_a(stack, player, list, bool);
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            list.add("Empty");
        } else {
            list.add(new StringTextComponent(fluidStack.getDisplayName() + ": " + fluidStack.getAmount() + "/64000mb"));
        }
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        super.func_195941_b(context, state);
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileFluidTank) {
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).orElse(null);
            ItemStack stack2 = stack.func_77946_l();
            stack2.func_190920_e(1);
            handler.fill(this.drain(stack2, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }

    public void fill(ItemStack stack, FluidStack fluid) {
        CompoundNBT nbt;
        FluidTank tank = new FluidTank(640000);
        if (stack.func_77942_o()) {
            nbt = stack.func_77978_p();
            tank.readFromNBT(nbt);
        } else {
            nbt = new CompoundNBT();
        }
        tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        tank.writeToNBT(nbt);
        stack.func_77982_d(nbt);
    }

    public FluidStack drain(ItemStack stack, int amt) {
        CompoundNBT nbt;
        FluidTank tank = new FluidTank(640000);
        if (stack.func_77942_o()) {
            nbt = stack.func_77978_p();
            tank.readFromNBT(nbt);
        } else {
            nbt = new CompoundNBT();
        }
        FluidStack stack2 = tank.drain(amt, IFluidHandler.FluidAction.EXECUTE);
        tank.writeToNBT(nbt);
        stack.func_77982_d(nbt);
        return stack2;
    }

    public FluidStack getFluid(ItemStack stack) {
        FluidTank tank = new FluidTank(640000);
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            tank.readFromNBT(nbt);
        } else {
            CompoundNBT nbt = new CompoundNBT();
        }
        return tank.getFluid();
    }
}

