/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.advancedRocketry.api.DataStorage;

public class ItemData
extends Item {
    int maxData;

    public ItemData(Item.Properties props) {
        super(props);
    }

    public int getMaxData(ItemStack stack) {
        return 1000;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getData(stack) == 0 ? super.getItemStackLimit(stack) : 1;
    }

    public int getData(ItemStack stack) {
        return this.getDataStorage(stack).getData();
    }

    public DataStorage.DataType getDataType(ItemStack stack) {
        return this.getDataStorage(stack).getDataType();
    }

    public DataStorage getDataStorage(ItemStack item) {
        DataStorage data = new DataStorage();
        if (!item.func_77942_o()) {
            data.setMaxData(this.getMaxData(item));
            CompoundNBT nbt = new CompoundNBT();
            data.writeToNBT(nbt);
        } else {
            data.readFromNBT(item.func_77978_p());
        }
        return data;
    }

    public int addData(ItemStack item, int amount, DataStorage.DataType dataType) {
        DataStorage data = this.getDataStorage(item);
        int amt = data.addData(amount, dataType, true);
        CompoundNBT nbt = new CompoundNBT();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return amt;
    }

    public int removeData(ItemStack item, int amount, DataStorage.DataType dataType) {
        DataStorage data = this.getDataStorage(item);
        int amt = data.removeData(amount, true);
        CompoundNBT nbt = new CompoundNBT();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return amt;
    }

    public void setData(ItemStack item, int amount, DataStorage.DataType dataType) {
        DataStorage data = this.getDataStorage(item);
        data.setData(amount, dataType);
        CompoundNBT nbt = new CompoundNBT();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag bool) {
        super.func_77624_a(stack, player, list, bool);
        DataStorage data = this.getDataStorage(stack);
        list.add(new StringTextComponent(data.getData() + " / " + data.getMaxData() + " Data"));
        list.add(new StringTextComponent(I18n.func_135052_a((String)data.getDataType().toString(), (Object[])new Object[0])));
    }
}

