/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.world.util.MultiData;

public class ItemMultiData
extends Item {
    public ItemMultiData(Item.Properties props) {
        super(props);
    }

    public void setMaxData(ItemStack stack, int amount) {
        MultiData data = this.getDataStorage(stack);
        data.setMaxData(amount);
        CompoundNBT nbt = !stack.func_77942_o() ? new CompoundNBT() : stack.func_77978_p();
        data.writeToNBT(nbt);
        stack.func_77982_d(nbt);
    }

    public int getData(ItemStack stack, DataStorage.DataType type) {
        return this.getDataStorage(stack).getDataAmount(type);
    }

    public int getMaxData(ItemStack stack) {
        return this.getDataStorage(stack).getMaxData();
    }

    private MultiData getDataStorage(ItemStack item) {
        MultiData data = new MultiData();
        if (!item.func_77942_o()) {
            CompoundNBT nbt = new CompoundNBT();
            data.writeToNBT(nbt);
        } else {
            data.readFromNBT(item.func_77978_p());
        }
        return data;
    }

    public boolean isFull(ItemStack item, DataStorage.DataType dataType) {
        return this.getDataStorage(item).getMaxData() == this.getData(item, dataType);
    }

    public int addData(ItemStack item, int amount, DataStorage.DataType dataType) {
        MultiData data = this.getDataStorage(item);
        int amt = data.addData(amount, dataType, Direction.DOWN, true);
        CompoundNBT nbt = item.func_77942_o() ? item.func_77978_p() : new CompoundNBT();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return amt;
    }

    public int removeData(ItemStack item, int amount, DataStorage.DataType dataType) {
        MultiData data = this.getDataStorage(item);
        int amt = data.extractData(amount, dataType, Direction.DOWN, true);
        CompoundNBT nbt = item.func_77942_o() ? item.func_77978_p() : new CompoundNBT();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return amt;
    }

    public void setData(ItemStack item, int amount, DataStorage.DataType dataType) {
        MultiData data = this.getDataStorage(item);
        data.setDataAmount(amount, dataType);
        CompoundNBT nbt = item.func_77942_o() ? item.func_77978_p() : new CompoundNBT();
        data.writeToNBT(nbt);
        item.func_77982_d(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag bool) {
        super.func_77624_a(stack, player, list, bool);
        MultiData data = this.getDataStorage(stack);
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            list.add(new StringTextComponent(data.getDataAmount(type) + " / " + data.getMaxData() + " " + I18n.func_135052_a((String)type.toString(), (Object[])new Object[0]) + " Data"));
        }
    }
}

