/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.satellite.SatelliteOreMapping;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.util.ZUtils;

public class ItemOreScanner
extends Item {
    public ItemOreScanner(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag arg5) {
        SatelliteBase sat = DimensionManager.getInstance().getSatellite(this.getSatelliteID(stack));
        SatelliteOreMapping mapping = null;
        if (sat instanceof SatelliteOreMapping) {
            mapping = (SatelliteOreMapping)sat;
        }
        if (!stack.func_77942_o()) {
            list.add(new TranslationTextComponent("msg.unprogrammed"));
        } else if (mapping == null) {
            list.add(new TranslationTextComponent("msg.itemorescanner.nosat"));
        } else if (mapping.getDimensionId().get() == ZUtils.getDimensionIdentifier((World)player)) {
            list.add(new TranslationTextComponent("msg.connected"));
            list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemorescanner.maxzoom") + mapping.getZoomRadius()));
            list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemorescanner.filter") + mapping.canFilterOre()));
        } else {
            list.add(new TranslationTextComponent("msg.notconnected"));
        }
        super.func_77624_a(stack, player, list, arg5);
    }

    public void setSatelliteID(ItemStack stack, long id) {
        CompoundNBT nbt = !stack.func_77942_o() ? new CompoundNBT() : stack.func_77978_p();
        nbt.func_74772_a("id", id);
        stack.func_77982_d(nbt);
    }

    public long getSatelliteID(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -1L;
        }
        CompoundNBT nbt = stack.func_77978_p();
        return nbt.func_74763_f("id");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!playerIn.field_70170_p.field_72995_K && !stack.func_190926_b()) {
            int satelliteId = (int)this.getSatelliteID(stack);
            SatelliteBase satellite = DimensionManager.getInstance().getSatellite(satelliteId);
            if (satellite != null && satellite instanceof SatelliteOreMapping && satellite.getDimensionId().get() == ZUtils.getDimensionIdentifier((World)worldIn)) {
                satellite.performAction(playerIn, worldIn, new BlockPos(playerIn.func_213303_ch()));
            }
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World worldIn = context.func_195991_k();
        if (!playerIn.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (!playerIn.field_70170_p.field_72995_K && !stack.func_190926_b()) {
                int satelliteId = (int)this.getSatelliteID(stack);
                SatelliteBase satellite = DimensionManager.getInstance().getSatellite(satelliteId);
                if (satellite != null && satellite instanceof SatelliteOreMapping && satellite.getDimensionId().get() == ZUtils.getDimensionIdentifier((World)worldIn)) {
                    satellite.performAction(playerIn, worldIn, new BlockPos(playerIn.func_213303_ch()));
                }
            }
        }
        return super.func_195939_a(context);
    }

    public void interactSatellite(SatelliteBase satellite, PlayerEntity player, World world, BlockPos pos) {
        satellite.performAction(player, world, pos);
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        return modules;
    }
}

