/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.item.ItemIdWithName;
import zmaster587.libVulpes.LibVulpes;

public class ItemPlanetIdentificationChip
extends ItemIdWithName {
    private static final String dimensionNameIdentifier = "DimensionName";
    private static final String dimensionIdIdentifier = "dimId";
    private static final String uuidIdentifier = "UUID";

    public ItemPlanetIdentificationChip(Item.Properties props) {
        super(props);
    }

    public boolean func_77645_m() {
        return false;
    }

    public DimensionProperties getDimension(ItemStack stack) {
        if (stack.func_77942_o()) {
            return DimensionManager.getInstance().getDimensionProperties(new ResourceLocation(stack.func_77978_p().func_74779_i(dimensionIdIdentifier)));
        }
        return null;
    }

    public boolean hasValidDimension(ItemStack stack) {
        if (stack.func_77942_o()) {
            ResourceLocation dimId = new ResourceLocation(stack.func_77978_p().func_74779_i(dimensionIdIdentifier));
            return DimensionManager.getInstance().isDimensionCreated(dimId);
        }
        return false;
    }

    public void erase(ItemStack stack) {
        stack.func_77982_d(null);
    }

    public void setDimensionId(ItemStack stack, ResourceLocation dimensionId) {
        if (Constants.INVALID_PLANET.equals((Object)dimensionId)) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a(dimensionIdIdentifier, dimensionId.toString());
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(dimensionId);
        if (properties == null) {
            this.erase(stack);
            return;
        }
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74778_a(dimensionIdIdentifier, dimensionId.toString());
        nbt.func_74778_a(dimensionNameIdentifier, properties.getName());
        stack.func_77982_d(nbt);
    }

    public ResourceLocation getDimensionId(ItemStack stack) {
        if (stack.func_77942_o()) {
            return new ResourceLocation(stack.func_77978_p().func_74779_i(dimensionIdIdentifier));
        }
        return Constants.INVALID_PLANET;
    }

    public DimensionProperties getDimensionProperties(ItemStack stack) {
        if (stack.func_77942_o()) {
            return DimensionManager.getInstance().getDimensionProperties(new ResourceLocation(stack.func_77978_p().func_74779_i(dimensionIdIdentifier)));
        }
        return null;
    }

    public Long getUUID(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74763_f(uuidIdentifier);
        }
        return null;
    }

    public void setUUID(ItemStack stack, long uuid) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74772_a(uuidIdentifier, uuid);
        stack.func_77982_d(nbt);
    }

    @Override
    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag bool) {
        if (!stack.func_77942_o()) {
            list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.unprogrammed")));
        } else if (!this.hasValidDimension(stack)) {
            list.add(new StringTextComponent(TextFormatting.RED + LibVulpes.proxy.getLocalizedString("msg.programfail")));
        } else if (stack.func_77952_i() == 0) {
            DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(this.getDimensionId(stack));
            String unknown = TextFormatting.YELLOW + "???";
            String dimName = stack.func_77978_p().func_74779_i(dimensionNameIdentifier);
            list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemplanetidchip.planetname") + TextFormatting.DARK_GREEN + dimName));
            if (!props.getRequiredArtifacts().isEmpty()) {
                list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemplanetidchip.artifacts")));
                for (ItemStack stack2 : props.getRequiredArtifacts()) {
                    list.add(new StringTextComponent(TextFormatting.DARK_PURPLE + "    " + stack2.func_200301_q()));
                }
            }
        } else {
            list.add(LibVulpes.proxy.getLocalizedString("msg.itemplanetidchip.stationid") + TextFormatting.DARK_GREEN + stack.func_77978_p().func_74779_i(dimensionNameIdentifier));
        }
    }
}

