/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemIdWithName;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.ZUtils;

public class ItemSatellite
extends ItemIdWithName {
    public ItemSatellite(Item.Properties properties) {
        super(properties);
    }

    @Deprecated
    public SatelliteProperties getSatellite(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            SatelliteProperties satellite = new SatelliteProperties();
            satellite.readFromNBT(nbt);
            return satellite;
        }
        return null;
    }

    public SatelliteProperties getSatelliteProperties(ItemStack stackIn) {
        if (stackIn.func_77942_o()) {
            int powerStorage = 0;
            int powerGeneration = 0;
            int maxData = 0;
            EmbeddedInventory inv = this.readInvFromNBT(stackIn);
            if (inv.func_70301_a(0).func_190926_b()) {
                return null;
            }
            String satType = SatelliteRegistry.getSatelliteProperty(inv.func_70301_a(0)).getSatelliteType();
            SatelliteBase sat = SatelliteRegistry.getSatellite(satType);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                SatelliteProperties properties = SatelliteRegistry.getSatelliteProperty(stack);
                if (!sat.acceptsItemInConstruction(stack)) continue;
                powerStorage += properties.getPowerStorage();
                powerGeneration += properties.getPowerGeneration();
                maxData += properties.getMaxDataStorage();
            }
            return new SatelliteProperties(powerGeneration, powerStorage, satType, maxData);
        }
        return null;
    }

    public EmbeddedInventory readInvFromNBT(ItemStack stackIn) {
        EmbeddedInventory inv = new EmbeddedInventory(7);
        if (!stackIn.func_77942_o() || !stackIn.func_77978_p().func_74764_b("inv")) {
            return inv;
        }
        inv.readFromNBT(stackIn.func_77978_p().func_74775_l("inv"));
        return inv;
    }

    public void writeInvToNBT(ItemStack stackIn, EmbeddedInventory inv) {
        CompoundNBT nbt = new CompoundNBT();
        if (!stackIn.func_77942_o()) {
            stackIn.func_77982_d(nbt);
        } else {
            nbt = stackIn.func_77978_p();
        }
        CompoundNBT tag = new CompoundNBT();
        inv.write(tag);
        nbt.func_218657_a("inv", (INBT)tag);
    }

    public void setSatellite(ItemStack stack, SatelliteProperties properties) {
        SatelliteBase testSatellite = SatelliteRegistry.getSatellite(properties.getSatelliteType());
        if (testSatellite != null) {
            CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
            properties.writeToNBT(nbt);
            stack.func_77982_d(nbt);
            this.setName(stack, testSatellite.getName());
        } else {
            stack.func_77982_d(null);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag bool) {
        SatelliteProperties properties = this.getSatellite(stack);
        if (properties != null) {
            list.add(new StringTextComponent(this.getName(stack)));
            list.add(new StringTextComponent("ID: " + properties.getId()));
            if (SatelliteProperties.Property.BATTERY.isOfType(properties.getPropertyFlag())) {
                int powerStorage = properties.getPowerStorage();
                if (powerStorage > 0) {
                    list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatellite.pwr") + powerStorage));
                } else {
                    list.add(new StringTextComponent(TextFormatting.RED + LibVulpes.proxy.getLocalizedString("msg.itemsatellite.nopwr")));
                }
            }
            if (SatelliteProperties.Property.POWER_GEN.isOfType(properties.getPropertyFlag())) {
                int powerGeneration = properties.getPowerGeneration();
                if (powerGeneration > 0) {
                    list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatellite.pwrgen") + powerGeneration));
                } else {
                    list.add(new StringTextComponent(TextFormatting.RED + LibVulpes.proxy.getLocalizedString("msg.itemsatellite.nopwrgen")));
                }
            }
            if (SatelliteProperties.Property.DATA.isOfType(properties.getPropertyFlag())) {
                int dataStorage = properties.getMaxDataStorage();
                if (dataStorage > 0) {
                    list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatellite.data") + ZUtils.formatNumber((int)dataStorage)));
                } else {
                    list.add(new StringTextComponent(TextFormatting.YELLOW + LibVulpes.proxy.getLocalizedString("msg.itemsatellite.nodata")));
                }
            }
        } else {
            list.add(new StringTextComponent(TextFormatting.RED + LibVulpes.proxy.getLocalizedString("msg.itemsatellite.empty")));
        }
    }
}

