/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.ISatelliteIdItem;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.libVulpes.LibVulpes;

public class ItemSatelliteIdentificationChip
extends Item
implements ISatelliteIdItem {
    private static String name = "name";

    public ItemSatelliteIdentificationChip(Item.Properties properties) {
        super(properties);
    }

    public boolean func_77645_m() {
        return false;
    }

    public long getSatelliteId(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            return nbt.func_74763_f("satelliteId");
        }
        return -1L;
    }

    public SatelliteBase getSatellite(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            long satId = nbt.func_74763_f("satelliteId");
            SatelliteBase satellite = DimensionManager.getInstance().getSatellite(satId);
            if (satellite != null) {
                if (!nbt.func_74764_b("dimId") || Constants.INVALID_PLANET.equals((Object)new ResourceLocation(nbt.func_74779_i("dimId")))) {
                    nbt.func_74778_a("dimId", satellite.getDimensionId().get().toString());
                }
                if (DimensionManager.getInstance().getDimensionProperties(satellite.getDimensionId().get()) != null) {
                    nbt.func_74778_a(name, DimensionManager.getInstance().getDimensionProperties(satellite.getDimensionId().get()).getName());
                }
            }
            return satellite;
        }
        return null;
    }

    public void setSatellite(ItemStack stack, SatelliteBase satellite) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74778_a("satelliteName", satellite.getName());
        nbt.func_74778_a("dimId", satellite.getDimensionId().toString());
        nbt.func_74772_a("satelliteId", satellite.getId());
    }

    @Override
    public void setSatellite(ItemStack stack, SatelliteProperties satellite) {
        this.erase(stack);
        SatelliteBase satellite2 = SatelliteRegistry.getSatellite(satellite.getSatelliteType());
        if (satellite2 != null) {
            CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
            nbt.func_74778_a("satelliteName", satellite2.getName());
            nbt.func_74772_a("satelliteId", satellite.getId());
            stack.func_77982_d(nbt);
        }
    }

    public void erase(ItemStack stack) {
        stack.func_77982_d(null);
    }

    public void setDim(ItemStack stack, int dimId) {
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT nbt = stack.func_77978_p();
        nbt.func_74768_a("dimId", dimId);
    }

    public String getSatelliteName(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            return nbt.func_74779_i("satelliteName");
        }
        return "";
    }

    public ResourceLocation getWorldId(ItemStack stack) {
        CompoundNBT nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimId")) {
            return new ResourceLocation(nbt.func_74779_i("dimId"));
        }
        return Constants.INVALID_PLANET;
    }

    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag bool) {
        ResourceLocation worldId = this.getWorldId(stack);
        long satId = this.getSatelliteId(stack);
        String satelliteName = this.getSatelliteName(stack);
        if (satId != -1L) {
            if (!Constants.INVALID_PLANET.equals((Object)worldId)) {
                if (stack.func_77978_p().func_74764_b(name)) {
                    list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatchip.id") + satId));
                    list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatchip.planet") + stack.func_77978_p().func_74779_i(name)));
                    list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatchip.sat") + satelliteName));
                } else {
                    list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatchip.planetunk")));
                    list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatchip.satlost")));
                }
            } else {
                list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatchip.id") + satId));
                list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatchip.planetunk")));
                list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.itemsatchip.sat") + satelliteName));
            }
        } else {
            list.add(new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.unprogrammed")));
        }
    }
}

