/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.naming.directory.NoSuchAttributeException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleStellarBackground;
import zmaster587.advancedRocketry.item.ItemIdWithName;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.INetworkItem;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class ItemStationChip
extends ItemIdWithName
implements IModularInventory,
IButtonInventory,
INetworkItem {
    private static final String uuidIdentifier = "UUID";
    private static final String SELECTION_ID = "selectionId";
    private static final String DESTINATION = "dests";
    private static final String TMPNAME = "TmpName";
    private static final int BUTTON_ID_CLEAR = 0;
    private static final int BUTTON_ID_DELETE = 1;
    private static final int BUTTON_ID_ADD = 2;
    private static final int BUTTON_ID_OFFSET = 5;

    public ItemStationChip(Item.Properties props) {
        super(props);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!playerIn.field_70170_p.field_72995_K && stack != null && playerIn.func_225608_bj_()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((INamedContainerProvider)stack.func_77973_b()), packetBuffer -> {
                packetBuffer.writeInt(this.getModularInvType().ordinal());
                packetBuffer.writeBoolean(hand == Hand.MAIN_HAND);
            });
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        int offset_all = 96;
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        if (stack != null) {
            modules.clear();
            modules.add(new ModuleStellarBackground(0, 0, zmaster587.libVulpes.inventory.TextureResources.starryBG));
            LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
            ModuleButton btnAdd = new ModuleButton(76, 64, LibVulpes.proxy.getLocalizedString("msg.label.add"), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
            btnAdd.setAdditionalData((Object)2);
            ModuleButton btnClear = new ModuleButton(76, 100, LibVulpes.proxy.getLocalizedString("msg.label.clear"), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
            btnClear.setAdditionalData((Object)0);
            ModuleButton btnDelete = new ModuleButton(76, 82, LibVulpes.proxy.getLocalizedString("msg.label.delete"), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
            btnDelete.setAdditionalData((Object)1);
            modules.add((ModuleBase)btnClear);
            modules.add((ModuleBase)btnDelete);
            modules.add((ModuleBase)btnAdd);
            ResourceLocation dimId = DimensionManager.getEffectiveDimId(player.field_70170_p, new BlockPos(player.func_213303_ch())).getId();
            List<LandingLocation> list = this.getLandingLocations(stack, dimId);
            int selectedId = this.getSelectionId(stack, dimId);
            int i = 0;
            for (LandingLocation pos : list) {
                ModuleButton button = new ModuleButton(0, i * 18, pos.toString(), (IButtonInventory)this, TextureResources.buttonGeneric, 128, 18);
                button.setAdditionalData((Object)(i + 5));
                list2.add(button);
                if (i == selectedId) {
                    button.setColor(-14483678);
                } else {
                    button.setColor(-56798);
                }
                ++i;
            }
            ModuleContainerPan pan = new ModuleContainerPan(-71, 50, list2, new LinkedList(), null, 512, 256, 0, -48, 258, 256);
            modules.add((ModuleBase)pan);
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "item.stationChip.name";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInventoryButtonPressed(ModuleButton buttonId) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.MAIN_HAND);
        if (stack != null && stack.func_77973_b() == this) {
            PacketHandler.sendToServer((BasePacket)new PacketItemModifcation((INetworkItem)this, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, ((Byte)buttonId.getAdditionalData()).byteValue()));
        }
    }

    private void setTempName(ItemStack stack, String string) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74778_a(TMPNAME, string);
        }
    }

    private String getTempName(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i(TMPNAME);
        }
        return "";
    }

    public void writeDataToNetwork(ByteBuf out, byte id, ItemStack stack) {
        if (id == 2) {
            String str = this.getTempName(stack);
            byte[] byteArray = str.getBytes();
            short len = (short)byteArray.length;
            out.writeShort((int)len);
            out.writeBytes(byteArray, 0, (int)len);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte id, CompoundNBT nbt, ItemStack stack) {
        if (id == 2) {
            short len = in.readShort();
            byte[] byteArray = new byte[len];
            in.readBytes(byteArray, 0, (int)len);
            nbt.func_74778_a(TMPNAME, new String(byteArray));
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K) {
            ResourceLocation dimId = DimensionManager.getEffectiveDimId(player.field_70170_p, new BlockPos(player.func_213303_ch())).getId();
            if (id >= 5) {
                this.setSelectionId(stack, dimId, id - 5);
            } else if (id == 1) {
                int selection = this.getSelectionId(stack, dimId);
                if (selection > 0) {
                    List<LandingLocation> locs = this.getLandingLocations(stack, dimId);
                    if (selection < locs.size()) {
                        locs.remove(selection);
                    }
                    this.setLandingLocations(stack, dimId, locs);
                }
            } else if (id == 0) {
                List<LandingLocation> locs = this.getLandingLocations(stack, dimId);
                LinkedList<LandingLocation> locs2 = new LinkedList<LandingLocation>();
                locs2.add(locs.get(0));
                this.setLandingLocations(stack, dimId, locs2);
            } else if (id == 2 && ZUtils.getDimensionIdentifier((World)player.func_130014_f_()) == dimId) {
                List<LandingLocation> locs = this.getLandingLocations(stack, dimId);
                BlockPos pos = new BlockPos(player.func_213303_ch());
                locs.add(new LandingLocation(nbt.func_74779_i(TMPNAME), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                this.setLandingLocations(stack, dimId, locs);
            }
            player.func_71053_j();
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)stack.func_77973_b()), packetBuffer -> {
                packetBuffer.writeInt(this.getModularInvType().ordinal());
                packetBuffer.writeBoolean(true);
            });
        }
    }

    public boolean canInteractWithContainer(PlayerEntity player) {
        return player.func_184586_b(player.func_184600_cs()).func_77973_b() == this;
    }

    public int getSelectionId(ItemStack stack, ResourceLocation dimid) {
        CompoundNBT nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            int selectedId;
            nbt = nbt.func_74775_l("dimid" + dimid);
            int size = this.getLandingLocations(stack, dimid).size();
            return size > (selectedId = nbt.func_74762_e(SELECTION_ID)) ? selectedId : 0;
        }
        return 0;
    }

    public void setSelectionId(ItemStack stack, ResourceLocation dimid, int slotId) {
        CompoundNBT nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            nbt = nbt.func_74775_l("dimid" + dimid);
            nbt.func_74768_a(SELECTION_ID, slotId);
        }
    }

    public List<LandingLocation> getLandingLocations(ItemStack stack, ResourceLocation dimid) {
        CompoundNBT nbt;
        LinkedList<LandingLocation> retList = new LinkedList<LandingLocation>();
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            nbt = nbt.func_74775_l("dimid" + dimid);
            ListNBT destList = nbt.func_150295_c(DESTINATION, 10);
            if (nbt.func_74764_b("x")) {
                float x = nbt.func_74760_g("x");
                float y = nbt.func_74760_g("y");
                float z = nbt.func_74760_g("z");
                nbt.func_82580_o("x");
                nbt.func_82580_o("y");
                nbt.func_82580_o("z");
                List<LandingLocation> list2 = this.getLandingLocations(stack, dimid);
                list2.add(0, new LandingLocation("Last", x, y, z));
                this.setLandingLocations(stack, dimid, list2);
            }
            for (INBT tag : destList) {
                try {
                    retList.add(LandingLocation.loadFromNBT((CompoundNBT)tag));
                }
                catch (NoSuchAttributeException e) {
                    AdvancedRocketry.logger.warn("Attempting to load a Landing location for planet " + dimid + " but chip appears to have malformed data");
                }
            }
        }
        return retList;
    }

    public void setLandingLocations(ItemStack stack, ResourceLocation dimid, List<LandingLocation> locations) {
        if (stack.func_77942_o()) {
            String tagName;
            CompoundNBT stackNBT = stack.func_77978_p();
            CompoundNBT nbt = stackNBT.func_74764_b(tagName = "dimid" + dimid) ? stackNBT.func_74775_l("dimid" + dimid) : new CompoundNBT();
            ListNBT destList = new ListNBT();
            for (LandingLocation loc : locations) {
                CompoundNBT nbtTag = new CompoundNBT();
                loc.savetoNBT(nbtTag);
                destList.add((Object)nbtTag);
            }
            nbt.func_218657_a(DESTINATION, (INBT)destList);
            stackNBT.func_218657_a(tagName, (INBT)nbt);
        }
    }

    public void setTakeoffCoords(ItemStack stack, Vector3F<Float> pos, ResourceLocation dimid, int slot) {
        this.setTakeoffCoords(stack, ((Float)pos.x).floatValue(), ((Float)pos.y).floatValue(), ((Float)pos.z).floatValue(), dimid, slot);
    }

    public void setTakeoffCoords(ItemStack stack, float x, float y, float z, ResourceLocation dimid, int slot) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        if (nbt.func_74764_b("dimid" + dimid)) {
            CompoundNBT nbtEntry = nbt.func_74775_l("dimid" + dimid);
        } else {
            CompoundNBT nbtEntry = new CompoundNBT();
        }
        LandingLocation landingLoc = new LandingLocation("Last", x, y, z);
        List<LandingLocation> landingLocList = this.getLandingLocations(stack, dimid);
        if (landingLocList.isEmpty() || slot >= landingLocList.size()) {
            landingLocList.add(landingLoc);
        } else {
            landingLocList.set(slot, landingLoc);
        }
        this.setLandingLocations(stack, dimid, landingLocList);
    }

    public LandingLocation getTakeoffCoords(ItemStack stack, ResourceLocation dimid) {
        CompoundNBT nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            nbt = nbt.func_74775_l("dimid" + dimid);
            List<LandingLocation> landingLocList = this.getLandingLocations(stack, dimid);
            int id = this.getSelectionId(stack, dimid);
            if (landingLocList.isEmpty()) {
                return null;
            }
            LandingLocation loc = id < landingLocList.size() && id > 0 ? landingLocList.get(id) : landingLocList.get(0);
            return loc;
        }
        return null;
    }

    public static ResourceLocation getUUID(ItemStack stack) {
        if (stack.func_77942_o()) {
            return new ResourceLocation(stack.func_77978_p().func_74779_i(uuidIdentifier));
        }
        return Constants.INVALID_PLANET;
    }

    public static void setUUID(ItemStack stack, ResourceLocation uuid) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74778_a(uuidIdentifier, uuid.toString());
        stack.func_77982_d(nbt);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag bool) {
        if (world == null || ItemStationChip.getUUID(stack) == DimensionManager.overworldProperties.getId()) {
            list.add(new StringTextComponent(TextFormatting.GRAY + LibVulpes.proxy.getLocalizedString("msg.unprogrammed")));
        } else {
            list.add(new StringTextComponent(TextFormatting.GREEN + LibVulpes.proxy.getLocalizedString("msg.stationchip.sation") + ItemStationChip.getUUID(stack)));
            super.func_77624_a(stack, world, list, bool);
            if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)world))) {
                ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
                ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos(p.func_213303_ch()));
                if (obj != null) {
                    LandingLocation loc = this.getTakeoffCoords(stack, obj.getOrbitingPlanetId());
                    if (loc != null) {
                        Vector3F<Float> vec = loc.location;
                        list.add(new StringTextComponent("Name: " + loc.name));
                        list.add(new StringTextComponent("X: " + vec.x));
                        list.add(new StringTextComponent("Z: " + vec.z));
                    } else {
                        list.add(new StringTextComponent("Name: N/A"));
                        list.add(new StringTextComponent("X: N/A"));
                        list.add(new StringTextComponent("Z: N/A"));
                    }
                }
            } else {
                LandingLocation loc = this.getTakeoffCoords(stack, ZUtils.getDimensionIdentifier((World)world));
                if (loc != null) {
                    Vector3F<Float> vec = loc.location;
                    list.add(new StringTextComponent("Name: " + loc.name));
                    list.add(new StringTextComponent("X: " + vec.x));
                    list.add(new StringTextComponent("Z: " + vec.z));
                } else {
                    list.add(new StringTextComponent("Name: N/A"));
                    list.add(new StringTextComponent("X: N/A"));
                    list.add(new StringTextComponent("Z: N/A"));
                }
            }
            list.add(new StringTextComponent(TextFormatting.DARK_GRAY + LibVulpes.proxy.getLocalizedString("item.stationchip.openmenu")));
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_HELD_ITEM, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULARCENTEREDFULLSCREEN;
    }

    public static class LandingLocation {
        public String name;
        public Vector3F<Float> location;

        public LandingLocation(String name, Vector3F<Float> location) {
            this.name = name;
            this.location = location;
        }

        public LandingLocation(String name, float x, float y, float z) {
            this.name = name;
            this.location = new Vector3F((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z));
        }

        public LandingLocation() {
            this.name = "";
            this.location = new Vector3F((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }

        public String toString() {
            return String.format("%s: %.0f, %.0f", this.name, this.location.x, this.location.z);
        }

        static LandingLocation loadFromNBT(CompoundNBT nbt) throws NoSuchAttributeException {
            String name = nbt.func_74779_i("name");
            Vector3F vec = new Vector3F((Object)Float.valueOf(nbt.func_74760_g("x")), (Object)Float.valueOf(nbt.func_74760_g("y")), (Object)Float.valueOf(nbt.func_74760_g("z")));
            return new LandingLocation(name, (Vector3F<Float>)vec);
        }

        void savetoNBT(CompoundNBT nbt) {
            nbt.func_74778_a("name", this.name);
            nbt.func_74776_a("x", ((Float)this.location.x).floatValue());
            nbt.func_74776_a("y", ((Float)this.location.y).floatValue());
            nbt.func_74776_a("z", ((Float)this.location.z).floatValue());
        }
    }
}

