/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.api.IJetPack;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.client.ResourceIcon;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.InputSyncHandler;

public class ItemJetpack
extends Item
implements IArmorComponent,
IJetPack {
    private ResourceLocation background = TextureResources.rocketHud;

    public ItemJetpack(Item.Properties props) {
        super(props);
    }

    public void onTick(World world, PlayerEntity player, ItemStack armorStack, IInventory inv, ItemStack componentStack) {
        if (player.func_184812_l_()) {
            return;
        }
        int speedUpgrades = 0;
        boolean allowsHover = false;
        ItemStack helm = player.func_184582_a(EquipmentSlotType.HEAD);
        if (helm != null && helm.func_77973_b() instanceof IModularArmor) {
            List helmInv = ((IModularArmor)helm.func_77973_b()).getComponents(helm);
            for (ItemStack stack : helmInv) {
                Item item;
                if (stack == null || (item = stack.func_77973_b()).getItem() != AdvancedRocketryItems.itemUpgradeHover) continue;
                if (stack.func_77952_i() == 0) {
                    allowsHover = true;
                    continue;
                }
                if (stack.func_77973_b() != AdvancedRocketryItems.itemUpgradeSpeed) continue;
                ++speedUpgrades;
            }
        }
        MODES mode = this.getMode(componentStack);
        boolean isActive = this.isActive(componentStack, player);
        if (!player.func_184613_cA()) {
            player.func_213293_j(player.func_213322_ci().field_72450_a + (double)((float)speedUpgrades * 0.02f), player.func_213322_ci().field_72448_b, player.func_213322_ci().field_72449_c + (double)((float)speedUpgrades * 0.02f));
        }
        if (this.hasModeSwitched(componentStack)) {
            player.field_71075_bZ.field_75100_b = false;
        }
        if (this.isEnabled(componentStack)) {
            if (mode == MODES.HOVER) {
                if (!allowsHover) {
                    this.changeMode(componentStack, inv, player);
                }
                if (!this.hasFuel(inv)) {
                    player.field_71075_bZ.field_75100_b = false;
                } else if (InputSyncHandler.isSpaceDown((PlayerEntity)player)) {
                    this.onAccelerate(componentStack, inv, player);
                    this.setHeight(componentStack, (float)((int)player.func_226278_cu_()) + player.func_213302_cg());
                } else if ((isActive || player.func_225608_bj_()) && player.field_70160_al) {
                    this.setHeight(componentStack, (float)((int)player.func_226278_cu_()) + player.func_213302_cg());
                    if (player.func_213322_ci().field_72448_b < -0.6) {
                        this.onAccelerate(componentStack, inv, player);
                    }
                } else if (player.func_226278_cu_() < (double)this.getHeight(componentStack)) {
                    this.onAccelerate(componentStack, inv, player);
                    if (player.func_213322_ci().field_72448_b < 0.1 && player.func_213322_ci().field_72448_b > -0.1) {
                        player.func_213317_d(new Vector3d(player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b * 0.01, player.func_213322_ci().field_72449_c));
                    }
                }
            } else if (isActive) {
                this.onAccelerate(componentStack, inv, player);
            }
        } else if (mode == MODES.HOVER && !isActive) {
            player.field_71075_bZ.field_75100_b = false;
        }
    }

    public boolean onComponentAdded(World world, ItemStack armorStack) {
        return true;
    }

    public void onComponentRemoved(World world, ItemStack armorStack) {
    }

    public void onArmorDamaged(LivingEntity entity, ItemStack armorStack, ItemStack componentStack, DamageSource source, int damage) {
    }

    public boolean isActive(ItemStack stack, PlayerEntity player) {
        return InputSyncHandler.isSpaceDown((PlayerEntity)player);
    }

    public boolean isEnabled(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("enabled");
    }

    public void setEnabledState(ItemStack stack, boolean state) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            nbt.func_74757_a("enabled", state);
            this.flagModeSwitched(stack);
        } else if (state) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("enabled", state);
            stack.func_77982_d(nbt);
            this.flagModeSwitched(stack);
        }
    }

    boolean hasFuel(IInventory inv) {
        boolean hasFuel = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack fuelTank = inv.func_70301_a(i);
            if (!FluidUtils.containsFluid((ItemStack)fuelTank, (Fluid)((Fluid)AdvancedRocketryFluids.hydrogenStill.get()))) continue;
            boolean bl = hasFuel = FluidUtils.getFluidHandler((ItemStack)fuelTank).drain(1, IFluidHandler.FluidAction.EXECUTE) != null;
            if (hasFuel) break;
        }
        return hasFuel;
    }

    public void onAccelerate(ItemStack stack, IInventory inv, PlayerEntity player) {
        boolean hasFuel = this.hasFuel(inv);
        MODES mode = this.getMode(stack);
        if (hasFuel) {
            player.func_70024_g(0.0, (Double)ARConfiguration.getCurrentConfig().jetPackThrust.get() * (double)0.1f, 0.0);
            if (player.field_70170_p.field_72995_K) {
                double xPos = player.func_226277_ct_();
                double zPos = player.func_226281_cx_();
                float playerRot = (float)(Math.PI / 180 * (double)(player.field_70177_z - 55.0f));
                xPos = player.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)playerRot) * 0.4f);
                zPos = player.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)playerRot) * 0.4f);
                float ejectSpeed = mode == MODES.HOVER ? 0.1f : 0.3f;
                AdvancedRocketry.proxy.spawnParticle("smallRocketFlame", player.field_70170_p, xPos, player.func_226278_cu_() + 0.75, zPos, 0.0, player.func_213322_ci().field_72448_b - (double)ejectSpeed, 0.0);
                playerRot = (float)(Math.PI / 180 * (double)(player.field_70177_z - 125.0f));
                xPos = player.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)playerRot) * 0.4f);
                zPos = player.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)playerRot) * 0.4f);
                AdvancedRocketry.proxy.spawnParticle("smallRocketFlame", player.field_70170_p, xPos, player.func_226278_cu_() + 0.75, zPos, 0.0, player.func_213322_ci().field_72448_b - (double)ejectSpeed, 0.0);
            }
            if (player.func_213322_ci().field_72448_b > -1.0) {
                player.field_70143_R = 0.0f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceIcon getComponentIcon(ItemStack armorStack) {
        return this.isEnabled(armorStack) ? (this.getMode(armorStack) == MODES.HOVER ? new ResourceIcon(TextureResources.jetpackIconHover) : new ResourceIcon(TextureResources.jetpackIconEnabled)) : new ResourceIcon(TextureResources.jetpackIconDisabled);
    }

    private MODES getMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return MODES.values()[stack.func_77978_p().func_74762_e("mode")];
        }
        return MODES.values()[0];
    }

    private void setHeight(ItemStack stack, float height) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74776_a("height", height);
        } else {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74776_a("height", height);
            stack.func_77982_d(nbt);
        }
    }

    private float getHeight(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74760_g("height");
        }
        return 0.0f;
    }

    public void changeMode(ItemStack stack, IInventory modules, PlayerEntity player) {
        int mode = 0;
        ItemStack helm = player.func_184582_a(EquipmentSlotType.HEAD);
        if (helm != null && helm.func_77973_b() instanceof IModularArmor) {
            List helmInv = ((IModularArmor)helm.func_77973_b()).getComponents(helm);
            for (ItemStack helmStack : helmInv) {
                if (stack == null || helmStack.func_77973_b() != AdvancedRocketryItems.itemUpgradeHover || helmStack.func_77952_i() != 0) continue;
                mode = 1;
                break;
            }
        }
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (mode == 1) {
                mode = nbt.func_74762_e("mode");
                if (++mode >= MODES.values().length) {
                    mode = 0;
                }
            }
            nbt.func_74768_a("mode", mode);
            this.flagModeSwitched(stack);
        } else {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("mode", mode);
            stack.func_77982_d(nbt);
            this.flagModeSwitched(stack);
        }
        if (mode == MODES.HOVER.ordinal()) {
            this.setHeight(stack, (float)player.func_226278_cu_() + player.func_213302_cg());
        }
    }

    private void flagModeSwitched(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            nbt.func_74757_a("modeSwitch", true);
        } else {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("modeSwitch", true);
            stack.func_77982_d(nbt);
        }
    }

    private boolean hasModeSwitched(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("modeSwitch")) {
            CompoundNBT nbt = stack.func_77978_p();
            boolean hasSwitched = nbt.func_74767_n("modeSwitch");
            nbt.func_74757_a("modeSwitch", false);
            return hasSwitched;
        }
        return false;
    }

    public boolean isAllowedInSlot(ItemStack stack, EquipmentSlotType slot) {
        return slot == EquipmentSlotType.CHEST;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderScreen(MatrixStack mat, ItemStack componentStack, List<ItemStack> modules, RenderGameOverlayEvent event, Screen gui) {
        List<ItemStack> inv = modules;
        int amt = 0;
        int maxAmt = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack currentStack = inv.get(i);
            if (!FluidUtils.containsFluid((ItemStack)currentStack, (Fluid)((Fluid)AdvancedRocketryFluids.hydrogenStill.get()))) continue;
            FluidStack fluidStack = FluidUtils.getFluidForItem((ItemStack)currentStack);
            if (fluidStack != null) {
                amt += fluidStack.getAmount();
            }
            maxAmt += FluidUtils.getFluidItemCapacity((ItemStack)currentStack);
        }
        if (maxAmt > 0) {
            float size = (float)amt / (float)maxAmt;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.background);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int width = 83;
            int screenX = RocketEventHandler.hydrogenBar.getRenderX();
            int screenY = RocketEventHandler.hydrogenBar.getRenderY();
            gui.func_238474_b_(mat, screenX, screenY, 23, 34, width, 17);
            gui.func_238474_b_(mat, screenX, screenY, 23, 51, (int)((float)width * size), 17);
        }
    }

    private static enum MODES {
        NORMAL,
        HOVER;

    }
}

