/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.mission;

import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.entity.EntityStationDeployedRocket;
import zmaster587.advancedRocketry.mission.MissionResourceCollection;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public class MissionGasCollection
extends MissionResourceCollection {
    Fluid gasFluid;

    public MissionGasCollection() {
    }

    public MissionGasCollection(long l, EntityRocket entityRocket, LinkedList<IInfrastructure> connectedInfrastructure, Fluid gasFluid) {
        super((long)((double)l * (Double)ARConfiguration.getCurrentConfig().gasCollectionMult.get()), entityRocket, connectedInfrastructure);
        this.gasFluid = gasFluid;
    }

    @Override
    public String getName() {
        return LibVulpes.proxy.getLocalizedString("mission.gascollection.name");
    }

    @Override
    public void onMissionComplete() {
        ServerWorld world;
        if ((Integer)this.rocketStats.getStatTag("intakePower") > 0 && this.gasFluid != null) {
            int amountOfGas = Integer.MAX_VALUE;
            Fluid type = this.gasFluid;
            for (TileEntity tile : this.rocketStorage.getFluidTiles()) {
                if ((amountOfGas -= ((IFluidHandler)tile).fill(new FluidStack(type, amountOfGas), IFluidHandler.FluidAction.EXECUTE)) == 0) break;
            }
        }
        if ((world = ZUtils.getWorld((ResourceLocation)this.launchDimension)) == null) {
            world = ZUtils.getWorld((ResourceLocation)this.launchDimension);
        }
        EntityStationDeployedRocket rocket = new EntityStationDeployedRocket((World)world, this.rocketStorage, this.rocketStats, this.x, this.y, this.z);
        rocket.setFuelAmountMonoproellant(0);
        rocket.setFuelAmountBipropellant(0);
        rocket.setFuelAmountOxidizer(0);
        rocket.readMissionPersistantNBT(this.missionPersistantNBT);
        Direction dir = rocket.forwardDirection;
        rocket.field_98038_p = true;
        rocket.func_70107_b((double)dir.func_82601_c() * 64.0 + (double)rocket.launchLocation.x + (this.rocketStorage.getSizeX() % 2 == 0 ? 0.0 : 0.5), this.y, (double)dir.func_82599_e() * 64.0 + (double)rocket.launchLocation.z + (this.rocketStorage.getSizeZ() % 2 == 0 ? 0.0 : 0.5));
        world.func_217376_c((Entity)rocket);
        rocket.setInOrbit(true);
        rocket.setInFlight(true);
        for (HashedBlockPosition i : this.infrastructureCoords) {
            TileEntity tile = world.func_175625_s(new BlockPos(i.x, (int)i.y, i.z));
            if (!(tile instanceof IInfrastructure)) continue;
            ((IInfrastructure)tile).unlinkMission();
            rocket.linkInfrastructure((IInfrastructure)tile);
        }
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("gas", this.gasFluid.getRegistryName().toString());
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.gasFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.func_74779_i("gas")));
    }
}

